/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TranscriptionTierSortAndSelectPanel
extends AbstractTierSortAndSelectPanel
implements ActionListener,
ListSelectionListener,
ChangeListener,
ItemListener,
TableModelListener {
    protected List<String> allTypeNames;
    protected List<String> allPartNames;
    protected List<String> allAnnNames;
    private Transcription transcription;

    public TranscriptionTierSortAndSelectPanel(Transcription transcription) {
        this(transcription, null, null, true, false);
    }

    public TranscriptionTierSortAndSelectPanel(Transcription transcription, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this(transcription, null, null, true, false, tierMode);
    }

    public TranscriptionTierSortAndSelectPanel(Transcription transcription, List<String> tierOrder, List<String> selectedTiers) {
        this(transcription, tierOrder, selectedTiers, true, false);
    }

    public TranscriptionTierSortAndSelectPanel(Transcription transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering) {
        this(transcription, tierOrder, selectedTiers, allowReordering, false);
    }

    public TranscriptionTierSortAndSelectPanel(Transcription transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting) {
        this(transcription, tierOrder, selectedTiers, allowReordering, allowSorting, AbstractTierSortAndSelectPanel.Modes.ALL_TIERS);
    }

    public TranscriptionTierSortAndSelectPanel(Transcription transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this.transcription = transcription;
        this.allTierNames = tierOrder;
        if (selectedTiers != null) {
            this.selectedTierNames = selectedTiers;
            this.initialSelectedTiersProvided = true;
        } else {
            this.selectedTierNames = new ArrayList();
            this.initialSelectedTiersProvided = false;
        }
        this.allowReordering = allowReordering;
        this.allowSorting = allowSorting;
        this.mode = tierMode;
        this.tabIndices = new HashMap(4);
        this.tabIndices.put(0, "Tier");
        this.tabIndices.put(1, "Type");
        this.tabIndices.put(2, "Participant");
        this.tabIndices.put(3, "Annotators");
        this.initComponents();
    }

    @Override
    protected void initTables() {
        TierImpl tier;
        int i;
        Vector tiers;
        this.allTypeNames = new ArrayList<String>();
        this.allPartNames = new ArrayList<String>();
        this.allAnnNames = new ArrayList<String>();
        if (this.allTierNames == null) {
            this.allTierNames = new ArrayList();
            tiers = this.transcription.getTiers();
            block10: for (i = 0; i < tiers.size(); ++i) {
                tier = (TierImpl)tiers.get(i);
                switch (this.mode) {
                    case ALIGNABLE_TIERS: {
                        if (!tier.isTimeAlignable()) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    case ROOT_TIERS: {
                        if (tier.getParentTier() != null) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    case ROOT_W_INCLUDED: {
                        if (tier.getParentTier() != null && (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 1)) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    default: {
                        this.allTierNames.add(tier.getName());
                    }
                }
            }
        } else {
            tiers = this.transcription.getTiers();
            block11: for (i = 0; i < tiers.size(); ++i) {
                tier = (TierImpl)tiers.get(i);
                switch (this.mode) {
                    case ALIGNABLE_TIERS: {
                        if (tier.isTimeAlignable()) {
                            if (this.allTierNames.contains(tier.getName())) continue block11;
                            this.allTierNames.add(tier.getName());
                            continue block11;
                        }
                        if (!this.allTierNames.contains(tier.getName())) continue block11;
                        this.allTierNames.remove(tier.getName());
                        continue block11;
                    }
                    case ROOT_TIERS: {
                        if (tier.getParentTier() == null) {
                            if (this.allTierNames.contains(tier.getName())) continue block11;
                            this.allTierNames.add(tier.getName());
                            continue block11;
                        }
                        if (!this.allTierNames.contains(tier.getName())) continue block11;
                        this.allTierNames.remove(tier.getName());
                        continue block11;
                    }
                    case ROOT_W_INCLUDED: {
                        if (tier.getParentTier() == null || tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 1) {
                            if (this.allTierNames.contains(tier.getName())) continue block11;
                            this.allTierNames.add(tier.getName());
                            continue block11;
                        }
                        if (!this.allTierNames.contains(tier.getName())) continue block11;
                        this.allTierNames.remove(tier.getName());
                        continue block11;
                    }
                    default: {
                        if (this.allTierNames.contains(tier.getName())) continue block11;
                        this.allTierNames.add(tier.getName());
                    }
                }
            }
        }
        if (this.allTierNames != null) {
            for (String name : this.allTierNames) {
                if (this.initialSelectedTiersProvided) {
                    if (this.selectedTierNames.contains(name)) {
                        this.model.addRow(new Object[]{Boolean.TRUE, name});
                    } else {
                        this.model.addRow(new Object[]{Boolean.FALSE, name});
                    }
                } else {
                    this.model.addRow(new Object[]{Boolean.TRUE, name});
                }
                tier = (TierImpl)this.transcription.getTierWithId(name);
                String value = tier.getParticipant();
                if (value.length() == 0) {
                    value = "not specified";
                }
                if (!this.allPartNames.contains(value)) {
                    this.allPartNames.add(value);
                    this.partModel.addRow(new Object[]{Boolean.FALSE, value});
                }
                if ((value = tier.getAnnotator()).length() == 0) {
                    value = "not specified";
                }
                if (!this.allAnnNames.contains(value)) {
                    this.allAnnNames.add(value);
                    this.annotModel.addRow(new Object[]{Boolean.FALSE, value});
                }
                if (this.allTypeNames.contains(value = tier.getLinguisticType().getLinguisticTypeName())) continue;
                this.allTypeNames.add(value);
                this.typeModel.addRow(new Object[]{Boolean.FALSE, value});
            }
            if (this.model.getRowCount() == 1) {
                this.model.setValueAt(Boolean.TRUE, 0, 0);
                String name = (String)this.model.getValueAt(0, this.model.findColumn("tier"));
                if (!this.selectedTierNames.contains(name)) {
                    this.selectedTierNames.add(name);
                }
            }
        }
    }

    @Override
    protected void toggleRootsOnly(boolean rootsOnly) {
        if (rootsOnly) {
            int i;
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            this.unfilteredTiers = new LinkedHashMap(this.model.getRowCount());
            for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
                this.unfilteredTiers.put((String)this.model.getValueAt(i2, nameCol), (Boolean)this.model.getValueAt(i2, includeCol));
            }
            this.model.removeTableModelListener(this);
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                String name = (String)this.model.getValueAt(i, nameCol);
                TierImpl t = (TierImpl)this.transcription.getTierWithId(name);
                if (t == null || !t.hasParentTier()) continue;
                this.model.removeRow(i);
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            this.unfilteredTypes = new LinkedHashMap(this.typeModel.getRowCount());
            includeCol = this.typeModel.findColumn("select");
            nameCol = this.typeModel.findColumn("tier");
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                this.unfilteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            Vector allTypes = this.transcription.getLinguisticTypes();
            block3: for (int i3 = this.typeModel.getRowCount() - 1; i3 >= 0; --i3) {
                String name = (String)this.typeModel.getValueAt(i3, nameCol);
                for (int j = 0; j < allTypes.size(); ++j) {
                    LinguisticType type = (LinguisticType)allTypes.get(j);
                    if (!type.getLinguisticTypeName().equals(name)) continue;
                    if (type.getConstraints() == null) continue block3;
                    this.typeModel.removeRow(i3);
                    continue block3;
                }
            }
        } else {
            String name;
            int i;
            String key2;
            if (this.unfilteredTiers == null) {
                return;
            }
            this.model.removeTableModelListener(this);
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            LinkedHashMap<String, Boolean> filteredTiers = new LinkedHashMap<String, Boolean>(this.model.getRowCount());
            for (int i4 = 0; i4 < this.model.getRowCount(); ++i4) {
                filteredTiers.put((String)this.model.getValueAt(i4, nameCol), (Boolean)this.model.getValueAt(i4, includeCol));
            }
            int insertAfter = -1;
            block6: for (String key2 : this.unfilteredTiers.keySet()) {
                boolean shouldInsert;
                boolean bl = shouldInsert = !filteredTiers.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.model.insertRow(0, new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.model.getRowCount() - 1) {
                        this.model.addRow(new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = this.model.getRowCount() - 1;
                        continue;
                    }
                    this.model.insertRow(insertAfter + 1, new Object[]{this.unfilteredTiers.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (i = 0; i < this.model.getRowCount(); ++i) {
                    name = (String)this.model.getValueAt(i, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i;
                    continue block6;
                }
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            LinkedHashMap<String, Boolean> filteredTypes = new LinkedHashMap<String, Boolean>(this.typeModel.getRowCount());
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                filteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            insertAfter = -1;
            Iterator keyIter = this.unfilteredTypes.keySet().iterator();
            key2 = null;
            name = null;
            block9: while (keyIter.hasNext()) {
                boolean shouldInsert;
                key2 = (String)keyIter.next();
                boolean bl = shouldInsert = !filteredTypes.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.typeModel.insertRow(0, new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.typeModel.getRowCount() - 1) {
                        this.typeModel.addRow(new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = this.typeModel.getRowCount() - 1;
                        continue;
                    }
                    this.typeModel.insertRow(insertAfter + 1, new Object[]{this.unfilteredTypes.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (int i5 = 0; i5 < this.typeModel.getRowCount(); ++i5) {
                    name = (String)this.typeModel.getValueAt(i5, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i5;
                    continue block9;
                }
            }
        }
    }

    @Override
    protected void showTiersTab() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        this.model.removeTableModelListener(this);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (this.selectedTierNames.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    @Override
    protected void updateLinguisticTypes() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.typeModel.findColumn("select");
            int nameCol = this.typeModel.findColumn("tier");
            for (int i = 0; i < this.typeModel.getRowCount(); ++i) {
                String typeName;
                Vector visibleTiers;
                Object include = this.typeModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue() || (visibleTiers = this.transcription.getTiersWithLinguisticType(typeName = (String)this.typeModel.getValueAt(i, nameCol))) == null) continue;
                for (int x = 0; x < visibleTiers.size(); ++x) {
                    this.selectedTierNames.add(((TierImpl)visibleTiers.get(x)).getName());
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }

    @Override
    protected void updateParticipants() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.partModel.findColumn("select");
            int nameCol = this.partModel.findColumn("tier");
            for (int i = 0; i < this.partModel.getRowCount(); ++i) {
                Object include = this.partModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String participant = (String)this.partModel.getValueAt(i, nameCol);
                for (String s : this.allTierNames) {
                    TierImpl tier = (TierImpl)this.transcription.getTierWithId(s);
                    String partName = tier.getParticipant();
                    if ((partName == null || partName.length() == 0) && participant == "not specified") {
                        this.selectedTierNames.add(tier.getName());
                        continue;
                    }
                    if (!participant.equals(partName)) continue;
                    this.selectedTierNames.add(tier.getName());
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }

    @Override
    protected void updateAnnotators() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.annotModel.findColumn("select");
            int nameCol = this.annotModel.findColumn("tier");
            for (int i = 0; i < this.annotModel.getRowCount(); ++i) {
                Object include = this.annotModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String annotator = (String)this.annotModel.getValueAt(i, nameCol);
                for (String s : this.allTierNames) {
                    TierImpl tier = (TierImpl)this.transcription.getTierWithId(s);
                    String annotName = tier.getAnnotator();
                    if ((annotName == null || annotName.length() == 0) && annotator == "not specified") {
                        this.selectedTierNames.add(tier.getName());
                        continue;
                    }
                    if (!annotator.equals(annotName)) continue;
                    this.selectedTierNames.add(tier.getName());
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }
}

