/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTwoTierOpDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TokenizeDialog
extends AbstractTwoTierOpDialog
implements ActionListener,
ItemListener,
ChangeListener {
    private JRadioButton customDelimRB;
    private JLabel tokenDelimLabel;
    private JPanel extraOptionsPanel;
    private JRadioButton defaultDelimRB;
    private JTextField customDelimField;
    private ButtonGroup delimButtonGroup;
    private final char[] DEF_DELIMS = new char[]{'\t', '\n', '\r', '\f'};

    public TokenizeDialog(Transcription transcription) {
        super(transcription);
        this.initOptionsPanel();
        this.updateLocale();
        this.loadPreferences();
        this.postInit();
    }

    @Override
    protected void extractDestinationTiers() {
        this.destTierComboBox.removeAllItems();
        this.destTierComboBox.addItem("-");
        if (this.sourceTierComboBox.getSelectedItem() != null && this.sourceTierComboBox.getSelectedItem() != "-") {
            String name = (String)this.sourceTierComboBox.getSelectedItem();
            TierImpl source = (TierImpl)this.transcription.getTierWithId(name);
            Vector depTiers = source.getDependentTiers();
            Iterator tierIt = depTiers.iterator();
            TierImpl dest = null;
            LinguisticType lt = null;
            while (tierIt.hasNext()) {
                dest = (TierImpl)tierIt.next();
                lt = dest.getLinguisticType();
                if (dest.getParentTier() != source || lt.getConstraints().getStereoType() != 0 && lt.getConstraints().getStereoType() != 3) continue;
                this.destTierComboBox.addItem(dest.getName());
            }
            if (this.destTierComboBox.getItemCount() > 1) {
                this.destTierComboBox.removeItem("-");
            }
        }
    }

    @Override
    protected void startOperation() {
        String sourceName = (String)this.sourceTierComboBox.getSelectedItem();
        String destName = (String)this.destTierComboBox.getSelectedItem();
        String delimsText = null;
        boolean preserveExisting = this.preserveRB.isSelected();
        boolean createEmptyAnnotations = this.emptyAnnCheckBox.isSelected();
        if (sourceName == "-" || destName == "-") {
            this.showWarningDialog(ElanLocale.getString("TokenizeDialog.Message.InvalidTiers"));
            return;
        }
        if (this.customDelimRB.isSelected()) {
            delimsText = this.customDelimField.getText();
            if (delimsText == null || delimsText.length() == 0) {
                this.showWarningDialog(ElanLocale.getString("TokenizeDialog.Message.NoDelimiter"));
                return;
            }
            delimsText = this.checkDelimiters(delimsText);
        }
        this.storePreferences();
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.Tokenize");
        Object[] args = new Object[]{sourceName, destName, delimsText, new Boolean(preserveExisting), new Boolean(createEmptyAnnotations)};
        com.execute(this.transcription, args);
    }

    private String checkDelimiters(String delim) {
        StringBuffer buffer = new StringBuffer(delim);
        for (int i = 0; i < this.DEF_DELIMS.length; ++i) {
            if (delim.indexOf(this.DEF_DELIMS[i]) >= 0) continue;
            buffer.append(this.DEF_DELIMS[i]);
        }
        return buffer.toString();
    }

    protected void initOptionsPanel() {
        this.extraOptionsPanel = new JPanel();
        this.delimButtonGroup = new ButtonGroup();
        this.tokenDelimLabel = new JLabel();
        this.defaultDelimRB = new JRadioButton();
        this.customDelimRB = new JRadioButton();
        this.customDelimField = new JTextField();
        Insets insets = new Insets(2, 0, 2, 6);
        this.extraOptionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.tokenDelimLabel, gridBagConstraints);
        this.defaultDelimRB.setSelected(true);
        this.defaultDelimRB.addChangeListener(this);
        this.delimButtonGroup.add(this.defaultDelimRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.defaultDelimRB, gridBagConstraints);
        this.customDelimRB.addChangeListener(this);
        this.delimButtonGroup.add(this.customDelimRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customDelimRB, gridBagConstraints);
        this.customDelimField.setEnabled(false);
        this.customDelimField.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.extraOptionsPanel.add((Component)this.customDelimField, gridBagConstraints);
        this.addOptionsPanel(this.extraOptionsPanel);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("TokenizeDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("TokenizeDialog.Title"));
        this.tokenDelimLabel.setText(ElanLocale.getString("TokenizeDialog.Label.TokenDelimiter"));
        this.defaultDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Default"));
        this.customDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Custom"));
    }

    private void storePreferences() {
        if (this.defaultDelimRB.isSelected()) {
            Preferences.set("TokenizeDialog.DefaultDelimiter", true, null, false, false);
        } else {
            Preferences.set("TokenizeDialog.DefaultDelimiter", false, null, false, false);
            Preferences.set("TokenizeDialog.CustomDelimiter", this.customDelimField.getText(), null, false, false);
        }
        Preferences.set("TokenizeDialog.Overwrite", this.overwriteRB.isSelected(), null, false, false);
        Preferences.set("TokenizeDialog.ProcessEmptyAnnotations", this.emptyAnnCheckBox.isSelected(), null, false, false);
    }

    private void loadPreferences() {
        boolean defde;
        Object val = null;
        val = Preferences.get("TokenizeDialog.DefaultDelimiter", null);
        if (val instanceof Boolean && !(defde = ((Boolean)val).booleanValue())) {
            this.customDelimRB.setSelected(true);
            val = Preferences.get("TokenizeDialog.CustomDelimiter", null);
            if (val instanceof String) {
                this.customDelimField.setText((String)val);
            }
        }
        if ((val = Preferences.get("TokenizeDialog.Overwrite", null)) instanceof Boolean) {
            boolean overwr = (Boolean)val;
            if (overwr) {
                this.overwriteRB.setSelected(true);
            } else {
                this.preserveRB.setSelected(true);
            }
        }
        if ((val = Preferences.get("TokenizeDialog.ProcessEmptyAnnotations", null)) instanceof Boolean) {
            this.emptyAnnCheckBox.setSelected((Boolean)val);
        }
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (this.defaultDelimRB.isSelected()) {
            this.customDelimField.setEnabled(false);
        } else {
            this.customDelimField.setEnabled(true);
            this.customDelimField.requestFocus();
        }
    }
}

