/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.ExportStatistics;
import mpi.eudico.client.annotator.gui.AbstractStatisticsPanel;
import mpi.eudico.client.annotator.gui.AnnotationStatisticsPanel;
import mpi.eudico.client.annotator.gui.AnnotationStatisticsPanel2;
import mpi.eudico.client.annotator.gui.AnnotatorStatisticsPanel;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.annotator.gui.LinguisticTypeStatisticsPanel;
import mpi.eudico.client.annotator.gui.ParticipantStatisticsPanel;
import mpi.eudico.client.annotator.gui.TierStatisticsPanel;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class StatisticsFrame
extends ClosableFrame
implements ActionListener,
ClientLogger {
    private TranscriptionImpl transcription;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JTabbedPane tabPane;
    private JButton saveButton;
    private JButton closeButton;
    private JPanel buttonPanel;
    private ElanMediaPlayer player;
    private long mediaDuration;

    public StatisticsFrame(Transcription transcription) {
        this.transcription = (TranscriptionImpl)transcription;
        this.player = ELANCommandFactory.getViewerManager(transcription).getMasterMediaPlayer();
        if (this.player != null) {
            this.mediaDuration = this.player.getMediaDuration();
            this.initComponents();
            this.postInit();
            this.tabPane.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.titlePanel = new JPanel();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Annotation"), new AnnotationStatisticsPanel(this.transcription, this.mediaDuration));
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Annotation") + " II", new AnnotationStatisticsPanel2(this.transcription, this.mediaDuration));
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Tier"), new TierStatisticsPanel(this.transcription, this.mediaDuration));
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Type"), new LinguisticTypeStatisticsPanel(this.transcription, this.mediaDuration));
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Participant"), new ParticipantStatisticsPanel(this.transcription, this.mediaDuration));
        this.tabPane.addTab(ElanLocale.getString("Statistics.Panel.Annotator"), new AnnotatorStatisticsPanel(this.transcription, this.mediaDuration));
        this.saveButton = new JButton();
        this.closeButton = new JButton();
        this.buttonPanel = new JPanel();
        this.updateLocale();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 2));
        this.saveButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.getRootPane().setDefaultButton(this.closeButton);
    }

    private void postInit() {
        this.pack();
        int w = 550;
        int h = 450;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    public void updateLocale() {
        this.setTitle(ElanLocale.getString("Menu.View.Statistics"));
        this.titleLabel.setText(ElanLocale.getString("Statistics.Title"));
        this.saveButton.setText(ElanLocale.getString("Button.Save"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.saveButton) {
            Component panel = this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
            if (panel instanceof AbstractStatisticsPanel) {
                new ExportStatistics((Frame)this, true, (Transcription)this.transcription, ((AbstractStatisticsPanel)panel).getStatisticsTable());
            }
        } else if (source == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

