/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.ColumnSorter;
import mpi.eudico.client.annotator.gui.ShortcutEditPanel;
import mpi.eudico.client.annotator.gui.ShortcutReplaceDialog;

public class ShortcutPanel
extends JPanel
implements ActionListener {
    private JTabbedPane shortcutPane;
    private JComboBox sortBox;
    private JButton cancelButton;
    private JButton editButton;
    private JButton reloadButton;
    private JButton reloadAllButton;
    private JButton saveButton;
    public Boolean replaceShortcut = false;
    public boolean saveChanges = false;
    private Map<String, Map<String, KeyStroke>> shortcutKeyStrokesMap;
    HashMap<KeyStroke, HashMap<String, List<String>>> keyStrokeClashMap;
    private HashMap<String, List<String>> keyStrokeModeMap;
    private HashMap<String, Color> colorMap;
    private HashMap<String, Integer> clashModeMap;
    private final ShortcutsUtil scu = ShortcutsUtil.getInstance();
    private final String[] columnNames = new String[]{ElanLocale.getString("Shortcuts.Table.Description"), ElanLocale.getString("Shortcuts.Table.Category"), ElanLocale.getString("Shortcuts.Table.Key"), "ActionID", "Keycode", "Modifiercode"};
    private final int desc_col = 2;
    private final int action_col = 3;
    private final int keycode_col = 4;
    private final int mod_col = 5;

    public ShortcutPanel() {
        this.shortcutKeyStrokesMap = new HashMap<String, Map<String, KeyStroke>>();
        this.keyStrokeClashMap = new HashMap();
        this.keyStrokeModeMap = new HashMap();
        this.colorMap = new HashMap();
        this.clashModeMap = new HashMap();
        HashMap<String, KeyStroke> map = new HashMap<String, KeyStroke>();
        map.putAll(this.scu.getShortcutKeysOnlyIn("Shortcuts.Common"));
        this.shortcutKeyStrokesMap.put("Shortcuts.Common", map);
        map = new HashMap();
        map.putAll(this.scu.getShortcutKeysOnlyIn("Menu.Options.AnnotationMode"));
        this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", map);
        map = new HashMap();
        map.putAll(this.scu.getShortcutKeysOnlyIn("Menu.Options.TranscriptionMode"));
        this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", map);
        map = new HashMap();
        map.putAll(this.scu.getShortcutKeysOnlyIn("Menu.Options.SyncMode"));
        this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", map);
        map = new HashMap();
        map.putAll(this.scu.getShortcutKeysOnlyIn("Menu.Options.SegmentationMode"));
        this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", map);
        this.setLayout(new GridBagLayout());
        this.initializeTabPane();
        GridBagConstraints gbc = new GridBagConstraints();
        Insets insets = new Insets(2, 6, 2, 6);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.add((Component)this.shortcutPane, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 6, 2, 2));
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        this.add((Component)buttonPanel, gbc);
        JLabel sortLabel = new JLabel(ElanLocale.getString("Shortcuts.Table.SortBy"));
        sortLabel.setHorizontalAlignment(4);
        sortLabel.setVerticalTextPosition(3);
        sortLabel.setHorizontalTextPosition(10);
        buttonPanel.add(sortLabel);
        String[] sortOptions = new String[]{ElanLocale.getString("Shortcuts.Table.Description"), ElanLocale.getString("Shortcuts.Table.Category"), ElanLocale.getString("Shortcuts.Table.Key")};
        this.sortBox = new JComboBox<String>(sortOptions);
        this.sortBox.addActionListener(this);
        buttonPanel.add(this.sortBox);
        this.editButton = new JButton(ElanLocale.getString("Shortcuts.Button.Edit"));
        this.editButton.addActionListener(this);
        this.editButton.setVerticalTextPosition(0);
        this.editButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.editButton);
        this.saveButton = new JButton(ElanLocale.getString("Button.Save"));
        this.saveButton.addActionListener(this);
        this.saveButton.setVerticalTextPosition(0);
        this.saveButton.setHorizontalTextPosition(10);
        this.saveButton.setEnabled(false);
        buttonPanel.add(this.saveButton);
        this.reloadButton = new JButton(ElanLocale.getString("Shortcuts.Button.Default"));
        this.reloadButton.addActionListener(this);
        this.reloadButton.setVerticalTextPosition(0);
        this.reloadButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.reloadButton);
        this.reloadAllButton = new JButton(ElanLocale.getString("Shortcuts.Button.RestoreAll"));
        this.reloadAllButton.addActionListener(this);
        this.reloadAllButton.setVerticalTextPosition(0);
        this.reloadAllButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.reloadAllButton);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setVerticalTextPosition(0);
        this.cancelButton.setHorizontalTextPosition(10);
        buttonPanel.add(this.cancelButton);
        if (this.keyStrokeClashMap.size() > 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Shortcuts.Warning.Clashes"), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    private void initializeTabPane() {
        this.shortcutPane = new JTabbedPane();
        JScrollPane listScrollPane = new JScrollPane(this.getNewTable());
        this.shortcutPane.addTab(ElanLocale.getString("Shortcuts.Common"), listScrollPane);
        listScrollPane = new JScrollPane(this.getNewTable());
        this.shortcutPane.addTab(ElanLocale.getString("Menu.Options.AnnotationMode"), listScrollPane);
        listScrollPane = new JScrollPane(this.getNewTable());
        this.shortcutPane.addTab(ElanLocale.getString("Menu.Options.SyncMode"), listScrollPane);
        listScrollPane = new JScrollPane(this.getNewTable());
        this.shortcutPane.addTab(ElanLocale.getString("Menu.Options.TranscriptionMode"), listScrollPane);
        listScrollPane = new JScrollPane(this.getNewTable());
        this.shortcutPane.addTab(ElanLocale.getString("Menu.Options.SegmentationMode"), listScrollPane);
        for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
            String modeName = this.getConstant(this.shortcutPane.getTitleAt(i));
            JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(i)).getViewport().getView();
            table.setName(modeName);
            DefaultTableModel model = (DefaultTableModel)table.getModel();
            model.setRowCount(0);
            this.loadTableModel(model, modeName);
        }
        this.computeClashes();
    }

    private JTable getNewTable() {
        DefaultTableModel model = new DefaultTableModel(0, this.columnNames.length);
        model.setColumnIdentifiers(this.columnNames);
        JTable table = new JTable(model){

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return false;
            }
        };
        table.getTableHeader().setReorderingAllowed(false);
        table.getColumn("ActionID").setMinWidth(0);
        table.getColumn("ActionID").setMaxWidth(0);
        table.getColumn("Keycode").setMinWidth(0);
        table.getColumn("Keycode").setMaxWidth(0);
        table.getColumn("Modifiercode").setMinWidth(0);
        table.getColumn("Modifiercode").setMaxWidth(0);
        table.setSelectionMode(0);
        ShortcutClashRenderer renderer = new ShortcutClashRenderer();
        table.getColumn(ElanLocale.getString("Shortcuts.Table.Description")).setCellRenderer(renderer);
        table.getColumn(ElanLocale.getString("Shortcuts.Table.Category")).setCellRenderer(renderer);
        table.getColumn(ElanLocale.getString("Shortcuts.Table.Key")).setCellRenderer(renderer);
        return table;
    }

    private void loadTableModel(DefaultTableModel model, String modeName) {
        Map<String, KeyStroke> allShortCuts = this.shortcutKeyStrokesMap.get(modeName);
        ArrayList<String> allActions = new ArrayList<String>();
        Iterator<String> it = allShortCuts.keySet().iterator();
        while (it.hasNext()) {
            allActions.add(it.next());
        }
        String[] nameArray = allActions.toArray(new String[0]);
        int numberOfShortCuts = allShortCuts.size();
        for (int i = 0; i < numberOfShortCuts; ++i) {
            String actionName = nameArray[i];
            String description = this.scu.getDescriptionForAction(actionName);
            String category = ElanLocale.getString(this.scu.getCategoryForAction(modeName, actionName));
            KeyStroke ks = allShortCuts.get(actionName);
            String keyStrokeName = this.scu.getDescriptionForKeyStroke(ks);
            String keyCode = "";
            String modCode = "";
            if (ks != null) {
                keyCode = Integer.toString(ks.getKeyCode());
                modCode = Integer.toString(ks.getModifiers());
            }
            Object[] row = new String[]{description, category, keyStrokeName, actionName, keyCode, modCode};
            model.addRow(row);
        }
        this.convertToKeyBoardClashMap(modeName);
        Collections.sort(model.getDataVector(), new ColumnSorter(0));
    }

    private void convertToKeyBoardClashMap(String modeName) {
        List<String> actionList;
        KeyStroke ks;
        HashMap map = new HashMap();
        for (Map.Entry<String, KeyStroke> entry : this.shortcutKeyStrokesMap.get(modeName).entrySet()) {
            String action = entry.getKey();
            ks = entry.getValue();
            if (ks == null) continue;
            if (map.containsKey(ks)) {
                actionList = (List)map.get(ks);
                actionList.add(action);
                continue;
            }
            actionList = new ArrayList();
            actionList.add(action);
            map.put(ks, actionList);
        }
        if (map.size() > 0) {
            for (Map.Entry<String, KeyStroke> entry : map.entrySet()) {
                ks = (KeyStroke)((Object)entry.getKey());
                actionList = (List)((Object)entry.getValue());
                if (actionList == null) continue;
                if (!this.keyStrokeClashMap.containsKey(ks)) {
                    this.keyStrokeClashMap.put(ks, new HashMap());
                }
                this.keyStrokeClashMap.get(ks).put(modeName, actionList);
            }
        }
    }

    private void computeClashes() {
        HashMap<String, List<String>> actionMap;
        KeyStroke ks;
        HashMap<KeyStroke, HashMap<String, List<String>>> clashMap = new HashMap<KeyStroke, HashMap<String, List<String>>>();
        for (Map.Entry<KeyStroke, HashMap<String, List<String>>> pair : this.keyStrokeClashMap.entrySet()) {
            List<String> actionList;
            ks = pair.getKey();
            actionMap = pair.getValue();
            if (actionMap == null) continue;
            if (actionMap.size() == 1) {
                for (Map.Entry<String, List<String>> pair1 : actionMap.entrySet()) {
                    String modeName = pair1.getKey();
                    actionList = pair1.getValue();
                    if (actionList == null || actionList.size() <= 1) continue;
                    clashMap.put(ks, actionMap);
                }
                continue;
            }
            if (actionMap.size() <= 1 || (actionList = actionMap.get("Shortcuts.Common")) == null || actionList.size() <= 0) continue;
            clashMap.put(ks, actionMap);
        }
        this.keyStrokeClashMap = clashMap;
        if (this.keyStrokeClashMap.size() > 0) {
            for (Map.Entry<KeyStroke, HashMap<String, List<String>>> pair : this.keyStrokeClashMap.entrySet()) {
                ks = pair.getKey();
                actionMap = pair.getValue();
                if (actionMap == null) continue;
                String ksName = this.scu.getDescriptionForKeyStroke(ks);
                if (!this.colorMap.containsKey(ksName)) {
                    this.colorMap.put(ksName, this.getNewColor());
                }
                for (String modeName : actionMap.keySet()) {
                    if (!this.keyStrokeModeMap.containsKey(ksName)) {
                        this.keyStrokeModeMap.put(ksName, new ArrayList());
                    }
                    this.keyStrokeModeMap.get(ksName).add(modeName);
                    if (!this.clashModeMap.containsKey(modeName)) {
                        this.clashModeMap.put(modeName, 0);
                    }
                    this.clashModeMap.put(modeName, this.clashModeMap.get(modeName) + 1);
                }
            }
            this.highLightTabWithClashes();
        }
    }

    private Color getNewColor() {
        int b;
        int g;
        double FACTOR;
        int r;
        Color c;
        while ((c = new Color((int)(255.0 - (double)(255 - (r = (int)(Math.random() * 255.0))) * (FACTOR = 0.16)), (int)(255.0 - (double)(255 - (g = (int)(Math.random() * 255.0))) * FACTOR), (int)(255.0 - (double)(255 - (b = (int)(Math.random() * 255.0))) * FACTOR))) == Color.BLACK || c == Color.WHITE || this.colorMap.containsValue(c)) {
        }
        return c;
    }

    private String getConstant(String tabName) {
        String constant = null;
        if (tabName.equals(ElanLocale.getString("Shortcuts.Common"))) {
            constant = "Shortcuts.Common";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.AnnotationMode"))) {
            constant = "Menu.Options.AnnotationMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.TranscriptionMode"))) {
            constant = "Menu.Options.TranscriptionMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.SyncMode"))) {
            constant = "Menu.Options.SyncMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.SegmentationMode"))) {
            constant = "Menu.Options.SegmentationMode";
        }
        return constant;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sortBox) {
            JComboBox cb = (JComboBox)e.getSource();
            int index = cb.getSelectedIndex();
            JTable table = null;
            for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
                table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(i)).getViewport().getView();
                DefaultTableModel dtmodel = (DefaultTableModel)table.getModel();
                Vector<Vector> data = dtmodel.getDataVector();
                Collections.sort(data, new ColumnSorter(index));
                dtmodel.fireTableStructureChanged();
                table.getColumn("ActionID").setMinWidth(0);
                table.getColumn("ActionID").setMaxWidth(0);
                table.getColumn("Keycode").setMinWidth(0);
                table.getColumn("Keycode").setMaxWidth(0);
                table.getColumn("Modifiercode").setMinWidth(0);
                table.getColumn("Modifiercode").setMaxWidth(0);
            }
        } else if (e.getSource() == this.editButton) {
            JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(this.shortcutPane.getSelectedIndex())).getViewport().getView();
            int row = table.getSelectedRow();
            if (row > -1) {
                String selectedAction = (String)table.getValueAt(row, 3);
                String shortcutKey = (String)table.getValueAt(row, 2);
                String keycode = (String)table.getValueAt(row, 4);
                String modcode = (String)table.getValueAt(row, 5);
                ArrayList<Integer> codes = new ArrayList<Integer>(2);
                if (shortcutKey == null || shortcutKey.length() <= 0) {
                    codes = null;
                } else {
                    codes.add(Integer.parseInt(keycode));
                    codes.add(Integer.parseInt(modcode));
                }
                this.createEditWindow(selectedAction, codes);
            }
        } else if (e.getSource() == this.saveButton) {
            if (!this.saveChanges) {
                return;
            }
            this.save();
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        } else if (e.getSource() == this.reloadButton) {
            String tabName = this.shortcutPane.getTitleAt(this.shortcutPane.getSelectedIndex());
            this.restoreTab(tabName);
            this.saveChanges = true;
        } else if (e.getSource() == this.reloadAllButton) {
            this.scu.restoreAll();
            for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
                this.restoreTab(this.shortcutPane.getTitleAt(i));
            }
            this.saveChanges = true;
        } else if (e.getSource() == this.cancelButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
            this.checkForSave();
        }
        this.saveButton.setEnabled(this.saveChanges);
    }

    private void save() {
        this.scu.saveCurrentShortcuts(this.scu.getStorableShortcutMap(this.shortcutKeyStrokesMap));
        this.saveChanges = false;
        this.scu.readCurrentShortcuts();
        FrameManager.getInstance().updateShortcuts();
    }

    void checkForSave() {
        if (this.saveChanges) {
            String strMessage = "Shorts have been changed. Do you want to save changes?";
            String strWarning = ElanLocale.getString("Message.Warning");
            int i = JOptionPane.showOptionDialog(this, strMessage, strWarning, 0, 2, null, null, null);
            if (i == 0) {
                this.save();
            } else {
                this.saveChanges = false;
                this.scu.readCurrentShortcuts();
            }
        }
    }

    private void restoreTab(String tabName) {
        this.scu.restoreDefaultShortcutsForthisMode(this.getConstant(tabName));
        Map<String, KeyStroke> allShortCuts = this.scu.getShortcutKeysOnlyIn(this.getConstant(tabName));
        this.shortcutKeyStrokesMap.put(this.getConstant(tabName), allShortCuts);
        int index = this.shortcutPane.indexOfTab(tabName);
        JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(index)).getViewport().getView();
        int noOfRows = table.getRowCount();
        for (int i = 0; i < noOfRows; ++i) {
            String action;
            KeyStroke aKeyStroke;
            int tableKeyCode = 0;
            int tableModCode = 0;
            int dataKeyCode = 0;
            int dataModCode = 0;
            String tableKeyCodeAsString = (String)table.getValueAt(i, 4);
            String tableModCodeAsString = (String)table.getValueAt(i, 5);
            if (tableKeyCodeAsString != "") {
                tableKeyCode = Integer.parseInt(tableKeyCodeAsString);
            }
            if (tableModCodeAsString != "") {
                tableModCode = Integer.parseInt(tableModCodeAsString);
            }
            if ((aKeyStroke = allShortCuts.get(action = (String)table.getValueAt(i, 3))) != null) {
                dataKeyCode = aKeyStroke.getKeyCode();
                dataModCode = aKeyStroke.getModifiers();
            }
            if (tableKeyCode == dataKeyCode && tableModCode == dataModCode) continue;
            table.setValueAt(Integer.toString(dataKeyCode), i, 4);
            table.setValueAt(Integer.toString(dataModCode), i, 5);
            String keyStrokeName = this.scu.getDescriptionForKeyStroke(aKeyStroke);
            table.setValueAt(keyStrokeName, i, 2);
        }
    }

    private void createEditWindow(String selectedAction, ArrayList<Integer> codes) {
        ShortcutEditPanel.createAndShowGUI(this, selectedAction, codes);
    }

    public void changeShortcut(KeyStroke ks, boolean applyInAllModes) {
        JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(this.shortcutPane.getSelectedIndex())).getViewport().getView();
        String action = (String)table.getValueAt(table.getSelectedRow(), 3);
        if (applyInAllModes) {
            for (int index = 0; index < this.shortcutPane.getTabCount(); ++index) {
                String tabName = this.shortcutPane.getTitleAt(index);
                for (Map.Entry<String, List<String>> pair : this.scu.getShortcuttableActions(this.getConstant(tabName)).entrySet()) {
                    List<String> actions = pair.getValue();
                    if (actions == null || !actions.contains(action)) continue;
                    this.changeShortcut(action, ks, tabName);
                }
            }
        } else {
            this.changeShortcut(action, ks, this.shortcutPane.getTitleAt(this.shortcutPane.getSelectedIndex()));
        }
    }

    private List<String> getActionsWithKeyStroke(String modeName, KeyStroke ks) {
        ArrayList<String> actionList = new ArrayList<String>();
        for (Map.Entry<String, KeyStroke> pair : this.shortcutKeyStrokesMap.get(modeName).entrySet()) {
            String action = pair.getKey();
            if (!ks.equals(pair.getValue())) continue;
            actionList.add(action);
        }
        return actionList;
    }

    private boolean isKeystrokeUsed(String action, KeyStroke ks, String tabName) {
        List actionList;
        boolean replaceDialog = false;
        HashMap<String, List> replaceShortcutsMap = new HashMap<String, List>();
        if (tabName.equals(ElanLocale.getString("Shortcuts.Common"))) {
            for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
                String modeName = this.getConstant(this.shortcutPane.getTitleAt(i));
                if (!this.shortcutKeyStrokesMap.get(modeName).containsValue(ks)) continue;
                actionList = this.getActionsWithKeyStroke(modeName, ks);
                if (actionList.contains(action)) {
                    actionList.remove(action);
                }
                if (actionList.size() <= 0) continue;
                replaceShortcutsMap.put(modeName, actionList);
            }
        } else {
            String modeName = this.getConstant(tabName);
            if (this.shortcutKeyStrokesMap.get(modeName).containsValue(ks)) {
                actionList = this.getActionsWithKeyStroke(modeName, ks);
                if (actionList.contains(action)) {
                    actionList.remove(action);
                }
                if (actionList.size() > 0) {
                    replaceShortcutsMap.put(modeName, actionList);
                }
            }
            if (this.shortcutKeyStrokesMap.get("Shortcuts.Common").containsValue(ks)) {
                actionList = this.getActionsWithKeyStroke("Shortcuts.Common", ks);
                if (actionList.contains(action)) {
                    actionList.remove(action);
                }
                if (actionList.size() > 0) {
                    replaceShortcutsMap.put("Shortcuts.Common", actionList);
                }
            }
        }
        if (replaceShortcutsMap.size() > 0) {
            StringBuffer actionDesc = new StringBuffer();
            String eol = System.getProperty("line.separator");
            for (Map.Entry pair : replaceShortcutsMap.entrySet()) {
                String modeName = (String)pair.getKey();
                actionList = (List)pair.getValue();
                if (actionList == null) continue;
                for (int i = 0; i < actionList.size(); ++i) {
                    actionDesc.append((String)actionList.get(i) + " - " + ElanLocale.getString(modeName) + eol);
                }
            }
            ShortcutReplaceDialog srd = new ShortcutReplaceDialog(this, actionDesc.toString(), ks);
            srd.pack();
            srd.setLocationRelativeTo((JDialog)SwingUtilities.getWindowAncestor(this));
            srd.setModal(true);
            srd.setVisible(true);
            if (this.replaceShortcut.booleanValue()) {
                for (Map.Entry pair : replaceShortcutsMap.entrySet()) {
                    String modeName = (String)pair.getKey();
                    JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(this.shortcutPane.indexOfTab(ElanLocale.getString(modeName)))).getViewport().getView();
                    actionList = (List)pair.getValue();
                    if (actionList != null) {
                        for (int i = 0; i < actionList.size(); ++i) {
                            int rowIndex = this.getRowForAction(table, (String)actionList.get(i));
                            if (rowIndex < 0) continue;
                            table.setValueAt("", rowIndex, 2);
                            table.setValueAt("", rowIndex, 4);
                            table.setValueAt("", rowIndex, 5);
                            action = (String)actionList.get(i);
                            this.updateClashesFor(this.shortcutKeyStrokesMap.get(modeName).get(action), modeName, action);
                            this.shortcutKeyStrokesMap.get(modeName).put(action, null);
                        }
                    }
                    table.repaint();
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void updateClashesFor(KeyStroke ks, String modeName, String action) {
        if (this.keyStrokeClashMap.containsKey(ks)) {
            HashMap<String, List<String>> actionMap = this.keyStrokeClashMap.get(ks);
            if (actionMap != null && actionMap.containsKey(modeName)) {
                List<String> actionList = actionMap.get(modeName);
                if (actionList != null && actionList.contains(action)) {
                    actionList.remove(action);
                    if (actionList.size() <= 0) {
                        actionMap.remove(modeName);
                        this.clashModeMap.put(modeName, this.clashModeMap.get(modeName) - 1);
                        this.keyStrokeModeMap.get(this.scu.getDescriptionForKeyStroke(ks)).remove(modeName);
                    }
                }
                if (actionMap.size() == 0) {
                    this.keyStrokeClashMap.remove(ks);
                    this.keyStrokeModeMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                    this.colorMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                } else if (actionMap.size() == 1) {
                    for (Map.Entry<String, List<String>> pair : actionMap.entrySet()) {
                        modeName = pair.getKey();
                        actionList = pair.getValue();
                        if (actionList != null && actionList.size() > 1) continue;
                        this.clashModeMap.put(modeName, this.clashModeMap.get(modeName) - 1);
                        this.keyStrokeClashMap.remove(ks);
                        this.keyStrokeModeMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                        this.colorMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                    }
                } else if (actionMap.size() > 1 && modeName.equals("Shortcuts.Common") && ((actionList = actionMap.get(modeName)) == null || actionList.size() == 0)) {
                    Iterator<Map.Entry<String, List<String>>> it = actionMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, List<String>> pair = it.next();
                        modeName = pair.getKey();
                        actionList = pair.getValue();
                        if (actionList != null && actionList.size() > 1) continue;
                        this.clashModeMap.put(modeName, this.clashModeMap.get(modeName) - 1);
                        this.keyStrokeModeMap.get(this.scu.getDescriptionForKeyStroke(ks)).remove(modeName);
                        it.remove();
                    }
                    if (actionMap.size() == 0) {
                        this.keyStrokeClashMap.remove(ks);
                        this.keyStrokeModeMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                        this.colorMap.remove(this.scu.getDescriptionForKeyStroke(ks));
                    }
                }
            }
            this.highLightTabWithClashes();
        }
    }

    private void highLightTabWithClashes() {
        for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
            String modeName = this.getConstant(this.shortcutPane.getTitleAt(i));
            if (!this.clashModeMap.containsKey(modeName)) continue;
            if (this.clashModeMap.get(modeName) > 0) {
                this.shortcutPane.setBackgroundAt(i, Color.RED);
                continue;
            }
            this.shortcutPane.setBackgroundAt(i, this.shortcutPane.getBackground());
        }
    }

    private void changeShortcut(String action, KeyStroke ks, String tabName) {
        JTable table = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(this.shortcutPane.indexOfTab(tabName))).getViewport().getView();
        int row = this.getRowForAction(table, action);
        if (row < 0) {
            return;
        }
        String keydesc = this.scu.getDescriptionForKeyStroke(ks);
        String keycodestring = "";
        String modstring = "";
        if (ks != null) {
            if (this.isKeystrokeUsed(action, ks, tabName)) {
                return;
            }
            keycodestring = Integer.toString(ks.getKeyCode());
            modstring = Integer.toString(ks.getModifiers());
        }
        table.setValueAt(keydesc, row, 2);
        table.setValueAt(keycodestring, row, 4);
        table.setValueAt(modstring, row, 5);
        table.repaint();
        this.updateClashesFor(this.shortcutKeyStrokesMap.get(this.getConstant(tabName)).get(action), this.getConstant(tabName), action);
        this.shortcutKeyStrokesMap.get(this.getConstant(tabName)).put(action, ks);
        this.saveChanges = true;
        this.saveButton.setEnabled(this.saveChanges);
    }

    private int getRowForAction(JTable table, String oldAction) {
        int noOfRows = table.getRowCount();
        for (int i = 0; i < noOfRows; ++i) {
            String tableresult = (String)table.getValueAt(i, 3);
            if (tableresult.compareTo(oldAction) != 0) continue;
            return i;
        }
        return -1;
    }

    public static void createAndShowGUI(Window owner) {
        JDialog frame = null;
        if (owner instanceof Dialog) {
            frame = new JDialog((Dialog)owner, ElanLocale.getString("Shortcuts.Table.Title"), true);
        } else if (owner instanceof Frame) {
            frame = new JDialog((Frame)owner, ElanLocale.getString("Shortcuts.Table.Title"), true);
        }
        if (frame == null) {
            return;
        }
        ShortcutPanel newContentPane = new ShortcutPanel();
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setLocationRelativeTo(owner);
        frame.setVisible(true);
        newContentPane.checkForSave();
    }

    class ShortcutClashRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                String modeName = table.getName();
                String keyStrokeName = (String)table.getValueAt(row, 2);
                if (ShortcutPanel.this.keyStrokeModeMap.get(keyStrokeName) != null && ((List)ShortcutPanel.this.keyStrokeModeMap.get(keyStrokeName)).contains(modeName)) {
                    cell.setBackground((Color)ShortcutPanel.this.colorMap.get(keyStrokeName));
                } else {
                    cell.setBackground(table.getBackground());
                }
            }
            return cell;
        }
    }
}

