/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class ShoeboxMarkerDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    public final String none = "None";
    private Frame frame;
    private JLabel titleLabel = new JLabel();
    private JLabel currentMarkerLabel = new JLabel();
    private JLabel markerLabel = new JLabel();
    private JLabel parentLabel = new JLabel();
    private JLabel constraintsLabel = new JLabel();
    private JLabel charsetLabel = new JLabel();
    private JLabel participantLabel = new JLabel();
    private JLabel excludeLabel = new JLabel();
    private JComboBox currentMarkers = new JComboBox();
    private JTextField markerTextField = new JTextField(30);
    private JComboBox parents = new JComboBox();
    private JComboBox constraints = new JComboBox();
    private JComboBox charsets = new JComboBox();
    private JCheckBox participantMarker = new JCheckBox();
    private JCheckBox excludeCheckBox = new JCheckBox();
    private JButton changeButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton addButton = new JButton();
    private JButton deleteButton = new JButton();
    private JButton loadButton = new JButton();
    private JButton storeButton = new JButton();
    private JPanel titlePanel = new JPanel();
    private JPanel markerPanel = new JPanel();
    private JPanel buttonPanel1 = new JPanel(new GridLayout(3, 1, 2, 6));
    private JPanel buttonPanel2 = new JPanel(new GridLayout(1, 1, 0, 2));
    private JPanel buttonPanel3 = new JPanel(new GridLayout(1, 3, 6, 6));
    private ArrayList markers = new ArrayList();
    private boolean toolboxMode = false;

    public ShoeboxMarkerDialog(Frame theFrame, boolean modal) {
        this(theFrame, modal, false);
    }

    public ShoeboxMarkerDialog(Frame theFrame, boolean modal, boolean toolboxMode) {
        super(theFrame, modal);
        this.frame = theFrame;
        this.toolboxMode = toolboxMode;
        this.loadMarkers();
        this.createDialog();
        this.updateForLocale();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.frame);
    }

    public static Object showDialog(Frame parent) {
        ShoeboxMarkerDialog dlg = new ShoeboxMarkerDialog(parent, true);
        Object o = dlg.getValue();
        return o;
    }

    public static Object showDialog(Frame parent, boolean toolboxMode) {
        ShoeboxMarkerDialog dlg = new ShoeboxMarkerDialog(parent, true, toolboxMode);
        Object o = dlg.getValue();
        return o;
    }

    public Object getValue() {
        return this.markers;
    }

    public List getMarkers() {
        return this.markers;
    }

    private void loadMarkers() {
        Object markerFile = Preferences.get("LastUsedShoeboxMarkerFile", null);
        if (markerFile instanceof String) {
            File f = new File((String)markerFile);
            this.loadMarkersFromFile(f);
        }
    }

    private void updateUIForMarker(String markerName) {
        if (markerName != null) {
            this.markerTextField.setText(markerName);
            Iterator markerIt = this.getMarkers().iterator();
            MarkerRecord mr = null;
            while (markerIt.hasNext()) {
                mr = (MarkerRecord)markerIt.next();
                if (!mr.getMarker().equals(markerName)) continue;
                this.currentMarkers.setSelectedItem(mr.getMarker());
                this.fillParentMenu();
                this.parents.setSelectedItem(mr.getParentMarker());
                String stereoType = mr.getStereoType();
                if (stereoType != null) {
                    this.constraints.setSelectedItem(mr.getStereoType());
                } else {
                    this.constraints.setSelectedItem("None");
                }
                if (!this.toolboxMode) {
                    this.charsets.setSelectedItem(mr.getCharsetString());
                }
                this.participantMarker.setSelected(mr.getParticipantMarker());
                this.excludeCheckBox.setSelected(mr.isExcluded());
                break;
            }
        }
    }

    private void fillCurrentMarkersMenu() {
        this.currentMarkers.removeAllItems();
        for (MarkerRecord mr : this.getMarkers()) {
            this.currentMarkers.addItem(mr.getMarker());
        }
    }

    private void fillParentMenu() {
        this.parents.removeAllItems();
        for (MarkerRecord mr : this.getMarkers()) {
            this.parents.addItem(mr.getMarker());
        }
        if (this.parents.getItemCount() > 0) {
            this.parents.setSelectedIndex(0);
        }
    }

    private boolean isDescendentOf(MarkerRecord record, String ofMarkerName) {
        if (record.getMarker().equals(ofMarkerName)) {
            return true;
        }
        if (record.getParentMarker() != null && record.getParentMarker().equals(ofMarkerName)) {
            return true;
        }
        boolean isDescendent = false;
        for (MarkerRecord mr : this.getMarkers()) {
            if (mr.getParentMarker() == null || !mr.getParentMarker().equals(ofMarkerName) || !this.isDescendentOf(record, mr.getMarker())) continue;
            isDescendent = true;
            break;
        }
        return isDescendent;
    }

    private void createDialog() {
        this.constraints.addItem("None");
        String[] publicStereoTypes = Constraint.publicStereoTypes;
        for (int i = 0; i < publicStereoTypes.length; ++i) {
            this.constraints.addItem(publicStereoTypes[i]);
        }
        this.charsets.addItem("ISO-Latin-1");
        this.charsets.addItem("Unicode (UTF-8)");
        this.charsets.addItem("SIL IPA");
        if (this.toolboxMode) {
            this.charsets.setSelectedItem("Unicode (UTF-8)");
            this.charsets.setEnabled(false);
        }
        this.currentMarkers.addItemListener(this);
        this.currentMarkers.setMaximumRowCount(20);
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        this.constraints.addItemListener(this);
        this.changeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.loadButton.addActionListener(this);
        this.storeButton.addActionListener(this);
        this.buttonPanel1.add(this.addButton);
        this.buttonPanel1.add(this.deleteButton);
        this.buttonPanel1.add(this.changeButton);
        this.buttonPanel2.add(this.loadButton);
        this.buttonPanel2.add(this.storeButton);
        this.buttonPanel3.add(this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ShoeboxMarkerDialog.this.close();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.markerPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(2, 6, 2, 6);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 11;
        c.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.currentMarkerLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.anchor = 18;
        c.insets = insets;
        this.markerPanel.add((Component)this.currentMarkers, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.markerLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.insets = insets;
        c.weightx = 1.0;
        this.markerPanel.add((Component)this.markerTextField, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.parentLabel, c);
        this.parents.setMaximumRowCount(20);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.anchor = 18;
        c.insets = insets;
        this.markerPanel.add((Component)this.parents, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.constraintsLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 3;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.constraints, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 4;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.charsetLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 4;
        c.anchor = 18;
        c.insets = insets;
        this.markerPanel.add((Component)this.charsets, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.participantLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 5;
        c.anchor = 18;
        c.insets = insets;
        this.markerPanel.add((Component)this.participantMarker, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 17;
        c.insets = insets;
        this.markerPanel.add((Component)this.excludeLabel, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 6;
        c.anchor = 18;
        c.insets = insets;
        this.markerPanel.add((Component)this.excludeCheckBox, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 18;
        c.gridheight = 3;
        c.insets = insets;
        this.markerPanel.add((Component)this.buttonPanel1, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 18;
        c.insets = insets;
        c.weightx = 1.0;
        this.getContentPane().add((Component)this.markerPanel, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel2, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel3, c);
        this.markerPanel.setBorder(new TitledBorder("Markers"));
        if (this.getMarkers().size() > 0) {
            this.fillCurrentMarkersMenu();
            this.updateUIForMarker(((MarkerRecord)this.getMarkers().get(0)).getMarker());
        }
    }

    private void updateForLocale() {
        this.setTitle(ElanLocale.getString("ShoeboxMarkerDialog.Title"));
        this.currentMarkerLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.CurrentMarkers"));
        this.markerLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Type"));
        this.parentLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Parent"));
        this.constraintsLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Stereotype"));
        this.charsetLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Charset"));
        this.participantLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Participant"));
        this.excludeLabel.setText(ElanLocale.getString("ShoeboxMarkerDialog.Label.Exclude"));
        this.cancelButton.setText(ElanLocale.getString("Button.Close"));
        this.addButton.setText(ElanLocale.getString("Button.Add"));
        this.deleteButton.setText(ElanLocale.getString("Button.Delete"));
        this.changeButton.setText(ElanLocale.getString("Button.Change"));
        this.loadButton.setText(ElanLocale.getString("ShoeboxMarkerDialog.Button.Load"));
        this.storeButton.setText(ElanLocale.getString("ShoeboxMarkerDialog.Button.Store"));
        this.setTitle(ElanLocale.getString("ShoeboxMarkerDialog.Title"));
        if (this.currentMarkers.getModel().getSize() > 0) {
            this.updateUIForMarker((String)this.currentMarkers.getItemAt(0));
            this.currentMarkers.addItemListener(this);
        }
        this.titleLabel.setText(this.getTitle());
    }

    private void doAdd(String name) {
        MarkerRecord mr2 = null;
        for (MarkerRecord mr2 : this.getMarkers()) {
            if (!mr2.getMarker().equals(name)) continue;
            String errorMessage = ElanLocale.getString("ShoeboxMarkerDialog.Message.Exists");
            this.markerTextField.requestFocus();
            JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
            return;
        }
        String stereoTypeString = (String)this.constraints.getSelectedItem();
        String parentMkrString = (String)this.parents.getSelectedItem();
        String charsetString = (String)this.charsets.getSelectedItem();
        if (stereoTypeString.equals("None")) {
            stereoTypeString = null;
        }
        if (stereoTypeString != null && parentMkrString == null) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ShoeboxMarkerDialog.Message.Inconsistent"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        if (stereoTypeString == null && parentMkrString != null) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ShoeboxMarkerDialog.Message.Inconsistent2"), ElanLocale.getString("Message.Error"), 0);
            return;
        }
        boolean partMarker = this.participantMarker.isSelected();
        boolean exclude = this.excludeCheckBox.isSelected();
        MarkerRecord newMR = new MarkerRecord();
        newMR.setMarker(name);
        newMR.setParentMarker(parentMkrString);
        newMR.setStereoType(stereoTypeString);
        newMR.setCharset(charsetString);
        newMR.setParticipantMarker(partMarker);
        newMR.setExcluded(exclude);
        if (partMarker) {
            for (MarkerRecord rec : this.getMarkers()) {
                if (rec.getMarker().equals(name)) continue;
                rec.setParticipantMarker(false);
            }
        }
        this.getMarkers().add(newMR);
        this.currentMarkers.addItem(name);
        this.updateUIForMarker(name);
    }

    private void doChange() {
        String markerToChange = (String)this.currentMarkers.getSelectedItem();
        MarkerRecord mr = null;
        Iterator mIter = this.getMarkers().iterator();
        while (mIter.hasNext() && !(mr = (MarkerRecord)mIter.next()).getMarker().equals(markerToChange)) {
        }
        if (mr != null) {
            String newMarker = this.markerTextField.getText();
            newMarker.replace('\n', ' ');
            newMarker.trim();
            if (newMarker.startsWith("\\")) {
                newMarker = newMarker.substring(1);
            }
            if (newMarker.length() == 0) {
                String errorMessage = ElanLocale.getString("ShoeboxMarkerDialog.Message.MarkerName");
                this.markerTextField.requestFocus();
                JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
                return;
            }
            String newParent = (String)this.parents.getSelectedItem();
            String newStereoType = (String)this.constraints.getSelectedItem();
            String newCharset = (String)this.charsets.getSelectedItem();
            boolean newPartMarker = this.participantMarker.isSelected();
            boolean newExclude = this.excludeCheckBox.isSelected();
            if (!newStereoType.equals("None") && newParent == null) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ShoeboxMarkerDialog.Message.Inconsistent"), ElanLocale.getString("Message.Error"), 0);
                this.updateUIForMarker(markerToChange);
                return;
            }
            if (newStereoType.equals("None") && newParent != null) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ShoeboxMarkerDialog.Message.Inconsistent2"), ElanLocale.getString("Message.Error"), 0);
                this.updateUIForMarker(markerToChange);
                return;
            }
            mr.setMarker(newMarker);
            this.currentMarkers.removeItem(markerToChange);
            this.currentMarkers.addItem(newMarker);
            for (MarkerRecord rec : this.getMarkers()) {
                if (rec.getParentMarker() == null || !rec.getParentMarker().equals(markerToChange)) continue;
                rec.setParentMarker(newMarker);
            }
            mr.setParentMarker(newParent);
            mr.setStereoType(newStereoType);
            mr.setCharset(newCharset);
            mr.setParticipantMarker(newPartMarker);
            mr.setExcluded(newExclude);
            if (newPartMarker) {
                for (MarkerRecord rec : this.getMarkers()) {
                    if (rec.getMarker().equals(newMarker)) continue;
                    rec.setParticipantMarker(false);
                }
            }
            this.updateUIForMarker(newMarker);
        }
    }

    private void doDelete() {
        String markerToDelete = (String)this.currentMarkers.getSelectedItem();
        MarkerRecord mr = null;
        Iterator mIter = this.getMarkers().iterator();
        while (mIter.hasNext() && !(mr = (MarkerRecord)mIter.next()).getMarker().equals(markerToDelete)) {
        }
        if (mr != null) {
            this.getMarkers().remove(mr);
            this.currentMarkers.removeItem(mr.getMarker());
            for (MarkerRecord rec : this.getMarkers()) {
                if (rec.getParentMarker() == null || !rec.getParentMarker().equals(mr.getMarker())) continue;
                rec.setParentMarker(null);
            }
        }
        if (this.getMarkers().size() > 0) {
            this.updateUIForMarker(((MarkerRecord)this.getMarkers().get(0)).getMarker());
        }
    }

    private void close() {
        if (this.getMarkers().size() > 0) {
            int numRoots = 0;
            MarkerRecord mr2 = null;
            for (MarkerRecord mr2 : this.getMarkers()) {
                if (mr2.getParentMarker() != null) continue;
                ++numRoots;
            }
            if (numRoots != 1) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ShoeboxMarkerDialog.Message.RootMarkers"), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        this.dispose();
    }

    public void doLoad() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ShoeboxMarkerDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_MKR_EXT, false, "LastUsedShoeboxMarkerDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.loadMarkersFromFile(f);
            Preferences.set("LastUsedShoeboxMarkerFile", f.getAbsolutePath(), null);
        }
    }

    private void loadMarkersFromFile(File f) {
        if (f != null) {
            String line = null;
            this.getMarkers().clear();
            this.currentMarkers.removeAllItems();
            try {
                FileReader filereader = new FileReader(f);
                BufferedReader br = new BufferedReader(filereader);
                MarkerRecord newRecord = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    String label = this.getLabelPart(line);
                    String value = this.getValuePart(line);
                    if (label.equals("marker")) {
                        newRecord = new MarkerRecord();
                        if (value.equals("null")) continue;
                        newRecord.setMarker(value);
                        continue;
                    }
                    if (label.equals("parent")) {
                        if (value.equals("null")) continue;
                        newRecord.setParentMarker(value);
                        continue;
                    }
                    if (label.equals("stereotype")) {
                        if (value.equals("null")) continue;
                        newRecord.setStereoType(value);
                        continue;
                    }
                    if (label.equals("charset")) {
                        if (value.equals("null")) continue;
                        newRecord.setCharset(value);
                        continue;
                    }
                    if (label.equals("exclude")) {
                        if (value.equals("null")) continue;
                        if (value.equals("true")) {
                            newRecord.setExcluded(true);
                            continue;
                        }
                        newRecord.setExcluded(false);
                        continue;
                    }
                    if (!label.equals("participant")) continue;
                    if (!value.equals("null")) {
                        if (value.equals("true")) {
                            newRecord.setParticipantMarker(true);
                        } else {
                            newRecord.setParticipantMarker(false);
                        }
                    }
                    this.getMarkers().add(newRecord);
                    this.currentMarkers.addItem(newRecord.getMarker());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.getMarkers().size() > 0) {
                this.updateUIForMarker(((MarkerRecord)this.getMarkers().get(0)).getMarker());
            }
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(58);
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(58);
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    public void doStore() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ShoeboxMarkerDialog.Title.Select"), 1, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_MKR_EXT, true, "LastUsedShoeboxMarkerDir", 0, null);
        File newSaveFile = chooser.getSelectedFile();
        if (newSaveFile != null) {
            try {
                FileOutputStream out = new FileOutputStream(newSaveFile);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                Iterator markerIter = this.getMarkers().iterator();
                while (markerIter.hasNext()) {
                    writer.write(((MarkerRecord)markerIter.next()).toString());
                }
                Preferences.set("LastUsedShoeboxMarkerFile", newSaveFile.getAbsolutePath(), null);
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.addButton) {
            String markerName = this.markerTextField.getText();
            markerName.replace('\n', ' ');
            markerName.trim();
            if (markerName.startsWith("\\")) {
                markerName = markerName.substring(1);
            }
            if (markerName.length() == 0) {
                String errorMessage = ElanLocale.getString("ShoeboxMarkerDialog.Message.MarkerName");
                this.markerTextField.requestFocus();
                JOptionPane.showMessageDialog(this, errorMessage, ElanLocale.getString("Message.Error"), 0);
                return;
            }
            this.doAdd(markerName);
        } else if (event.getSource() == this.deleteButton) {
            this.doDelete();
        } else if (event.getSource() == this.changeButton) {
            this.doChange();
        } else if (event.getSource() == this.cancelButton) {
            this.close();
        } else if (event.getSource() == this.loadButton) {
            this.doLoad();
        } else if (event.getSource() == this.storeButton) {
            this.doStore();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String name;
        if (e.getSource() == this.currentMarkers && e.getStateChange() == 1 && (name = (String)this.currentMarkers.getSelectedItem()) != null) {
            this.updateUIForMarker(name);
        }
    }
}

