/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.ElanSlider;

public class PlayAroundSelectionDialog
extends ClosableDialog
implements ItemListener,
ActionListener {
    private JPanel content;
    private JLabel unitLabel;
    private JRadioButton framesRB;
    private JRadioButton msRB;
    private JButton okButton;
    private JButton cancelButton;
    private ElanSlider slider;
    private final int maxMsOffset = 5000;
    private int curValue = 500;
    private String mode = "ms";

    public PlayAroundSelectionDialog(Frame owner) {
        super(owner, true);
        Object val = Preferences.get("PlayAroundSelection.Mode", null);
        if (val instanceof String) {
            this.mode = (String)val;
        }
        if ((val = Preferences.get("PlayAroundSelection.Value", null)) instanceof Integer) {
            this.curValue = (Integer)val;
        }
        this.initComponents();
        this.setLocationRelativeTo(owner);
    }

    private void initComponents() {
        Insets inset;
        this.setTitle(ElanLocale.getString("CommandActions.PlayAroundSelection"));
        this.setSize(350, 240);
        this.content = new JPanel(new GridBagLayout());
        this.content.setBorder(new EmptyBorder(6, 6, 6, 6));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = inset = new Insets(2, 2, 12, 2);
        JPanel unitsPanel = new JPanel(new GridBagLayout());
        this.unitLabel = new JLabel(ElanLocale.getString("PlayAroundSelDialog.UnitsLabel"));
        ButtonGroup unitsGroup = new ButtonGroup();
        this.msRB = new JRadioButton(ElanLocale.getString("PlayAroundSelDialog.Ms"));
        this.msRB.setSelected(true);
        this.framesRB = new JRadioButton(ElanLocale.getString("PlayAroundSelDialog.Frames"));
        unitsGroup.add(this.msRB);
        unitsGroup.add(this.framesRB);
        if (!this.mode.equals("ms")) {
            this.framesRB.setSelected(true);
        }
        this.msRB.addItemListener(this);
        this.framesRB.addItemListener(this);
        GridBagConstraints gbcon = new GridBagConstraints();
        gbcon.anchor = 17;
        unitsPanel.add((Component)this.unitLabel, gbcon);
        gbcon.gridy = 1;
        unitsPanel.add((Component)this.msRB, gbcon);
        gbcon.gridy = 2;
        unitsPanel.add((Component)this.framesRB, gbcon);
        gbc.fill = 0;
        this.content.add((Component)unitsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.slider = new ElanSlider(this.msRB.getText(), 0, 5000, this.curValue, null);
        this.content.add((Component)this.slider, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.content.add((Component)buttonPanel, gbc);
        this.setContentPane(this.content);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.msRB && e.getStateChange() == 2) {
            this.curValue = this.slider.getValue();
            this.content.remove(this.slider);
            this.curValue /= 40;
            int max = 125;
            if (this.curValue > max) {
                this.curValue = max;
            }
            this.slider = new ElanSlider(this.framesRB.getText(), 0, max, this.curValue, null);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.content.add((Component)this.slider, gbc);
            this.content.revalidate();
        } else if (e.getSource() == this.framesRB && e.getStateChange() == 2) {
            this.curValue = this.slider.getValue() * 40;
            if (this.curValue > 5000) {
                this.curValue = 5000;
            }
            this.content.remove(this.slider);
            this.slider = new ElanSlider(this.msRB.getText(), 0, 5000, this.curValue, null);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.content.add((Component)this.slider, gbc);
            this.content.revalidate();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton && this.slider != null) {
            int value = this.slider.getTextFieldValue();
            if (this.framesRB.isSelected()) {
                Preferences.set("PlayAroundSelection.Mode", "frames", null, false);
            } else {
                Preferences.set("PlayAroundSelection.Mode", "ms", null, false);
            }
            Preferences.set("PlayAroundSelection.Value", new Integer(value), null, true);
        }
        this.dispose();
    }
}

