/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.Document;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceGroup;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;

public class InlineEditBox
extends JPanel
implements ActionListener,
MouseListener,
MenuListener,
KeyListener,
ElanLocaleListener {
    private static final String EDIT_MENU_DET = "Detach Editor";
    private static final String EDIT_MENU_ATT = "Attach Editor";
    private static final String EDIT_MENU_CMT = "Commit Changes";
    private static final String EDIT_MENU_CNL = "Cancel Changes";
    private static final Logger LOG = Logger.getLogger(InlineEditBox.class.getName());
    private final JTextArea textArea = new JTextArea("", 2, 1);
    private final JScrollPane textAreaScrollPane = new JScrollPane(this.textArea);
    private final JTextArea exttextArea = new JTextArea("", 2, 1);
    private final JScrollPane exttextAreaScrollPane = new JScrollPane(this.exttextArea);
    private final FocusListener intFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!InlineEditBox.this.isUsingControlledVocabulary) {
                InlineEditBox.this.textArea.requestFocus();
                InlineEditBox.this.textArea.getCaret().setVisible(true);
            } else if (InlineEditBox.this.cvEntryComp != null) {
                InlineEditBox.this.cvEntryComp.grabFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!InlineEditBox.this.isEditing) {
                InlineEditBox.this.transferFocusUpCycle();
            }
        }
    };
    private final FocusListener extFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            if (!InlineEditBox.this.isUsingControlledVocabulary) {
                InlineEditBox.this.exttextArea.requestFocus();
                InlineEditBox.this.exttextArea.getCaret().setVisible(true);
            } else if (InlineEditBox.this.cvEntryComp != null) {
                InlineEditBox.this.cvEntryComp.grabFocus();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    };
    private JPopupMenu popupMenu = new JPopupMenu("Select Language");
    private static final int EDIT_COMMITTED = 0;
    private static final int EDIT_CANCELED = 1;
    private InlineEditBoxListener listener;
    private JDialog externalDialog = null;
    private Rectangle dialogBounds;
    private Locale[] allLocales;
    private int numberOfLocales;
    private String oldText;
    private boolean attached = true;
    private Annotation annotation;
    private Point position;
    private Locale annotationLocale;
    private boolean attachable;
    private boolean isUsingControlledVocabulary = false;
    private JMenu editMenu;
    private JMenu editorMenu;
    private JMenu selectLanguageMenu;
    private JMenuItem attachMI;
    private JMenuItem commitMI;
    private JMenuItem cancelMI;
    private JMenuItem closeMI;
    private JMenuItem detachPUMI;
    private JMenuItem commitPUMI;
    private JMenuItem cancelPUMI;
    private JMenuItem selectAllPUMI;
    private JMenuItem cutMI;
    private JMenuItem copyMI;
    private JMenuItem pasteMI;
    private JMenuItem cutPUMI;
    private JMenuItem copyPUMI;
    private JMenuItem pastePUMI;
    private JMenuItem selectAllMI;
    private JMenuBar menuBar;
    private JMenuItem toggleSuggestMI;
    private CVEntryComponent cvEntryComp;
    private int minCVWidth = 120;
    private int minCVHeight = 120;
    private List<KeyStroke> keyStrokesNotToBeConsumed = new ArrayList<KeyStroke>();
    private List<KeyStroke> defaultRegisteredKeyStrokes = new ArrayList<KeyStroke>();
    private JComponent editorComponent;
    private Font uniFont = Constants.DEFAULTFONT;
    private boolean isEditing = false;
    private boolean enterCommits = false;
    private String oriValue;
    private int cursorPos;
    private boolean restoreOriValue = false;

    public InlineEditBox(boolean attachable) {
        this.init();
        this.attachable = attachable;
    }

    public InlineEditBox() {
        this.init();
        this.attached = false;
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        this.keyStrokesNotToBeConsumed.clear();
        this.keyStrokesNotToBeConsumed.addAll(ksList);
    }

    public void init() {
        KeyStroke[] kss;
        for (KeyStroke ks : kss = this.textArea.getRegisteredKeyStrokes()) {
            ActionListener al = this.textArea.getActionForKeyStroke(ks);
            if (al == null) continue;
            this.defaultRegisteredKeyStrokes.add(ks);
        }
        Object val = Preferences.get("InlineEdit.EnterCommits", null);
        if (val instanceof Boolean) {
            this.enterCommits = (Boolean)val;
        }
        this.attachable = true;
        this.setLayout(new BorderLayout());
        try {
            this.allLocales = ImUtil.getLanguages();
            this.numberOfLocales = this.allLocales == null ? 0 : this.allLocales.length;
        }
        catch (NoSuchMethodError nsme) {
            String msg = ElanLocale.getString("InlineEditBox.Message.SPI") + "\n" + ElanLocale.getString("InlineEditBox.Message.SPI2");
            JOptionPane.showMessageDialog(null, msg, null, 0);
        }
        catch (Exception exc) {
            LOG.warning("InlineEditBox::init::ParentIMBug::FIXME");
            LOG.warning(exc.getMessage());
        }
        this.textArea.addMouseListener(this);
        this.textArea.setLineWrap(false);
        this.textAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.textAreaScrollPane.setVerticalScrollBarPolicy(21);
        this.add((Component)this.textAreaScrollPane, "Center");
        this.textArea.getCaret().setVisible(true);
        this.textArea.addKeyListener(this);
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (InlineEditBox.this.annotationLocale != null && !InlineEditBox.this.annotationLocale.equals(Locale.getDefault()) && !InlineEditBox.this.annotationLocale.equals(InlineEditBox.this.textArea.getLocale())) {
                    ImUtil.setLanguage(InlineEditBox.this.textArea, InlineEditBox.this.annotationLocale);
                    InlineEditBox.this.textArea.setFont(InlineEditBox.this.uniFont);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!InlineEditBox.this.isEditing) {
                    InlineEditBox.this.transferFocusUpCycle();
                }
            }
        });
        this.exttextArea.setLineWrap(true);
        this.exttextArea.setWrapStyleWord(true);
        this.exttextArea.addKeyListener(this);
        this.exttextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (InlineEditBox.this.annotationLocale != null && !InlineEditBox.this.annotationLocale.equals(Locale.getDefault()) && !InlineEditBox.this.annotationLocale.equals(InlineEditBox.this.exttextArea.getLocale())) {
                    ImUtil.setLanguage(InlineEditBox.this.exttextArea, InlineEditBox.this.annotationLocale);
                    InlineEditBox.this.exttextArea.setFont(InlineEditBox.this.uniFont.deriveFont(20.0f));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!InlineEditBox.this.isEditing) {
                    InlineEditBox.this.transferFocusUpCycle();
                }
            }
        });
        this.createPopupMenu();
        this.exttextAreaScrollPane.setHorizontalScrollBarPolicy(31);
        this.exttextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.textAreaScrollPane.addFocusListener(this.intFocusListener);
        this.addFocusListener(this.intFocusListener);
    }

    public void addInlineEditBoxListener(InlineEditBoxListener inLineListener) {
        this.listener = inLineListener;
    }

    public void removeInlineEditBoxListener(InlineEditBoxListener inLineListener) {
        this.listener = null;
    }

    private void notifyListener(int edit_Type) {
        if (this.listener != null) {
            switch (edit_Type) {
                case 0: {
                    this.listener.editingCommitted();
                    break;
                }
                case 1: {
                    this.listener.editingCancelled();
                }
            }
        }
    }

    public void createExternalDialog() {
        try {
            this.externalDialog = new JDialog(ELANCommandFactory.getRootFrame(this.annotation.getTier().getParent()), ElanLocale.getString("InlineEditBox.Title"), true);
            this.externalDialog.setDefaultCloseOperation(0);
            this.externalDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    InlineEditBox.this.cancelEdit();
                }
            });
            if (this.menuBar == null) {
                this.createJMenuBar();
            }
            if (this.isUsingControlledVocabulary) {
                this.toggleSuggestMI.setVisible(true);
            } else {
                this.toggleSuggestMI.setVisible(false);
            }
            this.externalDialog.setJMenuBar(this.menuBar);
            this.externalDialog.addFocusListener(this.extFocusListener);
            this.externalDialog.setSize(300, 300);
        }
        catch (Exception ex) {
            LOG.warning("Could not create external dialog: " + ex.getMessage());
        }
    }

    public void createPopupMenu() {
        this.detachPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Detach"));
        this.detachPUMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
        this.detachPUMI.setActionCommand(EDIT_MENU_DET);
        this.detachPUMI.addActionListener(this);
        this.popupMenu.add(this.detachPUMI);
        this.commitPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitPUMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.commitPUMI.setActionCommand(EDIT_MENU_CMT);
        this.commitPUMI.addActionListener(this);
        this.popupMenu.add(this.commitPUMI);
        this.cancelPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelPUMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.cancelPUMI.setActionCommand(EDIT_MENU_CNL);
        this.cancelPUMI.addActionListener(this);
        this.popupMenu.add(this.cancelPUMI);
        this.popupMenu.addSeparator();
        this.cutPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutPUMI.setActionCommand("cut");
        this.cutPUMI.addActionListener(this);
        this.popupMenu.add(this.cutPUMI);
        this.copyPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyPUMI.setActionCommand("copy");
        this.copyPUMI.addActionListener(this);
        this.popupMenu.add(this.copyPUMI);
        this.pastePUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pastePUMI.setActionCommand("paste");
        this.pastePUMI.addActionListener(this);
        this.popupMenu.add(this.pastePUMI);
        this.selectAllPUMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllPUMI.setActionCommand("selectAll");
        this.selectAllPUMI.addActionListener(this);
        this.popupMenu.add(this.selectAllPUMI);
        this.popupMenu.addSeparator();
        for (int i = 0; i < this.numberOfLocales; ++i) {
            JMenuItem newItem;
            if (i == 0 && this.allLocales[i] == Locale.getDefault()) {
                newItem = new JMenuItem(this.allLocales[i].getDisplayName() + " (System default)");
                newItem.setActionCommand(this.allLocales[i].getDisplayName());
            } else {
                newItem = new JMenuItem(this.allLocales[i].getDisplayName());
            }
            this.popupMenu.add(newItem);
            newItem.addActionListener(this);
        }
    }

    private JMenuBar createJMenuBar() {
        this.menuBar = new JMenuBar();
        this.editorMenu = new JMenu(ElanLocale.getString("InlineEditBox.Menu.Editor"));
        this.editMenu = new JMenu(ElanLocale.getString("Menu.Edit"));
        this.editMenu.addMenuListener(this);
        this.selectLanguageMenu = new JMenu(ElanLocale.getString("InlineEditBox.Menu.Select"));
        if (this.attachable) {
            this.attachMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Attach"));
            this.attachMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
            this.attachMI.setActionCommand(EDIT_MENU_ATT);
            this.attachMI.addActionListener(this);
            this.editorMenu.add(this.attachMI);
        }
        this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
        this.commitMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.commitMI.setActionCommand(EDIT_MENU_CMT);
        this.commitMI.addActionListener(this);
        this.editorMenu.add(this.commitMI);
        this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.cancelMI.setActionCommand(EDIT_MENU_CNL);
        this.cancelMI.addActionListener(this);
        this.editorMenu.add(this.cancelMI);
        this.closeMI = new JMenuItem(ElanLocale.getString("Button.Close"));
        this.closeMI.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.closeMI.setActionCommand("close");
        this.closeMI.addActionListener(this);
        this.editorMenu.add(this.closeMI);
        this.editorMenu.add(new JSeparator());
        this.toggleSuggestMI = new JMenuItem(ElanLocale.getString("InlineEditBox.ToggleSuggestPanel"));
        this.toggleSuggestMI.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.toggleSuggestMI.setActionCommand("toggleSuggest");
        this.toggleSuggestMI.addActionListener(this);
        this.editorMenu.add(this.toggleSuggestMI);
        this.cutMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.cutMI.setActionCommand("cut");
        this.cutMI.addActionListener(this);
        this.editMenu.add(this.cutMI);
        this.copyMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.copyMI.setActionCommand("copy");
        this.copyMI.addActionListener(this);
        this.editMenu.add(this.copyMI);
        this.pasteMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        this.pasteMI.setActionCommand("paste");
        this.pasteMI.addActionListener(this);
        this.editMenu.add(this.pasteMI);
        this.selectAllMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Edit.SelectAll"));
        this.selectAllMI.setActionCommand("selectAll");
        this.selectAllMI.addActionListener(this);
        this.editMenu.add(this.selectAllMI);
        for (int i = 0; i < this.numberOfLocales; ++i) {
            JMenuItem newItem = new JMenuItem(this.allLocales[i].getDisplayName());
            this.selectLanguageMenu.add(newItem);
            newItem.addActionListener(this);
        }
        this.menuBar.add(this.editorMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.selectLanguageMenu);
        return this.menuBar;
    }

    public boolean isUsingControlledVocabulary() {
        return this.isUsingControlledVocabulary;
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (this.externalDialog != null) {
            this.externalDialog.setVisible(vis);
        }
        if (!vis) {
            this.setLocation(-10, -10);
        }
    }

    @Override
    public void setSize(Dimension d) {
        if (d.getWidth() < 60.0) {
            d = new Dimension(60, d.height);
        }
        if (d.getHeight() < 38.0) {
            d = new Dimension(d.width, 38);
        }
        super.setSize(d);
        this.setPreferredSize(d);
        this.textAreaScrollPane.setPreferredSize(d);
        this.textAreaScrollPane.setSize(d);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.uniFont = font;
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
        if (this.exttextArea != null) {
            this.exttextArea.setFont(font);
        }
    }

    public void setAnnotation(Annotation ann, boolean forceOpenCV) {
        this.annotation = ann;
        this.oldText = ann.getValue();
        this.textArea.setText(this.oldText);
        try {
            this.annotationLocale = ((TierImpl)this.annotation.getTier()).getDefaultLocale();
            this.isUsingControlledVocabulary = forceOpenCV ? false : ((TierImpl)this.annotation.getTier()).getLinguisticType().isUsingControlledVocabulary();
        }
        catch (Exception e) {
            LOG.warning("Could not establish Default Language of Tier. Using System Default instead.");
            this.annotationLocale = null;
            this.isUsingControlledVocabulary = false;
        }
        if (this.attached) {
            if (!this.isUsingControlledVocabulary) {
                this.textArea.setEditable(true);
                this.textArea.setCaretPosition(this.textArea.getText().length());
            } else {
                this.textArea.setEditable(false);
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                }
                this.cvEntryComp.setAnnotation(this.annotation);
            }
        }
    }

    public void setAnnotation(Annotation ann) {
        if (this.annotation != null && ann == this.annotation) {
            return;
        }
        this.setAnnotation(ann, false);
    }

    public boolean annotationModified() {
        return this.attached ? !this.oldText.equals(this.textArea.getText()) : !this.oldText.equals(this.exttextArea.getText());
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void detachEditor() {
        if (this.attachable && !this.attached) {
            return;
        }
        this.attached = false;
        this.position = this.getLocation();
        this.createExternalDialog();
        if (this.dialogBounds != null) {
            this.externalDialog.setBounds(this.dialogBounds);
        } else {
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle frameDim = this.externalDialog.getBounds();
            this.externalDialog.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
        }
        ImUtil.setLanguage(this.textArea, Locale.getDefault());
        this.setVisible(false);
        if (!this.isUsingControlledVocabulary) {
            this.externalDialog.getContentPane().removeAll();
            this.externalDialog.getContentPane().add(this.exttextAreaScrollPane);
            this.exttextArea.setEditable(true);
            this.exttextArea.setText(this.textArea.getText());
            this.exttextArea.setCaretPosition(this.exttextArea.getText().length());
            this.exttextArea.setFont(this.textArea.getFont().deriveFont(20.0f));
        } else {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                this.cvEntryComp.setAnnotation(this.annotation);
            }
            this.exttextArea.setEditable(false);
            this.cvEntryComp.removePopupListener();
            this.cvEntryComp.setFont(this.getFont());
            this.externalDialog.getContentPane().removeAll();
            this.externalDialog.getContentPane().add(this.cvEntryComp.getEditorComponent());
        }
        this.externalDialog.setVisible(true);
    }

    protected void attachEditor() {
        this.attached = true;
        this.dialogBounds = this.externalDialog.getBounds();
        this.externalDialog.dispose();
        this.externalDialog = null;
        this.setLocation(this.position);
        this.setVisible(true);
        if (!this.isUsingControlledVocabulary) {
            this.textArea.setText(this.exttextArea.getText());
            this.textArea.requestFocus();
        } else {
            this.cvEntryComp.addPopupListener();
            if (this.editorComponent == this) {
                this.removeAll();
                this.add((Component)this.cvEntryComp.getEditorComponent(), "Center");
            }
            this.startEdit();
        }
    }

    public void cancelEdit() {
        this.isEditing = false;
        this.closeIM();
        if (this.attached) {
            this.setVisible(false);
        } else {
            if (this.externalDialog != null) {
                this.dialogBounds = this.externalDialog.getBounds();
                this.setVisible(false);
                this.externalDialog.dispose();
                this.externalDialog = null;
            }
            this.attached = true;
        }
        this.notifyListener(1);
    }

    public void commitEdit() {
        this.isEditing = false;
        this.closeIM();
        Object extRef = null;
        if (this.isUsingControlledVocabulary && this.cvEntryComp != null && this.cvEntryComp.getSelectedEntry() != null) {
            if (this.attached) {
                this.textArea.setText(this.cvEntryComp.getSelectedEntryValue());
            } else {
                this.exttextArea.setText(this.cvEntryComp.getSelectedEntryValue());
            }
            extRef = this.cvEntryComp.getSelectedEntry().getExternalRef();
            if (this.cvEntryComp.getSelectedEntry() instanceof ExternalCVEntry) {
                String entryId = ((ExternalCVEntry)this.cvEntryComp.getSelectedEntry()).getId();
                ExternalReferenceImpl extRefCv = new ExternalReferenceImpl(entryId, 5);
                ExternalReferenceGroup tmpExtRefGrp = new ExternalReferenceGroup();
                tmpExtRefGrp.addReference(extRefCv);
                if (extRef != null) {
                    try {
                        Object clone = ((ExternalReference)extRef).clone();
                        if (clone instanceof ExternalReference) {
                            tmpExtRefGrp.addReference((ExternalReference)clone);
                        }
                        extRef = tmpExtRefGrp;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    extRef = tmpExtRefGrp;
                }
            }
        }
        if (extRef == null && ((AbstractAnnotation)this.annotation).getExtRef() != null) {
            extRef = new ExternalReferenceImpl(null, 5);
        }
        String newText = "";
        boolean modified = this.annotationModified();
        if (this.attached) {
            if (modified) {
                newText = this.textArea.getText();
            }
            this.setVisible(false);
        } else {
            if (modified) {
                newText = this.exttextArea.getText();
            }
            this.dialogBounds = this.externalDialog.getBounds();
            this.setVisible(false);
            this.externalDialog.dispose();
            this.externalDialog = null;
            this.attached = true;
        }
        if (modified) {
            Command c = ELANCommandFactory.createCommand(this.annotation.getTier().getParent(), "Menu.Annotation.ModifyAnnotation");
            Object[] args = new Object[]{this.oldText, newText, extRef};
            c.execute(this.annotation, args);
        }
        this.notifyListener(0);
    }

    private void closeIM() {
        if (this.annotationLocale != null) {
            if (this.attached) {
                if (!this.textArea.getLocale().equals(Locale.getDefault())) {
                    ImUtil.setLanguage(this.textArea, Locale.getDefault());
                }
            } else if (!this.exttextArea.getLocale().equals(Locale.getDefault())) {
                ImUtil.setLanguage(this.exttextArea, Locale.getDefault());
            }
        }
    }

    private void doCut() {
        if (this.attached) {
            this.textArea.cut();
        } else {
            this.exttextArea.cut();
        }
    }

    private void doCopy() {
        if (this.attached) {
            this.textArea.copy();
        } else {
            this.exttextArea.copy();
        }
    }

    private void doPaste() {
        if (this.attached) {
            this.textArea.paste();
        } else {
            this.exttextArea.paste();
        }
    }

    private void doSelectAll() {
        if (this.attached) {
            this.textArea.selectAll();
        } else {
            this.exttextArea.selectAll();
        }
    }

    private void updatePopup() {
        if (this.textArea.getSelectedText() == null || this.textArea.getSelectedText().length() == 0) {
            this.cutPUMI.setEnabled(false);
            this.copyPUMI.setEnabled(false);
        } else {
            this.cutPUMI.setEnabled(true);
            this.copyPUMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pastePUMI.setEnabled(true);
        } else {
            this.pastePUMI.setEnabled(false);
        }
        if (this.textArea.getText() == null || this.textArea.getText().length() == 0) {
            this.selectAllPUMI.setEnabled(false);
        } else {
            this.selectAllPUMI.setEnabled(true);
        }
    }

    private void updateMenuBar() {
        if (this.exttextArea.getSelectedText() == null || this.exttextArea.getSelectedText().length() == 0) {
            this.cutMI.setEnabled(false);
            this.copyMI.setEnabled(false);
        } else {
            this.cutMI.setEnabled(true);
            this.copyMI.setEnabled(true);
        }
        if (this.isTextOnClipboard()) {
            this.pasteMI.setEnabled(true);
        } else {
            this.pasteMI.setEnabled(false);
        }
        if (this.exttextArea.getText() == null || this.exttextArea.getText().length() == 0) {
            this.selectAllMI.setEnabled(false);
        } else {
            this.selectAllMI.setEnabled(true);
        }
    }

    private boolean isTextOnClipboard() {
        DataFlavor[] flavors;
        DataFlavor best;
        Transferable contents = null;
        try {
            contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        }
        catch (IllegalStateException ise) {
            LOG.warning("Could not access the system clipboard.");
        }
        return contents != null && (best = DataFlavor.selectBestTextFlavor(flavors = contents.getTransferDataFlavors())) != null;
    }

    public JComponent getEditorComponent() {
        if (this.editorComponent == null) {
            return this;
        }
        return this.editorComponent;
    }

    public void configureEditor(Class preferredComponent, Font font, Dimension size) {
        if (preferredComponent == JPanel.class) {
            this.editorComponent = this;
            if (this.isUsingControlledVocabulary) {
                int h;
                int w;
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(JScrollPane.class);
                    this.cvEntryComp.setAnnotation(this.annotation);
                } else if (!(this.cvEntryComp.getEditorComponent() instanceof JScrollPane)) {
                    this.cvEntryComp.setDelegate(preferredComponent);
                }
                if (font != null) {
                    this.cvEntryComp.setFont(font);
                }
                this.cvEntryComp.addPopupListener();
                int l = this.cvEntryComp.getMaxEntryLength();
                int cvw = this.minCVWidth;
                if (l > 18) {
                    cvw = (int)((float)l / 18.0f * (float)this.minCVWidth);
                }
                if (size == null) {
                    w = cvw;
                    h = this.minCVHeight;
                } else {
                    w = size.width;
                    h = size.height;
                    if (w < cvw) {
                        w = cvw;
                    }
                    if (h < this.minCVHeight) {
                        h = this.minCVHeight;
                    }
                }
                this.removeAll();
                this.add((Component)this.cvEntryComp.getEditorComponent(), "Center");
                this.setSize(w, h);
                this.validate();
            } else {
                if (font != null) {
                    this.setFont(font);
                }
                this.removeAll();
                this.add((Component)this.textAreaScrollPane, "Center");
                if (size != null) {
                    this.setSize(size);
                }
                this.validate();
            }
        } else if (preferredComponent == JScrollPane.class) {
            if (this.isUsingControlledVocabulary) {
                if (this.cvEntryComp == null) {
                    this.cvEntryComp = new CVEntryComponent(preferredComponent);
                    this.cvEntryComp.setAnnotation(this.annotation);
                } else if (!(this.cvEntryComp.getEditorComponent() instanceof JScrollPane)) {
                    this.cvEntryComp.setDelegate(preferredComponent);
                }
                if (font != null) {
                    this.cvEntryComp.setFont(font);
                }
                this.cvEntryComp.addPopupListener();
                if (size != null) {
                    this.cvEntryComp.getEditorComponent().setSize(size);
                }
                this.editorComponent = this.cvEntryComp.getEditorComponent();
            } else {
                if (font != null) {
                    this.setFont(font);
                }
                if (size != null) {
                    this.setSize(size);
                }
                this.editorComponent = this.textAreaScrollPane;
            }
        } else if (preferredComponent == JComboBox.class && this.isUsingControlledVocabulary) {
            if (this.cvEntryComp == null) {
                this.cvEntryComp = new CVEntryComponent(preferredComponent);
                this.cvEntryComp.setAnnotation(this.annotation);
            } else if (!(this.cvEntryComp.getEditorComponent() instanceof JComboBox)) {
                this.cvEntryComp.setDelegate(preferredComponent);
            }
            if (font != null) {
                this.cvEntryComp.setFont(font);
            }
            if (size != null) {
                this.cvEntryComp.getEditorComponent().setSize(size);
            }
            this.editorComponent = this.cvEntryComp.getEditorComponent();
        }
    }

    public void startEdit() {
        this.isEditing = true;
        if (this.editorComponent == this) {
            this.setVisible(true);
            this.requestFocus();
        } else if (this.isUsingControlledVocabulary) {
            this.cvEntryComp.grabFocus();
        } else {
            this.editorComponent.requestFocus();
        }
    }

    public void setEnterCommits(boolean enterCommits) {
        this.enterCommits = enterCommits;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block17: {
            String command;
            block18: {
                block16: {
                    command = e.getActionCommand();
                    if (!command.equals(EDIT_MENU_DET)) break block16;
                    this.detachEditor();
                    break block17;
                }
                if (!command.equals(EDIT_MENU_ATT)) break block18;
                if (!this.attachable) break block17;
                this.attachEditor();
                break block17;
            }
            if (command.equals(EDIT_MENU_CNL) || command.equals("close")) {
                this.cancelEdit();
            } else if (command.equals(EDIT_MENU_CMT)) {
                this.commitEdit();
            } else if (command.equals("cut")) {
                this.doCut();
            } else if (command.equals("copy")) {
                this.doCopy();
            } else if (command.equals("paste")) {
                this.doPaste();
            } else if (command.equals("selectAll")) {
                this.doSelectAll();
            } else if (command.equals("toggleSuggest")) {
                this.cvEntryComp.toggleSuggestPanel(this.externalDialog.getContentPane());
            } else {
                for (int i = 0; i < this.numberOfLocales; ++i) {
                    if (!command.equals(this.allLocales[i].getDisplayName())) continue;
                    this.annotationLocale = this.allLocales[i];
                    if (this.attached) {
                        ImUtil.setLanguage(this.textArea, this.annotationLocale);
                        this.textArea.setFont(this.uniFont);
                        break;
                    }
                    ImUtil.setLanguage(this.exttextArea, this.annotationLocale);
                    this.exttextArea.setFont(this.uniFont.deriveFont(20.0f));
                    break;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            this.updatePopup();
            this.popupMenu.show(this.textArea, e.getX(), e.getY());
            this.popupMenu.setVisible(true);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
        if (this.keyStrokesNotToBeConsumed.contains(ks)) {
            this.oriValue = ((JTextArea)e.getSource()).getText();
            this.cursorPos = ((JTextArea)e.getSource()).getCaretPosition();
            this.restoreOriValue = false;
            if (e.getKeyCode() == 32 && (e.getModifiers() == 1 || e.getModifiers() == 8 || e.getModifiers() == 0)) {
                this.restoreOriValue = true;
            }
            return;
        }
        if (e.getKeyCode() == 27) {
            this.cancelEdit();
        } else if (e.getKeyCode() == 10 && e.isShiftDown()) {
            if (this.attachable) {
                e.consume();
                if (this.attached) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            InlineEditBox.this.detachEditor();
                        }
                    });
                } else {
                    this.attachEditor();
                }
            }
        } else if (e.getKeyCode() == 10 && (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
            e.consume();
            this.commitEdit();
        } else if (e.getKeyCode() == 10 && this.enterCommits) {
            e.consume();
            this.commitEdit();
        } else if (!(this.defaultRegisteredKeyStrokes.contains(ks) || ks.getModifiers() != 128 && ks.getModifiers() != 512 && ks.getModifiers() != 256)) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.restoreOriValue) {
            ((JTextArea)e.getSource()).setText(this.oriValue);
            ((JTextArea)e.getSource()).setCaretPosition(this.cursorPos);
            this.restoreOriValue = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.updateMenuBar();
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void updateLocale() {
        this.detachPUMI.setText(ElanLocale.getString("InlineEditBox.Detach"));
        this.commitPUMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
        this.cancelPUMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
        this.cutPUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
        this.copyPUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
        this.pastePUMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        if (this.menuBar != null) {
            this.editorMenu.setText(ElanLocale.getString("InlineEditBox.Menu.Editor"));
            this.editMenu.setText(ElanLocale.getString("Menu.Edit"));
            this.selectLanguageMenu.setText(ElanLocale.getString("InlineEditBox.Menu.Select"));
            this.attachMI.setText(ElanLocale.getString("InlineEditBox.Attach"));
            this.commitMI.setText(ElanLocale.getString("InlineEditBox.Commit"));
            this.cancelMI.setText(ElanLocale.getString("InlineEditBox.Cancel"));
            this.closeMI.setText(ElanLocale.getString("Button.Close"));
            this.cutMI.setText(ElanLocale.getString("InlineEditBox.Edit.Cut"));
            this.copyMI.setText(ElanLocale.getString("InlineEditBox.Edit.Copy"));
            this.pasteMI.setText(ElanLocale.getString("InlineEditBox.Edit.Paste"));
        }
    }

    class CVEntryComponent
    implements KeyListener,
    ActionListener,
    DocumentListener {
        private JList entryList;
        private DefaultListModel entryListModel;
        private JScrollPane scrollPane;
        private JPopupMenu popup;
        private MouseListener popupListener;
        private MouseListener doubleClickListener;
        private JMenuItem detachMI;
        private JMenuItem cancelMI;
        private JMenuItem commitMI;
        private JMenuItem toggleSuggestMI;
        private JComboBox box;
        private DefaultComboBoxModel entryBoxModel;
        private JComponent delegate;
        private CVEntry[] entries;
        private Annotation annotation;
        private int maxEntryLength = 0;
        private JTextField textField;
        private Document textFieldDoc;
        private JPanel suggestPanel;
        private volatile Thread t;
        private String oldPartial = new String();
        private JList suggestEntryList;
        private DefaultListModel suggestEntryListModel;
        private JScrollPane suggestScrollPane;
        private MouseAdapter suggestPanelPopupListener;
        private MouseAdapter suggestPanelDoubleClickListener;

        public CVEntryComponent(Class componentClass) {
            this.initComponents(componentClass);
        }

        public JComponent getEditorComponent() {
            return this.delegate;
        }

        void setDelegate(Class compClass) {
            if (this.delegate.getClass() == compClass) {
                return;
            }
            if (compClass == JComboBox.class) {
                if (this.box == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.box;
                this.entryBoxModel.removeAllElements();
                this.fillModel(true);
                if (this.entryList != null) {
                    this.box.setSelectedItem(this.entryList.getSelectedValue());
                }
            } else if (compClass == JScrollPane.class) {
                if (this.entryList == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.scrollPane;
                this.entryListModel.clear();
                this.fillModel(true);
                if (this.box != null) {
                    this.entryList.setSelectedValue(this.box.getSelectedItem(), true);
                }
            } else if (compClass == JPanel.class) {
                if (this.suggestEntryList == null) {
                    this.initComponents(compClass);
                }
                this.delegate = this.suggestPanel;
                this.suggestEntryListModel.clear();
                this.fillModel(true);
                if (this.box != null) {
                    this.suggestEntryList.setSelectedValue(this.box.getSelectedItem(), true);
                }
            }
        }

        public void ensureSelectionIsVisible() {
            if (this.delegate instanceof JScrollPane && this.entryList != null) {
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            } else if (this.delegate instanceof JPanel && this.suggestEntryList != null) {
                this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
            }
        }

        public void removePopupListener() {
            if (this.entryList != null) {
                this.entryList.removeMouseListener(this.popupListener);
            }
            if (this.suggestEntryList != null) {
                this.suggestEntryList.removeMouseListener(this.suggestPanelPopupListener);
                this.textField.removeMouseListener(this.suggestPanelPopupListener);
            }
        }

        public void addPopupListener() {
            int i;
            MouseListener[] listeners;
            if (this.entryList != null) {
                listeners = this.entryList.getMouseListeners();
                for (i = 0; i < listeners.length; ++i) {
                    if (listeners[i] != this.popupListener) continue;
                    return;
                }
                this.entryList.addMouseListener(this.popupListener);
            }
            if (this.suggestEntryList != null) {
                listeners = this.suggestEntryList.getMouseListeners();
                for (i = 0; i < listeners.length; ++i) {
                    if (listeners[i] != this.suggestPanelPopupListener) continue;
                    return;
                }
                this.suggestEntryList.addMouseListener(this.suggestPanelPopupListener);
                this.textField.addMouseListener(this.suggestPanelPopupListener);
            }
        }

        private void initComponents(Class component) {
            if (component == JScrollPane.class) {
                if (this.entryList == null) {
                    this.entryListModel = new DefaultListModel();
                    this.entryList = new JList(this.entryListModel);
                    this.entryList.setFont(InlineEditBox.this.getFont());
                    this.entryList.setSelectionMode(0);
                    this.scrollPane = new JScrollPane(this.entryList);
                    if (this.popup == null) {
                        this.createPopupMenu();
                    }
                    this.popupListener = new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                                CVEntryComponent.this.popup.show(CVEntryComponent.this.entryList, e.getX(), e.getY());
                                CVEntryComponent.this.popup.setVisible(true);
                            }
                        }
                    };
                    this.doubleClickListener = new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() > 1) {
                                InlineEditBox.this.commitEdit();
                            }
                        }
                    };
                    this.entryList.addMouseListener(this.popupListener);
                    this.entryList.addMouseListener(this.doubleClickListener);
                    this.entryList.addKeyListener(this);
                    this.entryList.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent lse) {
                            CVEntryComponent.this.ensureSelectionIsVisible();
                        }
                    });
                    this.delegate = this.scrollPane;
                }
            } else if (component == JComboBox.class) {
                if (this.box == null) {
                    this.entryBoxModel = new DefaultComboBoxModel();
                    this.box = new JComboBox(this.entryBoxModel);
                    this.box.addActionListener(this);
                    this.box.addKeyListener(this);
                    this.delegate = this.box;
                }
            } else if (component == JPanel.class && this.suggestEntryList == null) {
                this.suggestEntryListModel = new DefaultListModel();
                this.suggestEntryList = new JList(this.suggestEntryListModel);
                this.suggestEntryList.setFont(InlineEditBox.this.getFont());
                this.suggestEntryList.setSelectionMode(0);
                this.suggestEntryList.setFocusable(false);
                this.suggestScrollPane = new JScrollPane(this.suggestEntryList);
                this.textField = new JTextField();
                this.textField.addKeyListener(this);
                this.textFieldDoc = this.textField.getDocument();
                this.textFieldDoc.addDocumentListener(this);
                this.suggestPanel = new JPanel(new BorderLayout());
                this.suggestPanel.add((Component)this.textField, "North");
                this.suggestPanel.add((Component)this.suggestScrollPane, "Center");
                if (this.popup == null) {
                    this.createPopupMenu();
                }
                this.suggestPanelPopupListener = new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                            CVEntryComponent.this.popup.show(CVEntryComponent.this.suggestEntryList, e.getX(), e.getY());
                            CVEntryComponent.this.popup.setVisible(true);
                        }
                    }
                };
                this.suggestPanelDoubleClickListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 1) {
                            InlineEditBox.this.commitEdit();
                        }
                    }
                };
                this.suggestEntryList.addMouseListener(this.suggestPanelPopupListener);
                this.textField.addMouseListener(this.suggestPanelPopupListener);
                this.suggestEntryList.addMouseListener(this.suggestPanelDoubleClickListener);
                this.suggestEntryList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent lse) {
                        CVEntryComponent.this.ensureSelectionIsVisible();
                    }
                });
                this.delegate = this.suggestPanel;
            }
        }

        public void setFont(Font f) {
            if (this.delegate == this.box) {
                this.box.setFont(f);
            } else if (this.delegate == this.scrollPane) {
                this.entryList.setFont(f);
            } else if (this.delegate == this.suggestPanel) {
                this.textField.setFont(f);
                this.suggestEntryList.setFont(f);
            }
        }

        public void setAnnotation(Annotation annotation) {
            ControlledVocabulary oldCV = null;
            if (this.annotation != null) {
                TierImpl tier = (TierImpl)this.annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                oldCV = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            this.annotation = annotation;
            BasicControlledVocabulary cv = null;
            if (annotation != null) {
                TierImpl tier = (TierImpl)annotation.getTier();
                TranscriptionImpl trans = (TranscriptionImpl)tier.getParent();
                cv = trans.getControlledVocabulary(tier.getLinguisticType().getControlledVocabylaryName());
            }
            if (cv != null) {
                if (cv != oldCV || !(cv instanceof ExternalCV)) {
                    this.entries = cv.getEntries();
                    if (this.entryListModel != null) {
                        this.entryListModel.clear();
                    }
                    if (this.entryBoxModel != null) {
                        this.entryBoxModel.removeAllElements();
                    }
                    this.fillModel(true);
                } else {
                    this.fillModel(false);
                }
            } else {
                this.entries = new CVEntry[0];
                if (this.entryListModel != null) {
                    this.entryListModel.clear();
                }
                if (this.entryBoxModel != null) {
                    this.entryBoxModel.removeAllElements();
                }
                this.fillModel(false);
            }
        }

        private void fillModel(boolean reload) {
            String value = null;
            if (this.annotation != null) {
                value = this.annotation.getValue();
            }
            if (this.delegate == this.scrollPane) {
                if (reload) {
                    for (int i = 0; i < this.entries.length; ++i) {
                        this.entryListModel.addElement(this.entries[i]);
                        if (value != null && value.equals(this.entries[i].getValue())) {
                            this.entryList.setSelectedIndex(i);
                        }
                        if (this.entries[i].getValue() == null || this.entries[i].getValue().length() <= this.maxEntryLength) continue;
                        this.maxEntryLength = this.entries[i].getValue().length();
                    }
                } else if (value != null) {
                    for (int i = 0; i < this.entryListModel.size(); ++i) {
                        CVEntry entry = (CVEntry)this.entryListModel.getElementAt(i);
                        if (!value.equals(entry.getValue())) continue;
                        this.entryList.setSelectedIndex(i);
                        break;
                    }
                }
                this.entryList.setSelectedIndex(-1);
            } else if (this.delegate == this.box) {
                if (reload) {
                    for (int i = 0; i < this.entries.length; ++i) {
                        this.entryBoxModel.addElement(this.entries[i]);
                        if (value != null && value.equals(this.entries[i].getValue())) {
                            this.entryBoxModel.setSelectedItem(this.entries[i]);
                        }
                        if (this.entries[i].getValue() == null || this.entries[i].getValue().length() <= this.maxEntryLength) continue;
                        this.maxEntryLength = this.entries[i].getValue().length();
                    }
                } else if (value != null) {
                    for (int i = 0; i < this.entryBoxModel.getSize(); ++i) {
                        CVEntry entry = (CVEntry)this.entryBoxModel.getElementAt(i);
                        if (!value.equals(entry.getValue())) continue;
                        this.box.setSelectedIndex(i);
                        break;
                    }
                }
                this.box.setSelectedIndex(-1);
            } else if (this.delegate == this.suggestPanel) {
                this.textField.setText(value);
            }
        }

        public void grabFocus() {
            if (this.delegate == this.box) {
                this.box.requestFocus();
            } else if (this.delegate == this.scrollPane) {
                this.entryList.requestFocus();
                this.entryList.ensureIndexIsVisible(this.entryList.getSelectedIndex());
            } else if (this.delegate == this.suggestPanel) {
                this.textField.requestFocus();
            }
        }

        public String getSelectedEntryValue() {
            String value = null;
            if (this.delegate == this.scrollPane) {
                if (this.entryList.getSelectedValue() != null) {
                    value = ((CVEntry)this.entryList.getSelectedValue()).getValue();
                }
            } else if (this.delegate == this.box) {
                value = this.box.getSelectedItem() != null ? ((CVEntry)this.box.getSelectedItem()).getValue() : this.annotation.getValue();
            } else if (this.delegate == this.suggestPanel && this.suggestEntryList.getSelectedValue() != null) {
                value = ((CVEntry)this.suggestEntryList.getSelectedValue()).getValue();
            }
            return value;
        }

        public CVEntry getSelectedEntry() {
            CVEntry value = null;
            if (this.delegate == this.scrollPane) {
                if (this.entryList.getSelectedValue() != null) {
                    value = (CVEntry)this.entryList.getSelectedValue();
                }
            } else if (this.delegate == this.box) {
                if (this.box.getSelectedItem() != null) {
                    value = (CVEntry)this.box.getSelectedItem();
                }
            } else if (this.delegate == this.suggestPanel && this.suggestEntryList.getSelectedValue() != null) {
                value = (CVEntry)this.suggestEntryList.getSelectedValue();
            }
            return value;
        }

        public int getMaxEntryLength() {
            return this.maxEntryLength;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            block16: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    if (e.getKeyCode() != 10) break block15;
                                    if (e.isShiftDown()) {
                                        InlineEditBox.this.detachEditor();
                                    } else if (this.delegate == this.scrollPane) {
                                        if (this.entryList.getSelectedValue() != null) {
                                            InlineEditBox.this.commitEdit();
                                        } else {
                                            InlineEditBox.this.cancelEdit();
                                        }
                                    } else if (this.suggestEntryList.getSelectedValue() != null) {
                                        InlineEditBox.this.commitEdit();
                                    } else {
                                        InlineEditBox.this.cancelEdit();
                                    }
                                    break block16;
                                }
                                if (e.getKeyCode() != 27) break block17;
                                InlineEditBox.this.cancelEdit();
                                break block16;
                            }
                            if (e.getKeyCode() != 40 || e.getSource() != this.textField) break block18;
                            this.suggestEntryList.setSelectedIndex(this.suggestEntryList.getSelectedIndex() + 1);
                            this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
                            break block16;
                        }
                        if (e.getKeyCode() != 38 || e.getSource() != this.textField) break block19;
                        if (this.suggestEntryList.getSelectedIndex() <= 0) {
                            this.suggestEntryList.clearSelection();
                        } else {
                            this.suggestEntryList.setSelectedIndex(this.suggestEntryList.getSelectedIndex() - 1);
                            this.suggestEntryList.ensureIndexIsVisible(this.suggestEntryList.getSelectedIndex());
                        }
                        break block16;
                    }
                    if (e.getKeyCode() != 85 || (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0) break block20;
                    if (!InlineEditBox.this.isAttached()) break block16;
                    this.toggleSuggestPanel(InlineEditBox.this);
                    break block16;
                }
                if (this.entries != null) {
                    int code = e.getKeyCode();
                    for (CVEntry cve : this.entries) {
                        if (cve.getShortcutKeyCode() != code) continue;
                        if (this.delegate == this.scrollPane) {
                            this.entryList.setSelectedValue(cve, false);
                        } else if (this.delegate == this.box) {
                            this.box.setSelectedItem(cve);
                        }
                        InlineEditBox.this.commitEdit();
                        break;
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == this.detachMI) {
                if (InlineEditBox.this.attachable) {
                    if (InlineEditBox.this.attached) {
                        InlineEditBox.this.detachEditor();
                    } else {
                        InlineEditBox.this.attachEditor();
                    }
                }
            } else if (ae.getSource() == this.commitMI) {
                InlineEditBox.this.commitEdit();
            } else if (ae.getSource() == this.cancelMI) {
                InlineEditBox.this.cancelEdit();
            } else if (ae.getSource() == this.box) {
                if (ae.getID() == 1001 && ae.getModifiers() == 16 && this.box.isPopupVisible()) {
                    InlineEditBox.this.commitEdit();
                }
            } else if (ae.getSource() == this.toggleSuggestMI) {
                this.toggleSuggestPanel(InlineEditBox.this);
            }
        }

        private void toggleSuggestPanel(Container container) {
            container.removeAll();
            if (this.delegate == this.scrollPane) {
                this.setDelegate(JPanel.class);
                container.add((Component)this.getEditorComponent(), "Center");
            } else if (this.delegate == this.suggestPanel) {
                this.setDelegate(JScrollPane.class);
                container.add((Component)this.getEditorComponent(), "Center");
            }
            this.grabFocus();
            container.repaint();
            container.validate();
        }

        private void createPopupMenu() {
            this.popup = new JPopupMenu();
            this.detachMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Detach"));
            this.detachMI.addActionListener(this);
            this.detachMI.setAccelerator(KeyStroke.getKeyStroke(10, 1));
            this.popup.add(this.detachMI);
            this.commitMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Commit"));
            this.commitMI.addActionListener(this);
            this.commitMI.setAccelerator(KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.popup.add(this.commitMI);
            this.cancelMI = new JMenuItem(ElanLocale.getString("InlineEditBox.Cancel"));
            this.cancelMI.addActionListener(this);
            this.cancelMI.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            this.popup.add(this.cancelMI);
            this.popup.add(new JSeparator());
            this.toggleSuggestMI = new JMenuItem(ElanLocale.getString("InlineEditBox.ToggleSuggestPanel"));
            this.toggleSuggestMI.setAccelerator(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.toggleSuggestMI.addActionListener(this);
            this.popup.add(this.toggleSuggestMI);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getDocument() == this.textFieldDoc && !this.oldPartial.equals(this.textField.getText())) {
                this.findSuggestions();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (e.getDocument() == this.textFieldDoc && !this.oldPartial.equals(this.textField.getText())) {
                this.findSuggestions();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void findSuggestions() {
            this.oldPartial = this.textField.getText();
            if (this.t != null && this.t.isAlive()) {
                Thread tmpT = this.t;
                this.t = null;
                if (tmpT != null) {
                    tmpT.interrupt();
                }
                try {
                    tmpT.join();
                }
                catch (Exception ie) {
                    System.out.println(ie);
                }
            }
            this.t = new Thread(new SuggestionsFinder(this.oldPartial));
            this.t.start();
        }

        private class SuggestionsDisplayer
        implements Runnable {
            ArrayList suggestions;

            public SuggestionsDisplayer(ArrayList suggestions) {
                this.suggestions = suggestions;
                CVEntryComponent.this.suggestEntryListModel.clear();
            }

            @Override
            public void run() {
                Iterator suggestionIterator = this.suggestions.iterator();
                int suggestionIndex = 0;
                while (suggestionIterator.hasNext()) {
                    CVEntry nextSuggestion = (CVEntry)suggestionIterator.next();
                    CVEntryComponent.this.suggestEntryListModel.addElement(nextSuggestion);
                    if (nextSuggestion.getValue().equals(CVEntryComponent.this.oldPartial)) {
                        CVEntryComponent.this.suggestEntryList.setSelectedIndex(suggestionIndex);
                        CVEntryComponent.this.suggestEntryList.ensureIndexIsVisible(suggestionIndex);
                    }
                    ++suggestionIndex;
                }
            }
        }

        private class SuggestionsFinder
        implements Runnable {
            private String part;

            public SuggestionsFinder(String part) {
                this.part = part;
            }

            @Override
            public void run() {
                ArrayList<CVEntry> suggestions = new ArrayList<CVEntry>();
                Boolean suggestSearchMethodFlag = false;
                Boolean suggestSearchInDescFlag = false;
                Boolean suggestIgnoreCaseFlag = false;
                Object val = Preferences.get("SuggestPanel.EntryContains", null);
                if (val instanceof Boolean) {
                    suggestSearchMethodFlag = (boolean)((Boolean)val);
                }
                if ((val = Preferences.get("SuggestPanel.SearchDescription", null)) instanceof Boolean) {
                    suggestSearchInDescFlag = (boolean)((Boolean)val);
                }
                if ((val = Preferences.get("SuggestPanel.IgnoreCase", null)) instanceof Boolean) {
                    suggestIgnoreCaseFlag = (boolean)((Boolean)val);
                }
                if (this.part != null && !this.part.equals("")) {
                    int entriesIndex = 0;
                    if (suggestIgnoreCaseFlag.booleanValue()) {
                        this.part = this.part.toLowerCase();
                    }
                    while (entriesIndex < CVEntryComponent.this.entries.length && !Thread.currentThread().isInterrupted()) {
                        CVEntry next = CVEntryComponent.this.entries[entriesIndex];
                        String entryValue = next.getValue();
                        if (suggestIgnoreCaseFlag.booleanValue()) {
                            entryValue = entryValue.toLowerCase();
                        }
                        if (suggestSearchMethodFlag.booleanValue()) {
                            if (entryValue.contains(this.part)) {
                                suggestions.add(next);
                            } else if (suggestSearchInDescFlag.booleanValue() && next.getDescription().toLowerCase().contains(this.part)) {
                                suggestions.add(next);
                            }
                        } else if (entryValue.startsWith(this.part)) {
                            suggestions.add(next);
                        } else if (suggestSearchInDescFlag.booleanValue() && next.getDescription().toLowerCase().contains(this.part)) {
                            suggestions.add(next);
                        }
                        ++entriesIndex;
                    }
                    if (!Thread.currentThread().isInterrupted()) {
                        SwingUtilities.invokeLater(new SuggestionsDisplayer(suggestions));
                    }
                } else if (!Thread.currentThread().isInterrupted()) {
                    SwingUtilities.invokeLater(new SuggestionsDisplayer(new ArrayList()));
                }
            }
        }
    }
}

