/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ShoeboxMarkerDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;

public class ImportShoeboxWAC
extends JComponent
implements ActionListener,
ItemListener {
    public static final int SHOEBOX = 0;
    public static final int WAC = 1;
    public static final int TOOLBOX = 2;
    private static int importType;
    public static final String VALUE_PROPERTY = "value";
    public static final String TEXT_KEY = "TextFile";
    public static final String TYPE_KEY = "TypeFile";
    private JTextField sbxField = new JTextField("", 23);
    private JTextField typField = new JTextField("", 23);
    private GridBagLayout gridbag = new GridBagLayout();
    private JButton txtButton;
    private JButton typButton;
    private JButton fieldSpecButton;
    private JLabel fieldSpecLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JRadioButton typeRB;
    private JRadioButton specRB;
    private JLabel typeLabel;
    private JLabel intervalLabel;
    private JTextField intervalField;
    private JCheckBox timeInRefMarker;
    private JCheckBox allUnicodeCB;
    private JCheckBox calcCharBytesCB;
    private JCheckBox scrubOnImportCB;
    private final String INTERVAL_PREF = "ShoeboxChatBlockDuration";
    private List markers = null;
    private Object value;

    private ImportShoeboxWAC(int type) {
        if (type >= 0 && type <= 2) {
            importType = type;
        }
        this.createPane();
    }

    private void createPane() {
        this.setLayout(this.gridbag);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        int y = 0;
        if (importType == 0 || importType == 2) {
            ButtonGroup buttonGroup = new ButtonGroup();
            this.typeRB = new JRadioButton();
            this.typeRB.setSelected(true);
            this.specRB = new JRadioButton();
            buttonGroup.add(this.typeRB);
            buttonGroup.add(this.specRB);
            this.fieldSpecLabel = new JLabel("-");
            this.fieldSpecLabel.setFont(this.fieldSpecLabel.getFont().deriveFont(10.0f));
            gbc.gridx = 1;
            gbc.gridy = y;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.insets = insets;
            if (importType == 0) {
                this.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Shoebox")), gbc);
            } else {
                this.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Toolbox")), gbc);
            }
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.sbxField, gbc);
            this.txtButton = new JButton("...");
            this.txtButton.addActionListener(this);
            gbc.gridx = 3;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.add((Component)this.txtButton, gbc);
            gbc.gridx = 0;
            gbc.gridy = ++y;
            this.add((Component)this.typeRB, gbc);
            this.typeLabel = importType == 0 ? new JLabel(ElanLocale.getString("ImportDialog.Label.Type")) : new JLabel(ElanLocale.getString("ImportDialog.Label.TypeToolbox"));
            gbc.gridx = 1;
            this.add((Component)this.typeLabel, gbc);
            gbc.gridx = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.typField, gbc);
            this.typButton = new JButton("...");
            this.typButton.addActionListener(this);
            gbc.gridx = 3;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.typButton, gbc);
            ++y;
            this.allUnicodeCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.AllUnicode"));
            this.calcCharBytesCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.CorrectForBytesPerChar"));
            this.calcCharBytesCB.setSelected(true);
            this.scrubOnImportCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.ScrubAnnotations"));
            if (importType == 0) {
                gbc.gridx = 1;
                gbc.gridy = y++;
                gbc.gridwidth = 2;
                this.add((Component)this.allUnicodeCB, gbc);
                gbc.gridx = 0;
                gbc.gridy = y++;
                this.add((Component)this.specRB, gbc);
                this.fieldSpecButton = new JButton(ElanLocale.getString("ImportDialog.Button.FieldSpec"));
                this.fieldSpecButton.addActionListener(this);
                this.fieldSpecButton.setEnabled(false);
                gbc.gridx = 1;
                gbc.gridwidth = 1;
                this.add((Component)this.fieldSpecButton, gbc);
                gbc.gridx = 2;
                gbc.gridwidth = 2;
                this.add((Component)this.fieldSpecLabel, gbc);
            } else if (importType == 2) {
                this.allUnicodeCB.setSelected(true);
                gbc.gridx = 0;
                gbc.gridy = y++;
                this.add((Component)this.specRB, gbc);
                this.fieldSpecButton = new JButton(ElanLocale.getString("ImportDialog.Button.FieldSpec"));
                this.fieldSpecButton.addActionListener(this);
                this.fieldSpecButton.setEnabled(false);
                gbc.gridx = 1;
                this.add((Component)this.fieldSpecButton, gbc);
                gbc.gridx = 2;
                gbc.gridwidth = 2;
                this.add((Component)this.fieldSpecLabel, gbc);
                gbc.gridx = 1;
                gbc.gridy = y++;
                gbc.gridwidth = 3;
                this.add((Component)this.allUnicodeCB, gbc);
                gbc.gridy = y++;
                this.add((Component)this.calcCharBytesCB, gbc);
            }
            JPanel optionsPanel = new JPanel(new GridBagLayout());
            optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options")));
            this.intervalLabel = new JLabel(ElanLocale.getString("ImportDialog.Label.BlockDuration"));
            this.intervalField = new JTextField();
            if (Preferences.get("ShoeboxChatBlockDuration", null) != null) {
                Integer val = (Integer)Preferences.get("ShoeboxChatBlockDuration", null);
                this.intervalField.setText("" + val);
            } else {
                this.intervalField.setText("1000");
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = gbc.insets;
            gridBagConstraints.anchor = 17;
            optionsPanel.add((Component)this.intervalLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            optionsPanel.add((Component)this.intervalField, gridBagConstraints);
            this.timeInRefMarker = new JCheckBox(ElanLocale.getString("ImportDialog.Label.TimeInRefMarker"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            optionsPanel.add((Component)this.timeInRefMarker, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            optionsPanel.add((Component)this.scrubOnImportCB, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)optionsPanel, gridBagConstraints);
            this.setShoeboxMarkerRB();
            this.typeRB.addItemListener(this);
            this.specRB.addItemListener(this);
        } else {
            gbc.gridx = 0;
            gbc.gridy = y++;
            gbc.weightx = 0.0;
            gbc.anchor = 17;
            gbc.insets = insets;
            this.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.WAC")), gbc);
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.sbxField, gbc);
            this.txtButton = new JButton("...");
            this.txtButton.addActionListener(this);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            gbc.fill = 0;
            this.add((Component)this.txtButton, gbc);
            this.typeLabel = new JLabel(ElanLocale.getString("ImportDialog.Label.Type"));
            gbc.gridx = 0;
            gbc.gridy = y++;
            this.add((Component)this.typeLabel, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.typField, gbc);
            this.typButton = new JButton("...");
            this.typButton.addActionListener(this);
            gbc.gridx = 2;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.typButton, gbc);
        }
        Object val = Preferences.get("ToolboxImport.AllUnicode", null);
        if (val instanceof Boolean) {
            this.allUnicodeCB.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("ToolboxImport.TimeInRefMarker", null)) instanceof Boolean) {
            this.timeInRefMarker.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("ToolboxImport.CalcForCharBytes", null)) instanceof Boolean) {
            this.calcCharBytesCB.setSelected((Boolean)val);
        }
        if ((val = Preferences.get("ToolboxImport.ScrubAnnotations", null)) instanceof Boolean) {
            this.scrubOnImportCB.setSelected((Boolean)val);
        }
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc.gridwidth = 0;
        gbc.anchor = 15;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = y;
        this.add((Component)buttonPanel, gbc);
    }

    private void setShoeboxMarkerRB() {
        Object useTyp = Preferences.get("LastUsedShoeboxImportWithType", null);
        if (useTyp instanceof Boolean && !((Boolean)useTyp).booleanValue()) {
            this.specRB.setSelected(true);
            this.typButton.setEnabled(false);
            this.fieldSpecButton.setEnabled(true);
            if (importType == 0) {
                this.allUnicodeCB.setEnabled(false);
            } else {
                this.allUnicodeCB.setEnabled(true);
            }
            this.preloadMarkers();
        } else {
            this.typeRB.setSelected(true);
            Object luTypFile = Preferences.get("LastUsedShoeboxTypFile", null);
            if (luTypFile instanceof String) {
                this.typField.setText((String)luTypFile);
            }
            this.typButton.setEnabled(true);
            this.allUnicodeCB.setEnabled(true);
        }
    }

    public static Object showDialog() {
        return ImportShoeboxWAC.showDialog(0);
    }

    public static Object showDialog(int type) {
        return ImportShoeboxWAC.showDialog(null, type);
    }

    public static Object showDialog(Frame parent, int type) {
        ImportShoeboxWAC pane = new ImportShoeboxWAC(type);
        JDialog dialog = pane.createDialog(parent, type);
        dialog.setVisible(true);
        dialog.dispose();
        Object o = pane.getValue();
        return o;
    }

    private JDialog createDialog(Frame parent, int type) {
        final ClosableDialog dialog = new ClosableDialog(parent);
        if (type == 1) {
            dialog.setTitle(ElanLocale.getString("ImportDialog.Title.WAC"));
        } else if (type == 0) {
            dialog.setTitle(ElanLocale.getString("ImportDialog.Title.Shoebox"));
        } else {
            dialog.setTitle(ElanLocale.getString("ImportDialog.Title.Toolbox"));
        }
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.pack();
        if (parent != null) {
            dialog.setLocationRelativeTo(parent);
        }
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ImportShoeboxWAC.this.setValue(null);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == ImportShoeboxWAC.this && event.getPropertyName().equals(ImportShoeboxWAC.VALUE_PROPERTY)) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.txtButton) {
            this.chooseSbxWAC();
        } else if (source == this.typButton) {
            this.chooseTyp();
        } else if (source == this.fieldSpecButton) {
            this.specifyFieldSpecs();
        } else if (source == this.okButton) {
            this.checkFields();
        } else if (source == this.cancelButton) {
            this.setValue(null);
        }
    }

    private void chooseSbxWAC() {
        FileChooser chooser = new FileChooser(this);
        String[] mainExtension = null;
        boolean acceptAllFilesFilter = true;
        if (importType == 1) {
            mainExtension = FileExtension.WAC_EXT;
        } else {
            acceptAllFilesFilter = false;
            if (importType == 0) {
                mainExtension = FileExtension.SHOEBOX_TEXT_EXT;
            } else if (importType == 2) {
                mainExtension = FileExtension.TOOLBOX_TEXT_EXT;
            }
        }
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, mainExtension, acceptAllFilesFilter, "LastUsedShoeboxDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.sbxField.setText(f.getAbsolutePath());
        }
    }

    private void chooseTyp() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_TYP_EXT, false, "LastUsedShoeboxTypDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.typField.setText(f.getAbsolutePath());
            Preferences.set("LastUsedShoeboxTypFile", f.getAbsolutePath(), null);
            Preferences.set("LastUsedShoeboxImportWithType", Boolean.TRUE, null);
        }
    }

    private void preloadMarkers() {
        Object markerFile = Preferences.get("LastUsedShoeboxMarkerFile", null);
        if (markerFile instanceof String) {
            File f = new File((String)markerFile);
            if (!f.exists()) {
                return;
            }
            String line = null;
            this.markers = new ArrayList();
            try {
                FileReader filereader = new FileReader(f);
                BufferedReader br = new BufferedReader(filereader);
                MarkerRecord newRecord = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    String label = this.getLabelPart(line);
                    String value = this.getValuePart(line);
                    if (label.equals("marker")) {
                        newRecord = new MarkerRecord();
                        if (value.equals("null")) continue;
                        newRecord.setMarker(value);
                        continue;
                    }
                    if (label.equals("parent")) {
                        if (value.equals("null")) continue;
                        newRecord.setParentMarker(value);
                        continue;
                    }
                    if (label.equals("stereotype")) {
                        if (value.equals("null")) continue;
                        newRecord.setStereoType(value);
                        continue;
                    }
                    if (label.equals("charset")) {
                        if (value.equals("null")) continue;
                        newRecord.setCharset(value);
                        continue;
                    }
                    if (label.equals("exclude")) {
                        if (value.equals("null")) continue;
                        if (value.equals("true")) {
                            newRecord.setExcluded(true);
                            continue;
                        }
                        newRecord.setExcluded(false);
                        continue;
                    }
                    if (!label.equals("participant")) continue;
                    if (!value.equals("null")) {
                        if (value.equals("true")) {
                            newRecord.setParticipantMarker(true);
                        } else {
                            newRecord.setParticipantMarker(false);
                        }
                    }
                    this.markers.add(newRecord);
                }
                this.fieldSpecLabel.setText((String)markerFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(58);
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(58);
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    private void specifyFieldSpecs() {
        ShoeboxMarkerDialog smd;
        if (importType == 0) {
            smd = new ShoeboxMarkerDialog(null, true);
            smd.setVisible(true);
            this.markers = (List)smd.getValue();
            Preferences.set("LastUsedShoeboxImportWithType", Boolean.FALSE, null);
        } else {
            smd = new ShoeboxMarkerDialog(null, true, true);
            smd.setVisible(true);
            this.markers = (List)smd.getValue();
            Preferences.set("LastUsedShoeboxImportWithType", Boolean.FALSE, null);
        }
        Object markerFile = Preferences.get("LastUsedShoeboxMarkerFile", null);
        if (markerFile instanceof String) {
            this.fieldSpecLabel.setText((String)markerFile);
        }
    }

    private boolean checkFields() {
        ToolboxDecoderInfo decInfo;
        String sbxPath = null;
        String typPath = null;
        if (this.sbxField.getText() != null) {
            sbxPath = this.sbxField.getText().trim();
        }
        if (sbxPath == null || sbxPath.length() == 0) {
            if (importType == 1) {
                this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyWAC"));
            } else {
                this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyShoebox"));
            }
            return false;
        }
        if (this.typField.getText() != null) {
            typPath = this.typField.getText().trim();
        }
        if (this.typeRB.isSelected() && (typPath == null || typPath.length() == 0)) {
            this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyType"));
            return false;
        }
        if (!new File(sbxPath).exists()) {
            if (importType == 1) {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoWAC"));
            } else {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoShoebox"));
            }
            return false;
        }
        if (this.typeRB.isSelected()) {
            if (!new File(typPath).exists()) {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoType"));
                return false;
            }
        } else if (this.markers == null || this.markers.size() == 0) {
            this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyMarkers"));
            return false;
        }
        int durVal = 1000;
        if (this.intervalField != null) {
            String dur = this.intervalField.getText();
            try {
                durVal = Integer.parseInt(dur);
                Preferences.set("ShoeboxChatBlockDuration", durVal, null);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        Preferences.set("ToolboxImport.AllUnicode", new Boolean(this.allUnicodeCB.isSelected()), null);
        Preferences.set("ToolboxImport.TimeInRefMarker", new Boolean(this.timeInRefMarker.isSelected()), null);
        if (importType == 2) {
            decInfo = new ToolboxDecoderInfo2(sbxPath);
            decInfo.setBlockDuration(durVal);
            if (this.typeRB.isSelected()) {
                ((ToolboxDecoderInfo2)decInfo).setTypeFile(typPath);
                decInfo.setAllUnicode(this.allUnicodeCB.isSelected());
            } else {
                ((ToolboxDecoderInfo2)decInfo).setShoeboxMarkers(this.markers);
                decInfo.setAllUnicode(this.allUnicodeCB.isSelected());
            }
            decInfo.setTimeInRefMarker(this.timeInRefMarker.isSelected());
            ((ToolboxDecoderInfo2)decInfo).setRecalculateForCharBytes(this.calcCharBytesCB.isSelected());
            ((ToolboxDecoderInfo2)decInfo).setScrubAnnotations(this.scrubOnImportCB.isSelected());
            Preferences.set("ToolboxImport.CalcForCharBytes", new Boolean(this.calcCharBytesCB.isSelected()), null);
            Preferences.set("ToolboxImport.ScrubAnnotations", new Boolean(this.scrubOnImportCB.isSelected()), null);
            this.setValue(decInfo);
        } else {
            decInfo = new ToolboxDecoderInfo(sbxPath);
            decInfo.setBlockDuration(durVal);
            if (this.typeRB.isSelected()) {
                decInfo.setTypeFile(typPath);
                decInfo.setAllUnicode(this.allUnicodeCB.isSelected());
            } else {
                decInfo.setShoeboxMarkers(this.markers);
            }
            decInfo.setTimeInRefMarker(this.timeInRefMarker.isSelected());
            this.setValue(decInfo);
        }
        return true;
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Error"), 0);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        this.firePropertyChange(VALUE_PROPERTY, oldValue, this.value);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.typeRB && e.getStateChange() == 1) {
            this.typeLabel.setEnabled(true);
            this.typButton.setEnabled(true);
            this.typField.setEnabled(true);
            this.allUnicodeCB.setEnabled(true);
            this.fieldSpecButton.setEnabled(false);
            this.markers = null;
            if (this.typField.getText() == null || this.typField.getText().length() == 0) {
                this.typButton.doClick(200);
            }
        } else if (e.getSource() == this.specRB && e.getStateChange() == 1) {
            this.typeLabel.setEnabled(false);
            this.typButton.setEnabled(false);
            this.typField.setEnabled(false);
            if (importType == 0) {
                this.allUnicodeCB.setEnabled(false);
            }
            this.fieldSpecButton.setEnabled(true);
            this.fieldSpecButton.doClick(200);
        }
    }
}

