/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;

public class ImportFLExDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private JPanel filePanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JTextField flexFileField;
    private JTextField mediaFileField;
    private JButton selectFlexButton;
    private JButton selectMediaButton;
    private JCheckBox includeITCB;
    private JCheckBox includeParagrCB;
    private JComboBox unitsCombo;
    private JRadioButton fileDurationRB;
    private JRadioButton unitDurationRB;
    private JTextField fileDurTextField;
    private JTextField unitTextField;
    private JLabel msPerUnitLabel;
    private JButton okButton;
    private JButton cancelButton;
    private final String[] elements = new String[]{"interlinear-text", "paragraph", "phrase", "word"};
    private List<String> tempMediaPaths;
    private FlexDecoderInfo decoderInfo = null;

    public ImportFLExDialog(Frame owner) throws HeadlessException {
        super(owner, true);
        this.initComponents();
        this.postInit();
    }

    public FlexDecoderInfo getDecoderInfo() {
        return this.decoderInfo;
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("Menu.File.Import.FLEx"));
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.filePanel = new JPanel(new GridBagLayout());
        this.filePanel.setBorder(new TitledBorder(""));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        this.filePanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Flex.File")), gbc);
        gbc.gridy = 1;
        this.filePanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Media")), gbc);
        this.flexFileField = new JTextField("", 20);
        this.flexFileField.setEditable(false);
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.filePanel.add((Component)this.flexFileField, gbc);
        this.mediaFileField = new JTextField("", 20);
        this.mediaFileField.setEditable(false);
        gbc.gridy = 1;
        this.filePanel.add((Component)this.mediaFileField, gbc);
        this.selectFlexButton = new JButton("...");
        this.selectFlexButton.addActionListener(this);
        gbc.gridy = 0;
        gbc.gridx = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.filePanel.add((Component)this.selectFlexButton, gbc);
        this.selectMediaButton = new JButton("...");
        this.selectMediaButton.addActionListener(this);
        gbc.gridy = 1;
        this.filePanel.add((Component)this.selectMediaButton, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.filePanel, gbc);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ImportDialog.Label.Options")));
        this.includeITCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludeIT"));
        this.includeITCB.setSelected(true);
        this.includeParagrCB = new JCheckBox(ElanLocale.getString("ImportDialog.Flex.IncludePara"));
        this.includeParagrCB.setSelected(true);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        this.optionsPanel.add((Component)this.includeITCB, gbc);
        gbc.gridy = 1;
        this.optionsPanel.add((Component)this.includeParagrCB, gbc);
        JLabel smallestLabel = new JLabel(ElanLocale.getString("ImportDialog.Flex.SmallestTimeAlignable"));
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(12, 6, 2, 6);
        this.optionsPanel.add((Component)smallestLabel, gbc);
        this.unitsCombo = new JComboBox<String>(this.elements);
        this.unitsCombo.setSelectedItem("phrase");
        this.unitsCombo.addItemListener(this);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.unitsCombo, gbc);
        JLabel durLabel = new JLabel(ElanLocale.getString("Player.duration"));
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(12, 6, 2, 6);
        this.optionsPanel.add((Component)durLabel, gbc);
        ButtonGroup group = new ButtonGroup();
        this.fileDurationRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.FileDuration"));
        this.fileDurationRB.addActionListener(this);
        this.fileDurationRB.setSelected(true);
        group.add(this.fileDurationRB);
        gbc.gridy = 4;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.fileDurationRB, gbc);
        this.fileDurTextField = new JTextField("", 8);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.fileDurTextField, gbc);
        this.unitDurationRB = new JRadioButton(ElanLocale.getString("ImportDialog.Flex.UnitDuration"));
        this.unitDurationRB.addActionListener(this);
        group.add(this.unitDurationRB);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.insets = insets;
        gbc.gridwidth = 3;
        this.optionsPanel.add((Component)this.unitDurationRB, gbc);
        this.unitTextField = new JTextField("", 8);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = new Insets(2, 26, 2, 6);
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.optionsPanel.add((Component)this.unitTextField, gbc);
        this.msPerUnitLabel = new JLabel(ElanLocale.getString("ImportDialog.Flex.MsPer") + "   < " + this.unitsCombo.getSelectedItem() + " >");
        gbc.gridx = 1;
        gbc.insets = insets;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)this.msPerUnitLabel, gbc);
        this.unitTextField.setEnabled(false);
        this.msPerUnitLabel.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.insets = insets;
        gbc.anchor = 15;
        gbc.fill = 0;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void enableFileDuration(boolean enabled) {
        this.fileDurTextField.setEnabled(enabled);
        this.unitTextField.setEnabled(!enabled);
        this.msPerUnitLabel.setEnabled(!enabled);
    }

    private void selectFlexFile() {
        FileChooser chooser = new FileChooser((Frame)this.getParent());
        chooser.createAndShowFileDialog(ElanLocale.getString("Button.Select"), 0, ElanLocale.getString("Button.Select"), null, FileExtension.XML_EXT, false, "LastUsedFlexDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.flexFileField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void selectMediaFiles() {
        FileChooser chooser = new FileChooser((Frame)this.getParent());
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("Button.Select"), 2);
        Object[] files = chooser.getSelectedFiles();
        if (files != null && files.length > 0) {
            if (this.tempMediaPaths == null) {
                this.tempMediaPaths = new ArrayList<String>(4);
            } else {
                this.tempMediaPaths.clear();
            }
            String filePaths = "";
            for (int i = 0; i < files.length; ++i) {
                this.tempMediaPaths.add(((File)files[i]).getAbsolutePath());
                filePaths = filePaths + files[i] + ", ";
            }
            this.mediaFileField.setText(filePaths);
        }
    }

    private boolean checkFields() {
        String path = this.flexFileField.getText();
        if (path == null || path.length() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.NoFlex"), ElanLocale.getString("Message.Error"), 0);
            return false;
        }
        File f = new File(path);
        if (!f.exists() || f.isDirectory()) {
            String strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = strMessage + path;
            strMessage = strMessage + ElanLocale.getString("Menu.Dialog.Message2");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return false;
        }
        path = path.replace('\\', '/');
        long durationVal = -1L;
        if (this.fileDurationRB.isSelected()) {
            try {
                durationVal = Long.parseLong(this.fileDurTextField.getText());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.DurFile"), ElanLocale.getString("Message.Error"), 0);
                return false;
            }
        }
        try {
            durationVal = Long.parseLong(this.unitTextField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ImportDialog.Flex.Message.DurElement"), ElanLocale.getString("Message.Error"), 0);
            return false;
        }
        this.decoderInfo = new FlexDecoderInfo(path);
        this.decoderInfo.smallestWithTimeAlignment = (String)this.unitsCombo.getSelectedItem();
        this.decoderInfo.inclITElement = this.includeITCB.isSelected();
        this.decoderInfo.inclParagraphElement = this.includeParagrCB.isSelected();
        if (this.fileDurationRB.isSelected()) {
            this.decoderInfo.totalDurationSpecified = true;
            this.decoderInfo.totalDuration = durationVal;
        } else {
            this.decoderInfo.totalDurationSpecified = false;
            this.decoderInfo.perElementDuration = durationVal;
        }
        if (this.tempMediaPaths != null && this.tempMediaPaths.size() > 0) {
            ArrayList<MediaDescriptor> descriptors = new ArrayList<MediaDescriptor>(this.tempMediaPaths.size());
            for (String medPath : this.tempMediaPaths) {
                MediaDescriptor descriptor = MediaDescriptorUtil.createMediaDescriptor(medPath);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
            this.decoderInfo.setMediaDescriptors(descriptors);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectFlexButton) {
            this.selectFlexFile();
        } else if (e.getSource() == this.selectMediaButton) {
            this.selectMediaFiles();
        } else if (e.getSource() == this.fileDurationRB) {
            this.enableFileDuration(true);
        } else if (e.getSource() == this.unitDurationRB) {
            this.enableFileDuration(false);
        } else if (e.getSource() == this.okButton) {
            if (this.checkFields()) {
                this.setVisible(false);
            }
        } else if (e.getSource() == this.cancelButton) {
            this.decoderInfo = null;
            this.setVisible(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.unitsCombo) {
            this.msPerUnitLabel.setText(ElanLocale.getString("ImportDialog.Flex.MsPer") + "   < " + this.unitsCombo.getSelectedItem() + " >");
        }
    }
}

