/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;

public class FilesTierSortAndSelectPanel
extends AbstractTierSortAndSelectPanel
implements ActionListener,
ListSelectionListener,
ChangeListener,
ItemListener,
TableModelListener {
    protected ArrayList<File> files;
    protected Map<String, ArrayList<String>> tierTypeMap;
    protected Map<String, ArrayList<String>> tierParticipantMap;
    protected Map<String, ArrayList<String>> tierAnnotatorMap;
    protected List<String> rootTiers;
    protected List<String> rootTypes;

    public FilesTierSortAndSelectPanel(ArrayList<File> files) {
        this(files, null, null, true, false);
    }

    public FilesTierSortAndSelectPanel(ArrayList<File> files, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this(files, null, null, true, false, tierMode);
    }

    public FilesTierSortAndSelectPanel(ArrayList<File> files, List<String> tierOrder, List<String> selectedTiers) {
        this(files, tierOrder, selectedTiers, true, false);
    }

    public FilesTierSortAndSelectPanel(ArrayList<File> files, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering) {
        this(files, tierOrder, selectedTiers, allowReordering, false);
    }

    public FilesTierSortAndSelectPanel(ArrayList<File> files, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting) {
        this(files, tierOrder, selectedTiers, allowReordering, allowSorting, AbstractTierSortAndSelectPanel.Modes.ALL_TIERS);
    }

    public FilesTierSortAndSelectPanel(ArrayList<File> files, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this.files = files;
        this.allTierNames = tierOrder;
        if (selectedTiers != null) {
            this.selectedTierNames = selectedTiers;
            this.initialSelectedTiersProvided = true;
        } else {
            this.selectedTierNames = new ArrayList();
            this.initialSelectedTiersProvided = false;
        }
        this.allowReordering = allowReordering;
        this.allowSorting = allowSorting;
        this.mode = tierMode;
        this.tabIndices = new HashMap(4);
        this.tabIndices.put(0, "Tier");
        this.tabIndices.put(1, "Type");
        this.tabIndices.put(2, "Participant");
        this.tabIndices.put(3, "Annotators");
        this.tierTypeMap = new LinkedHashMap<String, ArrayList<String>>();
        this.tierParticipantMap = new LinkedHashMap<String, ArrayList<String>>();
        this.tierAnnotatorMap = new LinkedHashMap<String, ArrayList<String>>();
        this.rootTiers = new ArrayList<String>();
        this.rootTypes = new ArrayList<String>();
        this.initComponents();
    }

    @Override
    protected void initTables() {
        int i;
        if (this.allTierNames == null) {
            this.allTierNames = new ArrayList();
        }
        this.tierTypeMap.clear();
        this.tierParticipantMap.clear();
        this.tierAnnotatorMap.clear();
        ArrayList pts = null;
        EAFSkeletonParser parser = null;
        for (i = 0; i < this.files.size(); ++i) {
            File file = this.files.get(i);
            if (file == null) continue;
            String path = file.getAbsolutePath();
            try {
                parser = new EAFSkeletonParser(path);
                parser.parse();
                pts = parser.getTiers();
                for (int j = 0; j < pts.size(); ++j) {
                    List list;
                    String value;
                    TierImpl tier = (TierImpl)pts.get(j);
                    String tierName = tier.getName();
                    if (!this.allTierNames.contains(tierName)) {
                        this.allTierNames.add(tierName);
                    }
                    if (tier.getParentTier() == null && !this.rootTiers.contains(tierName)) {
                        this.rootTiers.add(tierName);
                    }
                    if ((value = tier.getParticipant()).length() == 0) {
                        value = "not specified";
                    }
                    if (this.tierParticipantMap.get(value) == null) {
                        this.tierParticipantMap.put(value, new ArrayList());
                    }
                    if (!(list = (List)this.tierParticipantMap.get(value)).contains(tierName)) {
                        list.add(tierName);
                    }
                    if ((value = tier.getAnnotator()).length() == 0) {
                        value = "not specified";
                    }
                    if (this.tierAnnotatorMap.get(value) == null) {
                        this.tierAnnotatorMap.put(value, new ArrayList());
                    }
                    if (!(list = (List)this.tierAnnotatorMap.get(value)).contains(tierName)) {
                        list.add(tierName);
                    }
                    if (this.tierTypeMap.get(value = tier.getLinguisticType().getLinguisticTypeName()) == null) {
                        this.tierTypeMap.put(value, new ArrayList());
                    }
                    if (!(list = (List)this.tierTypeMap.get(value)).contains(tierName)) {
                        list.add(tierName);
                    }
                    if (tier.getParentTier() != null || this.rootTypes.contains(value)) continue;
                    this.rootTypes.add(value);
                }
                continue;
            }
            catch (ParseException pe) {
                ClientLogger.LOG.warning(pe.getMessage());
                continue;
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Could not load file: " + path);
            }
        }
        for (i = this.model.getRowCount() - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        for (i = 0; i < this.allTierNames.size(); ++i) {
            if (this.selectedTierNames.size() > 0) {
                if (this.selectedTierNames.contains(this.allTierNames.get(i))) {
                    this.model.addRow(new Object[]{Boolean.TRUE, this.allTierNames.get(i)});
                    continue;
                }
                this.model.addRow(new Object[]{Boolean.FALSE, this.allTierNames.get(i)});
                continue;
            }
            if (i == 0) {
                this.model.addRow(new Object[]{Boolean.TRUE, this.allTierNames.get(i)});
                this.selectedTierNames.add((String)this.allTierNames.get(i));
                continue;
            }
            this.model.addRow(new Object[]{Boolean.FALSE, this.allTierNames.get(i)});
        }
        if (this.model.getRowCount() > 0) {
            this.tierTable.setRowSelectionInterval(0, 0);
        }
        for (String key : this.tierTypeMap.keySet()) {
            this.typeModel.addRow(new Object[]{Boolean.FALSE, key});
        }
        for (String key : this.tierParticipantMap.keySet()) {
            this.partModel.addRow(new Object[]{Boolean.FALSE, key});
        }
        for (String key : this.tierAnnotatorMap.keySet()) {
            this.annotModel.addRow(new Object[]{Boolean.FALSE, key});
        }
    }

    @Override
    protected void toggleRootsOnly(boolean rootsOnly) {
        if (rootsOnly) {
            int i;
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            this.unfilteredTiers = new LinkedHashMap(this.model.getRowCount());
            for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
                this.unfilteredTiers.put((String)this.model.getValueAt(i2, nameCol), (Boolean)this.model.getValueAt(i2, includeCol));
            }
            this.model.removeTableModelListener(this);
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                String name = (String)this.model.getValueAt(i, nameCol);
                if (this.rootTiers.contains(name)) continue;
                this.model.removeRow(i);
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            this.unfilteredTypes = new LinkedHashMap(this.typeModel.getRowCount());
            includeCol = this.typeModel.findColumn("select");
            nameCol = this.typeModel.findColumn("tier");
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                this.unfilteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            for (i = this.typeModel.getRowCount() - 1; i >= 0; --i) {
                String name = (String)this.typeModel.getValueAt(i, nameCol);
                if (this.rootTypes.contains(name)) continue;
                this.typeModel.removeRow(i);
            }
        } else {
            String name;
            int i;
            String key2;
            if (this.unfilteredTiers == null) {
                return;
            }
            this.model.removeTableModelListener(this);
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            LinkedHashMap<String, Boolean> filteredTiers = new LinkedHashMap<String, Boolean>(this.model.getRowCount());
            for (int i3 = 0; i3 < this.model.getRowCount(); ++i3) {
                filteredTiers.put((String)this.model.getValueAt(i3, nameCol), (Boolean)this.model.getValueAt(i3, includeCol));
            }
            int insertAfter = -1;
            block5: for (String key2 : this.unfilteredTiers.keySet()) {
                boolean shouldInsert;
                boolean bl = shouldInsert = !filteredTiers.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.model.insertRow(0, new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.model.getRowCount() - 1) {
                        this.model.addRow(new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = this.model.getRowCount() - 1;
                        continue;
                    }
                    this.model.insertRow(insertAfter + 1, new Object[]{this.unfilteredTiers.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (i = 0; i < this.model.getRowCount(); ++i) {
                    name = (String)this.model.getValueAt(i, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i;
                    continue block5;
                }
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            LinkedHashMap<String, Boolean> filteredTypes = new LinkedHashMap<String, Boolean>(this.typeModel.getRowCount());
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                filteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            insertAfter = -1;
            Iterator keyIter = this.unfilteredTypes.keySet().iterator();
            key2 = null;
            name = null;
            block8: while (keyIter.hasNext()) {
                boolean shouldInsert;
                key2 = (String)keyIter.next();
                boolean bl = shouldInsert = !filteredTypes.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.typeModel.insertRow(0, new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.typeModel.getRowCount() - 1) {
                        this.typeModel.addRow(new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = this.typeModel.getRowCount() - 1;
                        continue;
                    }
                    this.typeModel.insertRow(insertAfter + 1, new Object[]{this.unfilteredTypes.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (int i4 = 0; i4 < this.typeModel.getRowCount(); ++i4) {
                    name = (String)this.typeModel.getValueAt(i4, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i4;
                    continue block8;
                }
            }
        }
    }

    @Override
    protected void showTiersTab() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        this.model.removeTableModelListener(this);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (this.selectedTierNames.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    @Override
    protected void updateLinguisticTypes() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.typeModel.findColumn("select");
            int nameCol = this.typeModel.findColumn("tier");
            for (int i = 0; i < this.typeModel.getRowCount(); ++i) {
                Object include = this.typeModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String typeName = (String)this.typeModel.getValueAt(i, nameCol);
                List tierList = this.tierTypeMap.get(typeName);
                for (String s : tierList) {
                    if (this.selectedTierNames.contains(s)) continue;
                    this.selectedTierNames.add(s);
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }

    @Override
    protected void updateParticipants() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.partModel.findColumn("select");
            int nameCol = this.partModel.findColumn("tier");
            for (int i = 0; i < this.partModel.getRowCount(); ++i) {
                Object include = this.partModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String participant = (String)this.partModel.getValueAt(i, nameCol);
                List tierList = this.tierParticipantMap.get(participant);
                for (String s : tierList) {
                    if (this.selectedTierNames.contains(s)) continue;
                    this.selectedTierNames.add(s);
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }

    @Override
    protected void updateAnnotators() {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = this.annotModel.findColumn("select");
            int nameCol = this.annotModel.findColumn("tier");
            for (int i = 0; i < this.annotModel.getRowCount(); ++i) {
                Object include = this.annotModel.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String annotator = (String)this.annotModel.getValueAt(i, nameCol);
                List tierList = this.tierAnnotatorMap.get(annotator);
                for (String s : tierList) {
                    if (this.selectedTierNames.contains(s)) continue;
                    this.selectedTierNames.add(s);
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }
}

