/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class ChangedTranscriptionsPane
extends JPanel
implements ListSelectionListener {
    private JLabel messageLabel;
    private JTable transTable;
    private JScrollPane pane;
    private DefaultTableModel model;
    private final int checkW = 30;
    private final int tableW = 380;

    public ChangedTranscriptionsPane(ArrayList changedTrans) {
        this.initComponents();
        this.fillTable(changedTrans);
    }

    private void initComponents() {
        this.messageLabel = new JLabel("<html>" + ElanLocale.getString("Frame.ElanFrame.UnsavedMultiple1") + "<br>" + ElanLocale.getString("Frame.ElanFrame.UnsavedMultiple2") + "</html>");
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column <= 0;
            }
        };
        this.model.setColumnCount(2);
        this.transTable = new JTable(this.model);
        this.transTable.setTableHeader(null);
        this.transTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.transTable.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxTableCellRenderer());
        this.transTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.transTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.transTable.getColumnModel().getColumn(1).setPreferredWidth(346);
        this.transTable.setAutoResizeMode(0);
        this.transTable.getSelectionModel().setSelectionMode(0);
        this.transTable.getSelectionModel().addListSelectionListener(this);
        this.pane = new JScrollPane(this.transTable);
        this.pane.setPreferredSize(new Dimension(380, 80));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 6, 10, 6);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.messageLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.pane, gbc);
    }

    private void fillTable(ArrayList changedTrans) {
        if (changedTrans != null) {
            int w;
            String ws = "";
            for (int i = 0; i < changedTrans.size(); ++i) {
                String loopString = (String)changedTrans.get(i);
                this.model.addRow(new Object[]{Boolean.TRUE, loopString});
                if (loopString.length() <= ws.length()) continue;
                ws = loopString;
            }
            if (ws.length() > 0 && (w = this.transTable.getFontMetrics(this.transTable.getFont()).stringWidth(ws)) > 350) {
                this.transTable.getColumnModel().getColumn(1).setMinWidth(w + 4);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = 0;
            for (int i = b; i <= e; ++i) {
                Object curValue;
                if (!this.transTable.isRowSelected(i) || !((curValue = this.model.getValueAt(i, 0)) instanceof Boolean)) continue;
                if ((Boolean)curValue == Boolean.TRUE) {
                    this.model.setValueAt(Boolean.FALSE, i, col);
                    continue;
                }
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    public ArrayList getSelectedValues() {
        if (this.model != null) {
            ArrayList<Object> vals = new ArrayList<Object>(this.model.getRowCount());
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                if (!((Boolean)this.model.getValueAt(i, 0)).booleanValue()) continue;
                vals.add(this.model.getValueAt(i, 1));
            }
            return vals;
        }
        return null;
    }
}

