/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.AnnotationTableCellRenderer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.util.TimeRelation;

public class GridRenderer
extends AnnotationTableCellRenderer {
    protected static final Border activeBorder = new LineBorder(Constants.ACTIVEANNOTATIONCOLOR);
    protected final AbstractTableModel tableModel;
    protected final AbstractViewer viewer;

    public GridRenderer(AbstractViewer viewer, AbstractTableModel tableModel) {
        this.viewer = viewer;
        this.tableModel = tableModel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String columnName = table.getColumnName(column);
        GridRenderer.setAlignment(this.label, columnName);
        int annotationColumn = this.tableModel.findColumn("ColumnAnnotation");
        boolean isInSelection = isSelected;
        if (this.viewer != null) {
            isInSelection = TimeRelation.overlaps((AnnotationCore)this.tableModel.getValueAt(row, annotationColumn), this.viewer.getSelectionBeginTime(), this.viewer.getSelectionEndTime());
        }
        boolean isActive = false;
        if (this.viewer != null) {
            isActive = value instanceof AnnotationCore && this.viewer.getActiveAnnotation() == value;
        }
        GridRenderer.setComponentLayout(this.label, table, value, isInSelection, isActive, column);
        if ("ColumnTriangle".equals(columnName)) {
            this.label.setBorder(null);
            if (this.viewer != null) {
                int iconWidth = table.getCellRect((int)row, (int)column, (boolean)true).width - 1;
                int iconHeight = table.getCellRect((int)row, (int)column, (boolean)true).height - 1;
                this.label.setIcon(this.getTimePointerIcon(row, annotationColumn, iconWidth, iconHeight));
            }
        } else {
            this.label.setIcon(null);
            String renderedText = GridRenderer.getRenderedText(value);
            if ("ColumnFileName".equals(columnName) && !renderedText.equals("")) {
                String fileName = new File(renderedText).getName();
                int stopIndex = fileName.lastIndexOf(46);
                if (stopIndex > 0) {
                    this.label.setText(fileName.substring(0, stopIndex));
                } else {
                    this.label.setText(fileName);
                }
            } else {
                this.label.setText(renderedText);
            }
            if (!"".equals(renderedText)) {
                this.label.setToolTipText(renderedText);
            }
        }
        return this.label;
    }

    protected static void setComponentLayout(JComponent component, JTable table, Object value, boolean isSelected, boolean isActive, int column) {
        component.setBackground(isSelected ? Constants.SELECTIONCOLOR : table.getBackground());
        if (table instanceof AnnotationTable) {
            Color c;
            component.setFont(((AnnotationTable)table).getFontForColumn(column));
            if (!isSelected && value instanceof AnnotationCore && (c = ((AnnotationTable)table).getColorForAnnotation(column, ((AnnotationCore)value).getValue())) != null) {
                component.setBackground(c);
            }
        } else {
            component.setFont(table.getFont());
        }
        if (isActive) {
            component.setBorder(activeBorder);
        } else {
            component.setBorder(marginBorder);
        }
    }

    private Icon getTimePointerIcon(int row, int annotationColumn, int iconWidth, int iconHeight) {
        long mediaTime;
        long previousEndTime = 0L;
        long nextBeginTime = Long.MAX_VALUE;
        this.label.setText("");
        AnnotationCore aa = (AnnotationCore)this.tableModel.getValueAt(row, annotationColumn);
        long beginTime = aa.getBeginTimeBoundary();
        long endTime = aa.getEndTimeBoundary();
        if (row > 0) {
            aa = (AnnotationCore)this.tableModel.getValueAt(row - 1, annotationColumn);
            previousEndTime = aa.getEndTimeBoundary();
        }
        if (row < this.tableModel.getRowCount() - 1) {
            aa = (AnnotationCore)this.tableModel.getValueAt(row + 1, annotationColumn);
            nextBeginTime = aa.getBeginTimeBoundary();
        }
        if ((mediaTime = this.viewer.getMediaTime()) >= beginTime && mediaTime < endTime) {
            return new GridViewerIcon(0, iconWidth, iconHeight);
        }
        if (mediaTime > 0L && mediaTime >= previousEndTime && mediaTime < beginTime) {
            return new GridViewerIcon(-1, iconWidth, iconHeight);
        }
        if (mediaTime < this.viewer.getMediaDuration() - 1000L && mediaTime < nextBeginTime && mediaTime >= endTime) {
            return new GridViewerIcon(1, iconWidth, iconHeight);
        }
        return null;
    }

    private class GridViewerIcon
    implements Icon {
        static final int COMPLETE = 0;
        static final int UPPER_HALF = -1;
        static final int LOWER_HALF = 1;
        private final int[] x_arr;
        private final int[] y_arr;
        private final int iconHeight;
        private final int iconWidth;

        GridViewerIcon(int type, int iconWidth, int iconHeight) {
            if (type == 1) {
                this.x_arr = new int[]{0, iconWidth, 0};
                this.y_arr = new int[]{iconHeight / 2, iconHeight, iconHeight};
            } else if (type == -1) {
                this.x_arr = new int[]{0, 0, iconWidth};
                this.y_arr = new int[]{0, iconHeight / 2, 0};
            } else {
                this.x_arr = new int[]{0, iconWidth, 0};
                this.y_arr = new int[]{0, iconHeight / 2, iconHeight};
            }
            this.iconWidth = iconWidth;
            this.iconHeight = iconHeight;
        }

        @Override
        public int getIconHeight() {
            return this.iconHeight;
        }

        @Override
        public int getIconWidth() {
            return this.iconWidth;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Constants.CROSSHAIRCOLOR);
            g.fillPolygon(this.x_arr, this.y_arr, this.x_arr.length);
        }
    }
}

