/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class GridEditor
extends DefaultCellEditor {
    private final AbstractViewer viewer;
    private final GridViewerTableModel tableModel;
    private final String EMPTY = "";
    private Annotation annotation;
    private InlineEditBox inlineEditBox;
    private boolean enterCommits = false;

    public GridEditor(AbstractViewer viewer, GridViewerTableModel dataModel) {
        super(new JTextField());
        this.getComponent().setEnabled(false);
        this.viewer = viewer;
        this.tableModel = dataModel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.annotation = null;
        if (this.inlineEditBox == null) {
            this.inlineEditBox = new InlineEditBox(true);
            if (this.viewer instanceof InlineEditBoxListener) {
                this.inlineEditBox.addInlineEditBoxListener((InlineEditBoxListener)((Object)this.viewer));
            }
        }
        if (table.getColumnName(column).equals("ColumnAnnotation")) {
            this.annotation = (Annotation)this.tableModel.getAnnotationCore(row);
            this.configureEditBox(table, row, column);
            this.inlineEditBox.startEdit();
            return this.inlineEditBox.getEditorComponent();
        }
        if (value instanceof Annotation) {
            this.annotation = (Annotation)value;
            this.configureEditBox(table, row, column);
            this.inlineEditBox.startEdit();
            return this.inlineEditBox.getEditorComponent();
        }
        if (value instanceof String) {
            try {
                Tier childTier;
                String tierName = this.tableModel.getColumnName(column);
                AbstractAnnotation parentAnn = (AbstractAnnotation)this.tableModel.getAnnotationCore(row);
                if (tierName != null && parentAnn != null && (childTier = ((TranscriptionImpl)parentAnn.getTier().getParent()).getTierWithId(tierName)) != null) {
                    TierImpl parentTier = (TierImpl)((TierImpl)childTier).getParentTier();
                    long time = (parentAnn.getBeginTimeBoundary() + parentAnn.getEndTimeBoundary()) / 2L;
                    if (parentTier == parentAnn.getTier() || parentTier.getAnnotationAtTime(time) != null) {
                        this.annotation = ((TierImpl)childTier).createAnnotation(time, time);
                    }
                }
                if (this.annotation != null) {
                    this.tableModel.setValueAt(this.annotation, row, column);
                    this.configureEditBox(table, row, column);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (GridEditor.this.inlineEditBox != null) {
                                GridEditor.this.inlineEditBox.startEdit();
                            }
                        }
                    });
                    return this.inlineEditBox.getEditorComponent();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return this.getComponent();
            }
        }
        System.out.println("Warning: Cell (" + row + "," + column + ") not handled by editor. Should not be editable!");
        return this.getComponent();
    }

    private void configureEditBox(JTable table, int row, int column) {
        this.viewer.setActiveAnnotation(this.annotation);
        this.inlineEditBox.setAnnotation(this.annotation);
        this.inlineEditBox.setEnterCommits(this.enterCommits);
        table.setRowHeight(row, (int)(1.5 * (double)table.getRowHeight()));
        Font ff = table.getFont();
        if (table instanceof AnnotationTable) {
            ff = ((AnnotationTable)table).getFontForColumn(column);
        }
        if (this.inlineEditBox.isUsingControlledVocabulary()) {
            this.inlineEditBox.configureEditor(JComboBox.class, ff, table.getCellRect(row, column, true).getSize());
        } else {
            this.inlineEditBox.configureEditor(JScrollPane.class, ff, table.getCellRect(row, column, true).getSize());
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.annotation != null) {
            return this.annotation.getValue();
        }
        return "";
    }

    public void updateLocale() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.updateLocale();
        }
    }

    public void commitEdit() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.commitEdit();
        }
    }

    public void setEnterCommits(boolean enterCommits) {
        this.enterCommits = enterCommits;
    }

    @Override
    public void cancelCellEditing() {
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.setKeyStrokesNotToBeConsumed(ksList);
        }
    }
}

