/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MultipleFileToolBoxExportStep1
extends StepPane
implements ItemListener {
    private JTable tierTable;
    private JCheckBox blankLineCB;
    private JRadioButton selectedFilesFromDiskRB;
    private JRadioButton filesFromDomainRB;
    private JPanel fileSelectionPanel;
    private JPanel tierSelectionPanel;
    private JPanel buttonPanel;
    private ButtonGroup buttonGroup;
    private JButton selectFilesBtn;
    private JButton selectDomainBtn;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JScrollPane tierTableScrollPane;
    private List<String> openedFileList;
    private List<String> recordMarkerList;
    private Set<String> tierSet;
    HashMap<String, String> recordMarkerMap;
    HashMap<String, List<String>> tiersMap;
    private final String elanBeginLabel = "ELANBegin";
    private final String elanEndLabel = "ELANEnd";
    private final String elanParticipantLabel = "ELANParticipant";
    private Insets globalInset = new Insets(2, 4, 2, 4);
    private boolean bothMediaDetected = false;
    private boolean mediaDetected = false;

    public MultipleFileToolBoxExportStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.initFileSelectionPanel();
        this.initTierSelectionPanel();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.fileSelectionPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        this.add((Component)this.tierSelectionPanel, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExportToolbox.Title.Step1Title");
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        SelectableContentTableModel model = (SelectableContentTableModel)this.tierTable.getModel();
        Vector tiers = model.getSelectedValues();
        ArrayList<String> selectedTiers = new ArrayList<String>();
        for (Object t : tiers) {
            selectedTiers.add(t.toString());
        }
        this.multiPane.putStepProperty("SelectedTiers", selectedTiers);
        this.multiPane.putStepProperty("OpenedFiles", this.openedFileList);
        this.multiPane.putStepProperty("TierListMap", this.tiersMap);
        this.multiPane.putStepProperty("RecordMarkersList", this.recordMarkerList);
        this.multiPane.putStepProperty("RecordMarkersMap", this.recordMarkerMap);
        this.multiPane.putStepProperty("MarkersWithBlankLinesList", this.getMarkersWithBlankLines());
        this.multiPane.putStepProperty("BothMediaDetected", this.bothMediaDetected);
        this.multiPane.putStepProperty("EnableMediaMarker", this.mediaDetected);
        return true;
    }

    private List getMarkersWithBlankLines() {
        ArrayList<Object> mbl = new ArrayList<Object>();
        for (int i = 0; i < this.tierTable.getModel().getRowCount(); ++i) {
            SelectableObject sob = (SelectableObject)this.tierTable.getModel().getValueAt(i, 1);
            if (!sob.isSelected()) continue;
            mbl.add(sob.getValue());
        }
        return mbl;
    }

    private void initFileSelectionPanel() {
        this.fileSelectionPanel = new JPanel(new GridBagLayout());
        this.fileSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.FileSelection")));
        RadioButtonHandler radioButtonListener = new RadioButtonHandler();
        this.selectedFilesFromDiskRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromFileBrowser"));
        this.selectedFilesFromDiskRB.addActionListener(radioButtonListener);
        this.selectedFilesFromDiskRB.setSelected(true);
        this.filesFromDomainRB = new JRadioButton(ElanLocale.getString("FileAndTierSelectionStepPane.Radio.FilesFromDomain"));
        this.filesFromDomainRB.addActionListener(radioButtonListener);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.selectedFilesFromDiskRB);
        this.buttonGroup.add(this.filesFromDomainRB);
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(buttonHandler);
        this.selectDomainBtn = new JButton(ElanLocale.getString("FileAndTierSelectionStepPane.Button.Domain"));
        this.selectDomainBtn.addActionListener(buttonHandler);
        this.selectDomainBtn.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = this.globalInset;
        this.fileSelectionPanel.add((Component)this.selectedFilesFromDiskRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        this.fileSelectionPanel.add((Component)this.filesFromDomainRB, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        this.fileSelectionPanel.add((Component)this.selectDomainBtn, gbc);
    }

    private void initTierSelectionPanel() {
        Insets insets;
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExport.Panel.Title.TierSelection")));
        this.blankLineCB = new JCheckBox(ElanLocale.getString("ExportShoebox.Button.BlankLineAfter"));
        this.blankLineCB.addItemListener(this);
        this.blankLineCB.setEnabled(false);
        this.selectAllButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.selectNoneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        ButtonHandler buttonHandler = new ButtonHandler();
        this.selectAllButton.addActionListener(buttonHandler);
        this.selectNoneButton.addActionListener(buttonHandler);
        this.tierTable = new JTable();
        this.tierTable.setSelectionMode(0);
        this.tierTable.setShowVerticalLines(true);
        DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
        this.tierTable.setModel(model);
        this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
        this.tierTableScrollPane = new JScrollPane(this.tierTable);
        this.tierTableScrollPane.setColumnHeaderView(null);
        this.buttonPanel.add(this.selectAllButton);
        this.buttonPanel.add(this.selectNoneButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.insets = insets = new Insets(0, this.globalInset.left, 0, this.globalInset.right);
        this.tierSelectionPanel.add((Component)this.buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.insets = insets;
        this.tierSelectionPanel.add((Component)this.blankLineCB, gbc);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object val;
        int row;
        if (ie.getSource() == this.blankLineCB && (row = this.tierTable.getSelectedRow()) > -1 && (val = this.tierTable.getValueAt(row, 1)) instanceof SelectableObject) {
            ((SelectableObject)val).setSelected(this.blankLineCB.isSelected());
            this.tierTable.repaint();
        }
    }

    private List<String> showMultiFileChooser() {
        ArrayList<String> fileNames = null;
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("ExportDialog.Multi"), 0, FileExtension.EAF_EXT, "LastUsedEAFDir");
        Object[] objects = chooser.getSelectedFiles();
        if (objects != null && objects.length > 0) {
            fileNames = new ArrayList<String>();
            for (int i = 0; i < objects.length; ++i) {
                if (fileNames.contains(objects[i])) continue;
                fileNames.add("" + objects[i]);
            }
        }
        return fileNames;
    }

    public void updateButtonStates() {
        try {
            SelectableContentTableModel model = (SelectableContentTableModel)this.tierTable.getModel();
            this.multiPane.setButtonEnabled(1, model.getSelectedValues().size() > 1);
            this.multiPane.setButtonEnabled(2, false);
        }
        catch (ClassCastException e) {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    private void addFileNames(File dir, List<String> files) {
        if (dir == null && files == null) {
            return;
        }
        File[] allSubs = dir.listFiles();
        for (int i = 0; i < allSubs.length; ++i) {
            if (allSubs[i].isDirectory() && allSubs[i].canRead()) {
                this.addFileNames(allSubs[i], files);
                continue;
            }
            if (!allSubs[i].canRead() || !allSubs[i].getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0]) || files.contains(allSubs[i].getAbsolutePath())) continue;
            files.add(allSubs[i].getAbsolutePath());
        }
    }

    class MarkerCellRenderer
    extends DefaultTableCellRenderer {
        MarkerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof SelectableObject) {
                if (((SelectableObject)value).isSelected()) {
                    c.setForeground(Constants.ACTIVEANNOTATIONCOLOR);
                } else if (!isSelected) {
                    c.setForeground(table.getForeground());
                }
            }
            return c;
        }
    }

    class SelectableObjectComparator
    implements Comparator<SelectableObject> {
        SelectableObjectComparator() {
        }

        @Override
        public int compare(SelectableObject o1, SelectableObject o2) {
            if (o1.getValue().equals(o2.getValue())) {
                return 0;
            }
            return 1;
        }
    }

    protected class OpenFilesThread
    extends Thread
    implements ListSelectionListener {
        private List<String> filenames;
        private JTable tierTable;
        private DisplayableContentTableModel model;
        private ActionListener listener;

        public OpenFilesThread(List<String> filenames, JTable tierTable, ActionListener listener) {
            this.filenames = filenames;
            this.tierTable = tierTable;
            this.listener = listener;
            this.model = new DisplayableContentTableModel(new String[]{ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part1"), "0 " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + filenames.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (0%)"});
            this.model.connectTable(this.tierTable);
            this.tierTable.setModel(this.model);
        }

        @Override
        public void run() {
            MultipleFileToolBoxExportStep1.this.tierSet = new TreeSet();
            TreeSet<SelectableObject> selectableObjectSet = new TreeSet<SelectableObject>(new SelectableObjectComparator());
            MultipleFileToolBoxExportStep1.this.openedFileList = new ArrayList();
            MultipleFileToolBoxExportStep1.this.recordMarkerList = new ArrayList();
            MultipleFileToolBoxExportStep1.this.recordMarkerMap = new HashMap();
            MultipleFileToolBoxExportStep1.this.tiersMap = new HashMap();
            FrameManager manager = FrameManager.getInstance();
            for (int i = 0; i < this.filenames.size(); ++i) {
                TranscriptionImpl transImpl = null;
                ElanFrame2 frame = manager.getFrameFor(this.filenames.get(i), false);
                String message = null;
                if (frame != null) {
                    message = "' " + this.filenames.get(i) + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part1");
                    if (frame.getViewerManager().getTranscription().isChanged()) {
                        message = message + "\\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part2");
                    }
                    message = message + "\\n" + ElanLocale.getString("FileAndTierSelectionStepPane.Message3.Part3");
                    JOptionPane.showMessageDialog(MultipleFileToolBoxExportStep1.this, message, ElanLocale.getString("Message.Warning"), 2, null);
                }
                if (transImpl == null) {
                    transImpl = new TranscriptionImpl(this.filenames.get(i));
                }
                MultipleFileToolBoxExportStep1.this.openedFileList.add(this.filenames.get(i));
                this.checkForMediaFiles(transImpl);
                Vector tiersInFile = transImpl.getTiers();
                ArrayList<String> markersInthisFile = new ArrayList<String>();
                ArrayList<String> rootTiers = new ArrayList<String>(5);
                for (TierImpl t : tiersInFile) {
                    String tName = t.getName();
                    int atIndex = tName.indexOf(64);
                    if (atIndex > -1) {
                        String markName = tName.substring(0, atIndex);
                        if (!MultipleFileToolBoxExportStep1.this.tierSet.contains(markName)) {
                            if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                                selectableObjectSet.add(new SelectableObject("ELANBegin", false));
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                                selectableObjectSet.add(new SelectableObject("ELANEnd", false));
                                MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                                selectableObjectSet.add(new SelectableObject("ELANParticipant", false));
                            }
                            MultipleFileToolBoxExportStep1.this.tierSet.add(markName);
                            selectableObjectSet.add(new SelectableObject(markName, false));
                        }
                        if (!markersInthisFile.contains(markName)) {
                            markersInthisFile.add(markName);
                        }
                        if (t.hasParentTier() || rootTiers.contains(markName)) continue;
                        rootTiers.add(markName);
                        continue;
                    }
                    if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                        selectableObjectSet.add(new SelectableObject("ELANBegin", false));
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                        selectableObjectSet.add(new SelectableObject("ELANEnd", false));
                        MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                        selectableObjectSet.add(new SelectableObject("ELANParticipant", false));
                    }
                    selectableObjectSet.add(new SelectableObject(tName, false));
                    MultipleFileToolBoxExportStep1.this.tierSet.add(tName);
                    markersInthisFile.add(tName);
                    if (t.hasParentTier()) continue;
                    rootTiers.add(tName);
                }
                MultipleFileToolBoxExportStep1.this.tiersMap.put(this.filenames.get(i), markersInthisFile);
                if (rootTiers.size() == 1) {
                    String recordMarker = (String)rootTiers.get(0);
                    MultipleFileToolBoxExportStep1.this.recordMarkerMap.put(this.filenames.get(i), recordMarker);
                    if (!MultipleFileToolBoxExportStep1.this.recordMarkerList.contains(recordMarker)) {
                        MultipleFileToolBoxExportStep1.this.recordMarkerList.add(recordMarker);
                    }
                }
                this.model.updateMessage(1, i + 1 + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part2") + " " + this.filenames.size() + " " + ElanLocale.getString("FileAndTierSelectionStepPane.Message2.Part3") + " (" + Math.round((float)(i + 1) / (float)this.filenames.size() * 100.0f) + "%)");
            }
            if (MultipleFileToolBoxExportStep1.this.tierSet.isEmpty()) {
                MultipleFileToolBoxExportStep1.this.openedFileList.clear();
                DisplayableContentTableModel model = (DisplayableContentTableModel)this.tierTable.getModel();
                model.setValueAt(ElanLocale.getString("FileAndTierSelectionStepPane.Message3"), 0, 0);
            } else {
                if (MultipleFileToolBoxExportStep1.this.tierSet.size() == 1) {
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANBegin");
                    selectableObjectSet.add(new SelectableObject("ELANBegin", true));
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANEnd");
                    selectableObjectSet.add(new SelectableObject("ELANEnd", true));
                    MultipleFileToolBoxExportStep1.this.tierSet.add("ELANParticipant");
                    selectableObjectSet.add(new SelectableObject("ELANParticipant", true));
                }
                SelectableContentTableModel model = new SelectableContentTableModel(selectableObjectSet, this.tierTable);
                model.addActionListener(this.listener);
                model.selectAll();
                this.tierTable.setModel(model);
                this.tierTable.getSelectionModel().setSelectionMode(0);
                this.tierTable.getSelectionModel().addListSelectionListener(this);
                this.tierTable.getColumnModel().getColumn(0).setHeaderValue(null);
                this.tierTable.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
                this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
                this.tierTable.getColumnModel().getColumn(1).setCellRenderer(new MarkerCellRenderer());
                this.tierTable.repaint();
                MultipleFileToolBoxExportStep1.this.blankLineCB.setEnabled(true);
                MultipleFileToolBoxExportStep1.this.updateButtonStates();
            }
        }

        private void checkForMediaFiles(TranscriptionImpl transcription) {
            if (MultipleFileToolBoxExportStep1.this.bothMediaDetected) {
                return;
            }
            Vector mds = transcription.getMediaDescriptors();
            boolean video = false;
            boolean audio = false;
            if (mds != null && mds.size() > 0) {
                MediaDescriptor md = null;
                for (int i = 0; i < mds.size(); ++i) {
                    if (video && audio) {
                        MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                        MultipleFileToolBoxExportStep1.this.bothMediaDetected = true;
                        break;
                    }
                    md = (MediaDescriptor)mds.get(i);
                    if (MediaDescriptorUtil.isVideoType(md)) {
                        video = true;
                        MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                        continue;
                    }
                    if (md.mimeType == null || !md.mimeType.equals("audio/*") && !md.mimeType.equals("audio/x-wav")) continue;
                    audio = true;
                    MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                }
            }
            if (video && audio) {
                MultipleFileToolBoxExportStep1.this.mediaDetected = true;
                MultipleFileToolBoxExportStep1.this.bothMediaDetected = true;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            if (this.model != null && lse.getValueIsAdjusting()) {
                int col = 0;
                int row = this.tierTable.getSelectedRow();
                if (row > -1) {
                    Object val;
                    if (this.tierTable.isRowSelected(row)) {
                        this.tierTable.setValueAt(Boolean.TRUE, row, col);
                    }
                    if ((val = this.tierTable.getValueAt(row, 1)) instanceof SelectableObject) {
                        MultipleFileToolBoxExportStep1.this.blankLineCB.setSelected(((SelectableObject)val).isSelected());
                    }
                }
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private JRadioButton previouslySelectedRadioButton;

        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton rb = (JRadioButton)e.getSource();
            if (rb == MultipleFileToolBoxExportStep1.this.selectedFilesFromDiskRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    MultipleFileToolBoxExportStep1.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
                MultipleFileToolBoxExportStep1.this.tierTable.setModel(model);
                MultipleFileToolBoxExportStep1.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
                MultipleFileToolBoxExportStep1.this.selectFilesBtn.setEnabled(true);
                MultipleFileToolBoxExportStep1.this.selectDomainBtn.setEnabled(false);
            } else if (rb == MultipleFileToolBoxExportStep1.this.filesFromDomainRB) {
                if (this.previouslySelectedRadioButton != rb) {
                    MultipleFileToolBoxExportStep1.this.openedFileList = null;
                    this.previouslySelectedRadioButton = rb;
                }
                DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message3"));
                MultipleFileToolBoxExportStep1.this.tierTable.setModel(model);
                MultipleFileToolBoxExportStep1.this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
                MultipleFileToolBoxExportStep1.this.selectFilesBtn.setEnabled(false);
                MultipleFileToolBoxExportStep1.this.selectDomainBtn.setEnabled(true);
            }
            MultipleFileToolBoxExportStep1.this.updateButtonStates();
        }
    }

    private class ModelClickedHandler
    implements ActionListener {
        private ModelClickedHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileToolBoxExportStep1.this.updateButtonStates();
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultipleFileToolBoxExportStep1.this.updateButtonStates();
            if (e != null) {
                JButton button = (JButton)e.getSource();
                if (button == MultipleFileToolBoxExportStep1.this.selectFilesBtn) {
                    List filenames = MultipleFileToolBoxExportStep1.this.showMultiFileChooser();
                    if (filenames != null && !filenames.isEmpty()) {
                        OpenFilesThread t = new OpenFilesThread(filenames, MultipleFileToolBoxExportStep1.this.tierTable, new ModelClickedHandler());
                        t.start();
                    }
                } else if (button == MultipleFileToolBoxExportStep1.this.selectDomainBtn) {
                    MFDomainDialog domainDialog = new MFDomainDialog(ELANCommandFactory.getRootFrame(null), ElanLocale.getString("ExportDialog.Multi"), true);
                    domainDialog.setVisible(true);
                    List<String> searchPaths = domainDialog.getSearchPaths();
                    List<String> searchDirs = domainDialog.getSearchDirs();
                    ArrayList<String> fileNames = new ArrayList<String>();
                    if (!searchPaths.isEmpty()) {
                        fileNames.addAll(searchPaths);
                    }
                    if (!searchDirs.isEmpty()) {
                        for (int i = 0; i < searchDirs.size(); ++i) {
                            File f = new File(searchDirs.get(i));
                            if (f.isFile() && f.canRead()) {
                                if (fileNames.contains(searchDirs.get(i))) continue;
                                fileNames.add(searchDirs.get(i));
                                continue;
                            }
                            if (!f.isDirectory() || !f.canRead()) continue;
                            MultipleFileToolBoxExportStep1.this.addFileNames(f, fileNames);
                        }
                    }
                    if (fileNames.size() > 0) {
                        OpenFilesThread t = new OpenFilesThread(fileNames, MultipleFileToolBoxExportStep1.this.tierTable, new ModelClickedHandler());
                        t.start();
                    }
                } else if (button == MultipleFileToolBoxExportStep1.this.selectAllButton) {
                    try {
                        SelectableContentTableModel model = (SelectableContentTableModel)MultipleFileToolBoxExportStep1.this.tierTable.getModel();
                        model.selectAll();
                        MultipleFileToolBoxExportStep1.this.updateButtonStates();
                    }
                    catch (ClassCastException exception) {}
                } else if (button == MultipleFileToolBoxExportStep1.this.selectNoneButton) {
                    try {
                        SelectableContentTableModel model = (SelectableContentTableModel)MultipleFileToolBoxExportStep1.this.tierTable.getModel();
                        model.selectNone();
                        MultipleFileToolBoxExportStep1.this.updateButtonStates();
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

