/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.MinimalTabExportTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class ExportTabdelimited {
    public boolean includeBeginTime = true;
    public boolean includeEndTime = true;
    public boolean includeDuration = true;
    public boolean includeHHMM = true;
    public boolean includeSSMS = true;
    public boolean includeMS = false;
    public boolean includeSMPTE = false;
    public boolean palFormat = false;
    public boolean includeFileName = false;
    public boolean includeFilePath = false;
    public long mediaOffset = 0L;
    public boolean includeCVDescrip = true;
    public boolean repeatValues = true;
    public boolean combineBlocks = true;
    private final String TAB = "\t";
    private final String NEWLINE = "\n";
    private boolean multipleFileExport = false;

    public void exportTiersColumnPerTier(Transcription transcription, String[] tierNames, File exportFile, String charEncoding, long beginTime, long endTime) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(exportFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, charEncoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        ArrayList<String> includedTiers = new ArrayList<String>();
        if (tierNames == null) {
            Vector tiers = transcription.getTiers();
            Tier t = null;
            for (int i = 0; i < tiers.size(); ++i) {
                t = (Tier)tiers.get(i);
                includedTiers.add(t.getName());
            }
        } else {
            for (String name : tierNames) {
                includedTiers.add(name);
            }
        }
        this.writeHeaders(writer, includedTiers);
        this.writeTiersColumnPerTier(writer, transcription, includedTiers, beginTime, endTime);
        try {
            writer.close();
        }
        catch (IOException iioo) {
            iioo.printStackTrace();
        }
    }

    public void exportTiersColumnPerTier(List<File> files, String[] tierNames, File exportFile, String charEncoding, long beginTime, long endTime) throws IOException {
        if (exportFile == null) {
            throw new IOException("No destination file specified for export");
        }
        if (files == null || files.size() == 0) {
            throw new IOException("No files specified for export");
        }
        if (tierNames == null || tierNames.length == 0) {
            throw new IOException("No tiers specified for export");
        }
        this.multipleFileExport = true;
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(exportFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, charEncoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        ArrayList<String> includedTiers = new ArrayList<String>();
        for (String name : tierNames) {
            includedTiers.add(name);
        }
        this.writeHeaders(writer, includedTiers);
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            if (file == null) continue;
            try {
                TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                this.writeTiersColumnPerTier(writer, trans, includedTiers, beginTime, endTime);
                continue;
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Could not handle file: " + file.getAbsolutePath());
            }
        }
        try {
            writer.close();
        }
        catch (IOException iioo) {
            iioo.printStackTrace();
        }
    }

    public void writeTiersColumnPerTier(BufferedWriter writer, Transcription transcription, List<String> includedTiers, long beginTime, long endTime) throws IOException {
        if (transcription == null) {
            throw new NullPointerException("The transcription is null");
        }
        if (writer == null) {
            throw new IOException("No writer supplied to write to");
        }
        if (includedTiers == null) {
            includedTiers = new ArrayList<String>();
            Vector tiers = transcription.getTiers();
            Tier t = null;
            for (int i = 0; i < tiers.size(); ++i) {
                t = (Tier)tiers.get(i);
                includedTiers.add(t.getName());
            }
        }
        DefaultMutableTreeNode rootNode = this.createTree(includedTiers, transcription);
        ArrayList<MinimalTabExportTableModel> allBlocks = new ArrayList<MinimalTabExportTableModel>();
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(100);
        block1: for (int i = 0; i < rootNode.getChildCount(); ++i) {
            HashMap<String, String> cvEntryMap = null;
            String cvName = null;
            CVEntry[] entries = null;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            String tierName = (String)node.getUserObject();
            TierImpl tier = (TierImpl)transcription.getTierWithId(tierName);
            if (tier == null) continue;
            if (this.includeCVDescrip) {
                cvEntryMap = new HashMap<String, String>();
                cvName = tier.getLinguisticType().getControlledVocabylaryName();
                if (cvName != null) {
                    for (CVEntry cv : entries = ((TranscriptionImpl)transcription).getControlledVocabulary(cvName).getEntries()) {
                        cvEntryMap.put(cv.getValue(), cv.getDescription());
                    }
                }
            }
            Vector annos = tier.getAnnotations();
            for (int j = 0; j < annos.size(); ++j) {
                allAnnotations.clear();
                Annotation ann = (Annotation)annos.get(j);
                if (ann == null) continue;
                if (TimeRelation.overlaps(ann, beginTime, endTime)) {
                    allAnnotations.add(ann);
                    long b = ann.getBeginTimeBoundary();
                    long e = ann.getEndTimeBoundary();
                    Enumeration<TreeNode> nodeEn = node.depthFirstEnumeration();
                    block4: while (nodeEn.hasMoreElements()) {
                        DefaultMutableTreeNode chNode = (DefaultMutableTreeNode)nodeEn.nextElement();
                        if (chNode == node || (tier = (TierImpl)transcription.getTierWithId(tierName = (String)chNode.getUserObject())) == null) continue;
                        Vector annos2 = tier.getAnnotations();
                        for (int k = 0; k < annos2.size(); ++k) {
                            Annotation ann2 = (Annotation)annos2.get(k);
                            if (ann2 == null) continue;
                            if (TimeRelation.overlaps(ann2, b, e)) {
                                allAnnotations.add(ann2);
                            }
                            if (ann2.getBeginTimeBoundary() > e) continue block4;
                        }
                    }
                    MinimalTabExportTableModel tm = null;
                    tm = this.repeatValues && this.combineBlocks ? new MinimalTabExportTableModel(includedTiers, allAnnotations, cvEntryMap, true, true) : new MinimalTabExportTableModel(includedTiers, allAnnotations, cvEntryMap);
                    if (this.multipleFileExport) {
                        if (this.includeFileName) {
                            tm.setFileName(transcription.getName());
                        }
                        if (this.includeFilePath) {
                            tm.setFilePath(transcription.getFullPath());
                        }
                    }
                    if (this.combineBlocks) {
                        tm.setSpan(new long[]{b, e});
                        allBlocks.add(tm);
                    } else {
                        this.writeBlock(writer, tm);
                    }
                }
                if (ann.getBeginTimeBoundary() > endTime) continue block1;
            }
        }
        if (this.combineBlocks) {
            int i;
            ArrayList<MinimalTabExportTableModel> removableBlocks = new ArrayList<MinimalTabExportTableModel>();
            for (i = allBlocks.size() - 1; i >= 0; --i) {
                MinimalTabExportTableModel mtm2 = (MinimalTabExportTableModel)allBlocks.get(i);
                long[] span2 = mtm2.getSpan();
                for (int j = 0; j < allBlocks.size(); ++j) {
                    boolean empty;
                    MinimalTabExportTableModel mtm1;
                    long[] span1;
                    if (j == i || (span1 = (mtm1 = (MinimalTabExportTableModel)allBlocks.get(j)).getSpan())[0] > span2[0] || span1[1] < span2[1] || !(empty = this.mergeTables(mtm1, mtm2))) continue;
                    removableBlocks.add(mtm2);
                }
            }
            if (removableBlocks.size() > 0) {
                for (i = allBlocks.size() - 1; i >= 0; --i) {
                    if (!removableBlocks.contains(allBlocks.get(i))) continue;
                    allBlocks.remove(i);
                }
            }
            for (i = 0; i < allBlocks.size(); ++i) {
                this.writeBlock(writer, (MinimalTabExportTableModel)allBlocks.get(i));
            }
        }
    }

    private boolean mergeTables(MinimalTabExportTableModel mtm1, MinimalTabExportTableModel mtm2) {
        int i;
        ArrayList<Integer> removals = new ArrayList<Integer>();
        block0: for (i = 0; i < mtm2.getRows().size(); ++i) {
            List curRow = mtm2.getRows().get(i);
            long l1 = (Long)curRow.get(1);
            long l2 = (Long)curRow.get(2);
            for (int j = 0; j < mtm1.getRows().size(); ++j) {
                Object val;
                int k;
                List otherRow = mtm1.getRows().get(j);
                long l3 = (Long)otherRow.get(1);
                long l4 = (Long)otherRow.get(2);
                if (l1 == l3 && l2 == l4) {
                    removals.add(i);
                    for (k = 3; k < curRow.size(); ++k) {
                        val = curRow.get(k);
                        if (val == null) continue;
                        otherRow.set(k, val);
                    }
                    continue block0;
                }
                if (l3 > l1 || l4 < l2) continue;
                for (k = 3; k < otherRow.size(); ++k) {
                    val = otherRow.get(k);
                    if (val == null) continue;
                    curRow.set(k, val);
                }
            }
        }
        for (i = removals.size() - 1; i >= 0; --i) {
            mtm2.getRows().remove((Integer)removals.get(i));
        }
        return mtm2.getRows().size() == 0;
    }

    public void writeHeaders(BufferedWriter writer, List<String> includedTiers) throws IOException {
        if (this.includeBeginTime) {
            if (this.includeHHMM) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + "\t");
            }
            if (this.includeSSMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + "\t");
            }
            if (this.includeMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + "\t");
            }
            if (this.includeSMPTE) {
                if (this.palFormat) {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + "\t");
                } else {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + "\t");
                }
            }
        }
        if (this.includeEndTime) {
            if (this.includeHHMM) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + "\t");
            }
            if (this.includeSSMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + "\t");
            }
            if (this.includeMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + "\t");
            }
            if (this.includeSMPTE) {
                if (this.palFormat) {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + "\t");
                } else {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnEndTime") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + "\t");
                }
            }
        }
        if (this.includeDuration) {
            if (this.includeHHMM) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.TimeCode") + "\t");
            }
            if (this.includeSSMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.Seconds") + "\t");
            }
            if (this.includeMS) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.MilliSec") + "\t");
            }
            if (this.includeSMPTE) {
                if (this.palFormat) {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.PAL") + "\t");
                } else {
                    writer.write(ElanLocale.getString("Frame.GridFrame.ColumnDuration") + " - " + ElanLocale.getString("TimeCodeFormat.SMPTE.NTSC") + "\t");
                }
            }
        }
        for (String name : includedTiers) {
            writer.write(name);
            writer.write("\t");
        }
        if (this.includeCVDescrip) {
            writer.write(ElanLocale.getString("EditCVDialog.Label.CVDescription"));
            writer.write("\t");
        }
        if (this.multipleFileExport) {
            if (this.includeFileName) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnFileName") + "\t");
            }
            if (this.includeFilePath) {
                writer.write(ElanLocale.getString("Frame.GridFrame.ColumnFilePath"));
            }
        }
        writer.write("\n");
    }

    private void writeBlock(BufferedWriter writer, MinimalTabExportTableModel tm) throws IOException {
        if (tm == null) {
            ClientLogger.LOG.warning("No table model provided");
        }
        List<List> rows = tm.getRows();
        List row = null;
        for (int i = 0; i < rows.size(); ++i) {
            row = rows.get(i);
            if (row.get(0) == tm.HIDDEN) continue;
            long bt = (Long)row.get(1) + this.mediaOffset;
            long et = (Long)row.get(2) + this.mediaOffset;
            if (this.includeBeginTime) {
                if (this.includeHHMM) {
                    writer.write(TimeFormatter.toString(bt) + "\t");
                }
                if (this.includeSSMS) {
                    writer.write(Double.toString((double)bt / 1000.0) + "\t");
                }
                if (this.includeMS) {
                    writer.write(bt + "\t");
                }
                if (this.includeSMPTE) {
                    if (this.palFormat) {
                        writer.write(TimeFormatter.toTimecodePAL(bt) + "\t");
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(bt) + "\t");
                    }
                }
            }
            if (this.includeEndTime) {
                if (this.includeHHMM) {
                    writer.write(TimeFormatter.toString(et) + "\t");
                }
                if (this.includeSSMS) {
                    writer.write(Double.toString((double)et / 1000.0) + "\t");
                }
                if (this.includeMS) {
                    writer.write(et + "\t");
                }
                if (this.includeSMPTE && this.palFormat) {
                    if (this.palFormat) {
                        writer.write(TimeFormatter.toTimecodePAL(et) + "\t");
                    } else {
                        writer.write(TimeFormatter.toTimecodeNTSC(et) + "\t");
                    }
                }
            }
            if (this.includeDuration) {
                long d = et - bt;
                if (this.includeHHMM) {
                    writer.write(TimeFormatter.toString(d) + "\t");
                }
                if (this.includeSSMS) {
                    writer.write(Double.toString((double)d / 1000.0) + "\t");
                }
                if (this.includeMS) {
                    writer.write(d + "\t");
                }
            }
            for (int j = 3; j < row.size(); ++j) {
                Object value = row.get(j);
                if (value != null) {
                    if (value instanceof String) {
                        writer.write(((String)value).replace("\n", " "));
                    } else {
                        writer.write(value.toString());
                    }
                }
                if (j == row.size() - 1) continue;
                writer.write("\t");
            }
            if (tm.getFileName() != null) {
                writer.write("\t" + tm.getFileName());
            }
            if (tm.getFilePath() != null) {
                writer.write("\t" + tm.getFilePath());
            }
            writer.write("\n");
        }
    }

    private DefaultMutableTreeNode createTree(List<String> includedTiers, Transcription transcription) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        ArrayList<DefaultMutableTreeNode> nodeList = new ArrayList<DefaultMutableTreeNode>(includedTiers.size());
        for (String name : includedTiers) {
            nodeList.add(new DefaultMutableTreeNode(name));
        }
        for (DefaultMutableTreeNode node : nodeList) {
            String tierName = (String)node.getUserObject();
            TierImpl tier = (TierImpl)transcription.getTierWithId(tierName);
            if (tier == null) continue;
            TierImpl parentTier = (TierImpl)tier.getParentTier();
            if (parentTier == null) {
                rootNode.add(node);
            } else {
                String parentName = parentTier.getName();
                if (!includedTiers.contains(parentName)) {
                    do {
                        if ((parentTier = (TierImpl)parentTier.getParentTier()) != null) continue;
                        parentName = null;
                        break;
                    } while (!includedTiers.contains(parentName = parentTier.getName()));
                }
                if (parentName == null) {
                    rootNode.add(node);
                } else {
                    for (DefaultMutableTreeNode node2 : nodeList) {
                        if (!parentName.equals(node2.getUserObject())) continue;
                        node2.add(node);
                        break;
                    }
                }
            }
            if (node.getParent() != null) continue;
            ClientLogger.LOG.warning("Tier " + tierName + " could not be added to a parent");
            rootNode.add(node);
        }
        return rootNode;
    }
}

