/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.recognizer.data.RSelection;
import mpi.eudico.client.annotator.recognizer.data.Segment;
import mpi.eudico.client.annotator.recognizer.data.Segmentation;
import mpi.eudico.client.annotator.recognizer.io.RecTierWriter;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;

public class ExportRecogTiersDialog
extends AbstractExtTierExportDialog
implements ItemListener {
    private JCheckBox selectionCB;
    final String prefSelectedTiers = "ExportRecogTiersDialog.selectedTiers";
    final String prefTierOrder = "ExportRecogTiersDialog.TierOrder";
    final String prefParentTierOrder = "ExportRecogTiersDialog.ParentTierOrder";
    final String prefSelectTiersMode = "ExportRecogTiersDialog.SelectTiersMode";
    final String prefLastSelectedItems = "ExportRecogTiersDialog.LastSelectedItems";
    final String prefHiddenTiers = "ExportRecogTiersDialog.HiddenTiers";
    final String prefRootTiersOnly = "ExportRecogTiersDialog.ShowOnlyRootTiers";
    final String prefSelectionOnly = "ExportRecogTiersDialog.SelectionOnly";

    public ExportRecogTiersDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    protected void extractTiers() {
        Object useTyp = Preferences.get("ExportRecogTiersDialog.TierOrder", this.transcription);
        if (useTyp instanceof List) {
            this.setTierOrder((List)useTyp);
        } else {
            super.extractTiers(true);
        }
        useTyp = Preferences.get("ExportRecogTiersDialog.selectedTiers", this.transcription);
        if (useTyp instanceof List) {
            this.setSelectedTiers((List)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefSelectTiersMode, this.transcription)) instanceof String) {
            Object selItems;
            this.setSelectionMode((String)useTyp);
            if (!"Tier".equals((String)useTyp) && (selItems = Preferences.get("ExportRecogTiersDialog.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems((List)selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.selectionCB = new JCheckBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String fileName = this.promptForFileName();
        if (fileName == null) {
            return false;
        }
        File tf = new File(fileName);
        try {
            int answer;
            if (tf.exists() && (answer = JOptionPane.showConfirmDialog(this, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0, 2)) == 1) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        long begin = 0L;
        long end = Long.MAX_VALUE;
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
        }
        ArrayList<Object> segmentations = new ArrayList<Object>(selectedTiers.size());
        for (int i = 0; i < selectedTiers.size(); ++i) {
            String name = selectedTiers.get(i);
            TierImpl ti = (TierImpl)this.transcription.getTierWithId(name);
            if (ti == null) continue;
            Vector anns = ti.getAnnotations();
            ArrayList<RSelection> segments = new ArrayList<RSelection>(anns.size());
            for (int j = 0; j < anns.size(); ++j) {
                AbstractAnnotation aa = (AbstractAnnotation)anns.get(j);
                if (TimeRelation.overlaps(aa, begin, end)) {
                    segments.add(new Segment(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary(), aa.getValue()));
                }
                if (aa.getBeginTimeBoundary() > end) break;
            }
            Segmentation segmentation = new Segmentation(name, segments, "");
            segmentations.add(segmentation);
        }
        try {
            RecTierWriter xTierWriter = new RecTierWriter();
            xTierWriter.write(tf, segmentations, false);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Recognizer.RecognizerPanel.Warning.SaveFailed") + ioe.getMessage(), ElanLocale.getString("Message.Warning"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.RecogTiers.Title"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
    }

    protected String promptForFileName() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.XML_EXT);
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(null, 1, extensions, FileExtension.XML_EXT, "Recognizer.Path", null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            return f.getAbsolutePath();
        }
        return null;
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportRecogTiersDialog.ShowOnlyRootTiers", null);
        if (useTyp == null) {
            useTyp = Preferences.get("ExportRecogTiersDialog.rootTiersCB", null);
            Preferences.set("ExportRecogTiersDialog.rootTiersCB", null, null);
        }
        if (useTyp != null) {
            this.setRootTiersOnly((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportRecogTiersDialog.SelectionOnly", null)) == null) {
            useTyp = Preferences.get("ExportRecogTiersDialog.selectionCB", null);
            Preferences.set("ExportRecogTiersDialog.selectionCB", null, null);
        }
        if (useTyp != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set(this.prefRootTiersOnly, this.isRootTiersOnly(), null);
        Preferences.set(this.prefSelectionOnly, this.selectionCB.isSelected(), null);
        Preferences.set(this.prefSelectedTiers, this.getSelectedTiers(), this.transcription);
        Preferences.set(this.prefSelectTiersMode, this.getSelectionMode(), this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportRecogTiersDialog.LastSelectedItems", this.getSelectedItems(), this.transcription);
        }
        Preferences.set(this.prefHiddenTiers, this.getHiddenTiers(), this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set(this.prefTierOrder, tierOrder, this.transcription);
    }
}

