/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.TransformerException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.DisplaySettingsPane;
import mpi.eudico.client.annotator.export.ExportQtSmilDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.Transcription2QtSubtitle;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportQtSubtitleDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox mergeTiersCB;
    private JCheckBox recalculateTimesCB;
    private JButton fontSettingsButton;
    private HashMap fontSettingHashMap;
    private boolean smilExport;
    final String prefSmilPrefix = "ExportQtSMILDialog";
    final String prefSubtitlePrefix = "ExportQtSubtitleDialog";
    String prefStringPrefix = "ExportQtSubtitleDialog";
    final String prefSelectionOnly = this.prefStringPrefix + ".SelectionOnly";
    final String prefSelectedTiers = this.prefStringPrefix + ".selectedTiers";
    final String prefTierOrder = this.prefStringPrefix + ".TierOrder";
    final String prefSelectTiersMode = this.prefStringPrefix + ".SelectTiersMode";
    final String prefLastSelectedItems = this.prefStringPrefix + ".LastSelectedItems";
    final String prefHiddenTiers = this.prefStringPrefix + ".HiddenTiers";
    final String prefAddOffsetTime = this.prefStringPrefix + ".AddOffsetTime";
    final String prefMergeTiers = this.prefStringPrefix + ".MergeTiers";
    final String prefRecalculateTime = this.prefStringPrefix + ".RecalculateTimeFromZero";
    final String prefMinDur = this.prefStringPrefix + ".MinimumDuration";
    final String prefMinDurValue = this.prefStringPrefix + ".MinimumDurationValue";

    public ExportQtSubtitleDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        this(parent, modal, transcription, selection, false);
    }

    public ExportQtSubtitleDialog(Frame parent, boolean modal, Transcription transcription, Selection selection, boolean smilExport) {
        super(parent, modal, transcription, selection);
        this.smilExport = smilExport;
        this.prefStringPrefix = smilExport ? "ExportQtSMILDialog" : "ExportQtSubtitleDialog";
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.restrictCheckBox.requestFocus();
    }

    protected void extractTiers() {
        Object useTyp = Preferences.get(this.prefTierOrder, this.transcription);
        if (useTyp instanceof List) {
            this.setTierOrder((List)useTyp);
        } else {
            super.extractTiers(false);
        }
        useTyp = Preferences.get(this.prefSelectedTiers, this.transcription);
        if (useTyp instanceof List) {
            this.setSelectedTiers((List)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefSelectTiersMode, this.transcription)) instanceof String) {
            Object selItems;
            this.setSelectionMode((String)useTyp);
            if (!"Tier".equals((String)useTyp) && (selItems = Preferences.get(this.prefLastSelectedItems, this.transcription)) instanceof List) {
                this.setSelectedItems((List)selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.mergeTiersCB = new JCheckBox();
        this.mergeTiersCB.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.mergeTiersCB, gridBagConstraints);
        this.fontSettingsButton = new JButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.fontSettingsButton, gridBagConstraints);
        this.fontSettingsButton.addActionListener(this);
        this.minimalDurCB.addChangeListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        Vector mediaDescriptors;
        File exportFile;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        if (this.smilExport) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSmilDialog.Title"), null, FileExtension.SMIL_EXT, false);
            if (exportFile == null) {
                return false;
            }
        } else {
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSubtitleDialog.Title"), null, FileExtension.TEXT_EXT, false);
        }
        if (exportFile == null) {
            return false;
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = ((MediaDescriptor)mediaDescriptors.get((int)0)).timeOrigin;
        }
        boolean merge = this.mergeTiersCB.isSelected();
        long mediaDur = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        String[] tierNames = selectedTiers.toArray(new String[0]);
        long b = 0L;
        long e = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            b = this.selection.getBeginTime();
            e = this.selection.getEndTime();
        }
        String mediaURL = "";
        if (((TranscriptionImpl)this.transcription).getMediaDescriptors().size() > 0) {
            mediaURL = ((MediaDescriptor)((TranscriptionImpl)this.transcription).getMediaDescriptors().get((int)0)).mediaURL;
        }
        if (!merge) {
            Transcription2QtSubtitle.exportTiers(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        } else {
            Transcription2QtSubtitle.exportTiersMerged(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        }
        if (this.smilExport) {
            String smilFile = exportFile.getAbsolutePath();
            int index = smilFile.lastIndexOf(46);
            if (index > 0) {
                smilFile = smilFile.substring(0, index);
            }
            smilFile = smilFile + "." + FileExtension.SMIL_EXT[1];
            String mediaPath = "";
            if (mediaURL.length() > 0) {
                index = mediaURL.lastIndexOf("/");
                mediaPath = mediaURL.substring(index + 1);
            }
            try {
                if (this.selection != null && this.restrictCheckBox.isSelected()) {
                    ExportQtSmilDialog.export2SMILQt(new File(((TranscriptionImpl)this.transcription).getPathName()), new File(smilFile), tierNames, mediaPath, b + offset, e + offset, this.recalculateTimesCB.isSelected(), merge, this.fontSettingHashMap);
                } else {
                    ExportQtSmilDialog.export2SMILQt(new File(((TranscriptionImpl)this.transcription).getPathName()), new File(smilFile), tierNames, mediaPath, mediaDur, merge, this.fontSettingHashMap);
                }
                return true;
            }
            catch (TransformerException te) {
                throw new IOException("TransformerException: " + te.getMessage());
            }
        }
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        if (this.smilExport) {
            this.setTitle(ElanLocale.getString("ExportQtSmilDialog.Title"));
            this.titleLabel.setText(ElanLocale.getString("ExportQtSmilDialog.TitleLabel"));
        } else {
            this.setTitle(ElanLocale.getString("ExportQtSubtitleDialog.Title"));
            this.titleLabel.setText(ElanLocale.getString("ExportQtSubtitleDialog.TitleLabel"));
        }
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.mergeTiersCB.setText(ElanLocale.getString("ExportQtSubtitleDialog.Label.Merge"));
        this.fontSettingsButton.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.FontSetting"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (ae.getSource() == this.fontSettingsButton) {
            this.setNewFontSetting(DisplaySettingsPane.getNewFontSetting(this, ElanLocale.getString("DisplaySettingsPane.Title")));
        }
    }

    protected void setNewFontSetting(HashMap newSetting) {
        if (newSetting != null) {
            this.fontSettingHashMap = new HashMap();
            this.fontSettingHashMap = newSetting;
        }
    }

    protected void setPreferredSetting() {
        Object useTyp = Preferences.get(this.prefSelectionOnly, null);
        if (useTyp == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".restrictCheckBox", null);
            Preferences.set(this.prefStringPrefix + ".restrictCheckBox", null, null);
        }
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefMinDur, null)) == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".minimalDurCB", null);
            Preferences.set(this.prefStringPrefix + ".minimalDurCB", null, null);
        }
        if (useTyp != null) {
            this.minimalDurCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefAddOffsetTime, null)) == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".correctTimesCB", null);
            Preferences.set(this.prefStringPrefix + ".correctTimesCB", null, null);
        }
        if (useTyp != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefMergeTiers, null)) == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".mergeTiersCB", null);
            Preferences.set(this.prefStringPrefix + ".mergeTiersCB", null, null);
        }
        if (useTyp != null) {
            this.mergeTiersCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get(this.prefMinDurValue, null)) == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".minimalDurTF", null);
            Preferences.set(this.prefStringPrefix + ".minimalDurTF", null, null);
        }
        if (useTyp != null) {
            this.minimalDurTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get(this.prefRecalculateTime, null)) == null) {
            useTyp = Preferences.get(this.prefStringPrefix + ".recalculateTimesCB", null);
            Preferences.set(this.prefStringPrefix + ".recalculateTimesCB", null, null);
        }
        if (useTyp != null) {
            this.recalculateTimesCB.setSelected((Boolean)useTyp);
        }
    }

    protected void savePreferences() {
        Preferences.set(this.prefSelectionOnly, this.restrictCheckBox.isSelected(), null);
        Preferences.set(this.prefMinDur, this.minimalDurCB.isSelected(), null);
        Preferences.set(this.prefAddOffsetTime, this.correctTimesCB.isSelected(), null);
        Preferences.set(this.prefMergeTiers, this.mergeTiersCB.isSelected(), null);
        Preferences.set(this.prefRecalculateTime, this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set(this.prefMinDurValue, this.minimalDurTF.getText(), null);
        }
        Preferences.set(this.prefSelectedTiers, this.getSelectedTiers(), this.transcription);
        Preferences.set(this.prefSelectTiersMode, this.getSelectionMode(), this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set(this.prefLastSelectedItems, this.getSelectedItems(), this.transcription);
        }
        Preferences.set(this.prefHiddenTiers, this.getHiddenTiers(), this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set(this.prefTierOrder, tierOrder, this.transcription);
    }
}

