/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.util.TimeFormatter;

public class ExportFilmStrip {
    private int frameWidth = 120;
    private int frameStep = 1;
    private boolean includeTimeCodeInFrames = false;
    private boolean includeWaveform = true;
    private boolean timeRulerVisible = true;
    private int waveHeight = 100;
    private int stereoMode = 0;
    private ElanMediaPlayer[] players;
    private String waveFile;
    private final int MAX_IMG_WIDTH = 3000;
    private int numVideoRows = 0;
    private int totalImageWidth = 0;
    private int totalImageHeight = 0;
    private int margin = 2;
    private long msPerSample = 40L;
    private long bt = 0L;
    private long et = 0L;
    private BufferedImage bufImg;
    private ArrayList<ProgressListener> listeners;

    public ExportFilmStrip(ElanMediaPlayer[] players, String waveFile) {
        if (players == null) {
            throw new NullPointerException("No players to grab image from.");
        }
        if (waveFile == null) {
            this.includeWaveform = false;
        }
        this.players = players;
        this.waveFile = waveFile;
        this.init();
    }

    public ExportFilmStrip(ElanMediaPlayer[] players, String waveFile, int frameWidth, int frameStep, boolean includeWaveform, int waveHeight) {
        if (players == null) {
            throw new NullPointerException("No players to grab image from.");
        }
        if (waveFile == null) {
            includeWaveform = false;
        }
        this.players = players;
        this.waveFile = waveFile;
        if (frameWidth > 0) {
            this.frameWidth = frameWidth;
        }
        if (frameStep > 0) {
            this.frameStep = frameStep;
        }
        this.includeWaveform = includeWaveform;
        if (waveHeight > 0) {
            this.waveHeight = waveHeight;
        }
        this.init();
    }

    private void init() {
        this.totalImageHeight = this.margin;
        for (int i = 0; i < this.players.length; ++i) {
            if (!(this.players[i] instanceof VideoFrameGrabber) || !(this.players[i].getAspectRatio() > 0.0f)) continue;
            int h = (int)Math.ceil((float)this.frameWidth / this.players[i].getAspectRatio());
            this.totalImageHeight += h + this.margin;
            ++this.numVideoRows;
        }
        if (this.includeWaveform) {
            this.totalImageHeight += this.waveHeight + this.margin;
        }
    }

    public Image getImage() {
        return this.bufImg;
    }

    public void setFrameWidth(int frameWidth) {
        this.frameWidth = frameWidth;
        this.init();
    }

    public void setIncludeWaveform(boolean includeWaveform) {
        this.includeWaveform = includeWaveform;
        this.init();
    }

    public void setWaveHeight(int waveHeight) {
        this.waveHeight = waveHeight;
        this.init();
    }

    public void setFrameStep(int frameStep) {
        if (frameStep > 0) {
            this.frameStep = frameStep;
        }
    }

    public void setTimeRulerVisible(boolean timeRulerVisible) {
        this.timeRulerVisible = timeRulerVisible;
    }

    public void setStereoMode(int stereoMode) {
        this.stereoMode = stereoMode;
    }

    public void setIncludeTimeCodeInFrames(boolean includeTimeCodeInFrames) {
        this.includeTimeCodeInFrames = includeTimeCodeInFrames;
    }

    public void createImageInThread(long beginTime, long endTime) {
        this.msPerSample = this.players[0].getMilliSecondsPerSample();
        this.bt = beginTime - beginTime % this.msPerSample;
        this.et = endTime - endTime % this.msPerSample + this.msPerSample;
        try {
            new ImageThread().start();
        }
        catch (Exception ex) {
            this.progressInterrupt(ex.getMessage());
        }
    }

    public Image createImage(long beginTime, long endTime) {
        long timeSpan;
        this.msPerSample = this.players[0].getMilliSecondsPerSample();
        this.bt = beginTime - beginTime % this.msPerSample;
        this.et = endTime - endTime % this.msPerSample + this.msPerSample;
        int totalNumSamples = (int)((this.et - this.bt) / this.msPerSample);
        int numSamples = totalNumSamples / this.frameStep;
        if (totalNumSamples - numSamples * this.frameStep > 0) {
            ++numSamples;
        }
        if (this.frameStep > 1 && (timeSpan = (long)(numSamples - 1) * (this.msPerSample * (long)this.frameStep) + this.msPerSample) <= this.et - this.bt - this.msPerSample) {
            ++numSamples;
        }
        this.totalImageWidth = numSamples * this.frameWidth + 2 * this.margin;
        if (this.totalImageWidth == 0 || this.totalImageHeight == 0) {
            this.progressInterrupt("Image width or height is 0");
            return null;
        }
        int totalNumImages = numSamples * this.players.length;
        float perImg = this.includeWaveform ? 80.0f / (float)totalNumImages : 98.0f / (float)totalNumImages;
        BufferedImage buf = new BufferedImage(this.totalImageWidth, this.totalImageHeight, 1);
        Graphics2D g2d = buf.createGraphics();
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g2d.setFont(Constants.SMALLFONT);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.totalImageWidth, this.totalImageHeight);
        g2d.translate(this.margin, this.margin);
        for (int i = 0; i < this.players.length; ++i) {
            if (!(this.players[i] instanceof VideoFrameGrabber) || !(this.players[i].getAspectRatio() > 0.0f)) continue;
            this.paintFramesOfPlayer(g2d, this.players[i], (float)i * ((float)numSamples * perImg), perImg);
        }
        if (this.includeWaveform) {
            SignalViewer signalViewer = new SignalViewer(this.waveFile);
            this.progressUpdate(90, "");
            float mspp = (float)(this.et - this.bt) / (float)(numSamples * this.frameWidth + (numSamples - 1) * this.margin);
            signalViewer.setTimeScaleConnected(false);
            signalViewer.setSize(this.totalImageWidth - 2 * this.margin, this.waveHeight);
            signalViewer.setMsPerPixel(mspp);
            signalViewer.setIntervalBeginTime(this.bt);
            signalViewer.setTimeRulerVisible(this.timeRulerVisible);
            signalViewer.setChannelMode(this.stereoMode, false);
            signalViewer.paintComponent(g2d);
            this.progressUpdate(98, "");
        }
        this.bufImg = buf;
        this.progressComplete("");
        return buf;
    }

    private void paintFramesOfPlayer(Graphics2D g2d, ElanMediaPlayer player, float startProg, float perImg) {
        int wi;
        String tc;
        BufferedImage scaleImg;
        Image curImg;
        long curTime;
        int imgH = (int)Math.ceil((float)this.frameWidth / player.getAspectRatio());
        AffineTransform identity = new AffineTransform();
        AffineTransform at = null;
        AffineTransformOp atOp = null;
        int i = 1;
        long lastFrameTime = curTime = this.bt;
        while (curTime < this.et) {
            curImg = ((VideoFrameGrabber)((Object)player)).getFrameImageForTime(curTime);
            lastFrameTime = curTime;
            if (curImg != null) {
                if (at == null) {
                    at = new AffineTransform();
                    at.scale((float)this.frameWidth / (float)player.getSourceWidth(), (float)imgH / (float)player.getSourceHeight());
                    atOp = new AffineTransformOp(at, 3);
                }
                if (curImg instanceof RenderedImage) {
                    if (SystemReporting.isMacOS()) {
                        g2d.drawRenderedImage((RenderedImage)((Object)curImg), at);
                    } else {
                        try {
                            scaleImg = new BufferedImage(this.frameWidth, imgH, 1);
                            scaleImg = atOp.filter((BufferedImage)curImg, scaleImg);
                            g2d.drawRenderedImage(scaleImg, identity);
                        }
                        catch (Exception ex) {
                            g2d.drawRenderedImage((RenderedImage)((Object)curImg), at);
                        }
                    }
                } else {
                    g2d.drawImage(curImg, at, null);
                }
                g2d.drawRect(0, 0, this.frameWidth, imgH);
                if (this.includeTimeCodeInFrames) {
                    tc = TimeFormatter.toString(curTime);
                    wi = g2d.getFontMetrics().stringWidth(tc);
                    if (wi < this.frameWidth - 2) {
                        g2d.setColor(Color.LIGHT_GRAY);
                        g2d.drawString(tc, 3, g2d.getFont().getSize() + 2);
                        g2d.setColor(Color.BLUE);
                        g2d.drawString(tc, 2, g2d.getFont().getSize() + 1);
                    }
                    g2d.setColor(Color.WHITE);
                }
            }
            g2d.translate((double)this.frameWidth, 0.0);
            this.progressUpdate((int)(startProg + perImg * (float)i), "");
            ++i;
            curTime += (long)this.frameStep * this.msPerSample;
        }
        if (lastFrameTime < this.et - this.msPerSample) {
            curImg = ((VideoFrameGrabber)((Object)player)).getFrameImageForTime(this.et - this.msPerSample + 1L);
            if (curImg != null) {
                if (at == null) {
                    at = new AffineTransform();
                    at.scale((float)this.frameWidth / (float)player.getSourceWidth(), (float)imgH / (float)player.getSourceHeight());
                    atOp = new AffineTransformOp(at, 3);
                }
                if (curImg instanceof RenderedImage) {
                    try {
                        scaleImg = new BufferedImage(this.frameWidth, imgH, 1);
                        scaleImg = atOp.filter((BufferedImage)curImg, scaleImg);
                        g2d.drawRenderedImage(scaleImg, identity);
                    }
                    catch (Exception ex) {
                        g2d.drawRenderedImage((RenderedImage)((Object)curImg), at);
                    }
                    g2d.drawRenderedImage((RenderedImage)((Object)curImg), at);
                } else {
                    g2d.drawImage(curImg, at, null);
                }
                g2d.drawRect(0, 0, this.frameWidth, imgH);
                if (this.includeTimeCodeInFrames) {
                    tc = TimeFormatter.toString(curTime);
                    wi = g2d.getFontMetrics().stringWidth(tc);
                    if (wi < this.frameWidth - 2) {
                        g2d.setColor(Color.LIGHT_GRAY);
                        g2d.drawString(tc, 3, g2d.getFont().getSize() + 2);
                        g2d.setColor(Color.BLUE);
                        g2d.drawString(tc, 2, g2d.getFont().getSize() + 1);
                    }
                    g2d.setColor(Color.WHITE);
                }
            }
            g2d.translate((double)this.frameWidth, 0.0);
            this.progressUpdate((int)(startProg + perImg * (float)i), "");
        }
        g2d.translate(-g2d.getTransform().getTranslateX() + (double)this.margin, (double)(imgH + this.margin));
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private class ImageThread
    extends Thread {
        @Override
        public void run() {
            ExportFilmStrip.this.createImage(ExportFilmStrip.this.bt, ExportFilmStrip.this.et);
        }
    }
}

