/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.util.ClientLogger;

public class WebMA
extends FrameMenuAction {
    private String url;

    public WebMA(String name, ElanFrame2 frame, String webpageURL) {
        super(name, frame);
        this.url = webpageURL;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.url == null) {
            return;
        }
        try {
            URI uri = new URI(this.url);
            if (this.url.startsWith("mailto:")) {
                Desktop.getDesktop().mail(uri);
            } else {
                Desktop.getDesktop().browse(uri);
            }
        }
        catch (URISyntaxException use) {
            ClientLogger.LOG.warning("Error opening webpage: " + use.getMessage());
            this.errorMessage(use.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Error opening webpage: " + ioe.getMessage());
            this.errorMessage(ioe.getMessage());
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Message.Web.NoConnection") + ": " + message, ElanLocale.getString("Message.Warning"), 2);
    }
}

