/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TierDependenciesCA
extends CommandAction
implements ACMEditListener {
    private JFrame dependencyFrame;
    private int locationX = -1;
    private int locationY = -1;
    private int sizeWidth = -1;
    private int sizeHeight = -1;
    private JTree tree;

    public TierDependenciesCA(ViewerManager2 theVM) {
        super(theVM, "Menu.View.Dependencies");
        try {
            this.vm.getTranscription().addACMEditListener(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.View.Dependencies");
    }

    @Override
    protected Object getReceiver() {
        return null;
    }

    @Override
    protected Object[] getArguments() {
        Object[] args = new Object[]{this.getDependencyFrame()};
        return args;
    }

    public JFrame getFrame() {
        return this.dependencyFrame;
    }

    private JFrame getDependencyFrame() {
        if (this.dependencyFrame == null) {
            this.createDependencyFrame();
            Object val = Preferences.get("DependenciesFrame.Location", null);
            if (val instanceof Point) {
                Point p = (Point)val;
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                int x = p.x <= screen.width - 50 ? p.x : screen.width - 50;
                int y = p.y <= screen.height - 50 ? p.y : screen.height - 50;
                this.dependencyFrame.setLocation(x, y);
            }
            if ((val = Preferences.get("DependenciesFrame.Size", null)) instanceof Dimension) {
                this.dependencyFrame.setSize((Dimension)val);
            }
        }
        return this.dependencyFrame;
    }

    private void createDependencyFrame() {
        try {
            TierTree tTree = new TierTree(this.vm.getTranscription());
            JTree tree = this.initTree(tTree.getTree());
            this.dependencyFrame = new ClosableFrame(ElanLocale.getString("Tier Dependencies"));
            this.dependencyFrame.getContentPane().add(new JScrollPane(tree));
            if (this.locationX != -1 && this.locationY != -1 && this.sizeWidth != -1 && this.sizeHeight != -1) {
                this.dependencyFrame.setLocation(this.locationX, this.locationY);
                this.dependencyFrame.setSize(this.sizeWidth, this.sizeHeight);
            }
            if (this.dependencyFrame.getHeight() < 100 || this.dependencyFrame.getWidth() < 133) {
                this.dependencyFrame.setSize(133, 200);
            }
            this.addCloseActions();
            this.updateLocale();
        }
        catch (Exception ex) {
            System.out.println("Couldn't create dependencyFrame.");
        }
    }

    private JTree initTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        return tree;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.dependencyFrame != null) {
            this.dependencyFrame.setTitle(ElanLocale.getString("Menu.View.DependenciesDialog"));
            this.dependencyFrame.repaint();
        }
    }

    protected void addCloseActions() {
        if (this.dependencyFrame != null) {
            this.dependencyFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TierDependenciesCA.this.vm.getTranscription().removeACMEditListener(TierDependenciesCA.this);
                    Point p = TierDependenciesCA.this.dependencyFrame.getLocationOnScreen();
                    Dimension d = TierDependenciesCA.this.dependencyFrame.getSize();
                    Preferences.set("DependenciesFrame.Location", p, null, false, false);
                    Preferences.set("DependenciesFrame.Size", d, null, false, false);
                }
            });
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 0: 
            case 1: 
            case 2: {
                if (this.dependencyFrame == null) break;
                boolean bVisible = this.dependencyFrame.isVisible();
                this.locationX = (int)this.dependencyFrame.getLocation().getX();
                this.locationY = (int)this.dependencyFrame.getLocation().getY();
                this.sizeWidth = (int)this.dependencyFrame.getSize().getWidth();
                this.sizeHeight = (int)this.dependencyFrame.getSize().getHeight();
                this.dependencyFrame.dispose();
                this.createDependencyFrame();
                if (this.command == null || !bVisible) break;
                this.command.execute(this.getReceiver(), this.getArguments());
            }
        }
    }
}

