/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SplitAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private AnnotationDataRecord annotationRecord;
    private Transcription transcription;
    long splitTime;
    private boolean annotationsSplit = false;

    public SplitAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        AlignableAnnotation annotation = null;
        if (arguments[0] instanceof AlignableAnnotation) {
            annotation = (AlignableAnnotation)arguments[0];
        }
        if (annotation != null) {
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            this.splitTime = arguments.length > 1 && arguments[1] != null ? (Long)arguments[1] : (begin + end) / 2L;
        }
        this.splitAnnotation(annotation);
        if (this.annotationsSplit && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.SPLIT_ANNOTATION, new String[0]);
        }
    }

    public void splitAnnotation(AlignableAnnotation annotation) {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.setWaitCursor(true);
        ((TranscriptionImpl)this.transcription).setNotifying(false);
        if (annotation != null) {
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            TierImpl tier = (TierImpl)annotation.getTier();
            String value = annotation.getValue();
            this.annotationRecord = new AnnotationDataRecord(annotation);
            if (tier.isTimeAlignable() && !tier.hasParentTier()) {
                ArrayList childAnnotations = annotation.getParentListeners();
                annotation.updateTimeInterval(begin, this.splitTime);
                Annotation ann = tier.createAnnotation(this.splitTime, end);
                this.annotationsSplit = true;
                if (ann != null) {
                    ann.setValue(value);
                }
                if (childAnnotations != null) {
                    for (int j = 0; j < childAnnotations.size(); ++j) {
                        value = ((AbstractAnnotation)childAnnotations.get(j)).getValue();
                        long time = (this.splitTime + end) / 2L;
                        ann = ((TierImpl)((AbstractAnnotation)childAnnotations.get(j)).getTier()).createAnnotation(time, time);
                        if (ann == null) continue;
                        ann.setValue(value);
                    }
                }
            }
        }
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
        ((TranscriptionImpl)this.transcription).setNotifying(true);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        this.setWaitCursor(true);
        AlignableAnnotation ann = null;
        if (this.annotationRecord != null) {
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName());
            if (tier != null) {
                tier.removeAnnotation(tier.getAnnotationAtTime(this.splitTime));
                ann = (AlignableAnnotation)tier.getAnnotationAtTime(this.annotationRecord.getBeginTime());
                if (ann != null) {
                    ann.updateTimeInterval(this.annotationRecord.getBeginTime(), this.annotationRecord.getEndTime());
                }
            }
            this.annotationsSplit = false;
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.SPLIT_ANNOTATION);
            }
        }
        this.setWaitCursor(false);
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public void redo() {
        if (this.annotationRecord != null) {
            TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName());
            if (tier != null) {
                AlignableAnnotation ann = (AlignableAnnotation)tier.getAnnotationAtTime(this.annotationRecord.getBeginTime());
                this.splitAnnotation(ann);
            }
            if (this.annotationsSplit && MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.SPLIT_ANNOTATION);
            }
        }
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

