/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ShiftAnnotationsDialog;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ShiftAnnotationsLROfDlgCommand
implements Command {
    private String commandName;

    public ShiftAnnotationsLROfDlgCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl transcription = (TranscriptionImpl)receiver;
        if (arguments != null) {
            Long bt = (Long)arguments[0];
            Long et = (Long)arguments[1];
            Vector rootTiers = transcription.getTopTiers();
            TierImpl tier = null;
            long min = Long.MIN_VALUE;
            long max = Long.MAX_VALUE;
            for (int i = 0; i < rootTiers.size(); ++i) {
                AlignableAnnotation beforeAnn = null;
                AlignableAnnotation afterAnn = null;
                AlignableAnnotation firstIn = null;
                AlignableAnnotation lastIn = null;
                tier = (TierImpl)rootTiers.get(i);
                if (tier.hasParentTier() || !tier.isTimeAlignable()) continue;
                Vector annos = tier.getAnnotations();
                for (AlignableAnnotation ann : annos) {
                    if (ann.getEnd().getTime() <= bt || ann.getBegin().getTime() < bt && ann.getEnd().getTime() < et) {
                        beforeAnn = ann;
                        continue;
                    }
                    if (ann.getBegin().getTime() <= bt && ann.getEnd().getTime() > et || ann.getBegin().getTime() < bt && ann.getEnd().getTime() >= et) break;
                    if (ann.getBegin().getTime() >= et || ann.getBegin().getTime() > bt && ann.getEnd().getTime() > et) {
                        afterAnn = ann;
                        break;
                    }
                    if (firstIn == null) {
                        firstIn = ann;
                    }
                    lastIn = ann;
                }
                if (firstIn == null) continue;
                min = beforeAnn != null ? Math.max(min, beforeAnn.getEnd().getTime() - firstIn.getBegin().getTime()) : Math.max(min, -firstIn.getBegin().getTime());
                max = afterAnn != null ? Math.min(max, afterAnn.getBegin().getTime() - lastIn.getEnd().getTime()) : Math.min(max, Integer.MAX_VALUE);
            }
            if (min == 0L && max == 0L) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), ElanLocale.getString("ShiftAllDialog.Warn4"), ElanLocale.getString("Message.Warning"), 2);
                return;
            }
            long shiftValue = 0L;
            ShiftAnnotationsDialog dlg = new ShiftAnnotationsDialog(transcription, min, max);
            dlg.setVisible(true);
            shiftValue = dlg.getValue();
            if (shiftValue != 0L) {
                Command com = ELANCommandFactory.createCommand(transcription, "CommandActions.ShiftAnnotationsLROf");
                com.execute(transcription, new Object[]{bt, et, new Long(shiftValue)});
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

