/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class RemoveAnnotationsOrValuesCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    List tierNames;
    boolean annotations;
    boolean annotationValues;
    boolean allAnnotations;
    boolean annotationWithVal;
    String value;
    private ArrayList records;
    private HashMap<String, List<DefaultMutableTreeNode>> delAnnRecordsMap;

    public RemoveAnnotationsOrValuesCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.annotationValues) {
            String name = null;
            TierImpl tier = null;
            if (this.tierNames != null) {
                if (this.records != null) {
                    Annotation ann = null;
                    AnnotationValuesRecord record = null;
                    for (int i = 0; i < this.records.size(); ++i) {
                        record = (AnnotationValuesRecord)this.records.get(i);
                        name = record.getTierName();
                        if (tier == null || !tier.getName().equals(name)) {
                            tier = (TierImpl)this.transcription.getTierWithId(name);
                        }
                        if (tier != null) {
                            ann = tier.getAnnotationAtTime(record.getBeginTime());
                            if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                                ann.setValue(record.getValue());
                                continue;
                            }
                            LOG.warning("The annotation could not be found for undo");
                            continue;
                        }
                        LOG.warning("The tier could not be found: " + name);
                    }
                } else {
                    LOG.info("No annotation records have been stored for undo.");
                }
            } else {
                LOG.warning("No tier names have been stored.");
            }
        } else if (this.annotations && this.transcription != null && this.delAnnRecordsMap != null) {
            ArrayList anns = new ArrayList();
            List<Object> delAnnRecords = new ArrayList();
            String name = null;
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = (String)this.tierNames.get(i);
                delAnnRecords = this.delAnnRecordsMap.get(name);
                if (delAnnRecords == null || name == null) continue;
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier == null) {
                    ClientLogger.LOG.warning("The tier could not be found: " + name);
                    return;
                }
                int curPropMode = 0;
                curPropMode = this.transcription.getTimeChangePropagationMode();
                if (curPropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                this.transcription.setNotifying(false);
                this.setWaitCursor(true);
                if (this.allAnnotations) {
                    if (!tier.hasParentTier()) {
                        for (DefaultMutableTreeNode defaultMutableTreeNode : delAnnRecords) {
                            AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                        }
                    } else if (!this.tierNames.contains(tier.getParentTier().getName())) {
                        AnnotationRecreator.createAnnotationsSequentially(this.transcription, (ArrayList)delAnnRecords, true);
                    }
                } else if (this.annotationWithVal) {
                    for (DefaultMutableTreeNode defaultMutableTreeNode : delAnnRecords) {
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, defaultMutableTreeNode, true);
                    }
                }
                this.transcription.setTimeChangePropagationMode(curPropMode);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void redo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.annotationValues) {
            String name = null;
            TierImpl tier = null;
            if (this.tierNames != null) {
                if (this.records != null) {
                    Annotation ann = null;
                    AnnotationValuesRecord record = null;
                    for (int i = 0; i < this.records.size(); ++i) {
                        record = (AnnotationValuesRecord)this.records.get(i);
                        name = record.getTierName();
                        if (tier == null || !tier.getName().equals(name)) {
                            tier = (TierImpl)this.transcription.getTierWithId(name);
                        }
                        if (tier != null) {
                            ann = tier.getAnnotationAtTime(record.getBeginTime());
                            if (ann != null && ann.getEndTimeBoundary() == record.getEndTime()) {
                                ann.setValue("");
                                continue;
                            }
                            LOG.warning("The annotation could not be found for redo");
                            continue;
                        }
                        LOG.warning("Could not find tier for redo: " + name);
                    }
                } else {
                    LOG.info("No annotation records have been stored for undo.");
                }
            } else {
                LOG.warning("No tier names have been stored.");
            }
        } else if (this.annotations) {
            this.deleteAnnotations();
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.tierNames = (List)arguments[0];
        this.annotations = (Boolean)arguments[1];
        this.annotationValues = (Boolean)arguments[2];
        this.allAnnotations = (Boolean)arguments[3];
        this.annotationWithVal = (Boolean)arguments[4];
        this.value = (String)arguments[5];
        if (this.tierNames == null || this.tierNames.size() == 0) {
            LOG.warning("No tier selected.");
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
            return;
        }
        if (this.annotationWithVal && (this.value == null || this.value.length() == 0)) {
            LOG.warning("Search value is empty.");
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
            return;
        }
        if (this.annotations) {
            this.deleteAnnotations();
        } else if (this.annotationValues) {
            this.deleteAnnotationValues();
        }
    }

    private HashMap<String, List<AbstractAnnotation>> getAnnotationsToBeDeleted() {
        String name;
        ArrayList<AbstractAnnotation> anns;
        int i;
        TierImpl tier = null;
        HashMap<String, List<AbstractAnnotation>> annsMap = new HashMap<String, List<AbstractAnnotation>>();
        if (this.allAnnotations) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                anns = new ArrayList<AbstractAnnotation>();
                name = (String)this.tierNames.get(i);
                tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier != null) {
                    anns.addAll(tier.getAnnotations());
                } else {
                    LOG.warning("The tier " + name + " does not exist.");
                }
                annsMap.put(name, anns);
            }
        }
        if (this.annotationWithVal) {
            tier = null;
            name = null;
            for (i = 0; i < this.tierNames.size(); ++i) {
                anns = new ArrayList();
                name = (String)this.tierNames.get(i);
                tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier != null) {
                    Vector annotations = tier.getAnnotations();
                    for (int j = 0; j < annotations.size(); ++j) {
                        AbstractAnnotation annotation = (AbstractAnnotation)annotations.get(j);
                        if (annotation.getValue().compareToIgnoreCase(this.value) != 0) continue;
                        anns.add(annotation);
                    }
                } else {
                    LOG.warning("The tier " + name + " does not exist.");
                }
                annsMap.put(name, anns);
            }
        }
        return annsMap;
    }

    /*
     * Could not resolve type clashes
     */
    private void deleteAnnotations() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        this.delAnnRecordsMap = new HashMap();
        List<Object> anns = new ArrayList();
        ArrayList<DefaultMutableTreeNode> delAnnRecords = new ArrayList<DefaultMutableTreeNode>();
        HashMap<String, List<AbstractAnnotation>> annsMap = this.getAnnotationsToBeDeleted();
        String name = null;
        AnnotationValuesRecord record = null;
        if (this.allAnnotations) {
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = (String)this.tierNames.get(i);
                anns = annsMap.get(name);
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier.hasParentTier() && !this.tierNames.contains(tier.getParentTier().getName())) {
                    tier = (TierImpl)this.transcription.getTierWithId(name);
                    Vector annotations = ((TierImpl)tier.getParentTier()).getAnnotations();
                    for (int j = 0; j < annotations.size(); ++j) {
                        delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)annotations.elementAt(j)));
                    }
                }
                if (anns == null || anns.size() <= 0) continue;
                for (AbstractAnnotation ann : anns) {
                    tier = (TierImpl)ann.getTier();
                    if ((ann = (AbstractAnnotation)tier.getAnnotationAtTime(((record = new AnnotationValuesRecord(ann)).getBeginTime() + record.getEndTime()) / 2L)) == null) continue;
                    if (!tier.hasParentTier()) {
                        delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    }
                    tier.removeAnnotation(ann);
                }
                this.delAnnRecordsMap.put(name, delAnnRecords);
            }
        } else if (this.annotationWithVal) {
            for (int i = 0; i < this.tierNames.size(); ++i) {
                name = (String)this.tierNames.get(i);
                anns = annsMap.get(name);
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(name);
                if (anns == null || anns.size() <= 0) continue;
                for (AbstractAnnotation ann : anns) {
                    tier = (TierImpl)ann.getTier();
                    if ((ann = (AbstractAnnotation)tier.getAnnotationAtTime(((record = new AnnotationValuesRecord(ann)).getBeginTime() + record.getEndTime()) / 2L)) == null) continue;
                    delAnnRecords.add(AnnotationRecreator.createTreeForAnnotation(ann));
                    tier.removeAnnotation(ann);
                }
                this.delAnnRecordsMap.put(name, delAnnRecords);
            }
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void deleteAnnotationValues() {
        String name;
        int i;
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        TierImpl tier = null;
        ArrayList<AbstractAnnotation> anns = new ArrayList<AbstractAnnotation>();
        if (this.allAnnotations) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                name = (String)this.tierNames.get(i);
                tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier != null) {
                    anns.addAll(tier.getAnnotations());
                    continue;
                }
                LOG.warning("The tier " + name + " does not exist.");
            }
        } else if (this.annotationWithVal) {
            for (i = 0; i < this.tierNames.size(); ++i) {
                name = (String)this.tierNames.get(i);
                tier = (TierImpl)this.transcription.getTierWithId(name);
                if (tier != null) {
                    Vector annotations = tier.getAnnotations();
                    for (int j = 0; j < annotations.size(); ++j) {
                        AbstractAnnotation annotation = (AbstractAnnotation)annotations.get(j);
                        if (annotation.getValue().compareToIgnoreCase(this.value) != 0) continue;
                        anns.add(annotation);
                    }
                    continue;
                }
                LOG.warning("The tier " + name + " does not exist.");
            }
        }
        this.records = new ArrayList(anns.size());
        Annotation ann = null;
        AnnotationValuesRecord record = null;
        for (int i2 = 0; i2 < anns.size(); ++i2) {
            ann = (Annotation)anns.get(i2);
            record = new AnnotationValuesRecord(ann);
            this.records.add(record);
            ann.setValue("");
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

