/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class RemoveAnnotationValueCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private AnnotationDataRecord annotationRecord;
    private String oldValue;

    public RemoveAnnotationValueCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setValue(this.oldValue);
        }
    }

    @Override
    public void redo() {
        TierImpl tier;
        Annotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.setValue("");
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Annotation annotation = (Annotation)receiver;
        if (annotation != null) {
            this.transcription = annotation.getTier().getParent();
        }
        this.annotationRecord = new AnnotationDataRecord(annotation);
        this.oldValue = annotation.getValue();
        annotation.setValue("");
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

