/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Vector;
import mpi.eudico.client.annotator.commands.NewAnnotationCommand;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class NewAnnotationRecursiveCommand
extends NewAnnotationCommand {
    private TierImpl tier;
    private int numberofRecAnnotations;

    public NewAnnotationRecursiveCommand(String name) {
        super(name);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        super.execute(receiver, arguments);
        this.tier = (TierImpl)receiver;
        this.createNewAnnotaionsRecursively();
        if (this.numberofRecAnnotations > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.RECURSIVE_ANNOTATIONS, "number of annotations created recursively : " + this.numberofRecAnnotations);
        }
    }

    private void createNewAnnotaionsRecursively() {
        Vector dependentTiers = this.tier.getDependentTiers();
        if (dependentTiers != null && dependentTiers.size() > 0) {
            for (int i = 0; i < dependentTiers.size(); ++i) {
                TierImpl currentChildTier = (TierImpl)dependentTiers.elementAt(i);
                if (currentChildTier.isTimeAlignable()) {
                    currentChildTier.createAnnotation(this.newAnnBegin, this.newAnnEnd);
                } else {
                    long time = (this.newAnnBegin + this.newAnnEnd) / 2L;
                    currentChildTier.createAnnotation(time, time);
                }
                ++this.numberofRecAnnotations;
            }
            ((TranscriptionImpl)this.tier.getParent()).notifyListeners(this.tier, 3, this.tier.getAnnotationAtTime(this.newAnnBegin));
        }
    }

    @Override
    public void redo() {
        super.redo();
        this.createNewAnnotaionsRecursively();
        if (this.numberofRecAnnotations > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.RECURSIVE_ANNOTATIONS);
        }
    }

    @Override
    public void undo() {
        super.undo();
        this.numberofRecAnnotations = 0;
        if (this.numberofRecAnnotations > 0 && MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.RECURSIVE_ANNOTATIONS);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

