/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.annotator.util.TimeShiftRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class NewAnnotationCommand
implements UndoableCommand {
    private String commandName;
    TierImpl tier;
    TierImpl rootTier;
    int timePropMode;
    TranscriptionImpl transcription;
    Annotation newAnnotation;
    long begin;
    long end;
    protected long newAnnBegin;
    protected long newAnnEnd;
    ArrayList removedAnnotations;
    ArrayList changedAnnotations;
    private int leftOffset;
    private int rightOffset;

    public NewAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.tier != null && this.newAnnotation != null) {
            this.setWaitCursor(true);
            Annotation aa = this.tier.getAnnotationAtTime((this.newAnnBegin + this.newAnnEnd) / 2L);
            if (aa != null) {
                this.tier.removeAnnotation(aa);
                if (MonitoringLogger.isInitiated()) {
                    MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.NEW_ANNOTATION);
                }
            }
            if (this.tier.isTimeAlignable()) {
                this.transcription.setNotifying(false);
                this.restoreInUndo();
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.tier != null) {
            this.setWaitCursor(true);
            this.transcription.setNotifying(false);
            this.newAnnotation = this.tier.createAnnotation(this.begin, this.end);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.NEW_ANNOTATION);
            }
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.begin = (Long)arguments[0];
        this.end = (Long)arguments[1];
        this.transcription = (TranscriptionImpl)this.tier.getParent();
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        if (vm.getMasterMediaPlayer().isPlaying() && ELANCommandFactory.getLayoutManager(this.transcription).getMode() == 1) {
            vm.getMasterMediaPlayer().stop();
        }
        Command c = ELANCommandFactory.createCommand(this.transcription, "Commands.ActiveAnnotation");
        c.execute(vm, new Object[]{null});
        this.setWaitCursor(true);
        if (!this.tier.isTimeAlignable()) {
            this.newAnnotation();
        } else {
            this.adjustTimes();
            this.changedAnnotations = new ArrayList();
            this.removedAnnotations = new ArrayList();
            if (this.tier.hasParentTier()) {
                this.rootTier = this.tier.getRootTier();
            }
            this.timePropMode = this.transcription.getTimeChangePropagationMode();
            this.storeForUndo();
            this.newAnnotation();
        }
        Object pref = Preferences.get("ClearSelectionAfterCreation", null);
        if (pref instanceof Boolean && ((Boolean)pref).booleanValue()) {
            if (vm.getMediaPlayerController().getSelectionMode()) {
                vm.getSelection().setSelection(vm.getMediaPlayerController().getMediaTime(), vm.getMediaPlayerController().getMediaTime());
            } else {
                vm.getSelection().setSelection(0L, 0L);
            }
        }
        this.setWaitCursor(false);
    }

    protected void adjustTimes() {
        boolean snapAnnotations = false;
        boolean stickToVideoFrames = false;
        Object val = Preferences.get("SnapAnnotations", null);
        if (val instanceof Boolean) {
            snapAnnotations = (Boolean)val;
        }
        if ((val = Preferences.get("StickAnnotationsWithVideoFrames", null)) instanceof Boolean) {
            stickToVideoFrames = (Boolean)val;
        }
        if (stickToVideoFrames && this.tier.isTimeAlignable() && (!this.tier.hasParentTier() || this.tier.getLinguisticType().getConstraints().getStereoType() == 1)) {
            this.begin = this.getStartPointOfFrame(this.begin);
            this.end = this.getEndPointOfFrame(this.end);
        }
        if (snapAnnotations && this.tier.isTimeAlignable() && (!this.tier.hasParentTier() || this.tier.getLinguisticType().getConstraints().getStereoType() == 1)) {
            AbstractAnnotation annAfter;
            long firstDiff;
            long snapValue = 0L;
            val = Preferences.get("SnapAnnotationsValue", null);
            if (val instanceof Long && (snapValue = ((Long)val).longValue()) == 0L) {
                return;
            }
            long secDiff = firstDiff = Long.MAX_VALUE;
            AbstractAnnotation annBefore = (AbstractAnnotation)this.tier.getAnnotationAtTime(this.begin);
            if (annBefore == null) {
                annBefore = (AbstractAnnotation)this.tier.getAnnotationBefore(this.begin);
            }
            if ((annAfter = (AbstractAnnotation)this.tier.getAnnotationAtTime(this.end)) == null) {
                annAfter = (AbstractAnnotation)this.tier.getAnnotationAfter(this.end);
            }
            if (annBefore != null && (firstDiff = this.begin - annBefore.getEndTimeBoundary()) != 0L && firstDiff >= -snapValue && firstDiff <= snapValue) {
                this.begin -= firstDiff;
            }
            if (annAfter != null && (secDiff = annAfter.getBeginTimeBoundary() - this.end) != 0L && secDiff >= -snapValue && secDiff <= snapValue) {
                this.end += secDiff;
            }
        }
    }

    protected void storeForUndo() {
        switch (this.timePropMode) {
            case 0: {
                this.storeNormal();
                break;
            }
            case 1: {
                this.storeBulldozer();
                break;
            }
            case 2: {
                this.storeShift();
            }
        }
    }

    protected void restoreInUndo() {
        switch (this.timePropMode) {
            case 0: {
                this.restoreNormal();
                break;
            }
            case 1: {
                this.restoreBulldozer();
                break;
            }
            case 2: {
                this.restoreShift();
            }
        }
    }

    void newAnnotation() {
        this.newAnnotation = this.tier.createAnnotation(this.begin, this.end);
        if (this.newAnnotation != null) {
            this.newAnnBegin = this.newAnnotation.getBeginTimeBoundary();
            this.newAnnEnd = this.newAnnotation.getEndTimeBoundary();
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.NEW_ANNOTATION, this.tier.getName(), Long.toString(this.begin), Long.toString(this.end));
            }
        } else if (this.tier.isTimeAlignable() && this.tier.getParentTier() != null) {
            AlignableAnnotation aa = (AlignableAnnotation)((TierImpl)this.tier.getParentTier()).getAnnotationAtTime((this.begin + this.end) / 2L);
            if (aa == null) {
                return;
            }
            if (!aa.getBegin().isTimeAligned() || !aa.getEnd().isTimeAligned()) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("Message.UnalignedParentAnnotation"), ElanLocale.getString("Message.Error"), 0);
            }
        } else if (this.tier.getLinguisticType().getConstraints() != null && this.tier.getLinguisticType().getConstraints().getStereoType() == 4) {
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("Message.ExistingAnnotation"), ElanLocale.getString("Message.Error"), 0);
        }
    }

    public long getStartPointOfFrame(long time) {
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        long milliSecondsPerSample = vm.getMasterMediaPlayer().getMilliSecondsPerSample();
        long curFrame = time / milliSecondsPerSample;
        curFrame = curFrame > 0L ? (curFrame *= milliSecondsPerSample) : 0L;
        return curFrame;
    }

    public long getEndPointOfFrame(long time) {
        ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
        long milliSecondsPerSample = vm.getMasterMediaPlayer().getMilliSecondsPerSample();
        long curFrame = time / milliSecondsPerSample;
        curFrame = curFrame * milliSecondsPerSample != time ? (curFrame + 1L) * milliSecondsPerSample : (curFrame *= milliSecondsPerSample);
        return curFrame;
    }

    private void storeNormal() {
        if (this.rootTier != null) {
            Vector possiblyEffectedAnn = this.rootTier.getOverlappingAnnotations(this.begin, this.end);
            for (int i = 0; i < possiblyEffectedAnn.size(); ++i) {
                AbstractAnnotation aa = (AbstractAnnotation)possiblyEffectedAnn.get(i);
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
            }
        } else {
            Vector effectedAnn = this.tier.getOverlappingAnnotations(this.begin, this.end);
            for (int i = 0; i < effectedAnn.size(); ++i) {
                AbstractAnnotation aa = (AbstractAnnotation)effectedAnn.get(i);
                if (aa.getBeginTimeBoundary() < this.begin) {
                    this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
                    continue;
                }
                if (aa.getEndTimeBoundary() > this.end) {
                    this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
                    continue;
                }
                this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
            }
        }
    }

    private void restoreNormal() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            long mid = (this.newAnnBegin + this.newAnnEnd) / 2L;
            DefaultMutableTreeNode node = null;
            AnnotationDataRecord annRecord = null;
            for (int i = 0; i < this.changedAnnotations.size() && ((annRecord = (AnnotationDataRecord)(node = (DefaultMutableTreeNode)this.changedAnnotations.get(i)).getUserObject()).getBeginTime() > mid || annRecord.getEndTime() < mid); ++i) {
            }
            if (node == null) {
                return;
            }
            Annotation rootAnn = this.rootTier.getAnnotationAtTime(mid);
            if (rootAnn != null) {
                this.rootTier.removeAnnotation(rootAnn);
                AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
            }
        } else {
            DefaultMutableTreeNode node;
            int i;
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationDataRecord dataRecord = (AnnotationDataRecord)node.getUserObject();
                    AbstractAnnotation aa = dataRecord.getBeginTime() < this.begin ? (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getBeginTime()) : (AbstractAnnotation)this.tier.getAnnotationAtTime(dataRecord.getEndTime() - 1L);
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                }
            }
            if (this.changedAnnotations.size() > 0) {
                for (i = 0; i < this.changedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.changedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
                }
            }
            if (this.removedAnnotations.size() > 0) {
                for (i = 0; i < this.removedAnnotations.size(); ++i) {
                    node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
                }
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    private void storeBulldozer() {
        if (this.rootTier != null) {
            this.storeNormal();
        } else {
            Vector effectedAnn = this.tier.getOverlappingAnnotations(this.begin, this.end);
            Vector allAnn = this.tier.getAnnotations();
            if (effectedAnn.size() > 0) {
                int dist;
                int i;
                int gapBridged;
                int gapToBridge;
                AbstractAnnotation cur;
                Annotation aa = (Annotation)effectedAnn.get(0);
                int index = allAnn.indexOf(aa);
                if (aa.getBeginTimeBoundary() <= this.begin && aa.getEndTimeBoundary() > this.begin) {
                    this.leftOffset = (int)(this.begin - aa.getEndTimeBoundary());
                    if (this.end <= aa.getEndTimeBoundary()) {
                        this.rightOffset = 0;
                    } else if (effectedAnn.size() >= 2) {
                        aa = (Annotation)effectedAnn.get(1);
                        this.rightOffset = (int)(this.end - aa.getBeginTimeBoundary());
                    }
                } else {
                    this.leftOffset = 0;
                    this.rightOffset = (int)(this.end - aa.getBeginTimeBoundary());
                }
                if (this.leftOffset < 0) {
                    cur = (AbstractAnnotation)allAnn.get(index);
                    gapToBridge = -this.leftOffset;
                    gapBridged = 0;
                    this.changedAnnotations.add(new TimeShiftRecord(cur.getBeginTimeBoundary(), cur.getEndTimeBoundary(), this.leftOffset));
                    this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(cur));
                    for (i = index - 1; i >= 0; --i) {
                        AbstractAnnotation prev = (AbstractAnnotation)allAnn.get(i);
                        dist = (int)(cur.getBeginTimeBoundary() - prev.getEndTimeBoundary());
                        if ((gapBridged += dist) >= gapToBridge) break;
                        this.changedAnnotations.add(new TimeShiftRecord(prev.getBeginTimeBoundary(), prev.getEndTimeBoundary(), -(gapToBridge - gapBridged)));
                        this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(prev));
                        cur = prev;
                    }
                }
                if (this.rightOffset > 0) {
                    AbstractAnnotation next;
                    if (this.leftOffset < 0) {
                        ++index;
                    }
                    cur = (AbstractAnnotation)allAnn.get(index);
                    gapToBridge = this.rightOffset;
                    gapBridged = 0;
                    this.changedAnnotations.add(new TimeShiftRecord(cur.getBeginTimeBoundary(), cur.getEndTimeBoundary(), this.rightOffset));
                    this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(cur));
                    for (i = index + 1; i < allAnn.size() && (gapBridged += (dist = (int)((next = (AbstractAnnotation)allAnn.get(i)).getBeginTimeBoundary() - cur.getEndTimeBoundary()))) < gapToBridge; ++i) {
                        this.changedAnnotations.add(new TimeShiftRecord(next.getBeginTimeBoundary(), next.getEndTimeBoundary(), gapToBridge - gapBridged));
                        this.removedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(next));
                        cur = next;
                    }
                }
            }
        }
    }

    private void restoreBulldozer() {
        if (this.rootTier != null) {
            this.restoreNormal();
        } else {
            Annotation createdAnn;
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            if ((createdAnn = this.tier.getAnnotationAtTime(this.begin)) != null) {
                this.tier.removeAnnotation(createdAnn);
            }
            if (this.changedAnnotations.size() > 0) {
                for (int i = 0; i < this.changedAnnotations.size(); ++i) {
                    TimeShiftRecord tsRecord = (TimeShiftRecord)this.changedAnnotations.get(i);
                    AlignableAnnotation aa = (AlignableAnnotation)this.tier.getAnnotationAtTime(tsRecord.newBegin);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.removedAnnotations.get(i);
                    if (aa == null) continue;
                    this.tier.removeAnnotation(aa);
                    AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
                }
            }
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    private void storeShift() {
        if (this.rootTier != null) {
            this.storeNormal();
        } else {
            AbstractAnnotation aa;
            Vector effectedAnn = this.tier.getOverlappingAnnotations(this.begin, this.end);
            if (effectedAnn.size() > 0 && (aa = (AbstractAnnotation)effectedAnn.get(0)).getBeginTimeBoundary() < this.begin && aa.getEndTimeBoundary() > this.begin) {
                this.changedAnnotations.add(AnnotationRecreator.createTreeForAnnotation(aa));
            }
        }
    }

    private void restoreShift() {
        int curPropMode = 0;
        curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        if (this.rootTier != null) {
            this.transcription.shiftBackward(this.begin, -(this.end - this.begin));
            this.restoreNormal();
        } else {
            AnnotationDataRecord annRecord;
            long begin;
            Annotation aa;
            DefaultMutableTreeNode node = null;
            if (this.changedAnnotations.size() > 0 && (aa = this.tier.getAnnotationAtTime(begin = (annRecord = (AnnotationDataRecord)(node = (DefaultMutableTreeNode)this.changedAnnotations.get(0)).getUserObject()).getBeginTime())) != null) {
                this.tier.removeAnnotation(aa);
            }
            this.transcription.shiftBackward(this.begin, -(this.end - this.begin));
            if (node != null) {
                AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
            }
        }
        this.transcription.setTimeChangePropagationMode(curPropMode);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

