/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.StatisticsAnnotationsMF;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.StatisticsCollectionMF;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;

public class MultipleFileStatisticsCommand
implements Command,
ProcessReporter {
    private String commandName;
    private ArrayList<ProgressListener> listeners;
    private String[] selectedFiles;
    private String[] selectedTiers;
    private List<String> selectedTierList;
    private boolean loadAll = false;
    private StatisticsCollectionMF statsColl;
    private ProcessReport report;
    private StatisticsThread statsThread;

    public MultipleFileStatisticsCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.selectedFiles = (String[])arguments[0];
        this.selectedTiers = (String[])arguments[1];
        this.loadAll = (Boolean)arguments[2];
        this.statsColl = (StatisticsCollectionMF)arguments[3];
        if (this.selectedFiles == null || this.selectedFiles.length == 0) {
            this.report("No files provided for statistics calculation.");
            this.progressInterrupt("Illegal argument: no files provided");
            return;
        }
        this.report("Number of files to process:  " + this.selectedFiles.length);
        if (this.selectedTiers == null || this.selectedTiers.length == 0) {
            this.loadAll = true;
            this.selectedTierList = new ArrayList<String>(0);
            this.report("Tiers to process: all tiers");
        } else {
            this.selectedTierList = new ArrayList<String>(this.selectedTiers.length);
            this.report("Tiers to process: ");
            for (String nm : this.selectedTiers) {
                this.report("\t" + nm);
                this.selectedTierList.add(nm);
            }
        }
        if (this.statsColl == null) {
            this.report("No statistics results object provided.");
            this.progressInterrupt("Illegal argument: statistics collection is null");
            return;
        }
        this.statsThread = new StatisticsThread(this.commandName);
        try {
            this.statsThread.start();
        }
        catch (Exception exc) {
            this.report("An exception occurred while starting the statistics calculation process: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private class StatisticsThread
    extends Thread {
        public StatisticsThread() {
        }

        public StatisticsThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            float perFileProg = 100.0f / (float)MultipleFileStatisticsCommand.this.selectedFiles.length;
            int numInspected = 0;
            int numFailed = 0;
            TranscriptionImpl trans = null;
            TierImpl tier = null;
            AbstractAnnotation aa = null;
            for (int i = 0; i < MultipleFileStatisticsCommand.this.selectedFiles.length; ++i) {
                String path = MultipleFileStatisticsCommand.this.selectedFiles[i];
                File f = new File(path);
                ++numInspected;
                if (!f.exists() || f.isDirectory()) {
                    ++numFailed;
                    MultipleFileStatisticsCommand.this.report("Skipping file: " + f.getAbsolutePath());
                    MultipleFileStatisticsCommand.this.progressUpdate((int)((float)i * perFileProg), "Skipping file: " + f.getAbsolutePath());
                    continue;
                }
                try {
                    trans = new TranscriptionImpl(path);
                    Vector tiers = trans.getTiers();
                    ArrayList<Long> durations = null;
                    ArrayList<String> typeNames = null;
                    int numProcessedTiers = 0;
                    if (MultipleFileStatisticsCommand.this.loadAll) {
                        typeNames = new ArrayList<String>();
                    }
                    for (int j = 0; j < tiers.size(); ++j) {
                        String key;
                        tier = (TierImpl)tiers.get(j);
                        if (!MultipleFileStatisticsCommand.this.loadAll && !MultipleFileStatisticsCommand.this.selectedTierList.contains(tier.getName())) continue;
                        long minDur = Long.MAX_VALUE;
                        long maxDur = 0L;
                        long totalDur = 0L;
                        long latency = Long.MAX_VALUE;
                        durations = new ArrayList<Long>();
                        Vector annotations = tier.getAnnotations();
                        for (int k = 0; k < annotations.size(); ++k) {
                            aa = (AbstractAnnotation)annotations.get(k);
                            long bt = aa.getBeginTimeBoundary();
                            long et = aa.getEndTimeBoundary();
                            long curDur = et - bt;
                            if (curDur < minDur) {
                                minDur = curDur;
                            }
                            if (curDur > maxDur) {
                                maxDur = curDur;
                            }
                            if (bt < latency) {
                                latency = bt;
                            }
                            totalDur += curDur;
                            durations.add(curDur);
                        }
                        MultipleFileStatisticsCommand.this.statsColl.addTier(path, tier, annotations.size(), minDur, maxDur, totalDur, latency, durations);
                        StatisticsAnnotationsMF annMF = MultipleFileStatisticsCommand.this.statsColl.getAnnotationStats(tier.getName());
                        if (annMF == null) {
                            annMF = new StatisticsAnnotationsMF(tier);
                            MultipleFileStatisticsCommand.this.statsColl.addAnnotations(path, tier.getName(), annMF);
                        } else {
                            annMF.addTier(tier);
                        }
                        if (MultipleFileStatisticsCommand.this.loadAll && !typeNames.contains(key = tier.getLinguisticType().getLinguisticTypeName())) {
                            typeNames.add(key);
                        }
                        ++numProcessedTiers;
                    }
                    if (MultipleFileStatisticsCommand.this.loadAll) {
                        Vector types = trans.getLinguisticTypes();
                        for (int t = 0; t < types.size(); ++t) {
                            LinguisticType lt = (LinguisticType)types.get(t);
                            if (typeNames.contains(lt.getLinguisticTypeName())) continue;
                            MultipleFileStatisticsCommand.this.statsColl.addEmptyLinguisticType(path, lt.getLinguisticTypeName());
                        }
                    }
                    MultipleFileStatisticsCommand.this.report("Processed " + numProcessedTiers + " tiers from file: " + path);
                    MultipleFileStatisticsCommand.this.progressUpdate((int)((float)(i + 1) * perFileProg - 1.0f), "Processed file: " + path);
                    continue;
                }
                catch (Exception ex) {
                    ++numFailed;
                    MultipleFileStatisticsCommand.this.report("Can not load file: " + f.getAbsolutePath());
                    MultipleFileStatisticsCommand.this.report("Cause: " + (ex.getMessage() != null ? ex.getMessage() : "Unknown file loading or parsing error..."));
                    MultipleFileStatisticsCommand.this.progressUpdate((int)((float)(i + 1) * perFileProg - 1.0f), "Can not load file: " + f.getAbsolutePath());
                }
            }
            MultipleFileStatisticsCommand.this.report("Processing files completed: ");
            MultipleFileStatisticsCommand.this.report("Number of files inspected:  " + numInspected);
            MultipleFileStatisticsCommand.this.report("Number of files failed:  " + numFailed);
            MultipleFileStatisticsCommand.this.progressComplete("Statistics completed.");
        }
    }
}

