/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.model.ElanSearchEngine;
import mpi.eudico.client.annotator.search.result.model.Replace;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.model.QueryFormulationException;
import mpi.search.content.result.model.ContentResult;

public class MultiFindAndReplaceCommand
implements Command,
ProcessReporter {
    private String commandName;
    private ArrayList<ProgressListener> listeners;
    private File[] searchFiles;
    private String[] selectedTiers;
    private String searchPattern;
    private String replPattern;
    private boolean regExp;
    private boolean caseSens;
    private ReplaceThread frThread = null;
    private ProcessReport report;

    public MultiFindAndReplaceCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.searchFiles = (File[])arguments[0];
        this.selectedTiers = (String[])arguments[1];
        this.searchPattern = (String)arguments[2];
        this.replPattern = (String)arguments[3];
        this.regExp = (Boolean)arguments[4];
        this.caseSens = (Boolean)arguments[5];
        if (this.searchFiles == null || this.searchFiles.length == 0) {
            this.report("No files provided to Find and Replace.");
            this.progressInterrupt("Illegal argument: no files provided");
            return;
        }
        this.report("Number of files to process:  " + this.searchFiles.length);
        if (this.selectedTiers == null || this.selectedTiers.length == 0) {
            this.selectedTiers = new String[]{"Search.Constraint.AllTiers"};
            this.report("Tiers to search: all tiers");
        } else {
            this.report("Tiers to search: ");
            for (String nm : this.selectedTiers) {
                this.report("\t" + nm);
            }
        }
        if (this.searchPattern == null || this.searchPattern.length() == 0 || this.replPattern == null) {
            this.report("Illegal find or replace pattern provided.");
            this.progressInterrupt("Illegal search or replace pattern provided");
            return;
        }
        this.report("Search string:  " + this.searchPattern);
        this.report("Replace string:  " + this.replPattern);
        this.report("Regular expression:  " + this.regExp);
        this.report("Case sensitive:  " + this.caseSens);
        this.report("\n");
        this.frThread = new ReplaceThread(this.getName());
        try {
            this.frThread.start();
        }
        catch (Exception exc) {
            this.report("An exception occurred: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    public void interrupt() {
        if (this.frThread != null) {
            this.frThread.interrupt();
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }

    private class ReplaceThread
    extends Thread {
        private boolean interruptRequested;

        public ReplaceThread() {
            this.interruptRequested = false;
        }

        public ReplaceThread(String name) {
            super(name);
            this.interruptRequested = false;
        }

        @Override
        public void interrupt() {
            this.interruptRequested = true;
        }

        @Override
        public void run() {
            float perFileProg = 100.0f / (float)MultiFindAndReplaceCommand.this.searchFiles.length;
            int numInspected = 0;
            int numFailed = 0;
            int numChanged = 0;
            File f = null;
            TranscriptionImpl trans = null;
            AnchorConstraint constraint = new AnchorConstraint();
            constraint.setCaseSensitive(MultiFindAndReplaceCommand.this.caseSens);
            constraint.setRegEx(MultiFindAndReplaceCommand.this.regExp);
            constraint.setLowerBoundary(Long.MIN_VALUE);
            constraint.setUpperBoundary(Long.MAX_VALUE);
            constraint.setPattern(MultiFindAndReplaceCommand.this.searchPattern);
            constraint.setTierNames(MultiFindAndReplaceCommand.this.selectedTiers);
            constraint.setUnit("Search.Constraint.Inside");
            EAFType type = new EAFType();
            for (int i = 0; i < MultiFindAndReplaceCommand.this.searchFiles.length; ++i) {
                if (this.interruptRequested) {
                    MultiFindAndReplaceCommand.this.report("Search loop interrupted at index:  " + i);
                    this.finalReport(numInspected, numChanged, numFailed);
                    MultiFindAndReplaceCommand.this.progressInterrupt("Operation interrupted...");
                    break;
                }
                f = MultiFindAndReplaceCommand.this.searchFiles[i];
                if (!f.exists() || f.isDirectory()) {
                    ++numFailed;
                    MultiFindAndReplaceCommand.this.report("Skipping file: " + f.getAbsolutePath());
                    MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Skipping file: " + f.getAbsolutePath());
                    continue;
                }
                String path = f.getAbsolutePath();
                path = path.replace('\\', '/');
                try {
                    trans = new TranscriptionImpl(new File(path).getAbsolutePath());
                    trans.setUnchanged();
                    trans.setNotifying(false);
                }
                catch (Exception ex) {
                    ++numFailed;
                    MultiFindAndReplaceCommand.this.report("Can not load file: " + f.getAbsolutePath());
                    MultiFindAndReplaceCommand.this.report("Cause: " + (ex.getMessage() != null ? ex.getMessage() : "Unknown file loading or parsing error..."));
                    MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Can not load file: " + f.getAbsolutePath());
                    continue;
                }
                if (this.interruptRequested) {
                    MultiFindAndReplaceCommand.this.report("Search loop interrupted at index:  " + i);
                    this.finalReport(numInspected, numChanged, numFailed);
                    MultiFindAndReplaceCommand.this.progressInterrupt("Operation interrupted...");
                    break;
                }
                ElanSearchEngine engine = new ElanSearchEngine(null, trans);
                ContentQuery query = new ContentQuery(constraint, type);
                if (MultiFindAndReplaceCommand.this.selectedTiers[0] != "Search.Constraint.AllTiers") {
                    ArrayList<String> validNames = new ArrayList<String>(MultiFindAndReplaceCommand.this.selectedTiers.length);
                    for (String n : MultiFindAndReplaceCommand.this.selectedTiers) {
                        if (trans.getTierWithId(n) == null) continue;
                        validNames.add(n);
                    }
                    if (validNames.size() == 0) {
                        ++numInspected;
                        MultiFindAndReplaceCommand.this.report("None of the selected tiers found \nin file: " + f.getAbsolutePath());
                        MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "None of the tiers in file: " + f.getAbsolutePath());
                        continue;
                    }
                    constraint.setTierNames(validNames.toArray(new String[0]));
                }
                try {
                    engine.performSearch(query);
                    ContentResult result = (ContentResult)query.getResult();
                    int numHits = result.getRealSize();
                    ++numInspected;
                    MultiFindAndReplaceCommand.this.report("Number of hits in " + f.getAbsolutePath() + " :  " + numHits);
                    if (numHits == 0) {
                        MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "No hits in file: " + f.getAbsolutePath());
                        continue;
                    }
                    Replace.execute(result, MultiFindAndReplaceCommand.this.replPattern, trans);
                    if (!this.interruptRequested) {
                        try {
                            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(trans, null, new ArrayList(0), 0);
                            ++numChanged;
                            MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Processed succesfully: " + f.getAbsolutePath());
                            MultiFindAndReplaceCommand.this.report("Saved file successfully: " + f.getAbsolutePath());
                        }
                        catch (IOException ioe) {
                            ++numFailed;
                            MultiFindAndReplaceCommand.this.report("Could not save the file: " + f.getAbsolutePath());
                            MultiFindAndReplaceCommand.this.report("because: " + (ioe.getMessage() != null ? ioe.getMessage() : "unknown cause..."));
                        }
                        continue;
                    }
                    MultiFindAndReplaceCommand.this.report("Search loop interrupted at index:  " + i);
                    this.finalReport(numInspected, numChanged, numFailed);
                    MultiFindAndReplaceCommand.this.progressInterrupt("Operation interrupted...");
                    break;
                }
                catch (PatternSyntaxException pse) {
                    MultiFindAndReplaceCommand.this.report("Pattern exception: " + pse.getDescription());
                    this.finalReport(++numInspected, numChanged, ++numFailed);
                    MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Cannot perform search in file: " + f.getAbsolutePath());
                    MultiFindAndReplaceCommand.this.progressInterrupt("Illegal search pattern, exiting...");
                    break;
                }
                catch (QueryFormulationException qfe) {
                    ++numFailed;
                    ++numInspected;
                    MultiFindAndReplaceCommand.this.report("Query formulation exception: " + qfe.getMessage() + "\nin file: " + f.getAbsolutePath());
                    MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Cannot perform search in file: " + f.getAbsolutePath());
                    continue;
                }
                catch (Exception ex) {
                    ++numFailed;
                    ++numInspected;
                    MultiFindAndReplaceCommand.this.report("Exception while executing query: " + ex.getMessage() + "\nin file: " + f.getAbsolutePath());
                    MultiFindAndReplaceCommand.this.progressUpdate((int)((float)i * perFileProg), "Cannot perform search in file: " + f.getAbsolutePath());
                }
            }
            MultiFindAndReplaceCommand.this.report("Find and replace completed.");
            this.finalReport(numInspected, numChanged, numFailed);
            MultiFindAndReplaceCommand.this.progressComplete("Operation completed, view report");
        }

        private void finalReport(int numIns, int numChan, int numFail) {
            MultiFindAndReplaceCommand.this.report("\nSummary: ");
            MultiFindAndReplaceCommand.this.report("Number of files in domain:  " + MultiFindAndReplaceCommand.this.searchFiles.length);
            MultiFindAndReplaceCommand.this.report("Number of files inspected:  " + numIns);
            MultiFindAndReplaceCommand.this.report("Number of files changed:  " + numChan);
            MultiFindAndReplaceCommand.this.report("Number of files failed:  " + numFail);
        }
    }
}

