/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class MergeCVSCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private ControlledVocabulary conVoc;
    private ControlledVocabulary secConVoc;
    private ArrayList copiedEntries;

    public MergeCVSCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.conVoc != null && this.copiedEntries != null && this.copiedEntries.size() > 0) {
            for (int i = 0; i < this.copiedEntries.size(); ++i) {
                CVEntry entry = (CVEntry)this.copiedEntries.get(i);
                this.conVoc.removeEntry(entry);
            }
        }
    }

    @Override
    public void redo() {
        if (this.conVoc != null && this.copiedEntries != null && this.copiedEntries.size() > 0) {
            for (int i = 0; i < this.copiedEntries.size(); ++i) {
                CVEntry entry = (CVEntry)this.copiedEntries.get(i);
                this.conVoc.addEntry(entry);
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.conVoc = (ControlledVocabulary)arguments[0];
        this.secConVoc = (ControlledVocabulary)arguments[1];
        if (this.transcription.getControlledVocabulary(this.conVoc.getName()) != null && this.secConVoc != null) {
            this.copiedEntries = new ArrayList();
            CVEntry[] first = this.conVoc.getEntriesSortedByAlphabet();
            CVEntry[] second = this.secConVoc.getEntriesSortedByAlphabet();
            block0: for (int i = 0; i < second.length; ++i) {
                for (int j = 0; j < first.length && !first[j].getValue().equals(second[i].getValue()); ++j) {
                    if (j != first.length - 1 && first[j].getValue().compareTo(second[i].getValue()) <= 0) continue;
                    CVEntry nextEntry = new CVEntry(second[i].getValue(), second[i].getDescription());
                    this.copiedEntries.add(nextEntry);
                    this.conVoc.addEntry(nextEntry);
                    continue block0;
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

