/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class ImportLinguisticTypesCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private ArrayList typesAdded = new ArrayList();
    private ArrayList cvsAdded = new ArrayList();

    public ImportLinguisticTypesCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        int i;
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        for (i = 0; i < this.typesAdded.size(); ++i) {
            this.transcription.removeLinguisticType((LinguisticType)this.typesAdded.get(i));
        }
        for (i = 0; i < this.cvsAdded.size(); ++i) {
            this.transcription.removeControlledVocabulary((ControlledVocabulary)this.cvsAdded.get(i));
        }
    }

    @Override
    public void redo() {
        int i;
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        for (i = 0; i < this.cvsAdded.size(); ++i) {
            this.transcription.addControlledVocabulary((ControlledVocabulary)this.cvsAdded.get(i));
        }
        for (i = 0; i < this.typesAdded.size(); ++i) {
            this.transcription.addLinguisticType((LinguisticType)this.typesAdded.get(i));
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        int i;
        ArrayList<ControlledVocabulary> impCVs;
        ArrayList impTypes;
        this.transcription = (TranscriptionImpl)receiver;
        String fileName = (String)arguments[0];
        if (fileName == null) {
            LOG.warning("The filename is null");
            return;
        }
        fileName = FileUtility.pathToURLString(fileName).substring(5);
        try {
            EAFSkeletonParser parser = new EAFSkeletonParser(fileName);
            parser.parse();
            impTypes = parser.getLinguisticTypes();
            ArrayList cvs = parser.getControlledVocabularies();
            impCVs = new ArrayList<ControlledVocabulary>(cvs.size());
            block2: for (int i2 = 0; i2 < impTypes.size(); ++i2) {
                LinguisticType lt = (LinguisticType)impTypes.get(i2);
                if (lt.getControlledVocabylaryName() == null || lt.getControlledVocabylaryName().length() <= 0) continue;
                String cvName = lt.getControlledVocabylaryName();
                for (int j = 0; j < cvs.size(); ++j) {
                    ControlledVocabulary cv = (ControlledVocabulary)cvs.get(j);
                    if (!cv.getName().equals(cvName)) continue;
                    impCVs.add(cv);
                    continue block2;
                }
            }
        }
        catch (ParseException pe) {
            LOG.warning(pe.getMessage());
            pe.printStackTrace();
            return;
        }
        ArrayList currentTypes = new ArrayList(this.transcription.getLinguisticTypes());
        ArrayList currentCvs = new ArrayList(this.transcription.getControlledVocabularies());
        this.addCVsAndTypes(impCVs, impTypes);
        for (i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
            if (currentTypes.contains(this.transcription.getLinguisticTypes().get(i))) continue;
            this.typesAdded.add(this.transcription.getLinguisticTypes().get(i));
        }
        for (i = 0; i < this.transcription.getControlledVocabularies().size(); ++i) {
            if (currentCvs.contains(this.transcription.getControlledVocabularies().get(i))) continue;
            this.cvsAdded.add(this.transcription.getControlledVocabularies().get(i));
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void addCVsAndTypes(ArrayList cvs, ArrayList typesToAdd) {
        int i;
        if (cvs == null) {
            LOG.info("No Controlled Vocabularies to add");
            cvs = new ArrayList(0);
        }
        if (typesToAdd == null) {
            LOG.info("No Linguistic Types to add.");
            return;
        }
        HashMap<String, ControlledVocabulary> renamedCVS = new HashMap<String, ControlledVocabulary>(5);
        ControlledVocabulary cv2 = null;
        for (i = 0; i < cvs.size(); ++i) {
            ControlledVocabulary cv = (ControlledVocabulary)cvs.get(i);
            cv2 = this.transcription.getControlledVocabulary(cv.getName());
            if (cv2 == null) {
                this.transcription.addControlledVocabulary(cv);
                LOG.info("Added Controlled Vocabulary: " + cv.getName());
                continue;
            }
            if (cv.equals(cv2)) continue;
            String newCVName = cv.getName() + "-cp";
            int c = 1;
            while (this.transcription.getControlledVocabulary(newCVName + c) != null) {
                ++c;
            }
            newCVName = newCVName + c;
            LOG.info("Renamed Controlled Vocabulary: " + cv.getName() + " to " + newCVName);
            renamedCVS.put(cv.getName(), cv);
            cv.setName(newCVName);
            this.transcription.addControlledVocabulary(cv);
            LOG.info("Added Controlled Vocabulary: " + cv.getName());
        }
        for (i = 0; i < typesToAdd.size(); ++i) {
            LinguisticType lt = (LinguisticType)typesToAdd.get(i);
            String typeName = lt.getLinguisticTypeName();
            if (lt.isUsingControlledVocabulary() && renamedCVS.containsKey(lt.getControlledVocabylaryName())) {
                cv2 = (ControlledVocabulary)renamedCVS.get(lt.getControlledVocabylaryName());
                lt.setControlledVocabularyName(cv2.getName());
            }
            if (this.transcription.getLinguisticTypeByName(typeName) != null) {
                LOG.warning("Transcription already contains a Linguistic Type named: " + typeName);
                continue;
            }
            this.transcription.addLinguisticType(lt);
            LOG.info("Added Linguistic Type: " + typeName);
        }
    }
}

