/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.IOException;
import java.util.Vector;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class ExportMediaCommand
implements Command {
    private String commandName;

    public ExportMediaCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 viewerManager = (ViewerManager2)arguments[0];
        if (viewerManager != null) {
            Selection selection;
            String executable = "M2-edit-cl";
            if (arguments.length > 1) {
                executable = (String)arguments[1];
            }
            if ((selection = viewerManager.getSelection()) != null) {
                FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(viewerManager.getTranscription()));
                chooser.createAndShowFileDialog(null, 1, null, "MediaDir");
                if (chooser.getSelectedFile() != null) {
                    try {
                        String saveFileName = chooser.getSelectedFile().getAbsolutePath();
                        if (!saveFileName.toLowerCase().endsWith(".mpg") && !saveFileName.toLowerCase().endsWith(".mpeg")) {
                            saveFileName = saveFileName + ".mpg";
                        }
                        new ClipThread(viewerManager, saveFileName, executable).start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private class ClipThread
    extends Thread {
        ViewerManager2 viewerManager;
        String saveFileName;
        String executable = "M2-edit-cl";

        public ClipThread(ViewerManager2 viewerManager, String saveFileName, String exName) {
            this.viewerManager = viewerManager;
            this.saveFileName = saveFileName;
            if (exName != null) {
                this.executable = exName;
            }
        }

        @Override
        public void run() {
            if (this.viewerManager == null || this.saveFileName == null) {
                return;
            }
            ElanMediaPlayer player = this.viewerManager.getMasterMediaPlayer();
            long offset = player.getOffset();
            Selection selection = this.viewerManager.getSelection();
            long frameDuration = player.getMilliSecondsPerSample();
            long beginFrame = (offset + selection.getBeginTime()) / frameDuration;
            long endFrame = (long)Math.ceil(((double)offset + (double)selection.getEndTime()) / (double)frameDuration);
            String sourceFileName = player.getMediaDescriptor().mediaURL.substring(5);
            if (sourceFileName.startsWith("///")) {
                sourceFileName = sourceFileName.substring(3);
            } else {
                sourceFileName.replace('/', '\\');
            }
            String[] command = new String[]{this.executable, "/in:" + beginFrame, "/out:" + endFrame, sourceFileName, this.saveFileName};
            ClientLogger.LOG.info("Clip command: " + command[0] + " " + command[1] + " " + command[2] + " " + command[3] + " " + command[4]);
            try {
                Process pr = Runtime.getRuntime().exec(command);
                int exit = pr.waitFor();
                if (exit != 0) {
                    ClientLogger.LOG.warning("Clipping exited abnormally: " + exit);
                }
                ClientLogger.LOG.info("exported clip:" + this.saveFileName);
            }
            catch (InterruptedException ie) {
                ClientLogger.LOG.warning("Clip error: " + ie.getMessage());
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Clip error: " + ioe.getMessage());
            }
            Vector slavePlayers = this.viewerManager.getSlaveMediaPlayers();
            for (int i = 0; i < slavePlayers.size(); ++i) {
                ElanMediaPlayer pl = (ElanMediaPlayer)slavePlayers.get(i);
                MediaDescriptor md = pl.getMediaDescriptor();
                offset = pl.getOffset();
                if (md == null) continue;
                String sourceName = md.mediaURL.substring(5);
                if (sourceName.startsWith("///")) {
                    sourceName = sourceName.substring(3);
                } else {
                    sourceName.replace('/', '\\');
                }
                int stopIndex = this.saveFileName.lastIndexOf(46);
                String saveName = this.saveFileName.substring(0, stopIndex) + "_" + i + this.saveFileName.substring(stopIndex);
                long frameDur = player.getMilliSecondsPerSample();
                long beginFr = (offset + selection.getBeginTime()) / frameDur;
                long endFr = (long)Math.ceil(((double)offset + (double)selection.getEndTime()) / (double)frameDur);
                String[] comm = new String[]{this.executable, "/in:" + beginFr, "/out:" + endFr, sourceName, saveName};
                try {
                    Process pr = Runtime.getRuntime().exec(comm);
                    int exit = pr.waitFor();
                    if (exit != 0) {
                        ClientLogger.LOG.warning("Clipping exited abnormally: " + exit);
                    }
                    ClientLogger.LOG.info("exported clip:" + saveName);
                    continue;
                }
                catch (InterruptedException ie) {
                    ClientLogger.LOG.warning("Clip export interrupted: " + ie.getMessage());
                    continue;
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Clip export failed: " + ioe.getMessage());
                }
            }
        }
    }
}

