/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.IOException;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ClientLogger;

public class ExportMediaCA
extends CommandAction
implements SelectionListener {
    private boolean available;
    private String executable = "M2-edit-cl";

    public ExportMediaCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.File.Export.Media");
        try {
            Runtime.getRuntime().exec("M2-edit-cl");
            ClientLogger.LOG.info("Found executable version of M2-edit-cl");
            this.available = true;
        }
        catch (IOException e) {
            try {
                Runtime.getRuntime().exec("M2-xcode-cl");
                this.executable = "M2-xcode-cl";
                ClientLogger.LOG.info("Found executable version of M2-xcode-cl");
                this.available = true;
            }
            catch (IOException ee) {
                this.available = false;
                ClientLogger.LOG.info("No media export functionality available");
            }
            catch (Exception ex) {
                this.available = false;
                ClientLogger.LOG.info("No media export functionality available");
            }
        }
        viewerManager.connectListener(this);
        this.setEnabled(this.available);
    }

    public boolean isAvailable() {
        return this.available;
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.File.Export.Media");
    }

    @Override
    protected Object getReceiver() {
        return null;
    }

    @Override
    protected Object[] getArguments() {
        return new Object[]{this.vm, this.executable};
    }

    @Override
    public void updateSelection() {
        if (this.available) {
            if (this.vm.getSelection().getEndTime() > this.vm.getSelection().getBeginTime()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

