/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteTierCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier;
    private Vector depTiers;
    private ArrayList annotationsNodes;
    private Map colorPrefs;
    private Map fontPrefs;
    private TranscriptionImpl transcription;

    public DeleteTierCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.tier != null) {
            Object fontsObj;
            Object colorsObj;
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.transcription.getTierWithId(this.tier.getName()) == null) {
                this.transcription.addTier(this.tier);
            }
            if (this.depTiers != null) {
                for (int i = 0; i < this.depTiers.size(); ++i) {
                    TierImpl deptier = (TierImpl)this.depTiers.get(i);
                    if (this.transcription.getTierWithId(deptier.getName()) != null) continue;
                    this.transcription.addTier(deptier);
                }
            }
            if (this.annotationsNodes.size() > 0) {
                this.transcription.setNotifying(false);
                if (this.tier.hasParentTier()) {
                    AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.annotationsNodes, true);
                } else {
                    for (int i = 0; i < this.annotationsNodes.size(); ++i) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.annotationsNodes.get(i);
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                    }
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
            if (this.colorPrefs != null && (colorsObj = Preferences.get("TierColors", this.transcription)) instanceof Map) {
                Map colors = (Map)colorsObj;
                colors.putAll(this.colorPrefs);
                Preferences.set("TierColors", colors, this.transcription, true);
            }
            if (this.fontPrefs != null && (fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map) {
                Map fonts = (Map)fontsObj;
                fonts.putAll(this.fontPrefs);
                Preferences.set("TierFonts", fonts, this.transcription, true);
            }
        }
    }

    @Override
    public void redo() {
        Object fontsObj;
        Object colorsObj;
        if (this.transcription == null || this.tier == null) {
            return;
        }
        this.transcription.removeTier(this.tier);
        if (this.depTiers != null) {
            for (int i = 0; i < this.depTiers.size(); ++i) {
                this.transcription.removeTier((TierImpl)this.depTiers.get(i));
            }
        }
        if ((colorsObj = Preferences.get("TierColors", this.transcription)) instanceof Map) {
            Map colors = (Map)colorsObj;
            for (int i = 0; i < this.depTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.depTiers.get(i);
                colors.remove(t.getName());
            }
            colors.remove(this.tier.getName());
        }
        if ((fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map) {
            Map fonts = (Map)fontsObj;
            for (int i = 0; i < this.depTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.depTiers.get(i);
                fonts.remove(t.getName());
            }
            fonts.remove(this.tier.getName());
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Object fontsObj;
        if (!(receiver instanceof TranscriptionImpl)) {
            return;
        }
        this.transcription = (TranscriptionImpl)receiver;
        this.tier = (TierImpl)arguments[0];
        if (this.tier == null) {
            return;
        }
        this.depTiers = this.tier.getDependentTiers();
        this.annotationsNodes = new ArrayList();
        Vector annos = this.tier.getAnnotations();
        for (AbstractAnnotation ann : annos) {
            this.annotationsNodes.add(AnnotationRecreator.createTreeForAnnotation(ann));
        }
        if (this.depTiers != null) {
            for (int i = 0; i < this.depTiers.size(); ++i) {
                this.transcription.removeTier((TierImpl)this.depTiers.get(i));
            }
        }
        this.transcription.removeTier(this.tier);
        Object colorsObj = Preferences.get("TierColors", this.transcription);
        if (colorsObj instanceof Map) {
            Object col;
            Map colors = (Map)colorsObj;
            this.colorPrefs = new HashMap(colors.size());
            for (int i = 0; i < this.depTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.depTiers.get(i);
                col = colors.remove(t.getName());
                if (col == null) continue;
                this.colorPrefs.put(t.getName(), col);
            }
            col = colors.remove(this.tier.getName());
            if (col != null) {
                this.colorPrefs.put(this.tier.getName(), col);
            }
        }
        if ((fontsObj = Preferences.get("TierFonts", this.transcription)) instanceof Map) {
            Object fon;
            Map fonts = (Map)fontsObj;
            this.fontPrefs = new HashMap(fonts.size());
            for (int i = 0; i < this.depTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.depTiers.get(i);
                fon = fonts.remove(t.getName());
                if (fon == null) continue;
                this.fontPrefs.put(t.getName(), fon);
            }
            fon = fonts.remove(this.tier.getName());
            if (fon != null) {
                this.fontPrefs.put(this.tier.getName(), fon);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

