/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteAnnotationCommand
implements UndoableCommand {
    private String commandName;
    private AbstractAnnotation annotation;
    private TierImpl tier;
    private DefaultMutableTreeNode annRootNode;
    private TranscriptionImpl transcription;

    public DeleteAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.tier != null && this.annRootNode != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            this.transcription.setNotifying(false);
            AnnotationRecreator.createAnnotationFromTree((TranscriptionImpl)this.tier.getParent(), this.annRootNode, true);
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.DELETE_ANNOTATION);
            }
            this.setWaitCursor(false);
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void redo() {
        if (this.tier != null && this.annRootNode != null) {
            this.setWaitCursor(true);
            AnnotationDataRecord annRecord = (AnnotationDataRecord)this.annRootNode.getUserObject();
            long begin = annRecord.getBeginTime();
            long end = annRecord.getEndTime();
            long mid = (begin + end) / 2L;
            Annotation aa = this.tier.getAnnotationAtTime(mid);
            if (aa != null) {
                this.tier.removeAnnotation(aa);
            }
            if (MonitoringLogger.isInitiated()) {
                MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.REDO, MonitoringLogger.CHANGE_ANNOTATION_TIME);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)arguments[0];
        this.transcription = (TranscriptionImpl)vm.getTranscription();
        this.tier = (TierImpl)receiver;
        this.setWaitCursor(true);
        this.annotation = (AbstractAnnotation)arguments[1];
        if (vm.getActiveAnnotation().getAnnotation() == this.annotation) {
            vm.getActiveAnnotation().setAnnotation(null);
        }
        this.annRootNode = AnnotationRecreator.createTreeForAnnotation(this.annotation);
        this.tier.removeAnnotation(this.annotation);
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.DELETE_ANNOTATION, new String[0]);
        }
        this.setWaitCursor(false);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

