/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateAnnsOnDependentTiersCommand
implements UndoableCommand,
ClientLogger {
    private TranscriptionImpl transcription;
    private String commandName;
    private List<String> emptyAnnTiers;
    private List<String> annWithValTiers;
    private boolean overWrite;
    private HashMap<String, List<AnnotationDataRecord>> createdAnnos;
    private HashMap<String, List<AnnotationDataRecord>> editedAnnos;

    public CreateAnnsOnDependentTiersCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.emptyAnnTiers = (ArrayList)arguments[0];
        this.annWithValTiers = (ArrayList)arguments[1];
        this.overWrite = (Boolean)arguments[2];
        this.createdAnnos = new HashMap();
        this.editedAnnos = new HashMap();
        if (this.emptyAnnTiers != null && this.emptyAnnTiers.size() > 0) {
            this.createEmptyAnnotations();
        }
        if (this.annWithValTiers != null && this.annWithValTiers.size() > 0) {
            this.createAnnotationsWithValue();
        }
    }

    private void createEmptyAnnotations() {
        TierImpl tier;
        int i;
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        int curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        ArrayList tierList = new ArrayList();
        for (i = 0; i < this.emptyAnnTiers.size(); ++i) {
            tier = (TierImpl)this.transcription.getTierWithId(this.emptyAnnTiers.get(i));
            if (tier == null) {
                ClientLogger.LOG.severe(this.emptyAnnTiers.get(i) + "was not found");
                return;
            }
            tierList.add(tier);
        }
        tierList = this.sortTiers(tierList);
        for (i = 0; i < tierList.size(); ++i) {
            tier = (TierImpl)tierList.get(i);
            TierImpl parentTier = (TierImpl)tier.getParentTier();
            Vector annotations = parentTier.getAnnotations();
            ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
            for (int y = 0; y < annotations.size(); ++y) {
                Annotation aa = null;
                AbstractAnnotation ann = (AbstractAnnotation)annotations.get(y);
                if (tier.getAnnotationAtTime(ann.getBeginTimeBoundary()) == null) {
                    if (tier.isTimeAlignable()) {
                        aa = tier.createAnnotation(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                    } else {
                        long time = (ann.getBeginTimeBoundary() + ann.getEndTimeBoundary()) / 2L;
                        aa = tier.createAnnotation(time, time);
                    }
                }
                if (aa == null) continue;
                records.add(new AnnotationDataRecord(aa));
            }
            if (records.size() <= 0) continue;
            this.createdAnnos.put(tier.getName(), records);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void createAnnotationsWithValue() {
        TierImpl tier;
        int i;
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        int curPropMode = this.transcription.getTimeChangePropagationMode();
        if (curPropMode != 0) {
            this.transcription.setTimeChangePropagationMode(0);
        }
        ArrayList tierList = new ArrayList();
        for (i = 0; i < this.annWithValTiers.size(); ++i) {
            tier = (TierImpl)this.transcription.getTierWithId(this.annWithValTiers.get(i));
            if (tier == null) {
                ClientLogger.LOG.severe(this.annWithValTiers.get(i) + "was not found");
                return;
            }
            tierList.add(tier);
        }
        tierList = this.sortTiers(tierList);
        for (i = 0; i < tierList.size(); ++i) {
            tier = (TierImpl)tierList.get(i);
            TierImpl parentTier = (TierImpl)tier.getParentTier();
            Vector annotations = parentTier.getAnnotations();
            ArrayList<AnnotationDataRecord> records = new ArrayList<AnnotationDataRecord>();
            ArrayList<AnnotationDataRecord> valueRecords = new ArrayList<AnnotationDataRecord>();
            for (int y = 0; y < annotations.size(); ++y) {
                Annotation aa = null;
                AbstractAnnotation ann = (AbstractAnnotation)annotations.get(y);
                if (tier.getAnnotationAtTime(ann.getBeginTimeBoundary()) == null) {
                    if (tier.isTimeAlignable()) {
                        aa = tier.createAnnotation(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                    } else {
                        long time = (ann.getBeginTimeBoundary() + ann.getEndTimeBoundary()) / 2L;
                        aa = tier.createAnnotation(time, time);
                    }
                    if (aa == null) continue;
                    aa.setValue(ann.getValue());
                    records.add(new AnnotationDataRecord(aa));
                    continue;
                }
                AnnotationDataRecord record = null;
                aa = tier.getAnnotationAtTime(ann.getBeginTimeBoundary());
                if (aa == null) continue;
                record = new AnnotationDataRecord(aa);
                if (record.getValue() != null && record.getValue().length() > 0) {
                    if (!this.overWrite) continue;
                    aa.setValue(ann.getValue());
                    valueRecords.add(record);
                    continue;
                }
                valueRecords.add(record);
                aa.setValue(ann.getValue());
            }
            if (records.size() > 0) {
                this.createdAnnos.put(tier.getName(), records);
            }
            if (valueRecords.size() <= 0) continue;
            this.editedAnnos.put(tier.getName(), valueRecords);
        }
        this.transcription.setNotifying(true);
        this.setWaitCursor(false);
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    private ArrayList sortTiers(ArrayList tierList) {
        TierImpl tier;
        int i;
        ArrayList<Object> sortedTiers = new ArrayList<Object>();
        HashMap<TierImpl, DefaultMutableTreeNode> nodes = new HashMap<TierImpl, DefaultMutableTreeNode>();
        DefaultMutableTreeNode sortedRootNode = new DefaultMutableTreeNode("Root");
        for (i = 0; i < tierList.size(); ++i) {
            tier = (TierImpl)tierList.get(i);
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(tier);
            nodes.put(tier, n);
        }
        for (i = 0; i < tierList.size(); ++i) {
            tier = (TierImpl)tierList.get(i);
            if (nodes.get(tier.getParentTier()) == null) {
                sortedRootNode.add((DefaultMutableTreeNode)nodes.get(tier));
                continue;
            }
            ((DefaultMutableTreeNode)nodes.get(tier.getParentTier())).add((DefaultMutableTreeNode)nodes.get(tier));
        }
        Enumeration<TreeNode> nodeEnum = sortedRootNode.preorderEnumeration();
        nodeEnum.nextElement();
        while (nodeEnum.hasMoreElements()) {
            DefaultMutableTreeNode nextnode = (DefaultMutableTreeNode)nodeEnum.nextElement();
            sortedTiers.add(nextnode.getUserObject());
        }
        return sortedTiers;
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.transcription != null) {
            if (this.emptyAnnTiers != null || this.annWithValTiers != null) {
                if (this.createdAnnos.size() > 0 || this.editedAnnos.size() > 0) {
                    Annotation ann;
                    AnnotationDataRecord record;
                    int x;
                    List<AnnotationDataRecord> records;
                    TierImpl tier;
                    int i;
                    for (i = 0; i < this.emptyAnnTiers.size(); ++i) {
                        tier = (TierImpl)this.transcription.getTierWithId(this.emptyAnnTiers.get(i));
                        if (tier != null) {
                            records = this.createdAnnos.get(tier.getName());
                            if (records == null) continue;
                            for (x = 0; x < records.size(); ++x) {
                                record = records.get(x);
                                ann = tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                                if (ann != null) {
                                    tier.removeAnnotation(ann);
                                    continue;
                                }
                                LOG.warning("The annotation could not be found for undo");
                            }
                            continue;
                        }
                        LOG.warning("The tier could not be found: " + this.emptyAnnTiers.get(i));
                    }
                    for (i = 0; i < this.annWithValTiers.size(); ++i) {
                        tier = (TierImpl)this.transcription.getTierWithId(this.annWithValTiers.get(i));
                        if (tier != null) {
                            records = this.createdAnnos.get(tier.getName());
                            List<AnnotationDataRecord> valueRecords = this.editedAnnos.get(tier.getName());
                            if (records == null && valueRecords == null) continue;
                            if (records != null) {
                                for (x = 0; x < records.size(); ++x) {
                                    record = records.get(x);
                                    ann = tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                                    if (ann != null) {
                                        tier.removeAnnotation(ann);
                                        continue;
                                    }
                                    LOG.warning("The annotation could not be found for undo");
                                }
                            }
                            if (valueRecords == null) continue;
                            for (x = 0; x < valueRecords.size(); ++x) {
                                record = valueRecords.get(x);
                                ann = tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                                if (ann != null) {
                                    ann.setValue(record.getValue());
                                    continue;
                                }
                                LOG.warning("The annotation could not be found for undo");
                            }
                            continue;
                        }
                        LOG.warning("The tier could not be found: " + this.annWithValTiers.get(i));
                    }
                } else {
                    LOG.info("No annotation records have been stored for undo.");
                }
            } else {
                LOG.warning("No tier names have been stored.");
            }
        }
        this.setWaitCursor(false);
        this.transcription.setNotifying(true);
    }

    @Override
    public void redo() {
        this.setWaitCursor(true);
        this.transcription.setNotifying(false);
        if (this.transcription != null) {
            AnnotationDataRecord record;
            int x;
            List<AnnotationDataRecord> records;
            TierImpl tier;
            int i;
            for (i = 0; i < this.emptyAnnTiers.size(); ++i) {
                tier = (TierImpl)this.transcription.getTierWithId(this.emptyAnnTiers.get(i));
                if (tier == null || (records = this.createdAnnos.get(tier.getName())) == null) continue;
                for (x = 0; x < records.size(); ++x) {
                    record = records.get(x);
                    if (record == null) continue;
                    if (tier.isTimeAlignable()) {
                        tier.createAnnotation(record.getBeginTime(), record.getEndTime());
                        continue;
                    }
                    long time = (record.getBeginTime() + record.getEndTime()) / 2L;
                    tier.createAnnotation(time, time);
                }
            }
            for (i = 0; i < this.annWithValTiers.size(); ++i) {
                Annotation ann;
                tier = (TierImpl)this.transcription.getTierWithId(this.annWithValTiers.get(i));
                if (tier == null) continue;
                records = this.createdAnnos.get(tier.getName());
                List<AnnotationDataRecord> valueRecords = this.editedAnnos.get(tier.getName());
                if (records == null && valueRecords == null) continue;
                if (records != null) {
                    for (x = 0; x < records.size(); ++x) {
                        record = records.get(x);
                        if (record == null) continue;
                        if (tier.isTimeAlignable()) {
                            ann = tier.createAnnotation(record.getBeginTime(), record.getEndTime());
                        } else {
                            long time = (record.getBeginTime() + record.getEndTime()) / 2L;
                            ann = tier.createAnnotation(time, time);
                        }
                        if (ann == null) continue;
                        ann.setValue(record.getValue());
                    }
                }
                if (valueRecords == null) continue;
                for (x = 0; x < valueRecords.size(); ++x) {
                    record = valueRecords.get(x);
                    ann = tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                    if (ann == null) continue;
                    String value = ((TierImpl)tier.getParentTier()).getAnnotationAtTime(record.getBeginTime()).getValue();
                    ann.setValue(value);
                }
            }
        }
        this.setWaitCursor(false);
        this.transcription.setNotifying(true);
    }
}

