/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class CopyToNextAnnotationCA
extends CommandAction {
    private Icon icon;
    private Annotation currentAnnot = null;
    private Annotation newAnnot = null;

    public CopyToNextAnnotationCA(ViewerManager2 theVM) {
        super(theVM, "CommandActions.CopyToNextAnnotation");
        this.putValue("Default", "COPY_TO_NEXT_ANNOTATION");
        this.putValue("Name", "");
    }

    @Override
    protected void newCommand() {
        Annotation[] activeAnnotations = this.retrieveAnnotations();
        this.currentAnnot = activeAnnotations[0];
        this.newAnnot = activeAnnotations[1];
        this.command = this.currentAnnot != null ? ELANCommandFactory.createCommand(this.vm.getTranscription(), "CommandActions.CopyToNextAnnotation") : null;
    }

    @Override
    protected Object getReceiver() {
        return this.vm;
    }

    @Override
    protected Object[] getArguments() {
        Vector simultaneousAnnotations = this.getSimultaneousAnnotations(this.currentAnnot);
        Object[] args = new Object[]{this.newAnnot, this.currentAnnot, simultaneousAnnotations};
        return args;
    }

    private void extractRootTiers(Transcription transcription, Vector rootTiers) {
        Vector tiers;
        if (transcription != null && (tiers = transcription.getTiers()) != null) {
            Iterator tierIt = tiers.iterator();
            TierImpl tier = null;
            while (tierIt.hasNext()) {
                tier = (TierImpl)tierIt.next();
                if (tier.getLinguisticType().getConstraints() != null) continue;
                rootTiers.add(tier);
            }
        }
    }

    private Annotation[] retrieveAnnotations() {
        TierImpl currentTier;
        Annotation currentActiveAnnot = this.vm.getActiveAnnotation().getAnnotation();
        Annotation newActiveAnnot = null;
        if (currentActiveAnnot != null) {
            newActiveAnnot = ((TierImpl)currentActiveAnnot.getTier()).getAnnotationAfter(currentActiveAnnot);
        } else {
            TierImpl activeTier = (TierImpl)this.vm.getMultiTierControlPanel().getActiveTier();
            if (activeTier != null) {
                currentActiveAnnot = activeTier.getAnnotationAtTime(this.vm.getMasterMediaPlayer().getMediaTime());
                newActiveAnnot = activeTier.getAnnotationAfter(currentActiveAnnot);
            }
        }
        if (newActiveAnnot == null) {
            currentActiveAnnot = null;
        }
        if (currentActiveAnnot != null && (currentTier = (TierImpl)currentActiveAnnot.getTier()).getLinguisticType().getConstraints() != null) {
            currentActiveAnnot = null;
            newActiveAnnot = null;
        }
        Annotation[] activeAnnotations = new Annotation[]{currentActiveAnnot, newActiveAnnot};
        return activeAnnotations;
    }

    private Vector getSimultaneousAnnotations(Annotation currentActiveAnnot) {
        Vector rootTiers = new Vector();
        this.extractRootTiers(this.vm.getTranscription(), rootTiers);
        Vector<Annotation> simultaneousAnnotations = null;
        if (currentActiveAnnot != null) {
            TierImpl currentTier = (TierImpl)currentActiveAnnot.getTier();
            simultaneousAnnotations = new Vector<Annotation>();
            for (TierImpl tier : rootTiers) {
                Annotation ann;
                if (currentTier.getName().equals(tier.getName()) || (ann = tier.getAnnotationAtTime(this.vm.getMasterMediaPlayer().getMediaTime())) == null) continue;
                simultaneousAnnotations.add(ann);
            }
        }
        return simultaneousAnnotations;
    }
}

