/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Vector;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationValuesRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class CopyPreviousAnnotationCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private Transcription transcription;
    private ArrayList records = new ArrayList();

    public CopyPreviousAnnotationCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            for (AnnotationValuesRecord record : this.records) {
                Annotation ann;
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(record.getTierName());
                if (tier == null || (ann = tier.getAnnotationAtTime(record.getBeginTime())) == null) continue;
                ann.setValue(record.getValue());
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            for (AnnotationValuesRecord record : this.records) {
                Annotation ann;
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(record.getTierName());
                if (tier == null || (ann = tier.getAnnotationAtTime(record.getBeginTime())) == null) continue;
                ann.setValue(record.getNewLabelValue());
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)receiver;
        this.transcription = vm.getTranscription();
        Annotation newActiveAnnot = (Annotation)arguments[0];
        Annotation currentActiveAnnot = (Annotation)arguments[1];
        Vector simultaneousAnnots = (Vector)arguments[2];
        if (null == newActiveAnnot || null == currentActiveAnnot) {
            LOG.severe("Annotations on active tier not valid for copying.");
            return;
        }
        if (!(newActiveAnnot instanceof AlignableAnnotation) || !(currentActiveAnnot instanceof AlignableAnnotation)) {
            LOG.severe("Error in constraints of retrieved annotation on the active tier.");
            return;
        }
        long curBeginTime = currentActiveAnnot.getBeginTimeBoundary();
        long curEndTime = currentActiveAnnot.getEndTimeBoundary();
        long curLength = curEndTime - curBeginTime;
        long newBeginTime = newActiveAnnot.getBeginTimeBoundary();
        long newEndTime = newActiveAnnot.getEndTimeBoundary();
        if (curEndTime == newBeginTime && curLength == newEndTime - newBeginTime) {
            if (newActiveAnnot.getValue().trim().length() < 1) {
                AnnotationValuesRecord record = new AnnotationValuesRecord(newActiveAnnot);
                record.setNewLabelValue(currentActiveAnnot.getValue());
                this.records.add(record);
                newActiveAnnot.setValue(currentActiveAnnot.getValue());
            }
            if (simultaneousAnnots != null && !simultaneousAnnots.isEmpty()) {
                for (Annotation ann : simultaneousAnnots) {
                    this.copyToNextAnnotation(ann, curEndTime, curLength);
                }
            }
            this.setActiveAnnotation(vm, newActiveAnnot);
        }
    }

    private void setActiveAnnotation(ViewerManager2 vm, Annotation newActiveAnnot) {
        vm.getActiveAnnotation().setAnnotation(newActiveAnnot);
        vm.getSelection().setSelection(newActiveAnnot.getBeginTimeBoundary(), newActiveAnnot.getEndTimeBoundary());
        if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
            vm.getMediaPlayerController().toggleActiveSelectionBoundary();
        }
        vm.getMasterMediaPlayer().setMediaTime(newActiveAnnot.getBeginTimeBoundary());
    }

    private void copyToNextAnnotation(Annotation ann, long endTime, long length) {
        Annotation nextAnn;
        if (ann != null && (nextAnn = ((TierImpl)ann.getTier()).getAnnotationAfter(ann)) != null) {
            long annBT = ann.getBeginTimeBoundary();
            long annET = ann.getEndTimeBoundary();
            long nextBT = nextAnn.getBeginTimeBoundary();
            long nextET = nextAnn.getEndTimeBoundary();
            if (annET - annBT == length && nextET - nextBT == length && annET == nextBT && nextAnn.getValue().trim().length() < 1) {
                AnnotationValuesRecord record = new AnnotationValuesRecord(nextAnn);
                record.setNewLabelValue(ann.getValue());
                this.records.add(record);
                nextAnn.setValue(ann.getValue());
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

