/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.TransferableAnnotation;
import mpi.eudico.server.corpora.clom.Annotation;

public class CopyAnnotationCommand
implements Command,
ClientLogger {
    private String commandName;

    public CopyAnnotationCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (arguments[0] instanceof Annotation) {
            AnnotationDataRecord record = new AnnotationDataRecord((Annotation)arguments[0]);
            TransferableAnnotation ta = new TransferableAnnotation(record);
            if (this.canAccessSystemClipboard()) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ta, ta);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    protected boolean canAccessSystemClipboard() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                return true;
            }
            catch (SecurityException se) {
                LOG.warning("Cannot copy, cannot access the clipboard.");
                return false;
            }
        }
        return true;
    }
}

