/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.IndeterminateProgressMonitor;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ChangeTierAttributesCommand
implements UndoableCommand {
    private String commandName;
    private String oldTierName;
    private String oldParticipant;
    private String oldAnnotator;
    private Locale oldLocale;
    private LinguisticType oldLingType;
    private Tier oldParentTier;
    private String tierName;
    private Tier parentTier;
    private String lingTypeName;
    private LinguisticType lingType;
    private String participant;
    private String annotator;
    private Locale locale;
    private TierImpl tier;
    private TranscriptionImpl transcription;
    ArrayList storedGraphicsData;

    public ChangeTierAttributesCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.transcription = (TranscriptionImpl)this.tier.getParent();
        this.tierName = (String)arguments[0];
        this.parentTier = (Tier)arguments[1];
        this.lingTypeName = (String)arguments[2];
        this.participant = (String)arguments[3];
        this.annotator = (String)arguments[4];
        this.locale = (Locale)arguments[5];
        if (this.tier != null) {
            this.setWaitCursor(true);
            try {
                this.oldTierName = this.tier.getName();
                this.oldParticipant = this.tier.getParticipant();
                this.oldLocale = this.tier.getDefaultLocale();
                this.oldLingType = this.tier.getLinguisticType();
                this.oldParentTier = (TierImpl)this.tier.getParentTier();
                this.oldAnnotator = this.tier.getAnnotator();
                if (!this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.tierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.parentTier);
                }
                if (!this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.participant);
                }
                if (!this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.annotator);
                }
                if (this.locale == null || this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.locale);
                }
                if (this.oldLingType == null || this.lingTypeName != this.oldLingType.getLinguisticTypeName()) {
                    Vector types = this.tier.getParent().getLinguisticTypes();
                    LinguisticType t = null;
                    Iterator typeIter = types.iterator();
                    while (typeIter.hasNext() && !(t = (LinguisticType)typeIter.next()).getLinguisticTypeName().equals(this.lingTypeName)) {
                    }
                    if (t != null) {
                        this.lingType = t;
                        this.tier.setLinguisticType(this.lingType);
                        if (this.oldLingType.hasGraphicReferences() != this.lingType.hasGraphicReferences()) {
                            if (this.oldLingType.hasGraphicReferences()) {
                                new ConversionThread(this.transcription, this.tier).start(true);
                            } else {
                                new ConversionThread(this.transcription, this.tier).start();
                            }
                        }
                    }
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.oldTierName, this.tierName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void undo() {
        if (this.tier != null) {
            try {
                if (this.tierName != null && !this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.oldTierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.oldParentTier);
                }
                this.tier.setLinguisticType(this.oldLingType);
                if (this.participant != null && !this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.oldParticipant);
                }
                if (this.annotator != null && !this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.oldAnnotator);
                }
                if (this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.oldLocale);
                }
                if (this.lingType != null && this.oldLingType.hasGraphicReferences() != this.lingType.hasGraphicReferences()) {
                    new ConversionThread(this.transcription, this.tier).start();
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.tierName, this.oldTierName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
        }
    }

    @Override
    public void redo() {
        if (this.tier != null) {
            this.setWaitCursor(true);
            try {
                if (this.tierName != null && !this.tierName.equals(this.oldTierName)) {
                    this.tier.setName(this.tierName);
                }
                if (this.parentTier != this.oldParentTier) {
                    this.tier.setParentTier(this.parentTier);
                }
                if (this.lingType != null) {
                    this.tier.setLinguisticType(this.lingType);
                }
                if (this.participant != null && !this.participant.equals(this.oldParticipant)) {
                    this.tier.setParticipant(this.participant);
                }
                if (!this.annotator.equals(this.oldAnnotator)) {
                    this.tier.setAnnotator(this.annotator);
                }
                if (this.locale != this.oldLocale) {
                    this.tier.setDefaultLocale(this.locale);
                }
                if (this.lingType != null && this.oldLingType.hasGraphicReferences() != this.lingType.hasGraphicReferences()) {
                    new ConversionThread(this.transcription, this.tier).start();
                }
                if (!this.tierName.equals(this.oldTierName)) {
                    this.updatePreferences(this.oldTierName, this.tierName);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setWaitCursor(false);
            }
            this.setWaitCursor(false);
        }
    }

    private void updatePreferences(String oldTierName, String tierName) {
        Map fontsMap;
        Object fonts;
        Map colorMap;
        Object colors = Preferences.get("TierColors", this.transcription);
        if (colors instanceof Map && (colorMap = (Map)colors).containsKey(oldTierName)) {
            Object col = colorMap.remove(oldTierName);
            colorMap.put(tierName, col);
            Preferences.set("TierColors", colorMap, this.transcription, true);
        }
        if ((fonts = Preferences.get("TierFonts", this.transcription)) instanceof Map && (fontsMap = (Map)fonts).containsKey(oldTierName)) {
            Object font = fontsMap.remove(oldTierName);
            fontsMap.put(tierName, font);
            Preferences.set("TierFonts", fontsMap, this.transcription, true);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    class ConversionThread
    extends Thread {
        TranscriptionImpl transcription;
        TierImpl tier;
        boolean storeGraphicsData = false;

        public ConversionThread(TranscriptionImpl transcription, TierImpl tier) {
            this.transcription = transcription;
            this.tier = tier;
        }

        public void start(boolean storeGraphicsData) {
            this.storeGraphicsData = storeGraphicsData;
            this.start();
        }

        @Override
        public void run() {
            final IndeterminateProgressMonitor monitor = new IndeterminateProgressMonitor(ELANCommandFactory.getRootFrame(this.transcription), true, ElanLocale.getString("EditTypeDialog.Message.Convert"), false, null);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    monitor.show();
                }
            }).start();
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            if (this.storeGraphicsData) {
                ChangeTierAttributesCommand.this.storedGraphicsData = AnnotationRecreator.storeGraphicsData((Transcription)this.transcription, this.tier);
            }
            AnnotationRecreator.convertAnnotations((Transcription)this.transcription, this.tier);
            if (ChangeTierAttributesCommand.this.storedGraphicsData != null && this.tier.getLinguisticType().hasGraphicReferences()) {
                AnnotationRecreator.restoreGraphicsData(this.transcription, ChangeTierAttributesCommand.this.storedGraphicsData);
            }
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
            monitor.close();
        }
    }
}

