/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.tier.AnnotationFromOverlaps;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AnnotationsFromOverlapsUndoableCommand
extends AnnotationFromOverlaps
implements UndoableCommand {
    public AnnotationsFromOverlapsUndoableCommand(String name) {
        super(name);
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            TierImpl dt = (TierImpl)this.transcription.getTierWithId(this.destTierName);
            if (dt == null) {
                dt = (TierImpl)this.transcription.getTierWithId(this.sourceTiers[0]);
                LinguisticType lType = dt.getLinguisticType();
                if (lType.getConstraints() != null) {
                    ClientLogger.LOG.severe("The source tier is not a root tier.");
                    return;
                }
                TierImpl dTier = new TierImpl(null, this.destTierName, dt.getParticipant(), this.transcription, lType);
                dTier.setAnnotator(dt.getAnnotator());
                dTier.setDefaultLocale(dt.getDefaultLocale());
                this.transcription.addTier(dTier);
                dt = dTier;
            }
            if (dt == null) {
                ClientLogger.LOG.severe("Could not find the destination tier for redo");
                return;
            }
            if (this.createdAnnos == null || this.createdAnnos.size() == 0) {
                ClientLogger.LOG.info("No annotations to restore");
                return;
            }
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.transcription.setNotifying(false);
            for (int i = 0; i < this.createdAnnos.size(); ++i) {
                AnnotationDataRecord record = (AnnotationDataRecord)this.createdAnnos.get(i);
                Annotation ann = dt.createAnnotation(record.getBeginTime(), record.getEndTime());
                if (ann == null || record.getValue() == null) continue;
                ann.setValue(record.getValue());
            }
            this.transcription.setNotifying(true);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null) {
            if (this.destTierCreated) {
                Tier dt = this.transcription.getTierWithId(this.destTierName);
                if (dt != null) {
                    this.transcription.removeTier(dt);
                }
            } else {
                TierImpl st = (TierImpl)this.transcription.getTierWithId(this.destTierName);
                if (st != null && this.createdAnnos != null && this.createdAnnos.size() > 0) {
                    this.transcription.setNotifying(false);
                    for (int i = 0; i < this.createdAnnos.size(); ++i) {
                        AnnotationDataRecord record = (AnnotationDataRecord)this.createdAnnos.get(i);
                        Annotation ann = st.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                        if (ann == null) continue;
                        st.removeAnnotation(ann);
                    }
                    this.transcription.setNotifying(true);
                }
            }
        }
    }
}

