/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Dimension;
import javax.swing.JDialog;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.OverlapsOrSubtractionStep1;
import mpi.eudico.client.annotator.tier.OverlapsOrSubtractionStep3;
import mpi.eudico.client.annotator.tier.OverlapsOrSubtractionStep4;
import mpi.eudico.client.annotator.tier.OverlapsOrSubtractionStep5;
import mpi.eudico.client.annotator.tier.OverlapsStep2;
import mpi.eudico.client.annotator.tier.SubtractionStep2;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotationsFromOverlapsDlgCommand
implements Command {
    private String commandName;
    private boolean subtraction;

    public AnnotationsFromOverlapsDlgCommand(String name) {
        this(name, false);
    }

    public AnnotationsFromOverlapsDlgCommand(String name, boolean subtraction) {
        this.commandName = name;
        this.subtraction = subtraction;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl trans = (TranscriptionImpl)receiver;
        MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());
        OverlapsOrSubtractionStep1 step1 = new OverlapsOrSubtractionStep1(pane, trans, this.subtraction);
        StepPane step2 = null;
        step2 = this.subtraction ? new SubtractionStep2(pane) : new OverlapsStep2(pane, ELANCommandFactory.getRootFrame(trans));
        OverlapsOrSubtractionStep3 step3 = new OverlapsOrSubtractionStep3(pane, trans, this.subtraction);
        OverlapsOrSubtractionStep4 step4 = new OverlapsOrSubtractionStep4(pane, this.subtraction);
        OverlapsOrSubtractionStep5 step5 = new OverlapsOrSubtractionStep5(pane, trans, this.subtraction);
        pane.addStep(step1);
        pane.addStep(step2);
        pane.addStep(step3);
        pane.addStep(step4);
        pane.addStep(step5);
        String title = null;
        title = this.subtraction ? ElanLocale.getString("SubtractAnnotationDialog.Title") : ElanLocale.getString("OverlapsDialog.Title");
        JDialog dialog = pane.createDialog(ELANCommandFactory.getRootFrame(trans), title, true);
        dialog.setPreferredSize(new Dimension(600, 600));
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

