/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.SimpleReport;

public class AddParticipantCommand
implements UndoableCommand {
    private String commandName;
    private TranscriptionImpl transcription;
    private List names;
    private String participantName;
    private ArrayList<TierImpl> newTiers;
    private HashMap<String, String> oldNameToNewName;
    private String oldValue;
    private String newValue;
    private boolean changePrefix;
    private SimpleReport report;

    public AddParticipantCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.names = (List)arguments[0];
        this.participantName = (String)arguments[1];
        this.oldValue = (String)arguments[2];
        this.newValue = (String)arguments[3];
        this.changePrefix = (Boolean)arguments[4];
        boolean tierStrucSelected = (Boolean)arguments[5];
        this.report = new SimpleReport(ElanLocale.getString("AddParticipantDlg.Title"));
        this.newValue = this.newValue.trim();
        if (this.names == null || this.names.size() == 0) {
            ClientLogger.LOG.warning("No tier/participant selected.");
            this.transcription.setNotifying(true);
            return;
        }
        this.setWaitCursor(true);
        this.newTiers = new ArrayList();
        this.oldNameToNewName = new HashMap();
        TierImpl parentTier = null;
        if (tierStrucSelected) {
            this.report("Number of selected tier structures: " + this.names.size());
            this.report("Replace suffix/prefix : " + (this.changePrefix ? "prefix" : "suffix"));
            this.report("Value to be replaced : " + this.oldValue);
            this.report("New value to replace : " + this.newValue);
            this.report("New participant name : " + this.participantName);
            this.report("\n");
            this.createTierStructures(this.names);
        } else {
            this.report("Selected Participants: " + this.names.size());
            this.report("Replace suffix/prefix : " + (this.changePrefix ? "prefix" : "suffix"));
            this.report("Value to be replaced : " + this.oldValue);
            this.report("New value to replace : " + this.newValue);
            this.report("New participant name : " + this.participantName);
            this.report("\n");
            Vector tiers = this.transcription.getTiers();
            HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
            for (int i = 0; i < tiers.size(); ++i) {
                parentTier = (TierImpl)tiers.get(i);
                if (parentTier == null || parentTier.hasParentTier() || !this.names.contains(parentTier.getParticipant())) continue;
                ArrayList<String> rootTiers = (ArrayList<String>)map.get(parentTier.getParticipant());
                if (rootTiers == null) {
                    rootTiers = new ArrayList<String>();
                }
                rootTiers.add(parentTier.getName());
                map.put(parentTier.getParticipant(), rootTiers);
            }
            for (Map.Entry entry : map.entrySet()) {
                this.report("Creating tier structures of participant : " + (String)entry.getKey());
                this.createTierStructures((List)entry.getValue());
                this.report("\n");
            }
        }
        ReportDialog dialog = new ReportDialog(this.report);
        dialog.setModal(true);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        this.setWaitCursor(false);
    }

    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    private void createTierStructures(List<String> tierList) {
        for (int i = 0; i < tierList.size(); ++i) {
            String tierName = tierList.get(i);
            this.report("Creating tier structure : " + tierName);
            TierImpl parentTier = (TierImpl)this.transcription.getTierWithId(tierName);
            if (parentTier != null) {
                this.report("Number of tiers to be created : " + (parentTier.getDependentTiers().size() + 1));
                String newParentTier = this.getNewTierName(parentTier.getName());
                if (this.transcription.getTierWithId(newParentTier) == null) {
                    this.addTiers(parentTier);
                } else {
                    this.report("Number of tiers created : 0");
                    this.report("Creation failed. " + newParentTier + " could not be created. A tier with this name already exists.");
                }
            } else {
                this.report("Number of tiers created : 0");
                this.report("Creation failed since the tier '" + tierName + "' cannot be found");
            }
            this.report("\n");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addTiers(TierImpl parentTier) {
        TierImpl ti;
        int i;
        Vector depTiers = parentTier.getDependentTiers();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(parentTier);
        DefaultMutableTreeNode[] nodes = new DefaultMutableTreeNode[depTiers.size()];
        HashMap<TierImpl, DefaultMutableTreeNode> nodeMap = new HashMap<TierImpl, DefaultMutableTreeNode>();
        for (i = 0; i < depTiers.size(); ++i) {
            ti = (TierImpl)depTiers.get(i);
            nodes[i] = new DefaultMutableTreeNode(ti);
            nodeMap.put(ti, nodes[i]);
        }
        for (i = 0; i < depTiers.size(); ++i) {
            ti = (TierImpl)depTiers.get(i);
            if (ti.getParentTier() == parentTier) {
                rootNode.add(nodes[i]);
                continue;
            }
            DefaultMutableTreeNode dn = (DefaultMutableTreeNode)nodeMap.get(ti.getParentTier());
            if (dn == null) continue;
            dn.add(nodes[i]);
        }
        Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
        int tiersCreated = 0;
        int failedTiers = 0;
        while (en.hasMoreElements()) {
            TierImpl refTier;
            TierImpl newTier;
            block9: {
                newTier = null;
                DefaultMutableTreeNode dn = (DefaultMutableTreeNode)en.nextElement();
                refTier = (TierImpl)dn.getUserObject();
                String newName = this.getNewTierName(refTier.getName());
                if (this.transcription.getTierWithId(newName) != null) {
                    this.report("Could not create tier with this name : " + newName + " since a tier with this name already exists.");
                    ++failedTiers;
                    continue;
                }
                this.oldNameToNewName.put(refTier.getName(), newName);
                LinguisticType type = refTier.getLinguisticType();
                if (dn.getParent() != null) {
                    String oldParentName = ((TierImpl)((DefaultMutableTreeNode)dn.getParent()).getUserObject()).getName();
                    String newPName = this.oldNameToNewName.get(oldParentName);
                    TierImpl newParentTier = (TierImpl)this.transcription.getTierWithId(newPName);
                    if (newParentTier != null) {
                        newTier = new TierImpl(newParentTier, newName, this.participantName, this.transcription, type);
                        break block9;
                    } else {
                        this.report("Could not create tier : " + newName + " since its parent tier '" + newPName + "' could not be created.");
                        ++failedTiers;
                        continue;
                    }
                }
                newTier = new TierImpl(newName, this.participantName, this.transcription, type);
            }
            if (newTier == null) continue;
            newTier.setDefaultLocale(refTier.getDefaultLocale());
            newTier.setAnnotator(refTier.getAnnotator());
            this.newTiers.add(newTier);
            this.transcription.addTier(newTier);
            ++tiersCreated;
        }
        this.report("Number of tiers created : " + tiersCreated);
        if (failedTiers > 0) {
            this.report("Number of tiers that could not be created : " + failedTiers);
            this.report("Creation succeeded with incomplete tier structure. A few depending tiers/child tiers could not be created.");
            return;
        }
        this.report("Creation succeeded.");
    }

    private String getNewTierName(String tierName) {
        tierName = this.oldValue != null && this.oldValue.trim().length() > 0 ? (this.changePrefix ? (tierName.startsWith(this.oldValue) ? tierName.replaceFirst(this.oldValue, this.newValue) : this.newValue + "-" + tierName) : (tierName.endsWith(this.oldValue) ? tierName.substring(0, tierName.lastIndexOf(this.oldValue)) + this.newValue : tierName + "-" + this.newValue)) : (this.changePrefix ? this.newValue + "-" + tierName : tierName + "-" + this.newValue);
        return tierName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.newTiers != null) {
            for (int i = 0; i < this.newTiers.size(); ++i) {
                TierImpl t = this.newTiers.get(i);
                this.transcription.removeTier(t);
            }
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.newTiers != null) {
            int curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            TierImpl tier = null;
            for (int i = 0; i < this.newTiers.size(); ++i) {
                tier = this.newTiers.get(i);
                if (this.transcription.getTierWithId(tier.getName()) != null) continue;
                this.transcription.addTier(tier);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }
}

