/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JWindow;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PlayStepAndRepeatCA;

public class StepAndRepeatPanel
extends JPanel
implements ElanLocaleListener,
ActionListener {
    private ViewerManager2 vm;
    private JCheckBox enableCB;
    private JButton playPauseButton;
    private JButton configureButton;
    private boolean showEnableCheckBox = true;
    private PlayStepAndRepeatCA playAction;
    private long beginTime = -1L;
    private long endTime = -1L;
    private int intervalDuration = 2000;
    private int pauseDuration = 500;
    private int numRepeats = 3;
    private int stepSize = 1000;
    private boolean enabled = true;

    public StepAndRepeatPanel(ViewerManager2 vm) {
        this.vm = vm;
        this.readPreferences();
        this.initComponents();
    }

    private void initComponents() {
        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
        this.setLayout(flowLayout);
        this.enableCB = new JCheckBox();
        this.enableCB.setSelected(this.enabled);
        this.enableCB.addActionListener(this);
        this.add(this.enableCB);
        ImageIcon icon = null;
        String text = null;
        this.playAction = (PlayStepAndRepeatCA)ELANCommandFactory.getCommandAction(this.vm.getTranscription(), "Menu.Play.PlayStepAndRepeat");
        this.playPauseButton = new JButton(this.playAction);
        this.playPauseButton.setPreferredSize(new Dimension(30, 20));
        this.playPauseButton.setEnabled(this.enabled);
        this.add(this.playPauseButton);
        text = null;
        icon = null;
        try {
            icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Configure16.gif"));
        }
        catch (Exception ex) {
            text = "E";
        }
        this.configureButton = new JButton(text, icon);
        this.configureButton.setPreferredSize(new Dimension(20, 20));
        this.configureButton.setBorderPainted(false);
        this.configureButton.setEnabled(this.enabled);
        this.configureButton.addActionListener(this);
        this.add(this.configureButton);
        this.updateLocale();
        this.readPreferences();
    }

    @Override
    public void updateLocale() {
        this.enableCB.setToolTipText(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.Enable"));
        this.configureButton.setToolTipText(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.Configure"));
    }

    private void readPreferences() {
        Object pref = Preferences.get("StepAndRepeat.IntervalDuration", null);
        if (pref instanceof Integer) {
            this.intervalDuration = (Integer)pref;
        }
        if ((pref = Preferences.get("StepAndRepeat.PauseDuration", null)) instanceof Integer) {
            this.pauseDuration = (Integer)pref;
        }
        if ((pref = Preferences.get("StepAndRepeat.NumberOfRepeats", null)) instanceof Integer) {
            this.numRepeats = (Integer)pref;
        }
        if ((pref = Preferences.get("StepAndRepeat.StepSize", null)) instanceof Integer) {
            this.stepSize = (Integer)pref;
        }
    }

    public void setPlayIcon(boolean play) {
        if (this.playAction != null) {
            this.playAction.setPlayIcon(play);
        }
    }

    public void showEnableCheckBox(boolean showEnableCheckBox) {
        this.enableCB.setVisible(showEnableCheckBox);
        this.revalidate();
    }

    public int getIntervalDuration() {
        return this.intervalDuration;
    }

    public void setIntervalDuration(int intervalDuration) {
        this.intervalDuration = intervalDuration;
        Preferences.set("StepAndRepeat.IntervalDuration", intervalDuration, null, false, false);
    }

    public int getPauseDuration() {
        return this.pauseDuration;
    }

    public void setPauseDuration(int pauseDuration) {
        this.pauseDuration = pauseDuration;
        Preferences.set("StepAndRepeat.PauseDuration", pauseDuration, null, false, false);
    }

    public int getNumRepeats() {
        return this.numRepeats;
    }

    public void setNumRepeats(int numRepeats) {
        this.numRepeats = numRepeats;
        Preferences.set("StepAndRepeat.NumberOfRepeats", numRepeats, null, false, false);
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(int stepSize) {
        this.stepSize = stepSize;
        Preferences.set("StepAndRepeat.StepSize", stepSize, null, false, false);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.configureButton) {
            ConfigWindow cw = new ConfigWindow(SwingUtilities.getWindowAncestor(this));
            cw.pack();
            Dimension dim = cw.getPreferredSize();
            Point p = this.configureButton.getLocationOnScreen();
            cw.setBounds(p.x - dim.width, p.y, dim.width, dim.height);
            cw.setVisible(true);
        } else if (e.getSource() == this.enableCB) {
            this.playPauseButton.setEnabled(this.enableCB.isSelected());
            this.configureButton.setEnabled(this.enableCB.isSelected());
        }
    }

    private class ConfigWindow
    extends JWindow
    implements ActionListener,
    ChangeListener {
        private JPanel compPanel;
        private JButton closeButton;
        private JLabel durLabel;
        private JLabel repeatLabel;
        private JLabel pauseLabel;
        private JLabel stepLabel;
        private JSpinner durSpinner;
        private JSpinner repeatSpinner;
        private JSpinner pauseSpinner;
        private JSpinner stepSpinner;

        public ConfigWindow(Window owner) {
            super(owner);
            this.initComponents();
        }

        private void initComponents() {
            ImageIcon icon = null;
            String text = null;
            try {
                icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Close16.gif"));
            }
            catch (Exception ex) {
                text = "X";
            }
            this.compPanel = new JPanel(new GridBagLayout());
            this.compPanel.setBorder(new CompoundBorder(new LineBorder(Constants.SHAREDCOLOR6, 1), new EmptyBorder(2, 4, 2, 2)));
            this.closeButton = new JButton(text, icon);
            this.closeButton.setToolTipText(ElanLocale.getString("Button.Close"));
            this.closeButton.setBorderPainted(false);
            this.closeButton.setPreferredSize(new Dimension(16, 16));
            this.closeButton.addActionListener(this);
            this.durLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.IntervalDuration"));
            Font smallFont = this.durLabel.getFont().deriveFont(0, 10.0f);
            this.durLabel.setFont(smallFont);
            this.repeatLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.Repeats"));
            this.repeatLabel.setFont(smallFont);
            this.pauseLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.PauseDuration"));
            this.pauseLabel.setFont(smallFont);
            this.stepLabel = new JLabel(ElanLocale.getString("MediaPlayerControlPanel.StepAndRepeat.StepSize"));
            this.stepLabel.setFont(smallFont);
            this.durSpinner = new JSpinner(new SpinnerNumberModel(StepAndRepeatPanel.this.intervalDuration, 200, 10000, 200));
            this.durSpinner.setEditor(new JSpinner.NumberEditor(this.durSpinner, "#"));
            this.durSpinner.addChangeListener(this);
            this.repeatSpinner = new JSpinner(new SpinnerNumberModel(StepAndRepeatPanel.this.numRepeats, 1, 10, 1));
            this.repeatSpinner.setEditor(new JSpinner.NumberEditor(this.repeatSpinner, "#"));
            this.pauseSpinner = new JSpinner(new SpinnerNumberModel(StepAndRepeatPanel.this.pauseDuration, 0, 4000, 100));
            this.pauseSpinner.setEditor(new JSpinner.NumberEditor(this.pauseSpinner, "#"));
            this.stepSpinner = new JSpinner(new SpinnerNumberModel(StepAndRepeatPanel.this.stepSize, 200, 10000, 200));
            this.stepSpinner.setEditor(new JSpinner.NumberEditor(this.stepSpinner, "#"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridwidth = 2;
            this.compPanel.add((Component)this.closeButton, gbc);
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            gbc.gridy = 1;
            this.compPanel.add((Component)this.durLabel, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.repeatLabel, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.pauseLabel, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.stepLabel, gbc);
            gbc.gridy = 1;
            gbc.gridx = 1;
            gbc.fill = 2;
            this.compPanel.add((Component)this.durSpinner, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.repeatSpinner, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.pauseSpinner, gbc);
            ++gbc.gridy;
            this.compPanel.add((Component)this.stepSpinner, gbc);
            this.add(this.compPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.closeButton) {
                this.close();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object val;
            if (e.getSource() == this.durSpinner) {
                Object val2 = this.durSpinner.getValue();
                if (val2 instanceof Integer) {
                    StepAndRepeatPanel.this.setIntervalDuration((Integer)val2);
                }
            } else if (e.getSource() == this.repeatSpinner) {
                Object val3 = this.repeatSpinner.getValue();
                if (val3 instanceof Integer) {
                    StepAndRepeatPanel.this.setNumRepeats((Integer)val3);
                }
            } else if (e.getSource() == this.pauseSpinner) {
                Object val4 = this.pauseSpinner.getValue();
                if (val4 instanceof Integer) {
                    StepAndRepeatPanel.this.setPauseDuration((Integer)val4);
                }
            } else if (e.getSource() == this.stepSpinner && (val = this.stepSpinner.getValue()) instanceof Integer) {
                StepAndRepeatPanel.this.setStepSize((Integer)val);
            }
        }

        private void close() {
            Object val;
            try {
                this.durSpinner.commitEdit();
                val = this.durSpinner.getValue();
                if (val instanceof Integer) {
                    StepAndRepeatPanel.this.setIntervalDuration((Integer)val);
                }
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                this.repeatSpinner.commitEdit();
                val = this.repeatSpinner.getValue();
                if (val instanceof Integer) {
                    StepAndRepeatPanel.this.setNumRepeats((Integer)val);
                }
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                this.pauseSpinner.commitEdit();
                val = this.pauseSpinner.getValue();
                if (val instanceof Integer) {
                    StepAndRepeatPanel.this.setPauseDuration((Integer)val);
                }
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                this.stepSpinner.commitEdit();
                val = this.stepSpinner.getValue();
                if (val instanceof Integer) {
                    StepAndRepeatPanel.this.setStepSize((Integer)val);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.setVisible(false);
            this.dispose();
        }
    }
}

