/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class PlayerViewerMenuManager {
    private ElanFrame2 frame;
    private Transcription transcription;
    private List menuPlayers;
    private final String HIDDEN_PLAYERS_KEY = "HiddenPlayers";

    public PlayerViewerMenuManager(ElanFrame2 frame, Transcription transcription) {
        this.frame = frame;
        this.transcription = transcription;
        this.menuPlayers = new ArrayList();
    }

    public List getStoredVisiblePlayers() {
        ArrayList tempList = (ArrayList)Preferences.get("HiddenPlayers", this.transcription);
        if (tempList == null) {
            return this.transcription.getMediaDescriptors();
        }
        int size = this.transcription.getMediaDescriptors().size();
        ArrayList<MediaDescriptor> visList = new ArrayList<MediaDescriptor>(size);
        for (int i = 0; i < size; ++i) {
            MediaDescriptor md = (MediaDescriptor)this.transcription.getMediaDescriptors().get(i);
            if (md.mediaURL == null || tempList.contains(md.mediaURL)) continue;
            visList.add(md);
        }
        return visList;
    }

    public void initPlayerMenu() {
        List visuals = this.frame.getLayoutManager().getVisualPlayers();
        Vector descriptors = this.transcription.getMediaDescriptors();
        int visibles = 0;
        for (int i = 0; i < descriptors.size(); ++i) {
            MediaDescriptor md = (MediaDescriptor)descriptors.get(i);
            if (md.mimeType != null && md.mimeType.equals("audio/x-wav") || md.mimeType.equals("audio/*")) continue;
            boolean curVisual = visuals.contains(md);
            boolean curValid = MediaDescriptorUtil.checkLinkStatus(md);
            if (!curVisual && md.mimeType != null && md.mimeType.equals("unknown") && curValid && !this.isVideo(md)) continue;
            String fileName = FileUtility.fileNameFromPath(md.mediaURL);
            PlayerAction action = new PlayerAction(md.mediaURL, fileName);
            if (!curValid) {
                action.setEnabled(false);
            }
            this.frame.addActionToMenu(action, 610, -1);
            if (curVisual && visibles < 4) {
                this.frame.setMenuSelected(md.mediaURL, 610);
                this.menuPlayers.add(new SelectableObject(md, true));
                ++visibles;
                continue;
            }
            this.menuPlayers.add(new SelectableObject(md, false));
        }
    }

    public void reinitializePlayerMenu() {
        ArrayList<String> hidden = new ArrayList<String>(6);
        MediaDescriptor md = null;
        SelectableObject sob = null;
        for (int i = 0; i < this.menuPlayers.size(); ++i) {
            sob = (SelectableObject)this.menuPlayers.get(i);
            md = (MediaDescriptor)sob.getValue();
            if (!sob.isSelected()) {
                hidden.add(md.mediaURL);
            }
            this.frame.removeActionFromMenu(md.mediaURL, 610);
        }
        if (hidden.size() > 0) {
            this.removeHiddenPlayers(hidden);
        }
        this.menuPlayers.clear();
        this.initPlayerMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isVideo(MediaDescriptor md) {
        if (md == null) {
            return false;
        }
        ElanMediaPlayer player = null;
        try {
            player = PlayerFactory.createElanMediaPlayer(md);
            if (player.getVisualComponent() == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (player != null) {
                player.cleanUpOnClose();
                player = null;
            }
        }
    }

    private void savePreferences() {
        ArrayList<String> hidden = new ArrayList<String>();
        MediaDescriptor md = null;
        SelectableObject sob = null;
        for (int i = 0; i < this.menuPlayers.size(); ++i) {
            sob = (SelectableObject)this.menuPlayers.get(i);
            md = (MediaDescriptor)sob.getValue();
            if (sob.isSelected()) continue;
            hidden.add(md.mediaURL);
        }
        Preferences.set("HiddenPlayers", hidden, this.transcription);
    }

    void playerActionPerformed(AbstractAction action, ActionEvent e) {
        if (e.getSource() instanceof AbstractButton) {
            boolean selected = ((AbstractButton)e.getSource()).isSelected();
            List visuals = this.frame.getLayoutManager().getVisualPlayers();
            if (!selected) {
                String url = (String)action.getValue("LongDescription");
                MediaDescriptor md = null;
                SelectableObject sob = null;
                for (int i = 0; i < this.menuPlayers.size(); ++i) {
                    sob = (SelectableObject)this.menuPlayers.get(i);
                    md = (MediaDescriptor)sob.getValue();
                    if (md.mediaURL.equals(url)) {
                        sob.setSelected(false);
                        break;
                    }
                    if (i != this.menuPlayers.size() - 1) continue;
                    md = null;
                }
                if (md != null) {
                    this.removePlayer(md);
                }
            } else {
                String url = (String)action.getValue("LongDescription");
                MediaDescriptor md = null;
                SelectableObject sob = null;
                for (int i = 0; i < this.menuPlayers.size(); ++i) {
                    sob = (SelectableObject)this.menuPlayers.get(i);
                    md = (MediaDescriptor)sob.getValue();
                    if (md.mediaURL.equals(url)) {
                        sob.setSelected(true);
                        break;
                    }
                    if (i != this.menuPlayers.size() - 1) continue;
                    md = null;
                }
                long mediaTime = this.frame.getViewerManager().getMasterMediaPlayer().getMediaTime();
                if (visuals.size() < 4) {
                    ElanMediaPlayer pl;
                    if (md != null && (pl = MediaDescriptorUtil.createMediaPlayer((TranscriptionImpl)this.transcription, md)) != null) {
                        if (this.frame.getViewerManager().getMasterMediaPlayer() instanceof EmptyMediaPlayer) {
                            this.frame.getViewerManager().setMasterMediaPlayer(pl);
                        } else if (this.transcription.getMediaDescriptors().size() > 0 && this.transcription.getMediaDescriptors().get(0).equals(md)) {
                            this.frame.getViewerManager().setMasterMediaPlayer(pl);
                        }
                        this.frame.getLayoutManager().add(pl);
                        pl.setMediaTime(mediaTime);
                    }
                } else {
                    JOptionPane.showMessageDialog(this.frame, ElanLocale.getString("Player.MaxNumber") + " " + 4, ElanLocale.getString("Message.Warning"), 2);
                    ((AbstractButton)e.getSource()).setSelected(false);
                }
            }
            this.savePreferences();
        }
    }

    private void removeHiddenPlayers(List hidden) {
        if (hidden == null || hidden.size() == 0) {
            return;
        }
        List visuals = this.frame.getLayoutManager().getVisualPlayers();
        MediaDescriptor md = null;
        for (int i = 0; i < visuals.size(); ++i) {
            md = (MediaDescriptor)visuals.get(i);
            if (!hidden.contains(md.mediaURL)) continue;
            this.removePlayer(md);
        }
    }

    private void removePlayer(MediaDescriptor md) {
        if (md == null || md.mediaURL == null) {
            return;
        }
        ElanMediaPlayer player = null;
        List visuals = this.frame.getLayoutManager().getVisualPlayers();
        MediaDescriptor otherMd = this.frame.getViewerManager().getMasterMediaPlayer().getMediaDescriptor();
        if (otherMd != null && md.mediaURL.equals(otherMd.mediaURL)) {
            player = this.frame.getViewerManager().getMasterMediaPlayer();
            long mediaTime = player.getMediaTime();
            Vector slavePlayers = this.frame.getViewerManager().getSlaveMediaPlayers();
            if (slavePlayers.size() == 0) {
                this.frame.getViewerManager().setMasterMediaPlayer(new EmptyMediaPlayer(Integer.MAX_VALUE));
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            } else if (slavePlayers.size() == 1) {
                if (slavePlayers.get(0) instanceof EmptyMediaPlayer) {
                    long minTime;
                    long time = this.frame.getViewerManager().getTranscription().getLatestTime();
                    if (time < (minTime = 60000L)) {
                        time = minTime;
                    }
                    ((EmptyMediaPlayer)slavePlayers.get(0)).setMediaDuration(time);
                }
                this.frame.getViewerManager().setMasterMediaPlayer((ElanMediaPlayer)slavePlayers.get(0));
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            } else {
                ElanMediaPlayer slavePl = (ElanMediaPlayer)slavePlayers.get(0);
                if (slavePl instanceof EmptyMediaPlayer || !visuals.contains(slavePl.getMediaDescriptor())) {
                    block0: for (int i = 1; i < slavePlayers.size(); ++i) {
                        if (slavePlayers.get(i) instanceof EmptyMediaPlayer) continue;
                        ElanMediaPlayer nextPl = (ElanMediaPlayer)slavePlayers.get(i);
                        for (int j = 0; j < visuals.size(); ++j) {
                            if (!visuals.get(j).equals(nextPl.getMediaDescriptor())) continue;
                            slavePl = nextPl;
                            break block0;
                        }
                    }
                }
                this.frame.getViewerManager().setMasterMediaPlayer(slavePl);
                this.frame.getViewerManager().destroyMediaPlayer(player);
                this.frame.getLayoutManager().remove(player);
                this.frame.getViewerManager().getMasterMediaPlayer().setMediaTime(mediaTime);
            }
        } else {
            Vector slavePlayers = this.frame.getViewerManager().getSlaveMediaPlayers();
            ElanMediaPlayer slavePl = null;
            for (int i = 0; i < slavePlayers.size(); ++i) {
                slavePl = (ElanMediaPlayer)slavePlayers.get(i);
                if (!md.equals(slavePl.getMediaDescriptor())) continue;
                this.frame.getViewerManager().destroyMediaPlayer(slavePl);
                this.frame.getLayoutManager().remove(slavePl);
            }
        }
    }

    class PlayerAction
    extends AbstractAction {
        PlayerAction(String fileUrl, String fileName) {
            this.putValue("Name", fileName);
            this.putValue("LongDescription", fileUrl);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlayerViewerMenuManager.this.playerActionPerformed(this, e);
        }
    }
}

