/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.AnnotationNavigationPanel;
import mpi.eudico.client.annotator.DurationPanel;
import mpi.eudico.client.annotator.MediaPlayerControlSlider;
import mpi.eudico.client.annotator.ModePanel;
import mpi.eudico.client.annotator.PlayButtonsPanel;
import mpi.eudico.client.annotator.SelectionButtonsPanel;
import mpi.eudico.client.annotator.SelectionPanel;
import mpi.eudico.client.annotator.StepAndRepeatPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.VolumeIconPanel;
import mpi.eudico.client.annotator.gui.ElanSlider;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;

public class ElanMediaPlayerController
extends AbstractViewer {
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    private long userTimeBetweenLoops = 500L;
    private ViewerManager2 vm;
    private ElanSlider rateslider;
    private ElanSlider volumeslider;
    private SelectionPanel selectionpanel;
    private VolumeIconPanel volumeIconPanel;
    private StepAndRepeatPanel stepAndRepeatPanel;
    private DurationPanel durationPanel;
    private PlayButtonsPanel playButtonsPanel;
    private AnnotationNavigationPanel annotationPanel;
    private SelectionButtonsPanel selectionButtonsPanel;
    private ModePanel modePanel;
    private long stopTime = 0L;
    private boolean playingSelection = false;
    private boolean bLoopMode = false;
    private boolean bSelectionMode = false;
    private boolean bBeginBoundaryActive = false;
    private boolean stepAndRepeatMode = false;
    private LoopThread loopThread;
    private StepAndRepeatThread stepThread;

    public ElanMediaPlayerController(ViewerManager2 theVM) {
        this.vm = theVM;
        this.rateslider = new ElanSlider("ELANSLIDERRATE", 0, 200, 100, this.vm);
        this.volumeslider = new ElanSlider("ELANSLIDERVOLUME", 0, 100, 100, this.vm);
        this.selectionpanel = new SelectionPanel(this.vm);
        this.durationPanel = new DurationPanel(this.vm.getMasterMediaPlayer().getMediaDuration());
        this.playButtonsPanel = new PlayButtonsPanel(this.getButtonSize(), this.vm);
        this.annotationPanel = new AnnotationNavigationPanel(this.getButtonSize(), this.vm);
        this.selectionButtonsPanel = new SelectionButtonsPanel(this.getButtonSize(), this.vm);
        this.modePanel = new ModePanel(this.vm, this);
        this.volumeIconPanel = new VolumeIconPanel(this.vm, 1, this.getButtonSize());
        this.stepAndRepeatPanel = new StepAndRepeatPanel(this.vm);
    }

    public Dimension getButtonSize() {
        return BUTTON_SIZE;
    }

    public long getUserTimeBetweenLoops() {
        return this.userTimeBetweenLoops;
    }

    public void setUserTimeBetweenLoops(long loopTime) {
        this.userTimeBetweenLoops = loopTime;
    }

    public MediaPlayerControlSlider getSliderPanel() {
        return this.vm.getMediaPlayerControlSlider();
    }

    public AnnotationDensityViewer getAnnotationDensityViewer() {
        return this.vm.getAnnotationDensityViewer();
    }

    public JComponent getRatePanel() {
        return this.rateslider;
    }

    @Override
    public void setRate(float rate) {
        super.setRate(rate);
        this.rateslider.setValue((int)(100.0f * rate));
    }

    public JComponent getVolumePanel() {
        return this.volumeslider;
    }

    @Override
    public void setVolume(float volume) {
        super.setVolume(volume);
        this.volumeslider.setValue((int)(100.0f * volume));
    }

    public JPanel getModePanel() {
        return this.modePanel;
    }

    public SelectionButtonsPanel getSelectionButtonsPanel() {
        return this.selectionButtonsPanel;
    }

    public PlayButtonsPanel getPlayButtonsPanel() {
        return this.playButtonsPanel;
    }

    public AnnotationNavigationPanel getAnnotationNavigationPanel() {
        return this.annotationPanel;
    }

    public VolumeIconPanel getVolumeIconPanel() {
        return this.volumeIconPanel;
    }

    public JComponent getDurationPanel() {
        return this.durationPanel;
    }

    public JComponent getTimePanel() {
        return this.vm.getTimePanel();
    }

    public JPanel getSelectionPanel() {
        return this.selectionpanel;
    }

    public StepAndRepeatPanel getStepAndRepeatPanel() {
        return this.stepAndRepeatPanel;
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public void updateSelection() {
    }

    private void adjustSelection() {
        long currTime = this.getMediaTime();
        long beginTime = this.getSelectionBeginTime();
        long endTime = this.getSelectionEndTime();
        if (this.bBeginBoundaryActive) {
            beginTime = currTime;
        } else {
            endTime = currTime;
        }
        if (beginTime > endTime) {
            this.setSelection(endTime, beginTime);
            this.toggleActiveSelectionBoundary();
        } else {
            this.setSelection(beginTime, endTime);
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            return;
        }
        if (event instanceof TimeEvent && System.currentTimeMillis() - this.stopTime < 700L) {
            return;
        }
        if (event instanceof StopEvent) {
            if (!this.bLoopMode) {
                this.playingSelection = false;
            }
            this.stopTime = System.currentTimeMillis();
            if (this.isBeginBoundaryActive() && this.getMediaTime() == this.getSelectionEndTime()) {
                this.toggleActiveSelectionBoundary();
            }
        }
        if (!this.playingSelection && this.bSelectionMode) {
            this.adjustSelection();
        }
    }

    public void setPlaySelectionMode(boolean b) {
        this.playingSelection = b;
    }

    public boolean isPlaySelectionMode() {
        return this.playingSelection;
    }

    public void setLoopMode(boolean b) {
        this.bLoopMode = b;
        this.modePanel.updateLoopMode(this.bLoopMode);
    }

    public boolean getLoopMode() {
        return this.bLoopMode;
    }

    public void doToggleLoopMode() {
        this.bLoopMode = !this.bLoopMode;
    }

    public boolean getSelectionMode() {
        return this.bSelectionMode;
    }

    public void doToggleSelectionMode() {
        this.bSelectionMode = !this.bSelectionMode;
        this.modePanel.updateSelectionMode(this.bSelectionMode);
        this.getModePanel().revalidate();
    }

    public void toggleActiveSelectionBoundary() {
        this.bBeginBoundaryActive = !this.bBeginBoundaryActive;
        if (!this.playerIsPlaying()) {
            this.setMediaTime(this.getMediaTime());
        }
    }

    public boolean isBeginBoundaryActive() {
        return this.bBeginBoundaryActive;
    }

    public void startLoop(long begin, long end) {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
        this.loopThread = new LoopThread(begin, end);
        this.loopThread.start();
    }

    public void stopLoop() {
        this.setPlaySelectionMode(false);
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
    }

    public void setStepAndRepeatMode(boolean mode) {
        if (this.stepAndRepeatMode == mode) {
            return;
        }
        if (this.stepAndRepeatMode) {
            this.stepAndRepeatMode = false;
            if (this.stepThread != null) {
                try {
                    this.stepThread.interrupt();
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
            this.playButtonsPanel.setEnabled(true);
            this.selectionButtonsPanel.setEnabled(true);
            this.stepAndRepeatPanel.setPlayIcon(true);
        } else {
            this.playButtonsPanel.setEnabled(false);
            this.selectionButtonsPanel.setEnabled(false);
            this.stepAndRepeatPanel.setPlayIcon(false);
            this.stepAndRepeatMode = mode;
            this.playingSelection = false;
            this.bLoopMode = false;
            this.stepThread = new StepAndRepeatThread();
            this.stepThread.start();
        }
    }

    public boolean isStepAndRepeatMode() {
        return this.stepAndRepeatMode;
    }

    @Override
    public void preferencesChanged() {
        Float rate;
        Float volume = (Float)this.getPreference("MediaControlVolume", this.vm.getTranscription());
        if (volume != null) {
            this.setVolume(volume.floatValue());
        }
        if ((rate = (Float)this.getPreference("MediaControlRate", this.vm.getTranscription())) != null) {
            this.setRate(rate.floatValue());
        }
    }

    class StepAndRepeatThread
    extends Thread {
        private long interval = 2000L;
        private long repeats = 3L;
        private long step = 1000L;
        private long pauseBetweenLoops = 500L;
        private long begin;
        private long end;
        private long ultimateEnd;
        private long count = 0L;

        public StepAndRepeatThread() {
            this.begin = ElanMediaPlayerController.this.stepAndRepeatPanel.getBeginTime() < 0L ? ElanMediaPlayerController.this.getMediaTime() : ElanMediaPlayerController.this.stepAndRepeatPanel.getBeginTime();
            if (this.begin == ElanMediaPlayerController.this.getMediaDuration()) {
                this.begin = 0L;
            }
            this.interval = ElanMediaPlayerController.this.stepAndRepeatPanel.getIntervalDuration();
            this.end = this.begin + this.interval;
            this.repeats = ElanMediaPlayerController.this.stepAndRepeatPanel.getNumRepeats();
            this.step = ElanMediaPlayerController.this.stepAndRepeatPanel.getStepSize();
            this.pauseBetweenLoops = ElanMediaPlayerController.this.stepAndRepeatPanel.getPauseDuration();
            if (ElanMediaPlayerController.this.stepAndRepeatPanel.getEndTime() <= 0L) {
                this.ultimateEnd = ElanMediaPlayerController.this.getMediaDuration();
            } else {
                this.ultimateEnd = ElanMediaPlayerController.this.stepAndRepeatPanel.getEndTime();
                if (this.ultimateEnd < this.begin + this.interval) {
                    this.ultimateEnd = this.begin + this.interval;
                    if (this.ultimateEnd > ElanMediaPlayerController.this.getMediaDuration()) {
                        this.ultimateEnd = ElanMediaPlayerController.this.getMediaDuration();
                        this.interval = this.ultimateEnd - this.begin;
                    }
                }
            }
        }

        @Override
        public void run() {
            if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                ElanMediaPlayerController.this.playInterval(this.begin, this.end);
                while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
            while (!this.isInterrupted()) {
                if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    ElanMediaPlayerController.this.playInterval(this.begin, this.end);
                    while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                while (ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        try {
                            ElanMediaPlayerController.this.vm.getMasterMediaPlayer().stop();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.isInterrupted()) continue;
                    try {
                        ElanMediaPlayerController.this.vm.getMasterMediaPlayer().stop();
                        return;
                    }
                    catch (Exception eex) {
                    }
                }
                try {
                    Thread.sleep(this.pauseBetweenLoops);
                }
                catch (Exception ex) {
                    break;
                }
                ++this.count;
                if (this.count != this.repeats) continue;
                this.begin += this.step;
                if (this.begin >= this.ultimateEnd) break;
                this.end += this.step;
                if (this.end > this.ultimateEnd) {
                    this.end = this.ultimateEnd;
                } else if (this.ultimateEnd - this.end < this.step) {
                    this.end = this.ultimateEnd;
                }
                if (this.end - this.begin < 100L) break;
                this.count = 0L;
            }
            ElanMediaPlayerController.this.setStepAndRepeatMode(false);
        }
    }

    private class LoopThread
    extends Thread {
        private long beginTime;
        private long endTime;
        private boolean stopLoop = false;

        LoopThread(long begin, long end) {
            this.beginTime = begin;
            this.endTime = end;
        }

        public void stopLoop() {
            this.stopLoop = true;
        }

        @Override
        public void run() {
            while (!this.stopLoop && ElanMediaPlayerController.this.getLoopMode()) {
                if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    ElanMediaPlayerController.this.playInterval(this.beginTime, this.endTime);
                    while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                while (ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (!this.stopLoop) continue;
                    return;
                }
                try {
                    Thread.sleep(ElanMediaPlayerController.this.getUserTimeBetweenLoops());
                }
                catch (Exception exception) {}
            }
        }
    }
}

