/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.exmaralda;

import com.google.common.base.Splitter;
import com.google.common.collect.LinkedHashMultimap;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.CommonTimeLine;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.EVENT_MEDIUM;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Event;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.ExmaraldaBasicFactory;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.MetaInformation;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.SPEAKER_SEX;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Speaker;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TIER_TYPE;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TLI;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Tier;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.UDInformation;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.EXBResourceFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringEscapeUtils;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAExporter;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAExporterProperties;
import org.corpus_tools.salt.SALT_TYPE;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SDocumentGraph;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SFeature;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Salt2EXMARaLDAMapper
extends PepperMapperImpl {
    private static final Logger logger = LoggerFactory.getLogger(EXMARaLDAExporter.class);
    private BasicTranscription basicTranscription = null;
    private final Map<String, TLI> tLI2PointOfTimeMap = new HashMap<String, TLI>();
    private Integer numOfTiers = 0;
    public String TIER_ID_PREFIX = "TIE";
    public String TIER_NAME_TOKEN = "tok";

    public EXMARaLDAExporterProperties getProps() {
        return (EXMARaLDAExporterProperties)this.getProperties();
    }

    public void setBasicTranscription(BasicTranscription basicTranscription) {
        this.basicTranscription = basicTranscription;
    }

    public BasicTranscription getBasicTranscription() {
        return this.basicTranscription;
    }

    public DOCUMENT_STATUS mapSCorpus() {
        if (this.getResourceURI() != null) {
            File resourceFile = new File(this.getResourceURI().toFileString());
            resourceFile.mkdirs();
        }
        return DOCUMENT_STATUS.COMPLETED;
    }

    public DOCUMENT_STATUS mapSDocument() {
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (this.getResourceURI() != null) {
            File resourceFile = new File(this.getResourceURI().toFileString());
            resourceFile.getParentFile().mkdirs();
        }
        this.setBasicTranscription(ExmaraldaBasicFactory.eINSTANCE.createBasicTranscription());
        MetaInformation metaInformation = ExmaraldaBasicFactory.eINSTANCE.createMetaInformation();
        this.basicTranscription.setMetaInformation(metaInformation);
        Map<String, Speaker> speakerById = this.mapSDocument2SpeakerMeta(this.getDocument(), (List<Speaker>)this.basicTranscription.getSpeakertable());
        this.mapSDocument2MetaInfo(this.getDocument(), metaInformation, speakerById.keySet());
        this.mapMediaSourceToReferencedFile(this.getDocument().getDocumentGraph(), metaInformation);
        if (this.getDocument().getDocumentGraph().getTimeline() == null) {
            this.createTimelineFromText(this.getDocument().getDocumentGraph());
        }
        CommonTimeLine cTimeLine = ExmaraldaBasicFactory.eINSTANCE.createCommonTimeLine();
        this.basicTranscription.setCommonTimeLine(cTimeLine);
        this.map2CommonTimeLine(this.getDocument().getDocumentGraph().getTimeline(), cTimeLine);
        HashSet<Speaker> speakersWithText = new HashSet<Speaker>();
        List texts = this.getDocument().getDocumentGraph().getTextualDSs();
        if (texts != null && !texts.isEmpty()) {
            int textIdx = 0;
            for (STextualDS text : texts) {
                List tokensOfText;
                Tier tokenTier = ExmaraldaBasicFactory.eINSTANCE.createTier();
                DataSourceSequence seq = new DataSourceSequence((SSequentialDS)text, text.getStart(), text.getEnd());
                String name = text.getName();
                if (name == null || name.isEmpty() || name.startsWith("sText")) {
                    name = textIdx > 0 ? this.TIER_NAME_TOKEN + textIdx : this.TIER_NAME_TOKEN;
                }
                Speaker speaker = null;
                SFeature featSpeaker = text.getFeature(SaltUtil.createQName((String)"exmaralda", (String)"speaker"));
                if (featSpeaker != null && featSpeaker.getValue_STEXT() != null && (speaker = speakerById.get(featSpeaker.getValue_STEXT())) != null) {
                    tokenTier.setSpeaker(speaker);
                    speakersWithText.add(speaker);
                }
                if ((tokensOfText = this.getDocument().getDocumentGraph().getSortedTokenByText(text.getGraph().getTokensBySequence(seq))).isEmpty() && this.getProps().isDropEmptySpeaker().booleanValue()) {
                    if (speaker != null) {
                        speakersWithText.remove(speaker);
                    }
                } else {
                    this.basicTranscription.getTiers().add((Object)tokenTier);
                    this.mapSToken2Tier(tokensOfText, tokenTier, name);
                }
                ++textIdx;
            }
        } else {
            Tier tokenTier = ExmaraldaBasicFactory.eINSTANCE.createTier();
            this.basicTranscription.getTiers().add((Object)tokenTier);
            this.mapSToken2Tier(this.getDocument().getDocumentGraph().getTokens(), tokenTier, this.TIER_NAME_TOKEN);
        }
        if (this.getProps().isDropEmptySpeaker().booleanValue()) {
            this.basicTranscription.getSpeakertable().retainAll(speakersWithText);
        }
        ArrayList<SStructuredNode> structuredNodes = new ArrayList<SStructuredNode>();
        structuredNodes.addAll(this.getDocument().getDocumentGraph().getTokens());
        structuredNodes.addAll(this.getDocument().getDocumentGraph().getSpans());
        structuredNodes.addAll(this.getDocument().getDocumentGraph().getStructures());
        this.mapSStructuredNode2Tiers(structuredNodes, speakerById);
        SFeature featTierOrder = this.getDocument().getDocumentGraph().getFeature("exmaralda", "tier-order");
        if (featTierOrder != null) {
            List tierOrder = Splitter.on((String)",").trimResults().splitToList((CharSequence)featTierOrder.getValue().toString());
            LinkedHashMultimap tiersByDisplayName = LinkedHashMultimap.create();
            for (Tier t : this.basicTranscription.getTiers()) {
                if (t.getDisplayName() == null) {
                    tiersByDisplayName.put((Object)"", (Object)t);
                    continue;
                }
                tiersByDisplayName.put((Object)t.getDisplayName(), (Object)t);
            }
            LinkedList<Tier> newOrderedTierList = new LinkedList<Tier>();
            for (String displayName : tierOrder) {
                Collection tiers = tiersByDisplayName.removeAll((Object)displayName);
                for (Tier t : tiers) {
                    newOrderedTierList.add(t);
                }
            }
            for (Tier t : tiersByDisplayName.values()) {
                newOrderedTierList.add(t);
            }
            this.basicTranscription.getTiers().clear();
            this.basicTranscription.getTiers().addAll(newOrderedTierList);
        }
        this.saveToFile(this.basicTranscription);
        return DOCUMENT_STATUS.COMPLETED;
    }

    private STimeline createTimelineFromText(SDocumentGraph g) {
        STimeline retVal = null;
        if (g.getTimeline() == null || (Integer)g.getTimeline().getEnd() == 0) {
            STimeline sTimeline = SaltFactory.createSTimeline();
            g.addNode((Node)sTimeline);
            ArrayList sTimeRelList = new ArrayList();
            Hashtable sTimeRelTable = new Hashtable();
            for (STextualRelation sTextRel : g.getTextualRelations()) {
                STimelineRelation sTimeRel = SaltFactory.createSTimelineRelation();
                sTimeRel.setTarget((Node)sTimeline);
                sTimeRel.setSource(sTextRel.getSource());
                if (sTimeRelTable.get(sTextRel.getTarget()) == null) {
                    sTimeRelTable.put(sTextRel.getTarget(), new ArrayList());
                }
                ((List)sTimeRelTable.get(sTextRel.getTarget())).add(sTimeRel);
            }
            for (STextualDS sTextualDS : g.getTextualDSs()) {
                List rels = (List)sTimeRelTable.get(sTextualDS);
                if (rels == null) continue;
                sTimeRelList.addAll((Collection)sTimeRelTable.get(sTextualDS));
            }
            Integer pot = 0;
            for (STimelineRelation sTimeRelation : sTimeRelList) {
                sTimeRelation.setStart((Number)pot);
                Integer n = pot;
                Integer n2 = pot = Integer.valueOf(pot + 1);
                sTimeline.increasePointOfTime();
                sTimeRelation.setEnd((Number)pot);
                g.addRelation((Relation)sTimeRelation);
            }
            retVal = sTimeline;
        } else {
            retVal = g.getTimeline();
        }
        return retVal;
    }

    private void saveToFile(BasicTranscription basicTranscription) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("exb", new EXBResourceFactory());
        Resource resource = resourceSet.createResource(this.getResourceURI());
        if (resource == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot save a resource to uri '" + this.getResourceURI() + "', because the given resource is null.");
        }
        resource.getContents().add((Object)basicTranscription);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot write exmaradla basic transcription to uri '" + this.getResourceURI() + "'.", (Throwable)e);
        }
    }

    private void mapMediaSourceToReferencedFile(SDocumentGraph sDocGraph, MetaInformation metaInfo) {
        SMedialDS medialDS;
        File mediaFile;
        if (sDocGraph.getMedialDSs() != null && !sDocGraph.getMedialDSs().isEmpty() && (mediaFile = (medialDS = (SMedialDS)sDocGraph.getMedialDSs().get(0)).getMediaReference().isFile() ? new File(medialDS.getMediaReference().toFileString()) : new File(medialDS.getMediaReference().toString())).exists()) {
            String absMediaFilePath;
            try {
                absMediaFilePath = mediaFile.getCanonicalPath();
            }
            catch (Exception ex) {
                absMediaFilePath = mediaFile.getAbsolutePath();
                logger.warn("Could not get canonical path of file {}, using absolute path instead", (Object)absMediaFilePath, (Object)ex);
            }
            URI mediaLoc = URI.createFileURI((String)absMediaFilePath);
            URI baseLoc = this.getResourceURI();
            mediaLoc = mediaLoc.deresolve(baseLoc);
            metaInfo.setReferencedFile(mediaLoc.toFileString());
        }
    }

    private void mapSDocument2MetaInfo(SDocument sDoc, MetaInformation metaInfo, Set<String> excludeNamespaces) {
        for (SMetaAnnotation sMetaAnno : sDoc.getMetaAnnotations()) {
            if (sMetaAnno.getName().equalsIgnoreCase("projectName")) {
                metaInfo.setProjectName(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("transcriptionName")) {
                metaInfo.setTranscriptionName(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("referencedFile")) {
                metaInfo.setReferencedFile(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("comment")) {
                metaInfo.setComment(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("transcriptionConvention")) {
                metaInfo.setTranscriptionConvention(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getNamespace() != null && excludeNamespaces.contains(sMetaAnno.getNamespace())) continue;
            UDInformation udInfo = ExmaraldaBasicFactory.eINSTANCE.createUDInformation();
            this.mapSMetaAnnotation2UDInformation(sMetaAnno, udInfo);
            metaInfo.getUdMetaInformations().add((Object)udInfo);
        }
    }

    private Map<String, Speaker> mapSDocument2SpeakerMeta(SDocument doc, List<Speaker> speakerTable) {
        Splitter listSplitter = Splitter.on((char)',').trimResults();
        TreeMap<String, Speaker> speakerById = new TreeMap<String, Speaker>();
        for (SMetaAnnotation sMetaAnno : doc.getMetaAnnotations()) {
            String id = sMetaAnno.getNamespace();
            if (id == null) continue;
            Speaker speaker = (Speaker)speakerById.get(id);
            if (speaker == null) {
                speaker = ExmaraldaBasicFactory.eINSTANCE.createSpeaker();
                speaker.setId(id);
                speakerById.put(id, speaker);
            }
            if (sMetaAnno.getName().equalsIgnoreCase("sex")) {
                SPEAKER_SEX v = SPEAKER_SEX.get((String)sMetaAnno.getValue().toString());
                if (v == null) continue;
                speaker.setSex(v);
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("abbreviation")) {
                speaker.setAbbreviation(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("comment")) {
                speaker.setComment(sMetaAnno.getValue().toString());
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("l1")) {
                for (String l1 : listSplitter.split((CharSequence)sMetaAnno.getValue().toString())) {
                    speaker.getL1().add((Object)l1);
                }
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("l2")) {
                for (String l2 : listSplitter.split((CharSequence)sMetaAnno.getValue().toString())) {
                    speaker.getL2().add((Object)l2);
                }
                continue;
            }
            if (sMetaAnno.getName().equalsIgnoreCase("languages-used")) {
                for (String l : listSplitter.split((CharSequence)sMetaAnno.getValue().toString())) {
                    speaker.getLanguageUsed().add((Object)l);
                }
                continue;
            }
            UDInformation udInfo = ExmaraldaBasicFactory.eINSTANCE.createUDInformation();
            this.mapSMetaAnnotation2UDInformation(sMetaAnno, udInfo);
            speaker.getUdSpeakerInformations().add((Object)udInfo);
        }
        speakerTable.addAll(speakerById.values());
        return speakerById;
    }

    private void map2CommonTimeLine(STimeline sTimeline, CommonTimeLine cTimeLine) {
        boolean createFromMediaDS;
        if (sTimeline == null || sTimeline.getEnd() == null || (Integer)sTimeline.getEnd() == 0) {
            this.getDocument().getDocumentGraph().createTimeline();
            sTimeline = this.getDocument().getDocumentGraph().getTimeline();
        }
        boolean bl = createFromMediaDS = this.getDocument().getDocumentGraph().getMedialDSs() != null && !this.getDocument().getDocumentGraph().getMedialDSs().isEmpty() && !this.getDocument().getDocumentGraph().getMedialRelations().isEmpty();
        if (createFromMediaDS) {
            String TLI_id = "T";
            SMedialDS ds = (SMedialDS)this.getDocument().getDocumentGraph().getMedialDSs().get(0);
            TreeSet<Number> timePoints = new TreeSet<Number>();
            for (SRelation rel : ds.getInRelations()) {
                if (!(rel instanceof SMedialRelation)) continue;
                SMedialRelation sMedialRelation = (SMedialRelation)rel;
                timePoints.add(sMedialRelation.getStart());
                timePoints.add(sMedialRelation.getEnd());
            }
            int tIdx = 0;
            for (Double d : timePoints) {
                TLI tli = ExmaraldaBasicFactory.eINSTANCE.createTLI();
                cTimeLine.getTLIs().add((Object)tli);
                tli.setTime("" + d);
                tli.setId(TLI_id + tIdx);
                this.tLI2PointOfTimeMap.put(tli.getTime(), tli);
                ++tIdx;
            }
        } else {
            String TLI_id = "T";
            int i = 0;
            for (int j = 0; j <= (Integer)sTimeline.getEnd(); ++j) {
                TLI tli = ExmaraldaBasicFactory.eINSTANCE.createTLI();
                cTimeLine.getTLIs().add((Object)tli);
                tli.setTime(j + "");
                tli.setId(TLI_id + i);
                ++i;
                this.tLI2PointOfTimeMap.put(j + "", tli);
            }
        }
    }

    private Integer getNewNumOfTiers() {
        int num = this.numOfTiers;
        Integer n = this.numOfTiers;
        Integer n2 = this.numOfTiers = Integer.valueOf(this.numOfTiers + 1);
        return num;
    }

    private String createDisplayName(Tier tier, String annoName) {
        if (tier.getSpeaker() != null) {
            Speaker s = tier.getSpeaker();
            if (s.getAbbreviation() != null) {
                return s.getAbbreviation() + " [" + annoName + "]";
            }
            return s.getId() + " [" + annoName + "]";
        }
        return "[" + annoName + "]";
    }

    private void mapSToken2Tier(List<SToken> sTokens, Tier tier, String textName) {
        tier.setCategory(textName);
        tier.setDisplayName(this.createDisplayName(tier, textName));
        tier.setId(this.TIER_ID_PREFIX + this.getNewNumOfTiers());
        tier.setType(TIER_TYPE.T);
        for (SToken sToken : sTokens) {
            Event event = ExmaraldaBasicFactory.eINSTANCE.createEvent();
            tier.getEvents().add((Object)event);
            this.mapSToken2Event(sToken, event);
        }
    }

    private DataSourceSequence<? extends Number> getTimeOverlappedSeq(SStructuredNode sNode) {
        List mediaDSs = this.getDocument().getDocumentGraph().getMedialDSs();
        if (mediaDSs != null && !mediaDSs.isEmpty()) {
            List overlappedToken = this.getDocument().getDocumentGraph().getOverlappedTokens((SNode)sNode);
            double rangeStart = Double.MAX_VALUE;
            double rangeEnd = Double.MIN_VALUE;
            boolean foundMediaRel = false;
            for (SToken t : overlappedToken) {
                for (SRelation rel : t.getOutRelations()) {
                    if (!(rel instanceof SMedialRelation)) continue;
                    foundMediaRel = true;
                    SMedialRelation mediaRel = (SMedialRelation)rel;
                    rangeStart = Math.min((Double)mediaRel.getStart(), rangeStart);
                    rangeEnd = Math.max((Double)mediaRel.getEnd(), rangeEnd);
                }
            }
            if (!foundMediaRel) {
                return null;
            }
            return new DataSourceSequence((SSequentialDS)mediaDSs.get(0), (Number)rangeStart, (Number)rangeEnd);
        }
        List sequences = this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sNode, new SALT_TYPE[]{SALT_TYPE.STIME_OVERLAPPING_RELATION});
        if (!sequences.isEmpty()) {
            return (DataSourceSequence)sequences.get(0);
        }
        return null;
    }

    private void mapSToken2Event(SToken sToken, Event event) {
        DataSourceSequence<? extends Number> sequence = this.getTimeOverlappedSeq((SStructuredNode)sToken);
        if (sequence == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot map token to event, because there is no point of time for SToken: " + sToken.getId());
        }
        if (sequence.getStart() == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot map token to event, because start of pot for following token is empty: " + sToken.getId());
        }
        if (sequence.getEnd() == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot map token to event, because end of pot for following token is empty: " + sToken.getId());
        }
        event.setStart(this.tLI2PointOfTimeMap.get(sequence.getStart().toString()));
        event.setEnd(this.tLI2PointOfTimeMap.get(sequence.getEnd().toString()));
        event.setValue(this.stringXMLConformer(this.getDocument().getDocumentGraph().getText((SNode)sToken)));
    }

    private void mapSStructuredNode2Tiers(List<SStructuredNode> sNodes, Map<String, Speaker> speakerById) {
        TreeMap<String, Tier> annoName2Tier = new TreeMap<String, Tier>();
        for (SStructuredNode sStructuredNode : sNodes) {
            for (SAnnotation sAnno : sStructuredNode.getAnnotations()) {
                Tier currTier = null;
                if (annoName2Tier.containsKey(sAnno.getQName())) {
                    currTier = (Tier)annoName2Tier.get(sAnno.getQName());
                } else {
                    currTier = ExmaraldaBasicFactory.eINSTANCE.createTier();
                    currTier.setCategory(sAnno.getName());
                    currTier.setType(TIER_TYPE.A);
                    List seqList = this.getDocument().getDocumentGraph().getOverlappedDataSourceSequence((SNode)sStructuredNode, new SALT_TYPE[]{SALT_TYPE.STEXT_OVERLAPPING_RELATION});
                    if (seqList != null) {
                        for (DataSourceSequence seq : seqList) {
                            STextualDS ds;
                            SFeature featSpeaker;
                            if (!(seq.getDataSource() instanceof STextualDS) || (featSpeaker = (ds = (STextualDS)seq.getDataSource()).getFeature("exmaralda", "speaker")) == null || !speakerById.containsKey(featSpeaker.getValue_STEXT())) continue;
                            currTier.setSpeaker(speakerById.get(featSpeaker.getValue_STEXT()));
                        }
                    }
                    currTier.setDisplayName(this.createDisplayName(currTier, sAnno.getName()));
                    annoName2Tier.put(sAnno.getQName(), currTier);
                }
                if (sAnno.getQName().equalsIgnoreCase("medium") || sAnno.getQName().equalsIgnoreCase("url")) continue;
                Event event = ExmaraldaBasicFactory.eINSTANCE.createEvent();
                currTier.getEvents().add((Object)event);
                SAnnotation sMediumAnno = sStructuredNode.getAnnotation("medium");
                SAnnotation sURLAnno = sStructuredNode.getAnnotation("url");
                if (sMediumAnno != null) {
                    event.setMedium(EVENT_MEDIUM.get((String)sMediumAnno.getValue().toString()));
                }
                if (sURLAnno != null) {
                    event.setUrl(sMediumAnno.getValue().toString());
                }
                this.mapSStructuredNode2Event(sStructuredNode, sAnno.getQName(), event);
            }
        }
        for (Map.Entry entry : annoName2Tier.entrySet()) {
            ((Tier)entry.getValue()).setId(this.TIER_ID_PREFIX + this.getNewNumOfTiers());
            this.basicTranscription.getTiers().add(entry.getValue());
        }
    }

    private void mapSStructuredNode2Event(SStructuredNode sNode, String sAnnotationQName, Event event) {
        DataSourceSequence<? extends Number> sequence = this.getTimeOverlappedSeq(sNode);
        if (sequence == null || sequence.getStart() == null || sequence.getEnd() == null) {
            logger.error("Cannot map node {} because it does not cover any tokens", (Object)sNode.getId());
            return;
        }
        event.setStart(this.tLI2PointOfTimeMap.get(sequence.getStart().toString()));
        event.setEnd(this.tLI2PointOfTimeMap.get(sequence.getEnd().toString()));
        SAnnotation sAnno = sNode.getAnnotation(sAnnotationQName);
        if (sAnno != null) {
            event.setValue(this.stringXMLConformer(sAnno.getValue_STEXT()));
        }
        for (SMetaAnnotation sMetaAnno : sNode.getMetaAnnotations()) {
            UDInformation udInfo = ExmaraldaBasicFactory.eINSTANCE.createUDInformation();
            this.mapSMetaAnnotation2UDInformation(sMetaAnno, udInfo);
            event.getUdInformations().add((Object)udInfo);
        }
    }

    private void mapSMetaAnnotation2UDInformation(SMetaAnnotation sMetaAnno, UDInformation udInfo) {
        if (sMetaAnno.getName() != null && !sMetaAnno.getName().equals("")) {
            udInfo.setAttributeName(this.stringXMLConformer(sMetaAnno.getName()));
            udInfo.setValue(this.stringXMLConformer(sMetaAnno.getValue_STEXT()));
        }
    }

    private String stringXMLConformer(String uncleanedString) {
        String retString = uncleanedString;
        if (retString != null) {
            retString = StringEscapeUtils.escapeXml((String)uncleanedString);
            retString = retString.replace("\u00c4", "&#196;");
            retString = retString.replace("\u00d6", "&#214;");
            retString = retString.replace("\u00dc", "&#220;");
            retString = retString.replace("\u00e4", "&#228;");
            retString = retString.replace("\u00f6", "&#246;");
            retString = retString.replace("\u00fc", "&#252;");
            retString = retString.replace("\u00df", "&#223;");
        }
        return retString;
    }
}

