/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.exmaralda;

import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corpus_tools.pepper.modules.PepperModuleProperties;
import org.corpus_tools.pepper.modules.PepperModuleProperty;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAImporter;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.core.SLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXMARaLDAImporterProperties
extends PepperModuleProperties {
    private static final Logger logger = LoggerFactory.getLogger(EXMARaLDAImporter.class);
    @Deprecated
    public static final String PROP_TOKEN_TIER = "salt.token";
    public static final String PROP_TOKENSEP = "salt.tokenSeparator";
    public static final String PROP_TIERMERGE = "salt.tierMerge";
    public static final String PROP_LAYERS_SMALL = "salt.layers";
    public static final String PROP_LAYERS_BIG = "salt.Layers";
    public static final String PROP_URI_ANNOTATION = "salt.URIAnnotation";
    public static final String PROP_SALT_SEMANTICS_POS = "saltSemantics.POS";
    public static final String PROP_SALT_SEMANTICS_LEMMA = "saltSemantics.LEMMA";
    public static final String PROP_SALT_SEMANTICS_WORD = "saltSemantics.WORD";
    public static final String PROP_CLEAN_MODEL = "cleanModel";
    public static final String PROP_TRIM_EVENTS = "trimEvents";
    public static final String PROP_PARSE_NAMESPACE = "parseNamespace";
    public static final String PROP_MAP_TIMELINE = "mapTimeline";
    public static final String PROP_MAP_DESCRIPTIONS = "mapDescriptions";
    public static final String PROP_MAP_SPEAKER_METADATA = "mapSpeakerMetadata";
    private static final String TIER_NAME_DESC = "(_|-|[A-Z]|[a-z]|[0-9])+";
    private static final String SIMPLE_TIER_LIST_DESC = "\\{(_|-|[A-Z]|[a-z]|[0-9])+(,\\s?(_|-|[A-Z]|[a-z]|[0-9])+)*\\}";
    private static final String LAYER_NAME_DESC = "(_|-|[A-Z]|[a-z]|[0-9])+";
    private static final String SIMPLE_LAYER_DESC = "\\{(_|-|[A-Z]|[a-z]|[0-9])+\\{(_|-|[A-Z]|[a-z]|[0-9])+(,\\s?(_|-|[A-Z]|[a-z]|[0-9])+)*\\}\\}";

    public EXMARaLDAImporterProperties() {
        this.addProperty(new PepperModuleProperty(PROP_TOKEN_TIER, String.class, "With this property you can mark the Tier object which shall be interpreted as the one containing the tokenization and the primary text.", false));
        this.addProperty(new PepperModuleProperty(PROP_TOKENSEP, String.class, "With this property you can set a single sign or a sequence of signs which shall be used between the concatenation of event values representing the primary data.", false));
        this.addProperty(new PepperModuleProperty(PROP_TIERMERGE, String.class, "In EXMARaLDA there is just one value per each Event object. When mapping those data to Salt, this restriction results, that a SSpan or SToken object will be created for each Event object. To avoid this, you can mark a sequence of sets of tiers to map them to a single SSpan or SToken object in Salt.", false));
        this.addProperty(new PepperModuleProperty(PROP_LAYERS_SMALL, String.class, "With this property you can use the layer mechanism of Salt. This means, with this property, you can map all SToken or SSpan object caused by Event objects to an SLayer object. You can also group SToken or SSpan coming from Event objects contained in several Tier objects to the same SLayer object.", false));
        this.addProperty(new PepperModuleProperty(PROP_LAYERS_BIG, String.class, "With this property you can use the layer mechanism of Salt. This means, with this property, you can map all SToken or SSpan object caused by Event objects to an SLayer object. You can also group SToken or SSpan coming from Event objects contained in several Tier objects to the same SLayer object.", false));
        this.addProperty(new PepperModuleProperty(PROP_URI_ANNOTATION, String.class, "With the property salt.URIAnnotation, you can mark a Tier object containing annotations, which are references in URI notation and are not simple String values. When mapping the data to Salt the resulting SAnnotation.sValue objects will be typed as URI values, so that each interpreting tool can interpret them as references.", false));
        this.addProperty(new PepperModuleProperty(PROP_SALT_SEMANTICS_POS, String.class, "You can influence the creation of objects in Salt to have a more semantic typing when mapping data to Salt. Here we provide three properties which can be used for a closer definition or typing of SAnnotation, SToken or SSpan objects conform to ISOCat1. This can be important in the case of a further processing with Pepper. Some modules exist, which only can deal with semantical enriched data for example they need a special kind of annotation like part-of-speech for their processing.", false));
        this.addProperty(new PepperModuleProperty(PROP_SALT_SEMANTICS_LEMMA, String.class, "You can influence the creation of objects in Salt to have a more semantic typing when mapping data to Salt. Here we provide three properties which can be used for a closer definition or typing of SAnnotation, SToken or SSpan objects conform to ISOCat1. This can be important in the case of a further processing with Pepper. Some modules exist, which only can deal with semantical enriched data for example they need a special kind of annotation like part-of-speech for their processing.", false));
        this.addProperty(new PepperModuleProperty(PROP_SALT_SEMANTICS_WORD, String.class, "You can influence the creation of objects in Salt to have a more semantic typing when mapping data to Salt. Here we provide three properties which can be used for a closer definition or typing of SAnnotation, SToken or SSpan objects conform to ISOCat1. This can be important in the case of a further processing with Pepper. Some modules exist, which only can deal with semantical enriched data for example they need a special kind of annotation like part-of-speech for their processing.", false));
        this.addProperty(new PepperModuleProperty(PROP_CLEAN_MODEL, Boolean.class, "....", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_TRIM_EVENTS, Boolean.class, "When this property is true, all events in exmaralda are trimmed before they are mapped to Salt. That means for instance trailing blanks are removed. ", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_PARSE_NAMESPACE, Boolean.class, "Parse the qualified annotation name including the namespace (e.g. myns::annoname) from the category name.", (Object)false, false));
        this.addProperty(new PepperModuleProperty(PROP_MAP_TIMELINE, Boolean.class, "Import the EXMARaLDA timeline as Salt STimeline", (Object)true, false));
        this.addProperty(PepperModuleProperty.create().withName(PROP_MAP_DESCRIPTIONS).withType(Boolean.class).withDescription("Map tiers of the type \\\"Description\\\"").withDefaultValue((Object)true).build());
        this.addProperty(PepperModuleProperty.create().withName(PROP_MAP_SPEAKER_METADATA).withType(Boolean.class).withDescription("Import the metadata of the speaker").withDefaultValue((Object)true).build());
    }

    @Deprecated
    public Set<String> getTokenTiers() {
        String prop = (String)this.getProperty(PROP_TOKEN_TIER).getValue();
        LinkedHashSet<String> tokenTiers = new LinkedHashSet<String>();
        if (prop != null && !prop.isEmpty()) {
            if (prop.startsWith("{")) {
                String[] splitted;
                prop = prop.replace("{", "").replace("}", "");
                for (String s : splitted = prop.split(",")) {
                    tokenTiers.add(s.trim());
                }
            } else {
                tokenTiers.add(prop.trim());
            }
        }
        return tokenTiers;
    }

    public String getTokenSeparator() {
        return (String)this.getProperty(PROP_TOKENSEP).getValue();
    }

    public String getTierMerge() {
        return (String)this.getProperty(PROP_TIERMERGE).getValue();
    }

    public String getURIAnnotation() {
        return (String)this.getProperty(PROP_URI_ANNOTATION).getValue();
    }

    public String getPOS() {
        return (String)this.getProperty(PROP_SALT_SEMANTICS_POS).getValue();
    }

    public String getLemma() {
        return (String)this.getProperty(PROP_SALT_SEMANTICS_LEMMA).getValue();
    }

    public String getWord() {
        return (String)this.getProperty(PROP_SALT_SEMANTICS_WORD).getValue();
    }

    public Boolean getCleanModel() {
        return (Boolean)this.getProperty(PROP_CLEAN_MODEL).getValue();
    }

    public Boolean isTrimEvents() {
        return (Boolean)this.getProperty(PROP_TRIM_EVENTS).getValue();
    }

    public Boolean isParseNamespace() {
        return (Boolean)this.getProperty(PROP_PARSE_NAMESPACE).getValue();
    }

    public Boolean isMapTimeline() {
        return (Boolean)this.getProperty(PROP_MAP_TIMELINE).getValue();
    }

    public Boolean isMapDescriptions() {
        return (Boolean)this.getProperty(PROP_MAP_DESCRIPTIONS).getValue();
    }

    public Boolean isMapSpeakerMetadata() {
        return (Boolean)this.getProperty(PROP_MAP_SPEAKER_METADATA).getValue();
    }

    public Map<String, SLayer> getTier2SLayers() {
        Hashtable<String, SLayer> tierNames2SLayers = new Hashtable<String, SLayer>();
        String tier2SLayerStr = (String)this.getProperty(PROP_LAYERS_SMALL).getValue();
        if (tier2SLayerStr == null) {
            tier2SLayerStr = (String)this.getProperty(PROP_LAYERS_BIG).getValue();
        }
        if (tier2SLayerStr != null && !tier2SLayerStr.trim().isEmpty()) {
            char[] tier2SLayerChar = tier2SLayerStr.toCharArray();
            int numberOfOpeningBrackets = 0;
            int numberOfClosingBrackets = 0;
            for (int i = 0; i < tier2SLayerChar.length; ++i) {
                if (tier2SLayerChar.equals(Character.valueOf('{'))) {
                    ++numberOfOpeningBrackets;
                    continue;
                }
                if (!tier2SLayerChar.equals(Character.valueOf('}'))) continue;
                ++numberOfClosingBrackets;
            }
            if (numberOfClosingBrackets != numberOfOpeningBrackets) {
                throw new PepperModuleException("Cannot import the given data, because property file contains a corrupt value for property 'salt.Layers'. Please check the breckets you used.");
            }
            tier2SLayerStr = tier2SLayerStr.replace(" ", "");
            Pattern pattern = Pattern.compile(SIMPLE_LAYER_DESC, 2);
            Matcher matcher = pattern.matcher(tier2SLayerStr);
            while (matcher.find()) {
                String[] tierNames = null;
                String tierNameList = null;
                Pattern pattern1 = Pattern.compile(SIMPLE_TIER_LIST_DESC, 2);
                Matcher matcher1 = pattern1.matcher(matcher.group());
                while (matcher1.find()) {
                    tierNameList = matcher1.group();
                    tierNames = tierNameList.replace("}", "").replace("{", "").split(",");
                }
                String sLayerName = matcher.group().replace(tierNameList, "").replace("}", "").replace("{", "");
                SLayer sLayer = SaltFactory.createSLayer();
                sLayer.setName(sLayerName);
                for (String tierName : tierNames) {
                    tierNames2SLayers.put(tierName, sLayer);
                }
            }
            if (tierNames2SLayers.size() == 0) {
                logger.warn("[EXMARaLDAImporter] It seems as if there is a syntax failure in the given special-param file in property 'salt.Layers'. A value is given, but the layers to named could not have been extracted.");
            }
        }
        return tierNames2SLayers;
    }
}

