/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.exmaralda;

import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.resources.EXBResourceFactory;
import org.corpus_tools.pepper.core.SelfTestDesc;
import org.corpus_tools.pepper.impl.PepperImporterImpl;
import org.corpus_tools.pepper.modules.PepperImporter;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDA2SaltMapper;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAImporterProperties;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.graph.Identifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.osgi.service.component.annotations.Component;

@Component(name="EXMARaLDAImporterJavaComponent", factory="PepperImporterComponentFactory")
public class EXMARaLDAImporter
extends PepperImporterImpl
implements PepperImporter {
    public static final String[] EXMARALDA_FILE_ENDINGS = new String[]{"exb", "xml", "xmi", "exmaralda"};
    private ResourceSet resourceSet = null;

    public EXMARaLDAImporter() {
        this.setName("EXMARaLDAImporter");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"https://github.com/korpling/pepperModules-EXMARaLDAModules"));
        this.setDesc("This importer transforms data in the exb format of EXMARaLDA to a Salt model. ");
        this.setProperties(new EXMARaLDAImporterProperties());
        this.addSupportedFormat("EXMARaLDA", "1.0", null);
        for (String ending : EXMARALDA_FILE_ENDINGS) {
            this.getDocumentEndings().add(ending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            EXMARaLDAImporter eXMARaLDAImporter = this;
            synchronized (eXMARaLDAImporter) {
                if (this.resourceSet == null) {
                    this.resourceSet = new ResourceSetImpl();
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("exmaralda", new XMIResourceFactoryImpl());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("exb", new EXBResourceFactory());
                    this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new EXBResourceFactory());
                }
            }
        }
        return this.resourceSet;
    }

    public SelfTestDesc getSelfTestDesc() {
        return new SelfTestDesc(this.getResources().appendSegment("selfTests").appendSegment("exmaraldaImporter").appendSegment("in"), this.getResources().appendSegment("selfTests").appendSegment("exmaraldaImporter").appendSegment("expected"));
    }

    public Double isImportable(URI corpusPath) {
        Double retValue = 0.0;
        for (String content : this.sampleFileContent(corpusPath, EXMARALDA_FILE_ENDINGS)) {
            if (!content.contains("<?xml version=\"1.0\"") || !content.contains("<basic-transcription>")) continue;
            retValue = 1.0;
            break;
        }
        return retValue;
    }

    public PepperMapper createPepperMapper(Identifier sElementId) {
        EXMARaLDA2SaltMapper mapper = new EXMARaLDA2SaltMapper();
        URI resourcePath = (URI)this.getIdentifier2ResourceTable().get(sElementId);
        if (sElementId.getIdentifiableElement() instanceof SDocument) {
            mapper.setResourceURI(resourcePath);
            mapper.setResourceSet(this.getResourceSet());
        }
        return mapper;
    }
}

