/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.peppermodules.exmaralda;

import com.google.common.base.Joiner;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.BasicTranscription;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.CommonTimeLine;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Event;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.ExmaraldaBasicFactory;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Speaker;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TIER_TYPE;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.TLI;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.Tier;
import de.hu_berlin.german.korpling.saltnpepper.misc.exmaralda.UDInformation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleDataException;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleException;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAImporter;
import org.corpus_tools.peppermodules.exmaralda.EXMARaLDAImporterProperties;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDocument;
import org.corpus_tools.salt.common.SMedialDS;
import org.corpus_tools.salt.common.SMedialRelation;
import org.corpus_tools.salt.common.SSequentialDS;
import org.corpus_tools.salt.common.SSequentialRelation;
import org.corpus_tools.salt.common.SSpan;
import org.corpus_tools.salt.common.SSpanningRelation;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.STextualRelation;
import org.corpus_tools.salt.common.STimeline;
import org.corpus_tools.salt.common.STimelineRelation;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SAnnotationContainer;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SMetaAnnotation;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.graph.Layer;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.corpus_tools.salt.semantics.SPOSAnnotation;
import org.corpus_tools.salt.semantics.SWordAnnotation;
import org.corpus_tools.salt.util.DataSourceSequence;
import org.corpus_tools.salt.util.SaltUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EXMARaLDA2SaltMapper
extends PepperMapperImpl
implements PepperMapper {
    private static final Logger logger = LoggerFactory.getLogger(EXMARaLDAImporter.class);
    private BasicTranscription basicTranscription = null;
    private ResourceSet resourceSet = null;
    private Map<String, SLayer> tierNames2SLayers = null;
    private final Map<SToken, Speaker> token2Speaker = new Hashtable<SToken, Speaker>();
    private List<List<Tier>> tierCollection = null;

    public void setBasicTranscription(BasicTranscription basicTranscription) {
        this.basicTranscription = basicTranscription;
    }

    public BasicTranscription getBasicTranscription() {
        return this.basicTranscription;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public EXMARaLDAImporterProperties getProps() {
        return (EXMARaLDAImporterProperties)this.getProperties();
    }

    public DOCUMENT_STATUS mapSDocument() {
        Tier eTextTier;
        if (this.getDocument().getDocumentGraph() == null) {
            this.getDocument().setDocumentGraph(SaltFactory.createSDocumentGraph());
        }
        if (this.getBasicTranscription() == null) {
            Resource resource = this.getResourceSet().createResource(this.getResourceURI());
            if (resource == null) {
                throw new PepperModuleDataException((PepperMapper)this, "Cannot load the exmaralda file: " + this.getResourceURI() + ", becuase the resource is null.");
            }
            try {
                resource.load(null);
            }
            catch (IOException e) {
                throw new PepperModuleDataException((PepperMapper)this, "Cannot load the exmaralda file: " + this.getResourceURI() + ".", (Throwable)e);
            }
            BasicTranscription basicTranscription = null;
            basicTranscription = (BasicTranscription)resource.getContents().get(0);
            this.setBasicTranscription(basicTranscription);
        }
        this.addProgress(0.5);
        this.getDocument().getDocumentGraph().setId(this.getDocument().getId());
        this.tierNames2SLayers = this.getProps().getTier2SLayers();
        if (this.tierNames2SLayers.size() > 0) {
            for (SLayer sLayer : this.tierNames2SLayers.values()) {
                this.getDocument().getDocumentGraph().addLayer((Layer)sLayer);
            }
        }
        this.setBasicTranscription(this.basicTranscription);
        this.computeTierCollection();
        if (this.basicTranscription.getMetaInformation() != null) {
            this.mapMetaInformation2SDocument(this.basicTranscription, this.getDocument());
        }
        if (this.getProps().isMapSpeakerMetadata().booleanValue()) {
            for (Iterator speaker : this.basicTranscription.getSpeakertable()) {
                this.mapSpeaker2SMetaAnnotation((Speaker)speaker, this.getDocument());
            }
        }
        LinkedList<String> tierDisplayNames = new LinkedList<String>();
        for (Tier t : this.basicTranscription.getTiers()) {
            if (t.getDisplayName() == null) continue;
            tierDisplayNames.add(t.getDisplayName());
        }
        this.getDocument().getDocumentGraph().createFeature("exmaralda", "tier-order", (Object)Joiner.on((char)',').join(tierDisplayNames));
        STimeline sTimeline = SaltFactory.createSTimeline();
        this.getDocument().getDocumentGraph().setTimeline(sTimeline);
        this.mapCommonTimeLine2STimeine(this.basicTranscription.getCommonTimeLine(), sTimeline);
        Set<String> tokenTiers = this.getProps().getTokenTiers();
        LinkedHashMap<Tier, List<Tier>> allTextSlots = new LinkedHashMap<Tier, List<Tier>>();
        for (List<Tier> list : this.tierCollection) {
            eTextTier = null;
            for (Tier tier : list) {
                if (tokenTiers.size() > 0 && tokenTiers.contains(tier.getCategory().trim())) {
                    eTextTier = tier;
                    break;
                }
                if (!tier.getType().getName().trim().equalsIgnoreCase(TIER_TYPE.T.toString())) continue;
                eTextTier = tier;
                break;
            }
            if (eTextTier == null) continue;
            allTextSlots.put(eTextTier, list);
        }
        if (allTextSlots.size() == 0) {
            throw new PepperModuleDataException((PepperMapper)this, "Cannot convert given exmaralda file '" + this.getResourceURI() + "', because no textual source layer was found.");
        }
        if ("true".equalsIgnoreCase(this.getProps().getCleanModel().toString())) {
            this.cleanModel(this.basicTranscription, allTextSlots.keySet());
        }
        for (Map.Entry entry : allTextSlots.entrySet()) {
            eTextTier = (Tier)entry.getKey();
            List textSlot = (List)entry.getValue();
            STextualDS sTextDS = SaltFactory.createSTextualDS();
            logger.debug("[EXMARaLDAImporter] create primary data for tier '{}'.", (Object)eTextTier.getCategory());
            sTextDS.setName(eTextTier.getCategory());
            Speaker speaker = eTextTier.getSpeaker();
            if (speaker != null) {
                sTextDS.createFeature("exmaralda", "speaker", (Object)(speaker.getAbbreviation() == null ? speaker.getId() : speaker.getAbbreviation()));
            }
            this.getDocument().getDocumentGraph().addNode((Node)sTextDS);
            this.mapTier2STextualDS(eTextTier, sTextDS, textSlot);
        }
        this.tierCollection.removeAll(allTextSlots.values());
        for (List list : this.tierCollection) {
            this.mapTiers2SNodes(list);
        }
        if (!this.getProps().isMapTimeline().booleanValue() && sTimeline != null) {
            this.getDocument().getDocumentGraph().removeNode((Node)sTimeline);
            this.getDocument().getDocumentGraph().setTimeline(null);
        }
        this.setProgress(1.0);
        return DOCUMENT_STATUS.COMPLETED;
    }

    public void cleanModel(BasicTranscription basicTranscription, Collection<Tier> tokenTiers) {
        for (Tier tokenTier : tokenTiers) {
            if (tokenTier.getEvents().size() >= basicTranscription.getCommonTimeLine().getTLIs().size() - 1) continue;
            int insertPos = 0;
            for (TLI tli : basicTranscription.getCommonTimeLine().getTLIs()) {
                int tliPos = basicTranscription.getCommonTimeLine().getTLIs().indexOf((Object)tli);
                if (tliPos == basicTranscription.getCommonTimeLine().getTLIs().size() - 1) continue;
                boolean hasEvent = false;
                for (Event event : tli.getStartingEvents()) {
                    if (!tokenTier.equals(event.getTier())) continue;
                    hasEvent = true;
                    break;
                }
                if (!hasEvent) {
                    Event event = ExmaraldaBasicFactory.eINSTANCE.createEvent();
                    event.setValue(" ");
                    event.setStart(tli);
                    int endTliPos = basicTranscription.getCommonTimeLine().getTLIs().indexOf((Object)tli) + 1;
                    event.setEnd((TLI)basicTranscription.getCommonTimeLine().getTLIs().get(endTliPos));
                    tokenTier.getEvents().add(insertPos, (Object)event);
                }
                ++insertPos;
            }
        }
    }

    private void mapMetaInformation2SDocument(BasicTranscription basicTranscription, SDocument sDoc) {
        SMetaAnnotation sMetaAnno;
        if (basicTranscription.getMetaInformation().getProjectName() != null && !basicTranscription.getMetaInformation().getProjectName().isEmpty()) {
            sDoc.setName(basicTranscription.getMetaInformation().getProjectName());
        }
        if (basicTranscription.getMetaInformation().getTranscriptionName() != null && !basicTranscription.getMetaInformation().getTranscriptionName().isEmpty()) {
            sMetaAnno = SaltFactory.createSMetaAnnotation();
            sMetaAnno.setName("transcriptionName");
            sMetaAnno.setValue((Object)basicTranscription.getMetaInformation().getTranscriptionName());
            sDoc.addMetaAnnotation(sMetaAnno);
        }
        if (basicTranscription.getMetaInformation().getReferencedFile() != null) {
            URI audioURI = URI.createURI((String)basicTranscription.getMetaInformation().getReferencedFile());
            File audioFile = null;
            if (audioURI != null) {
                audioFile = "file".equals(audioURI.scheme()) && !audioURI.scheme().isEmpty() ? new File(audioURI.toFileString()) : new File(audioURI.toString());
            }
            if (audioFile == null || !audioFile.exists()) {
                logger.warn("[EXMARaLDAImporter] The file refered in exmaralda model '" + audioURI + "' does not exist and cannot be mapped to a salt model. It will be ignored.");
            } else {
                SMedialDS sAudioDS = SaltFactory.createSMedialDS();
                sAudioDS.setMediaReference(URI.createFileURI((String)audioFile.getPath()));
                sDoc.getDocumentGraph().addNode((Node)sAudioDS);
            }
        }
        if (basicTranscription.getMetaInformation().getComment() != null && !basicTranscription.getMetaInformation().getComment().isEmpty()) {
            sMetaAnno = SaltFactory.createSMetaAnnotation();
            sMetaAnno.setName("comment");
            sMetaAnno.setValue((Object)basicTranscription.getMetaInformation().getComment());
            sDoc.addMetaAnnotation(sMetaAnno);
        }
        if (basicTranscription.getMetaInformation().getTranscriptionConvention() != null && !basicTranscription.getMetaInformation().getTranscriptionConvention().isEmpty()) {
            sMetaAnno = SaltFactory.createSMetaAnnotation();
            sMetaAnno.setName("transcriptionConvention");
            sMetaAnno.setValue((Object)basicTranscription.getMetaInformation().getTranscriptionConvention());
            sDoc.addMetaAnnotation(sMetaAnno);
        }
        if (basicTranscription.getMetaInformation().getUdMetaInformations() != null) {
            this.mapUDInformations2SAnnotationContainer((List<UDInformation>)basicTranscription.getMetaInformation().getUdMetaInformations(), (SAnnotationContainer)sDoc);
        }
    }

    private void mapSpeaker2SMetaAnnotation(Speaker speaker, SDocument sDocument) {
        if (sDocument == null) {
            throw new PepperModuleDataException((PepperMapper)this, "Exception in method 'mapSpeaker2SMetaAnnotation()'. The given SDocument-object is null. Exception occurs in file '" + this.getResourceURI() + "'.");
        }
        if (speaker != null && speaker.getUdSpeakerInformations() != null) {
            Object namespace;
            String namespace2;
            if (speaker.getAbbreviation() != null && !speaker.getAbbreviation().isEmpty()) {
                namespace2 = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation(namespace2, "abbreviation", (Object)speaker.getAbbreviation().toString());
            }
            if (speaker.getSex() != null) {
                namespace2 = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation(namespace2, "sex", (Object)speaker.getSex().toString());
            }
            if (speaker.getLanguageUsed() != null && speaker.getLanguageUsed().size() > 0) {
                StringBuilder langUsedStr = null;
                for (String langUsed : speaker.getLanguageUsed()) {
                    if (langUsedStr == null) {
                        langUsedStr = new StringBuilder();
                        langUsedStr.append(langUsed);
                        continue;
                    }
                    langUsedStr.append(", " + langUsed);
                }
                namespace = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation((String)namespace, "languages-used", (Object)langUsedStr.toString());
            }
            if (speaker.getL1() != null && speaker.getL1().size() > 0) {
                StringBuilder l1Str = null;
                for (String l1 : speaker.getL1()) {
                    if (l1Str == null) {
                        l1Str = new StringBuilder();
                        l1Str.append(l1);
                        continue;
                    }
                    l1Str.append(", " + l1);
                }
                namespace = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation((String)namespace, "l1", (Object)l1Str.toString());
            }
            if (speaker.getL2() != null && speaker.getL2().size() > 0) {
                StringBuilder l2Str = null;
                for (String l2 : speaker.getL2()) {
                    if (l2Str == null) {
                        l2Str = new StringBuilder();
                        l2Str.append(l2);
                        continue;
                    }
                    l2Str.append(", " + l2);
                }
                namespace = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation((String)namespace, "l2", (Object)l2Str.toString());
            }
            if (speaker.getComment() != null && !speaker.getComment().isEmpty()) {
                namespace2 = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sDocument.createMetaAnnotation(namespace2, "comment", (Object)speaker.getComment());
            }
            for (UDInformation udInfo : speaker.getUdSpeakerInformations()) {
                SMetaAnnotation sMetaAnno = null;
                sMetaAnno = SaltFactory.createSMetaAnnotation();
                String namespace3 = speaker.getAbbreviation() != null ? speaker.getAbbreviation() : speaker.getId();
                sMetaAnno.setNamespace(namespace3);
                sMetaAnno.setName(udInfo.getAttributeName());
                sMetaAnno.setValue((Object)udInfo.getValue());
                if (sDocument.getMetaAnnotation(sMetaAnno.getQName()) != null) continue;
                sDocument.addMetaAnnotation(sMetaAnno);
            }
        }
    }

    private void mapUDInformations2SAnnotationContainer(List<UDInformation> udInformations, SAnnotationContainer sOwner) {
        SMetaAnnotation sMetaAnno = null;
        for (UDInformation udInfo : udInformations) {
            sMetaAnno = SaltFactory.createSMetaAnnotation();
            sMetaAnno.setName(udInfo.getAttributeName());
            sMetaAnno.setValue((Object)udInfo.getValue());
            sOwner.addMetaAnnotation(sMetaAnno);
        }
    }

    public void computeTierCollection() {
        this.tierCollection = new ArrayList<List<Tier>>();
        if (this.getProps().getTierMerge() != null && !this.getProps().getTierMerge().isEmpty()) {
            String[] slotStrings = this.getProps().getTierMerge().split("}");
            for (String string : slotStrings) {
                String string2 = string.replace("{", "");
                if (string2.isEmpty()) continue;
                String[] stringArray = string2.split(",");
                ArrayList<Tier> slot = new ArrayList<Tier>();
                this.tierCollection.add(slot);
                for (String tierCat : stringArray) {
                    tierCat = tierCat.trim();
                    for (Tier tier : this.getBasicTranscription().getTiers()) {
                        if (tier.getCategory() == null) {
                            throw new PepperModuleDataException((PepperMapper)this, "Cannot convert given exmaralda file '" + this.getResourceURI() + "', because there is a <tier> element ('id=\"" + tier.getId() + "\"') without a @category attribute.");
                        }
                        if (!tier.getCategory().equalsIgnoreCase(tierCat)) continue;
                        slot.add(tier);
                    }
                }
            }
            for (Tier tier1 : this.getBasicTranscription().getTiers()) {
                boolean found = false;
                for (List<Tier> list : this.tierCollection) {
                    for (Tier tier2 : list) {
                        if (!tier1.equals(tier2)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                ArrayList<Tier> arrayList = new ArrayList<Tier>();
                arrayList.add(tier1);
                this.tierCollection.add(arrayList);
            }
        } else {
            for (Tier tier : this.getBasicTranscription().getTiers()) {
                ArrayList<Tier> slot = new ArrayList<Tier>();
                slot.add(tier);
                this.tierCollection.add(slot);
            }
        }
    }

    private void mapTiers2SNodes(List<Tier> slot) {
        block0: for (Tier tier : slot) {
            if (tier.getType() == TIER_TYPE.D && !this.getProps().isMapDescriptions().booleanValue()) continue;
            logger.debug("[EXMARaLDAImporter] mapping tier '{}'. ", (Object)tier.getCategory());
            SLayer sLayer = null;
            if (this.tierNames2SLayers != null) {
                sLayer = this.tierNames2SLayers.get(tier.getCategory());
            }
            for (Event eEvent : tier.getEvents()) {
                SSpan sSpan = SaltFactory.createSSpan();
                this.getDocument().getDocumentGraph().addNode((Node)sSpan);
                this.mapEvent2SNode(tier, eEvent, (SNode)sSpan);
                if (sLayer != null) {
                    sSpan.addLayer((Layer)sLayer);
                }
                this.mapSStructuredNode2SemanticAnnotation(tier, (SStructuredNode)sSpan);
                this.mapUDInformations2SAnnotationContainer((List<UDInformation>)eEvent.getUdInformations(), (SAnnotationContainer)sSpan);
                Integer startPos = this.getBasicTranscription().getCommonTimeLine().getTLIs().indexOf((Object)eEvent.getStart());
                if (startPos < 0) {
                    if (this.getBasicTranscription().getCommonTimeLine().getTLIs().contains((Object)eEvent.getStart())) {
                        logger.warn("[EXMARaLDAImporter] Can not map an event '" + eEvent.getValue() + "' of tier '" + tier.getCategory() + "' because its start value reffering to timeline is less than 0.");
                        continue block0;
                    }
                    logger.warn("[EXMARaLDAImporter] Can not map an event '" + eEvent.getValue() + "' of tier '" + tier.getCategory() + "' because this event is not connected to the timeline.");
                    continue block0;
                }
                Integer endPos = this.getBasicTranscription().getCommonTimeLine().getTLIs().indexOf((Object)eEvent.getEnd());
                if (endPos < 0) {
                    if (this.getBasicTranscription().getCommonTimeLine().getTLIs().contains((Object)eEvent.getEnd())) {
                        logger.warn("[EXMARaLDAImporter] Can not map an event '" + eEvent.getValue() + "' of tier " + tier.getCategory() + "' because its end value reffering to timeline is less than 0.");
                        continue block0;
                    }
                    logger.warn("[EXMARaLDAImporter] Can not map an event '" + eEvent.getValue() + "' of tier " + tier.getCategory() + "' because this event is not connected to the timeline.");
                    continue block0;
                }
                DataSourceSequence sequence = new DataSourceSequence();
                sequence.setStart((Number)startPos);
                sequence.setEnd((Number)endPos);
                sequence.setDataSource((SSequentialDS)this.getDocument().getDocumentGraph().getTimeline());
                List<SToken> sTokens = this.getAdjacentSTokens((DataSourceSequence<Number>)sequence);
                ListIterator<SToken> itTokens = sTokens.listIterator();
                while (itTokens.hasNext()) {
                    SToken tok = itTokens.next();
                    Speaker tokSpeaker = this.token2Speaker.get(tok);
                    if (tokSpeaker == eEvent.getTier().getSpeaker()) continue;
                    itTokens.remove();
                }
                if (sTokens.isEmpty()) {
                    if (!this.getProps().getCleanModel().booleanValue()) {
                        logger.warn("There are no matching tokens found on token-tier for current tier: '" + tier.getCategory() + "' in event starting at '" + eEvent.getStart() + "' and ending at '" + eEvent.getEnd() + "' having the value '" + eEvent.getValue() + "'. The problem was detected in file '" + this.getResourceURI() + "'. You can try to set the property \"cleanModel\" to \"true\".");
                    } else {
                        logger.warn("There are no matching tokens found on token-tier for current tier: '" + tier.getCategory() + "' in event starting at '" + eEvent.getStart() + "' and ending at '" + eEvent.getEnd() + "' having the value '" + eEvent.getValue() + "'. The problem was detected in file '" + this.getResourceURI() + "'. Unfortunatly property '" + "cleanModel" + "' did not helped here. ");
                    }
                } else {
                    for (SToken sToken : sTokens) {
                        SSpanningRelation spanRel = SaltFactory.createSSpanningRelation();
                        spanRel.setSource((Node)sSpan);
                        spanRel.setTarget((Node)sToken);
                        this.getDocument().getDocumentGraph().addRelation((Relation)spanRel);
                    }
                }
                this.mapMediumURL2SSNode(eEvent, (SNode)sSpan);
            }
        }
    }

    public List<SToken> getAdjacentSTokens(DataSourceSequence<Number> sequence) {
        ArrayList<SToken> sTokens = new ArrayList<SToken>();
        List sSeqRels = null;
        if (sequence.getDataSource() instanceof STextualDS) {
            sSeqRels = this.getDocument().getDocumentGraph().getTextualRelations();
        } else if (sequence.getDataSource() instanceof STimeline) {
            sSeqRels = this.getDocument().getDocumentGraph().getTimelineRelations();
        } else {
            throw new PepperModuleException((PepperMapper)this, "Cannot compute overlaped nodes, because the given dataSource is not supported by this method.");
        }
        for (SSequentialRelation rel : sSeqRels) {
            if (!sequence.getDataSource().equals(rel.getTarget()) || !(rel.getSource() instanceof SToken) || !(rel instanceof STextualRelation) && !(rel instanceof STimelineRelation)) continue;
            DataSourceSequence<Number> intSeq = sequence;
            if ((Integer)rel.getStart() <= (Integer)intSeq.getStart() && (Integer)rel.getEnd() > (Integer)intSeq.getStart()) {
                sTokens.add((SToken)rel.getSource());
                continue;
            }
            if ((Integer)rel.getStart() < (Integer)intSeq.getStart() || (Integer)rel.getStart() >= (Integer)intSeq.getEnd()) continue;
            sTokens.add((SToken)rel.getSource());
        }
        return sTokens;
    }

    private void mapMediumURL2SSNode(Event event, SNode sNode) {
        if (event.getMedium() != null) {
            sNode.createAnnotation(null, "medium", (Object)event.getMedium().toString());
        }
        if (event.getUrl() != null) {
            sNode.createAnnotation(null, "url", (Object)event.getUrl().toString());
        }
    }

    public void mapCommonTimeLine2STimeine(CommonTimeLine eTimeLine, STimeline sTimeLine) {
        for (TLI tli : eTimeLine.getTLIs()) {
            sTimeLine.increasePointOfTime();
        }
    }

    public void mapEvent2SToken(Event eEvent, CommonTimeLine eCTimeline, SToken sToken, STimeline sTime) {
        TLI startTli = eEvent.getStart();
        TLI endTli = eEvent.getEnd();
        Integer startPos = null;
        Integer endPos = null;
        int i = 0;
        for (TLI tli : eCTimeline.getTLIs()) {
            if (tli.equals(startTli)) {
                startPos = i;
            }
            if (tli.equals(endTli)) {
                endPos = i;
            }
            if (startPos != null && endPos != null) break;
            ++i;
        }
        STimelineRelation sTimeRel = SaltFactory.createSTimelineRelation();
        sTimeRel.setTarget((Node)sTime);
        sTimeRel.setSource((Node)sToken);
        sTimeRel.setStart((Number)startPos);
        sTimeRel.setEnd(endPos);
        this.getDocument().getDocumentGraph().addRelation((Relation)sTimeRel);
    }

    public void mapTier2STextualDS(Tier eTextTier, STextualDS sText, List<Tier> textSlot) {
        StringBuilder text = new StringBuilder();
        int start = 0;
        int end = 0;
        for (Event event : eTextTier.getEvents()) {
            SLayer sLayer;
            start = text.length();
            String eventValue = event.getValue();
            if (eventValue != null) {
                if (this.getProps().isTrimEvents().booleanValue()) {
                    text.append(eventValue.trim());
                } else {
                    text.append(eventValue);
                }
            }
            end = text.length();
            String sep = this.getTokenSepearator();
            if (eventValue != null && sep != null) {
                text.append(sep);
            }
            SToken sToken = SaltFactory.createSToken();
            this.getDocument().getDocumentGraph().addNode((Node)sToken);
            if (this.tierNames2SLayers != null && (sLayer = this.tierNames2SLayers.get(eTextTier.getCategory())) != null) {
                sToken.addLayer((Layer)sLayer);
            }
            if (event.getTier().getSpeaker() != null) {
                this.token2Speaker.put(sToken, event.getTier().getSpeaker());
            }
            this.mapUDInformations2SAnnotationContainer((List<UDInformation>)event.getUdInformations(), (SAnnotationContainer)sToken);
            this.mapSStructuredNode2SemanticAnnotation(eTextTier, (SStructuredNode)sToken);
            this.mapMediumURL2SSNode(event, (SNode)sToken);
            STextualRelation sTextRel = SaltFactory.createSTextualRelation();
            sTextRel.setTarget((Node)sText);
            sTextRel.setSource((Node)sToken);
            sTextRel.setStart((Number)start);
            sTextRel.setEnd((Number)end);
            this.getDocument().getDocumentGraph().addRelation((Relation)sTextRel);
            if (this.getDocument().getDocumentGraph().getMedialDSs() != null && this.getDocument().getDocumentGraph().getMedialDSs().size() > 0 && (event.getStart().getTime() != null || event.getEnd().getTime() != null)) {
                try {
                    Double audioStart = null;
                    if (event.getStart().getTime() != null) {
                        audioStart = Double.valueOf(event.getStart().getTime());
                    }
                    Double audioEnd = null;
                    if (event.getEnd().getTime() != null) {
                        audioEnd = Double.valueOf(event.getEnd().getTime());
                    }
                    SMedialRelation sAudioDSRelation = SaltFactory.createSMedialRelation();
                    sAudioDSRelation.setSource((Node)sToken);
                    sAudioDSRelation.setTarget((Node)this.getDocument().getDocumentGraph().getMedialDSs().get(0));
                    sAudioDSRelation.setStart((Number)audioStart);
                    sAudioDSRelation.setEnd((Number)audioEnd);
                    this.getDocument().getDocumentGraph().addRelation((Relation)sAudioDSRelation);
                }
                catch (NumberFormatException e) {
                    logger.warn("[EXMARaLDAImporter] Cannot map time attribute of timeline to SStart or SEnd, because value '" + event.getStart().getTime() + "' is not mappable to a double value.");
                }
            }
            this.mapEvent2SToken(event, this.getBasicTranscription().getCommonTimeLine(), sToken, this.getDocument().getDocumentGraph().getTimeline());
        }
        sText.setText(text.toString());
        for (Tier tier : textSlot) {
            if (tier.equals(eTextTier)) continue;
            for (Event event : tier.getEvents()) {
                Integer startPos = this.getBasicTranscription().getCommonTimeLine().getTLIs().indexOf((Object)event.getStart());
                Integer endPos = this.getBasicTranscription().getCommonTimeLine().getTLIs().indexOf((Object)event.getEnd());
                DataSourceSequence sequence = new DataSourceSequence();
                sequence.setStart((Number)startPos);
                sequence.setEnd((Number)endPos);
                sequence.setDataSource((SSequentialDS)this.getDocument().getDocumentGraph().getTimeline());
                List sTokens = this.getDocument().getDocumentGraph().getTokensBySequence(sequence);
                if (sTokens == null) continue;
                for (SToken sToken : sTokens) {
                    this.mapEvent2SNode(tier, event, (SNode)sToken);
                }
            }
        }
    }

    public void mapEvent2SNode(Tier tier, Event eEvent, SNode sNode) {
        SPOSAnnotation sAnno;
        String posTier = this.getProps().getPOS();
        String lemmaTier = this.getProps().getLemma();
        String preUriTiers = this.getProps().getURIAnnotation();
        ArrayList<String> uriTiers = null;
        if (preUriTiers != null && !preUriTiers.isEmpty()) {
            uriTiers = new ArrayList<String>();
            for (String uriTier : preUriTiers.trim().split(",")) {
                uriTiers.add(uriTier);
            }
        }
        if (tier.getCategory().equalsIgnoreCase(posTier)) {
            sAnno = SaltFactory.createSPOSAnnotation();
            if (this.getProps().isTrimEvents().booleanValue()) {
                sAnno.setValue((Object)eEvent.getValue().trim());
            } else {
                sAnno.setValue((Object)eEvent.getValue());
            }
            sNode.addAnnotation((SAnnotation)sAnno);
        } else if (tier.getCategory().equalsIgnoreCase(lemmaTier)) {
            sAnno = SaltFactory.createSLemmaAnnotation();
            if (this.getProps().isTrimEvents().booleanValue()) {
                sAnno.setValue((Object)eEvent.getValue().trim());
            } else {
                sAnno.setValue((Object)eEvent.getValue());
            }
            sNode.addAnnotation((SAnnotation)sAnno);
        } else if (uriTiers != null && uriTiers.contains(tier.getCategory())) {
            String pathName = this.getResourceURI().toFileString().replace(this.getResourceURI().lastSegment(), eEvent.getValue());
            File file = new File(pathName);
            if (!file.exists()) {
                logger.warn("[EXMARaLDAImporter] Cannot add the uri-annotation '" + eEvent.getValue() + "' of tier '" + tier.getCategory() + "', because the file '" + pathName + "' does not exist.");
            } else {
                URI corpusFilePath = URI.createFileURI((String)file.getAbsolutePath());
                sNode.createAnnotation(null, tier.getCategory(), (Object)corpusFilePath.toFileString());
            }
        } else {
            String namespace = null;
            String name = tier.getCategory();
            if (this.getProps().isParseNamespace().booleanValue()) {
                Pair splitted = SaltUtil.splitQName((String)tier.getCategory());
                namespace = (String)splitted.getLeft();
                name = (String)splitted.getRight();
            } else if (eEvent.getTier().getSpeaker() != null) {
                namespace = eEvent.getTier().getSpeaker().getAbbreviation();
            }
            if (this.getProps().isTrimEvents().booleanValue()) {
                sNode.createAnnotation(namespace, name, (Object)eEvent.getValue().trim());
            } else {
                sNode.createAnnotation(namespace, name, (Object)eEvent.getValue());
            }
        }
        if (eEvent.getUdInformations() != null && eEvent.getUdInformations().size() > 0) {
            this.mapUDInformations2SAnnotationContainer((List<UDInformation>)eEvent.getUdInformations(), (SAnnotationContainer)sNode);
        }
    }

    private void mapSStructuredNode2SemanticAnnotation(Tier tier, SStructuredNode sStructuredNode) {
        if (tier.getCategory().equalsIgnoreCase(this.getSWordTier())) {
            SWordAnnotation sWordAnno = SaltFactory.createSWordAnnotation();
            sStructuredNode.addAnnotation((SAnnotation)sWordAnno);
        }
    }

    private String getTokenSepearator() {
        String preSep;
        String retVal = null;
        if (this.getProps().getTokenSeparator() != null && !this.getProps().getTokenSeparator().isEmpty() && (preSep = this.getProps().getTokenSeparator()).length() > 2) {
            retVal = preSep = preSep.replace("\"", "");
        }
        return retVal;
    }

    private String getSWordTier() {
        String wordTier;
        String retVal = null;
        if (this.getProps().getWord() != null && !this.getProps().getWord().isEmpty() && (wordTier = this.getProps().getWord()).length() > 2) {
            retVal = wordTier = wordTier.replace("\"", "");
        }
        return retVal;
    }
}

