/*
 * Decompiled with CFR 0.152.
 */
package org.corpus_tools.pepperModules_SqueezerModule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.corpus_tools.pepper.common.DOCUMENT_STATUS;
import org.corpus_tools.pepper.impl.PepperManipulatorImpl;
import org.corpus_tools.pepper.impl.PepperMapperImpl;
import org.corpus_tools.pepper.modules.PepperMapper;
import org.corpus_tools.pepper.modules.exceptions.PepperModuleNotReadyException;
import org.corpus_tools.salt.SaltFactory;
import org.corpus_tools.salt.common.SDominanceRelation;
import org.corpus_tools.salt.common.SStructure;
import org.corpus_tools.salt.common.SStructuredNode;
import org.corpus_tools.salt.common.STextualDS;
import org.corpus_tools.salt.common.SToken;
import org.corpus_tools.salt.core.GraphTraverseHandler;
import org.corpus_tools.salt.core.SAnnotation;
import org.corpus_tools.salt.core.SGraph;
import org.corpus_tools.salt.core.SLayer;
import org.corpus_tools.salt.core.SNode;
import org.corpus_tools.salt.core.SRelation;
import org.corpus_tools.salt.graph.Identifier;
import org.corpus_tools.salt.graph.Node;
import org.corpus_tools.salt.graph.Relation;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;

@Component(name="SqueezerModuleManipulatorComponent", factory="PepperManipulatorComponentFactory")
public class SqueezerModuleManipulator
extends PepperManipulatorImpl {
    public SqueezerModuleManipulator() {
        this.setName("Squeezer");
        this.setSupplierContact(URI.createURI((String)"saltnpepper@lists.hu-berlin.de"));
        this.setSupplierHomepage(URI.createURI((String)"http://corpus-tools.org/pepper/"));
        this.setDesc("This manipulator deletes nodes with no annotations.");
    }

    public PepperMapper createPepperMapper(Identifier Identifier2) {
        SqueezerModuleMapper mapper = new SqueezerModuleMapper();
        return mapper;
    }

    public boolean isReadyToStart() throws PepperModuleNotReadyException {
        return true;
    }

    public static class SqueezerModuleMapper
    extends PepperMapperImpl
    implements GraphTraverseHandler {
        private Map<String, UUID> rstId2UUID;
        private Map<UUID, Integer> tokenUUID2index;
        private Map<UUID, SToken> tokenMap = new HashMap<UUID, SToken>();
        private Map<UUID, SStructure> structureMap;
        private SLayer layer;
        private Map<SStructure, List<SStructure>> signalsForSecondaryEdge = null;
        private Map<String, SStructure> secondaryEdgeIndex = null;
        private Set<SDominanceRelation> primaryRelationsWithSignals = null;

        public SqueezerModuleMapper() {
            this.tokenUUID2index = new HashMap<UUID, Integer>();
            this.structureMap = new HashMap<UUID, SStructure>();
            this.signalsForSecondaryEdge = new HashMap<SStructure, List<SStructure>>();
            this.secondaryEdgeIndex = new HashMap<String, SStructure>();
            this.primaryRelationsWithSignals = new HashSet<SDominanceRelation>();
        }

        public DOCUMENT_STATUS mapSCorpus() {
            return DOCUMENT_STATUS.COMPLETED;
        }

        private void indexUuids() {
            SAnnotation ann;
            for (SToken t : this.getDocument().getDocumentGraph().getTokens()) {
                ann = t.getAnnotation("TEMP", "uuid");
                if (ann == null) continue;
                this.tokenMap.put((UUID)ann.getValue(), t);
                t.removeLabel("TEMP", "uuid");
            }
            for (SNode n : this.getDocument().getDocumentGraph().getNodes()) {
                ann = n.getAnnotation("TEMP", "uuid");
                if (ann == null) continue;
                this.structureMap.put((UUID)ann.getValue(), (SStructure)n);
                n.removeLabel("TEMP", "uuid");
            }
        }

        private void constructSecEdges() {
            for (SNode sNode : this.structureMap.values()) {
                SAnnotation secedgeAnn = sNode.getAnnotation("TEMP", "secedges");
                if (secedgeAnn == null) continue;
                for (Map secedgeMap : (List)secedgeAnn.getValue()) {
                    UUID sourceId = (UUID)secedgeMap.get("edgeSource");
                    UUID targetId = (UUID)secedgeMap.get("edgeTarget");
                    SStructure source = this.structureMap.get(sourceId);
                    SStructure target = this.structureMap.get(targetId);
                    SStructure ses = SaltFactory.createSStructure();
                    ses.createAnnotation("sec", "relname", secedgeMap.get("relationName"));
                    SDominanceRelation sourceRel = SaltFactory.createSDominanceRelation();
                    sourceRel.setSource((Node)ses);
                    sourceRel.setTarget((Node)source);
                    sourceRel.createAnnotation(null, "end", (Object)"source");
                    SDominanceRelation targetRel = SaltFactory.createSDominanceRelation();
                    targetRel.setSource((Node)ses);
                    targetRel.setTarget((Node)target);
                    targetRel.createAnnotation(null, "end", (Object)"target");
                    this.getDocument().getDocumentGraph().addNode((Node)ses);
                    this.getDocument().getDocumentGraph().addRelation((Relation)sourceRel);
                    this.getDocument().getDocumentGraph().addRelation((Relation)targetRel);
                    if (this.layer != null) {
                        this.layer.addNode((Node)ses);
                        this.layer.addRelation((Relation)sourceRel);
                        this.layer.addRelation((Relation)targetRel);
                    }
                    this.secondaryEdgeIndex.put(sourceId + "-" + targetId, ses);
                }
                sNode.removeLabel("TEMP", "secedges");
            }
        }

        private void constructSignal(SNode source, Map<Object, Object> signal) {
            String signalType = (String)signal.get("signal:type");
            String signalSubtype = (String)signal.get("signal:subtype");
            List tokenIds = (List)signal.get("signal:tokens");
            List sourceIds = (List)signal.get("signal:source");
            boolean isSecondary = sourceIds.size() > 1;
            SStructure signalNode = SaltFactory.createSStructure();
            signalNode.createAnnotation(null, "signal_type", (Object)signalType);
            signalNode.createAnnotation(null, "signal_subtype", (Object)signalSubtype);
            this.getDocument().getDocumentGraph().addNode((Node)signalNode);
            if (this.layer != null) {
                this.layer.addNode((Node)signalNode);
            }
            if (tokenIds != null) {
                StringBuilder tokenTextSb = new StringBuilder();
                StringBuilder tokenIndexesSb = new StringBuilder();
                for (Object tokenId : tokenIds) {
                    SToken token = this.tokenMap.get(tokenId);
                    String tokenText = this.getDocument().getDocumentGraph().getText((SNode)token);
                    tokenTextSb.append(tokenText);
                    tokenIndexesSb.append(this.tokenUUID2index.get(tokenId).toString());
                    tokenTextSb.append(" ");
                    tokenIndexesSb.append(" ");
                }
                if (tokenTextSb.length() > 0) {
                    tokenTextSb.deleteCharAt(tokenTextSb.length() - 1);
                    tokenIndexesSb.deleteCharAt(tokenIndexesSb.length() - 1);
                }
                signalNode.createAnnotation(null, "signal_text", (Object)tokenTextSb.toString());
                signalNode.createAnnotation(null, "signal_indexes", (Object)tokenIndexesSb.toString());
            }
            Integer earliestToken = Integer.MAX_VALUE;
            if (tokenIds != null) {
                List sTokens = this.getDocument().getDocumentGraph().getTokens();
                for (Object tokenId : tokenIds) {
                    Integer tokenIndex;
                    SDominanceRelation tokRel = SaltFactory.createSDominanceRelation();
                    tokRel.setSource((Node)signalNode);
                    tokRel.setTarget((Node)this.tokenMap.get(tokenId));
                    tokRel.setType("signal_token");
                    tokRel.setSource((Node)signalNode);
                    this.getDocument().getDocumentGraph().addRelation((Relation)tokRel);
                    if (this.layer != null) {
                        this.layer.addRelation((Relation)tokRel);
                    }
                    if ((tokenIndex = this.tokenUUID2index.get(tokenId)) >= earliestToken) continue;
                    earliestToken = tokenIndex;
                }
            }
            String relname = null;
            List incomingRelations = source.getInRelations();
            if (incomingRelations != null) {
                for (SRelation r : incomingRelations) {
                    if (!isSecondary) {
                        if (!(r instanceof SDominanceRelation)) continue;
                        SAnnotation ann = r.getAnnotation(null, "relname");
                        this.primaryRelationsWithSignals.add((SDominanceRelation)r);
                        if (ann == null) continue;
                        relname = (String)ann.getValue();
                        continue;
                    }
                    if (!(r instanceof SDominanceRelation) || r.getAnnotation(null, "end") == null || !r.getAnnotation(null, "end").getValue().equals("source")) continue;
                    SStructure s = (SStructure)r.getSource();
                    UUID targetId = (UUID)sourceIds.get(1);
                    for (SRelation r2 : s.getOutRelations()) {
                        if (!(r2 instanceof SDominanceRelation) || !this.structureMap.get(targetId).equals(r2.getTarget())) continue;
                        relname = (String)s.getAnnotation("sec", "relname").getValue();
                    }
                }
            }
            if (isSecondary) {
                SStructure seSource = this.structureMap.get(sourceIds.get(0));
                SStructure seTarget = this.structureMap.get(sourceIds.get(1));
                SDominanceRelation signal2source = SaltFactory.createSDominanceRelation();
                SDominanceRelation signal2target = SaltFactory.createSDominanceRelation();
                signal2source.setSource((Node)signalNode);
                signal2source.setTarget((Node)seSource);
                signal2target.setSource((Node)signalNode);
                signal2target.setTarget((Node)seTarget);
                if (relname != null) {
                    signal2source.createAnnotation("sec", "signal", (Object)relname);
                    signalNode.createAnnotation("sec", "signaled_relation", (Object)relname);
                }
                this.getDocument().getDocumentGraph().addRelation((Relation)signal2source);
                this.getDocument().getDocumentGraph().addRelation((Relation)signal2target);
                if (this.layer != null) {
                    this.layer.addRelation((Relation)signal2source);
                    this.layer.addRelation((Relation)signal2target);
                }
                signalNode.createProcessingAnnotation(null, "earliest_token", (Object)earliestToken);
                SStructure secondaryEdge = this.secondaryEdgeIndex.get(sourceIds.get(0) + "-" + sourceIds.get(1));
                if (!this.signalsForSecondaryEdge.containsKey(secondaryEdge)) {
                    this.signalsForSecondaryEdge.put(secondaryEdge, new ArrayList());
                }
                this.signalsForSecondaryEdge.get(secondaryEdge).add(signalNode);
            } else {
                SDominanceRelation signal2rstNode = SaltFactory.createSDominanceRelation();
                signal2rstNode.setSource((Node)signalNode);
                signal2rstNode.setTarget((Node)((SStructuredNode)source));
                if (relname != null) {
                    signal2rstNode.createAnnotation("prim", "signal", relname);
                    signalNode.createAnnotation("prim", "signaled_relation", relname);
                }
                this.getDocument().getDocumentGraph().addRelation((Relation)signal2rstNode);
                if (this.layer != null) {
                    this.layer.addNode((Node)signalNode);
                }
            }
        }

        private void constructSignals() {
            for (Map.Entry<UUID, SStructure> kvp : this.structureMap.entrySet()) {
                SNode n = (SNode)kvp.getValue();
                SAnnotation ann = n.getAnnotation("TEMP", "signals");
                if (ann == null) continue;
                for (Map signal : (List)ann.getValue()) {
                    this.constructSignal(n, signal);
                }
                n.removeLabel("TEMP", "signals");
            }
        }

        private void connectSecondaryEdgesToSignals() {
            for (Map.Entry<SStructure, List<SStructure>> kvp : this.signalsForSecondaryEdge.entrySet()) {
                SStructure secEdge = kvp.getKey();
                List<SStructure> signals = kvp.getValue();
                SStructure winningSignal = null;
                int earliestToken = Integer.MAX_VALUE;
                for (SStructure signal : signals) {
                    int signalEarliestToken = (Integer)signal.getProcessingAnnotation("earliest_token").getValue();
                    if (signalEarliestToken >= earliestToken) continue;
                    earliestToken = signalEarliestToken;
                    winningSignal = signal;
                }
                if (winningSignal == null) continue;
                SDominanceRelation r = SaltFactory.createSDominanceRelation();
                r.setSource((Node)secEdge);
                r.setTarget(winningSignal);
                this.getDocument().getDocumentGraph().addRelation((Relation)r);
            }
        }

        private void markEdgesWithSignals() {
            for (SDominanceRelation dr : this.getDocument().getDocumentGraph().getDominanceRelations()) {
                if (dr.getTarget() instanceof SToken || ((SStructure)dr.getSource()).getAnnotation("sec", "signaled_relation") != null || ((SStructure)dr.getSource()).getAnnotation("prim", "signaled_relation") != null || ((SStructure)dr.getSource()).getAnnotation("sec", "relname") != null) continue;
                dr.createAnnotation(null, "is_signaled", (Object)this.primaryRelationsWithSignals.contains(dr));
            }
        }

        public DOCUMENT_STATUS mapSDocument() {
            for (SNode n : this.getDocument().getDocumentGraph().getNodes()) {
                if (n.getAnnotation(null, "kind") != null) {
                    this.layer = (SLayer)n.getLayers().toArray()[0];
                }
                if (n.getAnnotation("TEMP", "rstid2uuid") == null) continue;
                this.rstId2UUID = (Map)n.getAnnotation("TEMP", "rstid2uuid").getValue();
                n.removeLabel("TEMP", "rstid2uuid");
                for (Map.Entry<String, UUID> kvp : this.rstId2UUID.entrySet()) {
                    String id = kvp.getKey();
                    UUID uuid = kvp.getValue();
                    if (!id.startsWith("token")) continue;
                    this.tokenUUID2index.put(uuid, Integer.parseInt(id.substring(5)));
                }
            }
            this.indexUuids();
            this.constructSecEdges();
            this.constructSignals();
            this.connectSecondaryEdgesToSignals();
            this.markEdgesWithSignals();
            return DOCUMENT_STATUS.COMPLETED;
        }

        public void nodeReached(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation sRelation, SNode fromNode, long order) {
        }

        public void nodeLeft(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SNode currNode, SRelation edge, SNode fromNode, long order) {
        }

        public boolean checkConstraint(SGraph.GRAPH_TRAVERSE_TYPE traversalType, String traversalId, SRelation edge, SNode currNode, long order) {
            return !(currNode instanceof STextualDS);
        }
    }
}

